/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;

public class JMSResourceFactoryImpl
implements JMSResourceFactory {
    protected String initialContextFactoryName;
    protected String connectionFactoryName = "ConnectionFactory";
    protected String jndiURL;
    protected Connection connection;
    protected Context context;
    protected boolean isConnectionStarted;

    public JMSResourceFactoryImpl(String connectionFactoryName, String initialContextFactoryName, String jndiURL) {
        if (connectionFactoryName != null && connectionFactoryName.trim().length() > 0) {
            this.connectionFactoryName = connectionFactoryName.trim();
        }
        if (initialContextFactoryName != null && initialContextFactoryName.trim().length() > 0) {
            this.initialContextFactoryName = initialContextFactoryName.trim();
        }
        if (jndiURL != null) {
            this.jndiURL = jndiURL.trim();
        }
    }

    public Connection getConnection() throws NamingException, JMSException {
        if (this.connection == null) {
            this.createConnection();
        }
        return this.connection;
    }

    public Session createSession() throws JMSException, NamingException {
        return this.getConnection().createSession(false, 1);
    }

    public void startConnection() throws JMSException, NamingException {
        if (!this.isConnectionStarted) {
            this.getConnection().start();
            this.isConnectionStarted = true;
        }
    }

    public void closeConnection() throws JMSException {
        block3: {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (JMSException e) {
                    if (e.getMessage().contains("disposed")) break block3;
                    throw e;
                }
            }
        }
    }

    protected void createConnection() throws NamingException, JMSException {
        ConnectionFactory connectionFactory = (ConnectionFactory)this.jndiLookUp(this.connectionFactoryName);
        if (connectionFactory == null) {
            throw new JMSBindingException("connection factory not found: " + this.connectionFactoryName);
        }
        this.connection = connectionFactory.createConnection();
    }

    protected synchronized Context getInitialContext() throws NamingException {
        if (this.context == null) {
            Properties props = new Properties();
            if (this.initialContextFactoryName != null) {
                props.setProperty("java.naming.factory.initial", this.initialContextFactoryName);
            }
            if (this.jndiURL != null) {
                props.setProperty("java.naming.provider.url", this.jndiURL);
            }
            this.initJREEnvironment(props);
            this.context = new InitialContext(props);
        }
        return this.context;
    }

    protected void initJREEnvironment(Properties props) {
        String vendor;
        if ("com.ibm.websphere.naming.WsnInitialContextFactory".equals(props.get("java.naming.factory.initial")) && ((vendor = System.getProperty("java.vendor")) == null || !vendor.contains("IBM"))) {
            props.setProperty("com.ibm.CORBA.ORBInit", "com.ibm.ws.sib.client.ORB");
        }
    }

    public Destination lookupDestination(String destName) throws NamingException {
        if ("NODESTINATION".equals(destName)) {
            return null;
        }
        Destination dest = (Destination)this.jndiLookUp(destName);
        if (dest == null) {
            dest = this.lookupPhysical(destName);
        }
        return dest;
    }

    protected Destination lookupPhysical(String jndiName) {
        return null;
    }

    public Destination createDestination(String jndiName) throws NamingException {
        return this.lookupDestination("dynamicQueues/" + jndiName);
    }

    protected Object jndiLookUp(String name) {
        Object o = null;
        try {
            o = this.getInitialContext().lookup("java:comp/env/" + name);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (o == null) {
            try {
                o = this.getInitialContext().lookup(name);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        return o;
    }
}

