/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.provider;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.binding.jms.headers.HeaderReferenceInterceptor;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingException;
import org.apache.tuscany.sca.binding.jms.provider.JMSBindingInvoker;
import org.apache.tuscany.sca.binding.jms.provider.JMSResourceFactory;
import org.apache.tuscany.sca.binding.jms.provider.RRBJMSBindingInvoker;
import org.apache.tuscany.sca.binding.jms.transport.TransportReferenceInterceptor;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Interceptor;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.ReferenceBindingProviderRRB;
import org.apache.tuscany.sca.provider.WireFormatProvider;
import org.apache.tuscany.sca.provider.WireFormatProviderFactory;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeWire;

public class JMSBindingReferenceBindingProvider
implements ReferenceBindingProviderRRB {
    private RuntimeComponentReference reference;
    private JMSBinding jmsBinding;
    private List<JMSBindingInvoker> jmsBindingInvokers = new ArrayList<JMSBindingInvoker>();
    private JMSResourceFactory jmsResourceFactory;
    private RuntimeComponent component;
    private InterfaceContract interfaceContract;
    private ExtensionPointRegistry extensions;
    private ProviderFactoryExtensionPoint providerFactories;
    private WireFormatProviderFactory requestWireFormatProviderFactory;
    private WireFormatProvider requestWireFormatProvider;
    private WireFormatProviderFactory responseWireFormatProviderFactory;
    private WireFormatProvider responseWireFormatProvider;

    public JMSBindingReferenceBindingProvider(RuntimeComponent component, RuntimeComponentReference reference, JMSBinding binding, ExtensionPointRegistry extensions, JMSResourceFactory jmsResourceFactory) {
        this.reference = reference;
        this.jmsBinding = binding;
        this.extensions = extensions;
        this.component = component;
        this.jmsResourceFactory = jmsResourceFactory;
        this.providerFactories = (ProviderFactoryExtensionPoint)extensions.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        this.requestWireFormatProviderFactory = (WireFormatProviderFactory)this.providerFactories.getProviderFactory(this.jmsBinding.getRequestWireFormat().getClass());
        if (this.requestWireFormatProviderFactory != null) {
            this.requestWireFormatProvider = this.requestWireFormatProviderFactory.createReferenceWireFormatProvider(component, reference, (Binding)this.jmsBinding);
        }
        this.responseWireFormatProviderFactory = (WireFormatProviderFactory)this.providerFactories.getProviderFactory(this.jmsBinding.getResponseWireFormat().getClass());
        if (this.responseWireFormatProviderFactory != null) {
            this.responseWireFormatProvider = this.responseWireFormatProviderFactory.createReferenceWireFormatProvider(component, reference, (Binding)this.jmsBinding);
        }
    }

    public Invoker createInvoker(Operation operation) {
        if (this.jmsBinding.getDestinationName().equals("NODESTINATION") && !this.reference.isCallback()) {
            throw new JMSBindingException("No destination specified for reference " + this.reference.getName());
        }
        RRBJMSBindingInvoker invoker = null;
        invoker = new RRBJMSBindingInvoker(this.jmsBinding, operation, this.jmsResourceFactory, this.reference);
        return invoker;
    }

    public boolean supportsOneWayInvocation() {
        return true;
    }

    public InterfaceContract getBindingInterfaceContract() {
        if (this.interfaceContract == null) {
            this.interfaceContract = this.requestWireFormatProvider.getWireFormatInterfaceContract();
        }
        return this.interfaceContract;
    }

    public void start() {
    }

    public void stop() {
        try {
            this.jmsResourceFactory.closeConnection();
        }
        catch (JMSException e) {
            throw new JMSBindingException((Throwable)e);
        }
    }

    public void configureBindingChain(RuntimeWire runtimeWire) {
        InvocationChain bindingChain = runtimeWire.getBindingInvocationChain();
        bindingChain.addInterceptor("reference.binding.transport", (Interceptor)new TransportReferenceInterceptor(this.jmsBinding, this.jmsResourceFactory, runtimeWire));
        bindingChain.addInterceptor(this.requestWireFormatProvider.getPhase(), this.requestWireFormatProvider.createInterceptor());
        if (!this.jmsBinding.getRequestWireFormat().equals(this.jmsBinding.getResponseWireFormat())) {
            bindingChain.addInterceptor(this.responseWireFormatProvider.getPhase(), this.responseWireFormatProvider.createInterceptor());
        }
        bindingChain.addInterceptor("reference.binding.wireformat", (Interceptor)new HeaderReferenceInterceptor(this.jmsBinding, this.jmsResourceFactory, runtimeWire));
    }
}

