/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.OperationSelector;
import org.apache.tuscany.sca.assembly.WireFormat;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.assembly.xml.ConfiguredOperationProcessor;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.binding.jms.impl.BindingProperty;
import org.apache.tuscany.sca.binding.jms.impl.JMSBinding;
import org.apache.tuscany.sca.binding.jms.impl.JMSBindingConstants;
import org.apache.tuscany.sca.binding.jms.operationselector.jmsdefault.OperationSelectorJMSDefault;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsdefault.WireFormatJMSDefault;
import org.apache.tuscany.sca.binding.jms.wireformat.jmsobject.WireFormatJMSObject;
import org.apache.tuscany.sca.binding.jms.wireformat.jmstext.WireFormatJMSText;
import org.apache.tuscany.sca.binding.jms.wireformat.jmstextxml.WireFormatJMSTextXML;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.PolicyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMSBindingProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<JMSBinding> {
    private PolicyFactory policyFactory;
    private PolicyAttachPointProcessor policyProcessor;
    private ConfiguredOperationProcessor configuredOperationProcessor;
    protected StAXArtifactProcessor<Object> extensionProcessor;
    private Monitor monitor;
    private ModelFactoryExtensionPoint modelFactories;

    public JMSBindingProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor<Object> extensionProcessor, Monitor monitor) {
        this.policyFactory = (PolicyFactory)modelFactories.getFactory(PolicyFactory.class);
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
        this.configuredOperationProcessor = new ConfiguredOperationProcessor(modelFactories, this.monitor);
        this.extensionProcessor = extensionProcessor;
        this.monitor = monitor;
        this.modelFactories = modelFactories;
    }

    private void warning(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(((Object)((Object)this)).getClass().getName(), "binding-jms-validation-messages", Problem.Severity.WARNING, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    private void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(((Object)((Object)this)).getClass().getName(), "binding-jms-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    public QName getArtifactType() {
        return JMSBindingConstants.BINDING_JMS_QNAME;
    }

    public Class<JMSBinding> getModelType() {
        return JMSBinding.class;
    }

    public JMSBinding read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String responseConnectionName;
        String requestConnectionName;
        String messageProcessorName;
        String jndiURL;
        String initialContextFactory;
        String correlationScheme;
        String uri;
        JMSBinding jmsBinding = new JMSBinding();
        this.policyProcessor.readPolicies((Object)jmsBinding, reader);
        String name = reader.getAttributeValue(null, "name");
        if (name != null) {
            jmsBinding.setName(name);
        }
        if ((uri = reader.getAttributeValue(null, "uri")) != null && uri.length() > 0) {
            this.parseURI(uri, jmsBinding);
        }
        if ((correlationScheme = reader.getAttributeValue(null, "correlationScheme")) != null && correlationScheme.length() > 0) {
            if (JMSBindingConstants.VALID_CORRELATION_SCHEMES.contains(correlationScheme.toLowerCase())) {
                jmsBinding.setCorrelationScheme(correlationScheme);
            } else {
                this.error("InvalidCorrelationScheme", reader, correlationScheme);
            }
        }
        if ((initialContextFactory = reader.getAttributeValue(null, "initialContextFactory")) != null && initialContextFactory.length() > 0) {
            jmsBinding.setInitialContextFactoryName(initialContextFactory);
        }
        if ((jndiURL = reader.getAttributeValue(null, "jndiURL")) != null && jndiURL.length() > 0) {
            jmsBinding.setJndiURL(jndiURL);
        }
        if ((messageProcessorName = reader.getAttributeValue(null, "messageProcessor")) != null && messageProcessorName.length() > 0) {
            if ("XMLTextMessage".equalsIgnoreCase(messageProcessorName)) {
                jmsBinding.setRequestWireFormat(new WireFormatJMSTextXML());
                jmsBinding.setResponseWireFormat(jmsBinding.getRequestWireFormat());
            } else if ("TextMessage".equalsIgnoreCase(messageProcessorName)) {
                jmsBinding.setRequestWireFormat(new WireFormatJMSText());
                jmsBinding.setResponseWireFormat(jmsBinding.getRequestWireFormat());
            } else if ("ObjectMessage".equalsIgnoreCase(messageProcessorName)) {
                jmsBinding.setRequestWireFormat(new WireFormatJMSObject());
                jmsBinding.setResponseWireFormat(jmsBinding.getRequestWireFormat());
            } else {
                jmsBinding.setRequestMessageProcessorName(messageProcessorName);
                jmsBinding.setResponseMessageProcessorName(messageProcessorName);
                jmsBinding.setRequestWireFormat(new WireFormatJMSText());
                jmsBinding.setResponseWireFormat(jmsBinding.getRequestWireFormat());
            }
        }
        if ((requestConnectionName = reader.getAttributeValue(null, "requestConnection")) != null && requestConnectionName.length() > 0) {
            jmsBinding.setRequestConnectionName(this.getQNameValue(reader, requestConnectionName));
        }
        if ((responseConnectionName = reader.getAttributeValue(null, "responseConnection")) != null && responseConnectionName.length() > 0) {
            jmsBinding.setResponseConnectionName(this.getQNameValue(reader, responseConnectionName));
        }
        boolean endFound = false;
        block4: while (!endFound) {
            int fg = reader.next();
            switch (fg) {
                case 1: {
                    String elementName = reader.getName().getLocalPart();
                    if ("destination".equals(elementName)) {
                        this.parseDestination(reader, jmsBinding);
                        break;
                    }
                    if ("connectionFactory".equals(elementName)) {
                        this.parseConnectionFactory(reader, jmsBinding);
                        break;
                    }
                    if ("activationSpec".equals(elementName)) {
                        this.parseActivationSpec(reader, jmsBinding);
                        break;
                    }
                    if ("response".equals(elementName)) {
                        this.parseResponse(reader, jmsBinding);
                        break;
                    }
                    if ("resourceAdapter".equals(elementName)) {
                        this.parseResourceAdapter(reader, jmsBinding);
                        break;
                    }
                    if ("headers".equals(elementName)) {
                        this.parseHeaders(reader, jmsBinding);
                        break;
                    }
                    if ("operationProperties".equals(elementName)) {
                        this.parseOperationProperties(reader, jmsBinding);
                        break;
                    }
                    if ("SubscriptionHeaders".equals(elementName)) {
                        this.parseSubscriptionHeaders(reader, jmsBinding);
                        break;
                    }
                    if (Constants.OPERATION_QNAME.equals(reader.getName())) {
                        ConfiguredOperation confOp = this.configuredOperationProcessor.read(reader);
                        if (confOp == null) continue block4;
                        jmsBinding.getConfiguredOperations().add(confOp);
                        break;
                    }
                    Object extension = this.extensionProcessor.read(reader);
                    if (extension == null) continue block4;
                    if (extension instanceof WireFormat) {
                        jmsBinding.setRequestWireFormat((WireFormat)extension);
                        break;
                    }
                    if (extension instanceof OperationSelector) {
                        jmsBinding.setOperationSelector((OperationSelector)extension);
                        break;
                    }
                    this.error("UnexpectedElement", reader, extension.toString());
                    break;
                }
                case 2: {
                    QName x = reader.getName();
                    if ("operation".equals(x.getLocalPart()) || x.getLocalPart().startsWith("wireFormat.") || x.getLocalPart().startsWith("operationSelector.")) break;
                    if (x.equals(JMSBindingConstants.BINDING_JMS_QNAME)) {
                        endFound = true;
                        break;
                    }
                    this.error("UnexpectedElement: expected " + JMSBindingConstants.BINDING_JMS_QNAME + ", found " + x.toString(), reader, x.toString());
                }
            }
        }
        if (jmsBinding.getOperationSelector() == null) {
            jmsBinding.setOperationSelector(new OperationSelectorJMSDefault());
        }
        if (jmsBinding.getRequestWireFormat() == null) {
            jmsBinding.setRequestWireFormat(new WireFormatJMSDefault());
        }
        if (jmsBinding.getResponseWireFormat() == null) {
            jmsBinding.setResponseWireFormat(jmsBinding.getRequestWireFormat());
        }
        this.validate(jmsBinding);
        return jmsBinding;
    }

    protected void parseURI(String uri, JMSBinding jmsBinding) {
        if (!uri.startsWith("jms:")) {
            this.error("MustStartWithSchema", jmsBinding, uri);
            return;
        }
        int i = uri.indexOf(63);
        if (i >= 0) {
            StringTokenizer st = new StringTokenizer(uri.substring(i + 1), "&");
            while (st.hasMoreTokens()) {
                String s = st.nextToken();
                if (s.startsWith("connectionFactoryName=")) {
                    jmsBinding.setConnectionFactoryName(s.substring(22));
                    continue;
                }
                this.error("UnknownTokenInURI", jmsBinding, s, uri);
                return;
            }
            jmsBinding.setDestinationName(uri.substring(4, i));
        } else {
            jmsBinding.setDestinationName(uri.substring(4));
        }
    }

    public void resolve(JMSBinding model, ModelResolver resolver) throws ContributionResolveException {
        if (model.getRequestConnectionName() != null) {
            model.setRequestConnectionBinding(this.getConnectionBinding(model, "requestConnection", model.getRequestConnectionName(), resolver));
        }
        if (model.getResponseConnectionName() != null) {
            model.setResponseConnectionBinding(this.getConnectionBinding(model, "responseConnection", model.getResponseConnectionName(), resolver));
        }
    }

    private JMSBinding getConnectionBinding(JMSBinding model, String attrName, QName bindingName, ModelResolver resolver) {
        JMSBinding binding = new JMSBinding();
        binding.setTargetNamespace(bindingName.getNamespaceURI());
        binding.setName(bindingName.getLocalPart());
        binding.setUnresolved(true);
        binding = (JMSBinding)resolver.resolveModel(JMSBinding.class, (Object)binding);
        if (binding.isUnresolved()) {
            this.error("BindingNotFound", model, attrName, bindingName);
        }
        return binding;
    }

    private void parseDestination(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String create;
        String type;
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            jmsBinding.setDestinationName(name);
        }
        if ((type = reader.getAttributeValue(null, "type")) != null && type.length() > 0) {
            this.warning("DoesntProcessDestinationType", jmsBinding, new Object[0]);
            if ("queue".equalsIgnoreCase(type)) {
                jmsBinding.setDestinationType("queue");
            } else if ("topic".equalsIgnoreCase(type)) {
                jmsBinding.setDestinationType("topic");
            } else {
                this.error("InvalidDestinationType", reader, type);
            }
        }
        if ((create = reader.getAttributeValue(null, "create")) != null && create.length() > 0) {
            jmsBinding.setDestinationCreate(create);
        }
        jmsBinding.getDestinationProperties().putAll(this.parseBindingProperties(reader));
    }

    private void parseConnectionFactory(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            jmsBinding.setConnectionFactoryName(name);
        } else {
            this.error("MissingConnectionFactoryName", reader, new Object[0]);
        }
        jmsBinding.getConnectionFactoryProperties().putAll(this.parseBindingProperties(reader));
    }

    private void parseActivationSpec(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            jmsBinding.setActivationSpecName(name);
        } else {
            this.warning("MissingActivationSpecName", reader, new Object[0]);
        }
        jmsBinding.getActivationSpecProperties().putAll(this.parseBindingProperties(reader));
    }

    private void parseResponseDestination(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String create;
        String type;
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            jmsBinding.setResponseDestinationName(name);
        }
        if ((type = reader.getAttributeValue(null, "type")) != null && type.length() > 0) {
            this.warning("DoesntProcessResponseDestinationType", jmsBinding, new Object[0]);
            if ("queue".equalsIgnoreCase(type)) {
                jmsBinding.setResponseDestinationType("queue");
            } else if ("topic".equalsIgnoreCase(type)) {
                jmsBinding.setResponseDestinationType("topic");
            } else {
                this.error("InvalidResponseDestinationType", reader, type);
            }
        }
        if ((create = reader.getAttributeValue(null, "create")) != null && create.length() > 0) {
            jmsBinding.setResponseDestinationCreate(create);
        }
        jmsBinding.getResponseDestinationProperties().putAll(this.parseBindingProperties(reader));
    }

    private void parseResponseConnectionFactory(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            jmsBinding.setResponseConnectionFactoryName(name);
        } else {
            this.warning("MissingResponseConnectionFactory", reader, new Object[0]);
        }
        jmsBinding.getResponseConnectionFactoryProperties().putAll(this.parseBindingProperties(reader));
    }

    private void parseResponseActivationSpec(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            jmsBinding.setResponseActivationSpecName(name);
        } else {
            this.warning("MissingResponseActivationSpec", reader, new Object[0]);
        }
        jmsBinding.getResponseActivationSpecProperties().putAll(this.parseBindingProperties(reader));
    }

    private void parseResponse(XMLStreamReader reader, JMSBinding jmsBinding) throws ContributionReadException, XMLStreamException {
        while (true) {
            switch (reader.next()) {
                case 1: {
                    String elementName = reader.getName().getLocalPart();
                    if ("destination".equals(elementName)) {
                        this.parseResponseDestination(reader, jmsBinding);
                        break;
                    }
                    if ("connectionFactory".equals(elementName)) {
                        this.parseResponseConnectionFactory(reader, jmsBinding);
                        break;
                    }
                    if ("activationSpec".equals(elementName)) {
                        this.parseResponseActivationSpec(reader, jmsBinding);
                        break;
                    }
                    Object extension = this.extensionProcessor.read(reader);
                    if (extension != null) {
                        if (extension instanceof WireFormat) {
                            jmsBinding.setResponseWireFormat((WireFormat)extension);
                        } else {
                            this.error("UnexpectedElement", reader, extension.toString());
                        }
                    }
                    reader.next();
                    break;
                }
                case 2: {
                    QName x = reader.getName();
                    if (x.getLocalPart().equals("response")) {
                        return;
                    }
                    this.error("UnexpectedResponseElement", reader, x.toString());
                }
            }
        }
    }

    private void parseResourceAdapter(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "name");
        if (name != null && name.length() > 0) {
            jmsBinding.setResourceAdapterName(name);
        } else {
            this.error("MissingResourceAdapterName", reader, new Object[0]);
        }
        jmsBinding.getResourceAdapterProperties().putAll(this.parseBindingProperties(reader));
    }

    private void parseHeaders(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String jmsPriority;
        String jmsTimeToLive;
        String jmsDeliveryMode;
        String jmsCorrelationId;
        String jmsType = reader.getAttributeValue(null, "JMSType");
        if (jmsType != null && jmsType.length() > 0) {
            jmsBinding.setJMSType(jmsType);
        }
        if ((jmsCorrelationId = reader.getAttributeValue(null, "JMSCorrelationID")) != null && jmsCorrelationId.length() > 0) {
            jmsBinding.setJMSCorrelationId(jmsCorrelationId);
        }
        if ((jmsDeliveryMode = reader.getAttributeValue(null, "JMSDeliveryMode")) != null && jmsDeliveryMode.length() > 0) {
            if ("PERSISTENT".equalsIgnoreCase(jmsDeliveryMode)) {
                jmsBinding.setJMSDeliveryMode(true);
            } else if ("NON_PERSISTENT".equalsIgnoreCase(jmsDeliveryMode)) {
                jmsBinding.setJMSDeliveryMode(false);
            } else {
                this.error("InvalidJMSDeliveryMode", jmsBinding, jmsDeliveryMode);
            }
        }
        if ((jmsTimeToLive = reader.getAttributeValue(null, "JMSTimeToLive")) != null && jmsTimeToLive.length() > 0) {
            jmsBinding.setJMSTimeToLive(Long.parseLong(jmsTimeToLive));
        }
        if ((jmsPriority = reader.getAttributeValue(null, "JMSPriority")) != null && jmsPriority.length() > 0) {
            int p = Integer.parseInt(jmsPriority);
            if (p >= 0 && p <= 9) {
                jmsBinding.setJMSPriority(p);
            } else {
                this.warning("InvalidJMSPriority", jmsBinding, jmsPriority);
            }
        }
        while (true) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getName().getLocalPart().equals("property")) break;
                    this.parseProperty(reader, jmsBinding);
                    break;
                }
                case 2: {
                    QName x = reader.getName();
                    if (x.getLocalPart().equals("headers")) {
                        return;
                    }
                    this.error("UnexpectedResponseElement", reader, x.toString());
                }
            }
        }
    }

    private void parseProperty(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        jmsBinding.setHeaders(true);
        String name = reader.getAttributeValue(null, "name");
        String type = reader.getAttributeValue(null, "type");
        if (name != null && name.length() > 0) {
            Object value = reader.getElementText();
            if ("boolean".equalsIgnoreCase(type)) {
                value = Boolean.parseBoolean((String)value);
            } else if ("byte".equalsIgnoreCase(type)) {
                value = Byte.parseByte((String)value);
            } else if ("short".equalsIgnoreCase(type)) {
                value = Short.parseShort((String)value);
            } else if ("int".equalsIgnoreCase(type)) {
                value = Integer.parseInt((String)value);
            } else if ("long".equalsIgnoreCase(type)) {
                value = Long.parseLong((String)value);
            } else if ("float".equalsIgnoreCase(type)) {
                value = Float.valueOf(Float.parseFloat((String)value));
            } else if ("double".equalsIgnoreCase(type)) {
                value = Double.parseDouble((String)value);
            } else if ("String".equalsIgnoreCase(type)) {
                // empty if block
            }
            jmsBinding.setProperty(name, value);
        }
    }

    private void parseOperationProperties(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String opName = reader.getAttributeValue(null, "name");
        if (opName == null || opName.length() < 1) {
            this.warning("MissingJMSOperationPropertyName", jmsBinding, new Object[0]);
            return;
        }
        jmsBinding.addOperationName(opName);
        String nativeOpName = reader.getAttributeValue(null, "nativeOperation");
        if (nativeOpName != null && nativeOpName.length() > 0) {
            jmsBinding.setNativeOperationName(opName, nativeOpName);
        }
        HashMap<String, BindingProperty> props = new HashMap<String, BindingProperty>();
        block4: while (true) {
            switch (reader.next()) {
                case 1: {
                    if (reader.getName().getLocalPart().equals("headers")) {
                        this.parseOperationHeaders(reader, jmsBinding, opName);
                        break;
                    }
                    if (!reader.getName().getLocalPart().equals("property")) break;
                    this.processProperty(reader, props);
                    break;
                }
                case 2: {
                    QName x;
                    if (!reader.isEndElement() || (x = reader.getName()).getLocalPart().equals("headers") || x.getLocalPart().equals("property")) continue block4;
                    if (x.getLocalPart().equals("operationProperties")) {
                        jmsBinding.getOperationPropertiesProperties(opName).putAll(props);
                        return;
                    }
                    this.error("UnexpectedResponseElement", reader, x.toString());
                }
            }
        }
    }

    private void parseOperationHeaders(XMLStreamReader reader, JMSBinding jmsBinding, String opName) throws XMLStreamException {
        String jmsPriority;
        String jmsTimeToLive;
        String jmsDeliveryMode;
        String jmsCorrelationId;
        String jmsType = reader.getAttributeValue(null, "JMSType");
        if (jmsType != null && jmsType.length() > 0) {
            jmsBinding.setOperationJMSType(opName, jmsType);
        }
        if ((jmsCorrelationId = reader.getAttributeValue(null, "JMSCorrelationID")) != null && jmsCorrelationId.length() > 0) {
            jmsBinding.setOperationJMSCorrelationId(opName, jmsCorrelationId);
        }
        if ((jmsDeliveryMode = reader.getAttributeValue(null, "JMSDeliveryMode")) != null && jmsDeliveryMode.length() > 0) {
            if ("PERSISTENT".equalsIgnoreCase(jmsDeliveryMode)) {
                jmsBinding.setJMSDeliveryMode(true);
            } else if ("NON_PERSISTENT".equalsIgnoreCase(jmsDeliveryMode)) {
                jmsBinding.setOperationJMSDeliveryMode(opName, false);
            } else {
                this.error("InvalidOPJMSDeliveryMode", jmsBinding, jmsDeliveryMode);
            }
        }
        if ((jmsTimeToLive = reader.getAttributeValue(null, "JMSTimeToLive")) != null && jmsTimeToLive.length() > 0) {
            jmsBinding.setOperationJMSTimeToLive(opName, Long.parseLong(jmsTimeToLive));
        }
        if ((jmsPriority = reader.getAttributeValue(null, "JMSPriority")) != null && jmsPriority.length() > 0) {
            int p = Integer.parseInt(jmsPriority);
            if (p >= 0 && p <= 9) {
                jmsBinding.setOperationJMSPriority(opName, p);
            } else {
                this.warning("InvalidOPJMSPriority", jmsBinding, jmsPriority);
            }
        }
        while (true) {
            switch (reader.next()) {
                case 1: {
                    if (!reader.getName().getLocalPart().equals("property")) break;
                    this.parseOperationPropertyProperties(reader, jmsBinding, opName);
                    break;
                }
                case 2: {
                    QName x = reader.getName();
                    if (x.getLocalPart().equals("headers")) {
                        return;
                    }
                    this.error("UnexpectedResponseElement", reader, x.toString());
                }
            }
        }
    }

    private void parseOperationPropertyProperties(XMLStreamReader reader, JMSBinding jmsBinding, String opName) throws XMLStreamException {
        String propName = reader.getAttributeValue(null, "name");
        String type = reader.getAttributeValue(null, "type");
        if (propName != null && propName.length() > 0) {
            Object value = reader.getElementText();
            if ("boolean".equalsIgnoreCase(type)) {
                value = Boolean.parseBoolean((String)value);
            } else if ("byte".equalsIgnoreCase(type)) {
                value = Byte.parseByte((String)value);
            } else if ("short".equalsIgnoreCase(type)) {
                value = Short.parseShort((String)value);
            } else if ("int".equalsIgnoreCase(type)) {
                value = Integer.parseInt((String)value);
            } else if ("long".equalsIgnoreCase(type)) {
                value = Long.parseLong((String)value);
            } else if ("float".equalsIgnoreCase(type)) {
                value = Float.valueOf(Float.parseFloat((String)value));
            } else if ("double".equalsIgnoreCase(type)) {
                value = Double.parseDouble((String)value);
            } else if ("String".equalsIgnoreCase(type)) {
                // empty if block
            }
            jmsBinding.setOperationProperty(opName, propName, value);
        }
    }

    private void parseSubscriptionHeaders(XMLStreamReader reader, JMSBinding jmsBinding) throws XMLStreamException {
        String jmsSelector = reader.getAttributeValue(null, "JMSSelector");
        if (jmsSelector != null && jmsSelector.length() > 0) {
            jmsBinding.setJMSSelector(jmsSelector);
        }
        while (reader.hasNext() && (reader.next() != 2 || !"SubscriptionHeaders".equals(reader.getName().getLocalPart()))) {
        }
    }

    private Map<String, BindingProperty> parseBindingProperties(XMLStreamReader reader) throws XMLStreamException {
        HashMap<String, BindingProperty> props = new HashMap<String, BindingProperty>();
        String parentName = reader.getName().getLocalPart();
        boolean completed = false;
        while (!completed) {
            switch (reader.next()) {
                case 1: {
                    String elementName = reader.getName().getLocalPart();
                    if (!"property".equals(elementName)) break;
                    this.processProperty(reader, props);
                    break;
                }
                case 2: {
                    String endName = reader.getName().getLocalPart();
                    if (!parentName.equals(endName)) break;
                    completed = true;
                }
            }
        }
        return props;
    }

    private void processProperty(XMLStreamReader reader, Map<String, BindingProperty> props) throws XMLStreamException {
        String name = reader.getAttributeValue(null, "name");
        if (name == null || name.length() < 1) {
            this.error("InvalidPropertyElement", reader, new Object[0]);
        }
        String type = reader.getAttributeValue(null, "type");
        String value = reader.getElementText();
        props.put(name, new BindingProperty(name, type, value));
    }

    public void validate() {
        this.validate(null);
    }

    protected void validate(JMSBinding jmsBinding) {
        String responseDestinationName;
        QName responseConnectionName;
        String activationSpecName;
        if (jmsBinding == null) {
            return;
        }
        String connectionFactoryName = jmsBinding.getConnectionFactoryName();
        if (connectionFactoryName != null && connectionFactoryName.length() > 0) {
            if ("queue" == jmsBinding.getDestinationType() && connectionFactoryName.contains("topic")) {
                this.error("DestinationQueueContradiction", jmsBinding, connectionFactoryName);
            }
            if ("topic" == jmsBinding.getDestinationType() && connectionFactoryName.contains("queue")) {
                this.error("DestinationTopicContradiction", jmsBinding, connectionFactoryName);
            }
        }
        if (connectionFactoryName != null && connectionFactoryName.length() > 0 && (activationSpecName = jmsBinding.getActivationSpecName()) != null && activationSpecName.length() > 0) {
            this.error("ConnectionFactoryActivationSpecContradiction", jmsBinding, connectionFactoryName, activationSpecName);
        }
        if ((responseConnectionName = jmsBinding.getResponseConnectionName()) != null && responseConnectionName.getLocalPart().length() > 0 && (responseDestinationName = jmsBinding.getResponseDestinationName()) != null && responseDestinationName.length() > 0) {
            this.error("ResponseAttrElement", jmsBinding, responseConnectionName, responseDestinationName);
        }
    }

    public void write(JMSBinding jmsBinding, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        String correlationScheme;
        String dest;
        this.writeStart(writer, "http://www.osoa.org/xmlns/sca/1.0", "binding.jms", new BaseStAXArtifactProcessor.XAttr[]{new BaseStAXArtifactProcessor.XAttr("requestConnection", jmsBinding.getRequestConnectionName()), new BaseStAXArtifactProcessor.XAttr("responseConnection", jmsBinding.getResponseConnectionName())});
        if (jmsBinding.getName() != null) {
            writer.writeAttribute("name", jmsBinding.getName());
        }
        if (jmsBinding.getURI() != null) {
            writer.writeAttribute("uri", jmsBinding.getURI());
        }
        if ((dest = jmsBinding.getDestinationName()) != null && dest != null) {
            writer.writeAttribute("uri", "jms:" + jmsBinding.getDestinationName());
        }
        if ((correlationScheme = jmsBinding.getCorrelationScheme()) != null && !correlationScheme.equals("requestmsgidtocorrelid")) {
            writer.writeAttribute("correlationScheme", jmsBinding.getCorrelationScheme());
        }
        if (jmsBinding.getInitialContextFactoryName() != null) {
            writer.writeAttribute("initialContextFactory", jmsBinding.getInitialContextFactoryName());
        }
        if (jmsBinding.getJndiURL() != null) {
            writer.writeAttribute("jndiURL", jmsBinding.getJndiURL());
        }
        if (jmsBinding.containsHeaders()) {
            this.writeHeaders(jmsBinding, writer);
        }
        this.writeOperationProperties(jmsBinding, writer);
        this.writeSubscriptionHeaders(jmsBinding, writer);
        this.writeDestinationProperties(jmsBinding, writer);
        this.writeConnectionFactoryProperties(jmsBinding, writer);
        this.writeActivationSpecProperties(jmsBinding, writer);
        String responseDestName = jmsBinding.getResponseDestinationName();
        String responseCFName = jmsBinding.getResponseConnectionFactoryName();
        String responseASName = jmsBinding.getResponseActivationSpecName();
        if (responseDestName != null || responseCFName != null || responseASName != null) {
            writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "response");
            this.writeResponseDestinationProperties(jmsBinding, writer);
            this.writeResponseConnectionFactoryProperties(jmsBinding, writer);
            this.writeResponseActivationSpecProperties(jmsBinding, writer);
            if (jmsBinding.getResponseWireFormat() != null && !(jmsBinding.getResponseWireFormat() instanceof WireFormatJMSTextXML)) {
                this.writeWireFormat(jmsBinding.getResponseWireFormat(), writer);
            }
            writer.writeEndElement();
            writer.writeCharacters(" ");
        }
        this.writeResourceAdapterProperties(jmsBinding, writer);
        this.writeConfiguredOperations(jmsBinding, writer);
        if (jmsBinding.getRequestWireFormat() != null && !(jmsBinding.getRequestWireFormat() instanceof WireFormatJMSTextXML)) {
            this.writeWireFormat(jmsBinding.getRequestWireFormat(), writer);
        }
        if (jmsBinding.getOperationSelector() != null && !(jmsBinding.getOperationSelector() instanceof OperationSelectorJMSDefault)) {
            this.writeOperationSelector(jmsBinding.getOperationSelector(), writer);
        }
        this.writeEnd(writer);
    }

    private void writeHeaders(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        Integer jmsPriority;
        Long jmsTimeToLive;
        Boolean jmsDeliveryMode;
        String jmsCorrelationId;
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "headers");
        String jmsType = jmsBinding.getJMSType();
        if (jmsType != null && jmsType.length() > 0) {
            writer.writeAttribute("JMSType", jmsType);
        }
        if ((jmsCorrelationId = jmsBinding.getJMSCorrelationId()) != null && jmsCorrelationId.length() > 0) {
            writer.writeAttribute("JMSCorrelationId", jmsCorrelationId);
        }
        if ((jmsDeliveryMode = jmsBinding.isdeliveryModePersistent()) != null) {
            if (jmsDeliveryMode.booleanValue()) {
                writer.writeAttribute("JMSDeliveryMode", "PERSISTENT");
            } else {
                writer.writeAttribute("JMSDeliveryMode", "NON_PERSISTENT");
            }
        }
        if ((jmsTimeToLive = jmsBinding.getJMSTimeToLive()) != null) {
            writer.writeAttribute("JMSTimeToLive", jmsTimeToLive.toString());
        }
        if ((jmsPriority = jmsBinding.getJMSPriority()) != null) {
            writer.writeAttribute("JMSPriority", jmsPriority.toString());
        }
        Map<String, Object> properties = jmsBinding.getProperties();
        this.writeProperties(properties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeProperties(Map<String, Object> properties, XMLStreamWriter writer) throws XMLStreamException {
        if (properties == null || properties.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "property");
            writer.writeAttribute("name", key.toString());
            if (value instanceof String) {
                writer.writeCharacters(value.toString());
            } else if (value instanceof BindingProperty) {
                BindingProperty property = (BindingProperty)value;
                String type = property.getType();
                if (type != null) {
                    writer.writeAttribute("type", type);
                }
                writer.writeCharacters(property.getValue().toString());
            } else if (value instanceof Boolean) {
                writer.writeAttribute("type", "boolean");
                writer.writeCharacters(value.toString());
            } else if (value instanceof Byte) {
                writer.writeAttribute("type", "byte");
                writer.writeCharacters(value.toString());
            } else if (value instanceof Short) {
                writer.writeAttribute("type", "short");
                writer.writeCharacters(value.toString());
            } else if (value instanceof Integer) {
                writer.writeAttribute("type", "int");
                writer.writeCharacters(value.toString());
            } else if (value instanceof Long) {
                writer.writeAttribute("type", "long");
                writer.writeCharacters(value.toString());
            } else if (value instanceof Float) {
                writer.writeAttribute("type", "float");
                writer.writeCharacters(value.toString());
            } else if (value instanceof Double) {
                writer.writeAttribute("type", "double");
                writer.writeCharacters(value.toString());
            } else {
                writer.writeCharacters(value.toString());
            }
            writer.writeEndElement();
        }
    }

    private void writeOperationProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        Set<String> operationNames = jmsBinding.getOperationNames();
        if (operationNames == null || operationNames.size() < 1) {
            return;
        }
        for (String opName : operationNames) {
            writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "operationProperties");
            writer.writeAttribute("name", opName);
            String nativeOperation = jmsBinding.getNativeOperationName(opName);
            if (nativeOperation != null && nativeOperation.length() > 0 && !nativeOperation.equals(opName)) {
                writer.writeAttribute("nativeOperation", nativeOperation);
            }
            Map<String, BindingProperty> operationPropertiesProperties = jmsBinding.getOperationPropertiesProperties(opName);
            this.writeBindingProperties(operationPropertiesProperties, writer);
            String jmsType = jmsBinding.getOperationJMSType(opName);
            String jmsCorrelationId = jmsBinding.getOperationJMSCorrelationId(opName);
            Boolean jmsDeliveryMode = jmsBinding.getOperationJMSDeliveryMode(opName);
            Long jmsTimeToLive = jmsBinding.getOperationJMSTimeToLive(opName);
            Integer jmsPriority = jmsBinding.getOperationJMSPriority(opName);
            Map<String, Object> operationProperties = jmsBinding.getOperationProperties(opName);
            if (jmsType != null || jmsCorrelationId != null || jmsDeliveryMode != null || jmsTimeToLive != null || jmsPriority != null || operationProperties != null) {
                writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "headers");
                if (jmsType != null && jmsType.length() > 0) {
                    writer.writeAttribute("JMSType", jmsType);
                }
                if (jmsCorrelationId != null && jmsCorrelationId.length() > 0) {
                    writer.writeAttribute("JMSCorrelationId", jmsCorrelationId);
                }
                if (jmsDeliveryMode != null) {
                    if (jmsDeliveryMode.booleanValue()) {
                        writer.writeAttribute("JMSDeliveryMode", "PERSISTENT");
                    } else {
                        writer.writeAttribute("JMSDeliveryMode", "NON_PERSISTENT");
                    }
                }
                if (jmsTimeToLive != null) {
                    writer.writeAttribute("JMSTimeToLive", jmsTimeToLive.toString());
                }
                if (jmsPriority != null) {
                    writer.writeAttribute("JMSPriority", jmsPriority.toString());
                }
                this.writeProperties(operationProperties, writer);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeCharacters(" ");
        }
    }

    private void writeBindingProperties(Map<String, BindingProperty> properties, XMLStreamWriter writer) throws XMLStreamException {
        if (properties == null || properties.size() == 0) {
            return;
        }
        for (Map.Entry<String, BindingProperty> entry : properties.entrySet()) {
            String key = entry.getKey();
            BindingProperty value = entry.getValue();
            writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "property");
            writer.writeAttribute("name", key.toString());
            if (value instanceof String) {
                writer.writeCharacters(value.toString());
            } else if (value instanceof BindingProperty) {
                BindingProperty property = value;
                String type = property.getType();
                if (type != null) {
                    writer.writeAttribute("type", type);
                }
                writer.writeCharacters(property.getValue().toString());
            } else {
                writer.writeCharacters(value.toString());
            }
            writer.writeEndElement();
        }
    }

    private void writeSubscriptionHeaders(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String jmsSubscriptionHeaders = jmsBinding.getJMSSelector();
        if (jmsSubscriptionHeaders != null && jmsSubscriptionHeaders.length() > 0) {
            writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "SubscriptionHeaders");
            writer.writeAttribute("JMSSelector", jmsSubscriptionHeaders);
            writer.writeEndElement();
        }
    }

    private void writeDestinationProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String destinationCreate;
        String destinationName = jmsBinding.getDestinationName();
        if (destinationName == null || destinationName.length() < 1) {
            return;
        }
        if (destinationName == null) {
            return;
        }
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "destination");
        if (destinationName != null && destinationName.length() > 0) {
            writer.writeAttribute("name", destinationName);
        }
        if ((destinationCreate = jmsBinding.getDestinationCreate()) != null && destinationCreate.length() > 0) {
            writer.writeAttribute("create", destinationCreate);
        }
        Map<String, BindingProperty> destinationProperties = jmsBinding.getDestinationProperties();
        this.writeBindingProperties(destinationProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeConnectionFactoryProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String destinationCreate;
        String cfName = jmsBinding.getConnectionFactoryName();
        if (cfName == null || cfName.length() < 1) {
            return;
        }
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "connectionFactory");
        if (cfName != null && cfName.length() > 0) {
            writer.writeAttribute("name", cfName);
        }
        if ((destinationCreate = jmsBinding.getConnectionFactoryCreate()) != null && destinationCreate.length() > 0) {
            writer.writeAttribute("create", destinationCreate);
        }
        Map<String, BindingProperty> cfProperties = jmsBinding.getConnectionFactoryProperties();
        this.writeBindingProperties(cfProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeActivationSpecProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String destinationCreate;
        String asName = jmsBinding.getActivationSpecName();
        if (asName == null || asName.length() < 1) {
            return;
        }
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "activationSpec");
        if (asName != null && asName.length() > 0) {
            writer.writeAttribute("name", asName);
        }
        if ((destinationCreate = jmsBinding.getActivationSpecCreate()) != null && destinationCreate.length() > 0) {
            writer.writeAttribute("create", destinationCreate);
        }
        Map<String, BindingProperty> cfProperties = jmsBinding.getActivationSpecProperties();
        this.writeBindingProperties(cfProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeResponseDestinationProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String destinationCreate;
        String destinationName = jmsBinding.getResponseDestinationName();
        if (destinationName == null || destinationName.length() < 1) {
            return;
        }
        if (destinationName == null) {
            return;
        }
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "destination");
        if (destinationName != null && destinationName.length() > 0) {
            writer.writeAttribute("name", destinationName);
        }
        if ((destinationCreate = jmsBinding.getResponseDestinationCreate()) != null && destinationCreate.length() > 0) {
            writer.writeAttribute("create", destinationCreate);
        }
        Map<String, BindingProperty> destinationProperties = jmsBinding.getResponseDestinationProperties();
        this.writeBindingProperties(destinationProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeResponseConnectionFactoryProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String destinationCreate;
        String cfName = jmsBinding.getResponseConnectionFactoryName();
        if (cfName == null || cfName.length() < 1) {
            return;
        }
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "connectionFactory");
        if (cfName != null && cfName.length() > 0) {
            writer.writeAttribute("name", cfName);
        }
        if ((destinationCreate = jmsBinding.getResponseConnectionFactoryCreate()) != null && destinationCreate.length() > 0) {
            writer.writeAttribute("create", destinationCreate);
        }
        Map<String, BindingProperty> cfProperties = jmsBinding.getResponseConnectionFactoryProperties();
        this.writeBindingProperties(cfProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeResponseActivationSpecProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String destinationCreate;
        String asName = jmsBinding.getResponseActivationSpecName();
        if (asName == null || asName.length() < 1) {
            return;
        }
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "activationSpec");
        if (asName != null && asName.length() > 0) {
            writer.writeAttribute("name", asName);
        }
        if ((destinationCreate = jmsBinding.getResponseActivationSpecCreate()) != null && destinationCreate.length() > 0) {
            writer.writeAttribute("create", destinationCreate);
        }
        Map<String, BindingProperty> cfProperties = jmsBinding.getResponseActivationSpecProperties();
        this.writeBindingProperties(cfProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeResourceAdapterProperties(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException {
        String asName = jmsBinding.getResourceAdapterName();
        if (asName == null || asName.length() < 1) {
            return;
        }
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", "resourceAdapter");
        if (asName != null && asName.length() > 0) {
            writer.writeAttribute("name", asName);
        }
        Map<String, BindingProperty> cfProperties = jmsBinding.getResourceAdapterProperties();
        this.writeBindingProperties(cfProperties, writer);
        writer.writeEndElement();
        writer.writeCharacters(" ");
    }

    private void writeConfiguredOperations(JMSBinding jmsBinding, XMLStreamWriter writer) throws XMLStreamException, ContributionWriteException {
        List<ConfiguredOperation> configOps = jmsBinding.getConfiguredOperations();
        if (configOps == null || configOps.size() < 1) {
            return;
        }
        Iterator<ConfiguredOperation> it = configOps.iterator();
        while (it.hasNext()) {
            this.configuredOperationProcessor.write(it.next(), writer);
        }
        writer.writeCharacters(" ");
    }

    private void writeWireFormat(WireFormat wireFormat, XMLStreamWriter writer) throws XMLStreamException, ContributionWriteException {
        this.extensionProcessor.write((Object)wireFormat, writer);
    }

    private void writeOperationSelector(OperationSelector operationSeletor, XMLStreamWriter writer) throws XMLStreamException, ContributionWriteException {
        this.extensionProcessor.write((Object)operationSeletor, writer);
    }
}

