/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.atom.provider;

import java.util.List;
import org.apache.abdera.model.Entry;
import org.apache.http.client.HttpClient;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.atom.AtomBinding;
import org.apache.tuscany.sca.binding.atom.provider.AtomBindingInvoker;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.host.http.client.HttpClientFactory;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;

class AtomReferenceBindingProvider
implements ReferenceBindingProvider {
    private HttpClientFactory httpClientFactory;
    private EndpointReference endpointReference;
    private RuntimeComponentReference reference;
    private AtomBinding binding;
    private String authorizationHeader = null;
    private HttpClient httpClient;
    private Mediator mediator;
    private DataType<?> itemClassType;
    private DataType<?> itemXMLType;
    private boolean supportsFeedEntries;

    AtomReferenceBindingProvider(HttpClientFactory httpClientFactory, EndpointReference endpointReference, Mediator mediator) {
        this.httpClientFactory = httpClientFactory;
        this.endpointReference = endpointReference;
        this.reference = (RuntimeComponentReference)endpointReference.getReference();
        this.binding = (AtomBinding)endpointReference.getBinding();
        this.mediator = mediator;
    }

    public Invoker createInvoker(Operation operation) {
        String operationName = operation.getName();
        String uri = this.endpointReference.getDeployedURI();
        if (operationName.equals("get")) {
            DataType outputType;
            this.itemXMLType = new DataTypeImpl(String.class.getName(), String.class, String.class);
            this.itemClassType = outputType = (DataType)((List)operation.getOutputType().getLogical()).get(0);
            if (this.itemClassType.getPhysical() == Entry.class) {
                this.supportsFeedEntries = true;
            }
            return new AtomBindingInvoker.GetInvoker(operation, uri, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("post")) {
            return new AtomBindingInvoker.PostInvoker(operation, uri, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("put")) {
            return new AtomBindingInvoker.PutInvoker(operation, uri, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("delete")) {
            return new AtomBindingInvoker.DeleteInvoker(operation, uri, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("getFeed") || operationName.equals("getAll")) {
            return new AtomBindingInvoker.GetAllInvoker(operation, uri, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("postMedia")) {
            return new AtomBindingInvoker.PostMediaInvoker(operation, uri, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("putMedia")) {
            return new AtomBindingInvoker.PutMediaInvoker(operation, uri, this.httpClient, this.authorizationHeader, this);
        }
        if (operationName.equals("query")) {
            return new AtomBindingInvoker.QueryInvoker(operation, uri, this.httpClient, this.authorizationHeader, this);
        }
        return new AtomBindingInvoker(operation, uri, this.httpClient, this.authorizationHeader, this);
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.reference.getInterfaceContract();
    }

    public void start() {
        this.httpClient = this.httpClientFactory.createHttpClient();
    }

    public void stop() {
        if (this.httpClient != null) {
            this.httpClient.getConnectionManager().shutdown();
        }
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    Mediator getMediator() {
        return this.mediator;
    }

    DataType<?> getItemClassType() {
        return this.itemClassType;
    }

    DataType<?> getItemXMLType() {
        return this.itemXMLType;
    }

    boolean supportsFeedEntries() {
        return this.supportsFeedEntries;
    }
}

