/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.atom.provider;

import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.atom.AtomBinding;
import org.apache.tuscany.sca.binding.atom.provider.AtomReferenceBindingProvider;
import org.apache.tuscany.sca.binding.atom.provider.AtomServiceBindingProvider;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostHelper;
import org.apache.tuscany.sca.host.http.client.HttpClientFactory;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class AtomBindingProviderFactory
implements BindingProviderFactory<AtomBinding> {
    private MessageFactory messageFactory;
    private Mediator mediator;
    private ServletHost servletHost;
    private HttpClientFactory httpClientFactory;

    public AtomBindingProviderFactory(ExtensionPointRegistry extensionPoints) {
        this.servletHost = ServletHostHelper.getServletHost((ExtensionPointRegistry)extensionPoints);
        FactoryExtensionPoint modelFactories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.messageFactory = (MessageFactory)modelFactories.getFactory(MessageFactory.class);
        this.mediator = (Mediator)((UtilityExtensionPoint)extensionPoints.getExtensionPoint(UtilityExtensionPoint.class)).getUtility(Mediator.class);
        this.httpClientFactory = HttpClientFactory.getInstance((ExtensionPointRegistry)extensionPoints);
    }

    public ReferenceBindingProvider createReferenceBindingProvider(RuntimeEndpointReference endpointReference) {
        return new AtomReferenceBindingProvider(this.httpClientFactory, (EndpointReference)endpointReference, this.mediator);
    }

    public ServiceBindingProvider createServiceBindingProvider(RuntimeEndpoint endpoint) {
        return new AtomServiceBindingProvider(endpoint, this.messageFactory, this.mediator, this.servletHost);
    }

    public Class<AtomBinding> getModelType() {
        return AtomBinding.class;
    }
}

