/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.shell.jline;

import java.io.File;
import java.util.List;
import jline.FileNameCompletor;
import org.apache.tuscany.sca.shell.Shell;
import org.apache.tuscany.sca.shell.jline.ICURICompletor;
import org.apache.tuscany.sca.shell.jline.TShellCompletor;

public class InstallCompletor
extends FileNameCompletor {
    ICURICompletor icuriCompletor;

    public InstallCompletor(Shell shell) {
        this.icuriCompletor = new ICURICompletor(shell);
    }

    public int complete(String buf, int cursor, List candidates) {
        if ("-duris".equals(TShellCompletor.lastArg)) {
            return this.icuriCompletor.complete(buf, cursor, candidates);
        }
        if ("-metadata".equals(TShellCompletor.lastArg)) {
            return super.complete(buf, cursor, candidates);
        }
        return super.complete(buf, cursor, candidates);
    }

    public int matchFiles(String buffer, String translated, File[] entries, List candidates) {
        int i;
        if (entries == null) {
            return -1;
        }
        int matches = 0;
        for (i = 0; i < entries.length; ++i) {
            if (!entries[i].getAbsolutePath().startsWith(translated)) continue;
            ++matches;
        }
        if ("-metadata".startsWith(buffer)) {
            ++matches;
        }
        if ("-duris".startsWith(buffer)) {
            ++matches;
        }
        if ("-start".startsWith(buffer)) {
            ++matches;
        }
        for (i = 0; i < entries.length; ++i) {
            if (!entries[i].getAbsolutePath().startsWith(translated)) continue;
            String name = entries[i].getName() + (matches == 1 && entries[i].isDirectory() ? File.separator : " ");
            candidates.add(name);
        }
        if ("-metadata".startsWith(buffer) && !TShellCompletor.allArgs.contains("-metadata")) {
            candidates.add("-metadata" + (matches == 1 ? " " : ""));
        }
        if ("-duris".startsWith(buffer) && !TShellCompletor.allArgs.contains("-duris")) {
            candidates.add("-duris" + (matches == 1 ? " " : ""));
        }
        if ("-start".startsWith(buffer) && !TShellCompletor.allArgs.contains("-start")) {
            candidates.add("-start" + (matches == 1 ? " " : ""));
        }
        int index = buffer.lastIndexOf(File.separator);
        int x = index + File.separator.length();
        return x;
    }
}

