/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.runtime;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class DomainRegistryURI {
    private String domainName = "default";
    private String bindAddress = null;
    private int listenPort = 14820;
    private String password = "tuscany";
    private boolean multicastDisabled = false;
    private String multicastAddress = "224.5.12.10";
    private int multicastPort = 51482;
    private List<String> remotes = new ArrayList<String>();
    private String uri;

    public DomainRegistryURI(String uri) {
        this.uri = uri;
        this.parseURI(uri);
    }

    private void parseURI(String uri) {
        if (uri.startsWith("tuscanyclient:")) {
            uri = uri.replace("tuscanyclient:", "tuscany:");
        }
        if (!uri.startsWith("tuscany:")) {
            throw new IllegalArgumentException("Config URI must start with 'tuscany:'");
        }
        int i = uri.indexOf(":");
        if (uri.charAt("tuscany:".length()) != '/') {
            uri = uri.replaceFirst(":", ":/");
        }
        if (uri.charAt("tuscany:".length() + 1) != '/') {
            uri = uri.replaceFirst(":/", "://");
        }
        URI configURI = URI.create(uri);
        this.domainName = configURI.getHost();
        String query = configURI.getQuery();
        if (query != null && query.length() > 0) {
            String[] params = query.split("&");
            HashMap<String, String> paramMap = new HashMap<String, String>();
            for (String param : params) {
                paramMap.put(param.split("=")[0], param.split("=")[1]);
            }
            for (String name : paramMap.keySet()) {
                String[] ips;
                String[] addr;
                String value = (String)paramMap.get(name);
                if ("listen".equals(name)) {
                    if (value.indexOf(":") == -1) {
                        this.listenPort = Integer.parseInt(value);
                        continue;
                    }
                    addr = value.split(":");
                    this.bindAddress = addr[0];
                    this.listenPort = Integer.parseInt(addr[1]);
                    continue;
                }
                if ("multicast".equals(name)) {
                    if ("off".equalsIgnoreCase(value)) {
                        this.multicastDisabled = true;
                        continue;
                    }
                    if (value.indexOf(":") == -1) {
                        this.multicastAddress = value;
                        continue;
                    }
                    addr = value.split(":");
                    this.multicastAddress = addr[0];
                    this.multicastPort = Integer.parseInt(addr[1]);
                    continue;
                }
                if ("password".equals(name)) {
                    this.password = value;
                    continue;
                }
                if (!"remotes".equals(name)) continue;
                for (String ip : ips = value.split(",")) {
                    if (ip.indexOf(":") == -1) {
                        this.remotes.add(ip + ":14820");
                        continue;
                    }
                    this.remotes.add(ip);
                }
                if (paramMap.containsKey("multicast")) continue;
                this.multicastDisabled = true;
            }
        }
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public int getListenPort() {
        return this.listenPort;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isMulticastDisabled() {
        return this.multicastDisabled;
    }

    public String getMulticastAddress() {
        return this.multicastAddress;
    }

    public int getMulticastPort() {
        return this.multicastPort;
    }

    public List<String> getRemotes() {
        return this.remotes;
    }

    public String toString() {
        return this.uri;
    }
}

