/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tuscany.sca.common.xml.xpath.XPathHelper;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.ExternalAttachment;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.xml.PolicyConstants;
import org.apache.tuscany.sca.policy.xml.PolicyXPathFunction;
import org.apache.tuscany.sca.policy.xml.PolicyXPathFunctionResolver;

public class ExternalAttachmentProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<ExternalAttachment>,
PolicyConstants {
    private PolicyFactory policyFactory;
    private XPathHelper xpathHelper;

    public ExternalAttachmentProcessor(ExtensionPointRegistry registry) {
        FactoryExtensionPoint factories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.policyFactory = factories.getFactory(PolicyFactory.class);
        this.xpathHelper = XPathHelper.getInstance(registry);
    }

    @Override
    public Class<ExternalAttachment> getModelType() {
        return ExternalAttachment.class;
    }

    @Override
    public void resolve(ExternalAttachment attachment, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (attachment != null && attachment.isUnresolved()) {
            this.resolveIntents(attachment, resolver, context);
            this.resolvePolicySets(attachment, resolver, context);
            attachment.setUnresolved(false);
        }
    }

    private void resolvePolicySets(ExternalAttachment attachment, ModelResolver resolver, ProcessorContext context) {
        ArrayList<PolicySet> referredPolicySets = new ArrayList<PolicySet>();
        for (PolicySet referredPolicySet : attachment.getPolicySets()) {
            if (referredPolicySet.isUnresolved()) {
                PolicySet resolved = resolver.resolveModel(PolicySet.class, referredPolicySet, context);
                if (!resolved.isUnresolved() || resolved != referredPolicySet) {
                    referredPolicySets.add(resolved);
                    continue;
                }
                this.error(context.getMonitor(), "ReferredPolicySetNotFound", attachment, referredPolicySet, attachment);
                return;
            }
            referredPolicySets.add(referredPolicySet);
        }
        attachment.getPolicySets().clear();
        attachment.getPolicySets().addAll(referredPolicySets);
    }

    private void resolveIntents(ExternalAttachment attachment, ModelResolver resolver, ProcessorContext context) {
        if (attachment != null) {
            ArrayList<Intent> providedIntents = new ArrayList<Intent>();
            for (Intent providedIntent : attachment.getIntents()) {
                if (providedIntent.isUnresolved()) {
                    Intent resolved = resolver.resolveModel(Intent.class, providedIntent, context);
                    if (!resolved.isUnresolved() || resolved != providedIntent) {
                        providedIntents.add(resolved);
                        continue;
                    }
                    this.error(context.getMonitor(), "ProvidedIntentNotFound", attachment, providedIntent, attachment);
                    return;
                }
                providedIntents.add(providedIntent);
            }
            attachment.getIntents().clear();
            attachment.getIntents().addAll(providedIntents);
        }
    }

    @Override
    public QName getArtifactType() {
        return EXTERNAL_ATTACHMENT_QNAME;
    }

    @Override
    public ExternalAttachment read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        ExternalAttachment attachment = this.policyFactory.createExternalAttachment();
        this.readPolicySets(attachment, reader);
        this.readIntents(attachment, reader, context);
        this.readAttachTo(attachment, reader, context);
        return attachment;
    }

    private void readIntents(ExternalAttachment attachment, XMLStreamReader reader, ProcessorContext context) {
        String value = reader.getAttributeValue(null, "intents");
        if (value != null) {
            List<Intent> intents = attachment.getIntents();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                Intent intent = this.policyFactory.createIntent();
                intent.setName(qname);
                intents.add(intent);
            }
        }
    }

    private void readAttachTo(ExternalAttachment attachment, XMLStreamReader reader, ProcessorContext context) {
        Monitor monitor = context.getMonitor();
        String attachTo = reader.getAttributeValue(null, "attachTo");
        if (attachTo != null) {
            try {
                XPath path = this.xpathHelper.newXPath();
                NamespaceContext nsContext = this.xpathHelper.getNamespaceContext(attachTo, reader.getNamespaceContext());
                path.setXPathFunctionResolver(new PolicyXPathFunctionResolver(nsContext));
                attachTo = PolicyXPathFunction.normalize(attachTo, this.getSCAPrefix(nsContext));
                XPathExpression expression = this.xpathHelper.compile(path, nsContext, attachTo);
                attachment.setAttachTo(attachTo);
                attachment.setAttachToXPathExpression(expression);
            }
            catch (XPathExpressionException e) {
                ContributionReadException ce = new ContributionReadException(e);
                this.error(monitor, "ContributionReadException", attachment, ce);
            }
        }
    }

    private String getSCAPrefix(NamespaceContext nsContext) {
        Iterator<String> iter = nsContext.getPrefixes("http://docs.oasis-open.org/ns/opencsa/sca/200912");
        while (iter.hasNext()) {
            String prefix = iter.next();
            if (prefix.equals("")) continue;
            return prefix;
        }
        return "__sca";
    }

    private void readPolicySets(ExternalAttachment attachment, XMLStreamReader reader) {
        String value = reader.getAttributeValue(null, "policySets");
        if (value != null) {
            List<PolicySet> policySets = attachment.getPolicySets();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                PolicySet policySet = this.policyFactory.createPolicySet();
                policySet.setName(qname);
                policySets.add(policySet);
            }
        }
    }

    @Override
    public void write(ExternalAttachment attachment, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writePolicySets(attachment, writer, context);
        this.writeIntents(attachment, writer, context);
        this.writeAttachTo(attachment, writer, context);
    }

    private void writeAttachTo(ExternalAttachment attachment, XMLStreamWriter writer, ProcessorContext context) throws XMLStreamException {
        if (attachment.getAttachTo() != null) {
            writer.writeAttribute("attachTo", attachment.getAttachTo());
        }
    }

    private void writeIntents(ExternalAttachment attachment, XMLStreamWriter writer, ProcessorContext context) throws XMLStreamException {
        if (!attachment.getIntents().isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (Intent intent : attachment.getIntents()) {
                sb.append(this.getQualifiedName(intent.getName(), writer));
                sb.append(" ");
            }
            sb.deleteCharAt(sb.length() - 1);
            writer.writeAttribute("intents", sb.toString());
        }
    }

    private void writePolicySets(ExternalAttachment attachment, XMLStreamWriter writer, ProcessorContext context) throws XMLStreamException {
        if (!attachment.getPolicySets().isEmpty()) {
            StringBuffer sb = new StringBuffer();
            for (PolicySet ps : attachment.getPolicySets()) {
                sb.append(this.getQualifiedName(ps.getName(), writer));
                sb.append(" ");
            }
            sb.deleteCharAt(sb.length() - 1);
            writer.writeAttribute("policySets", sb.toString());
        }
    }

    private String getQualifiedName(QName name, XMLStreamWriter writer) throws XMLStreamException {
        String local = name.getLocalPart();
        String prefix = writer.getPrefix(name.getNamespaceURI());
        if (prefix != null && prefix.length() > 0) {
            return prefix + ':' + local;
        }
        return local;
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "org.apache.tuscany.sca.policy.xml.policy-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }
}

