/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.impl;

import java.lang.ref.WeakReference;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.impl.InterfaceImpl;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaOperationImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.policy.Intent;
import org.oasisopen.sca.ResponseDispatch;

public class JavaInterfaceImpl
extends InterfaceImpl
implements JavaInterface {
    private String className;
    private WeakReference<Class<?>> javaClass;
    private Class<?> callbackClass;
    private QName qname;
    private String jaxwsWSDLLocation;
    private String jaxwsJavaInterfaceName;
    private Contribution contributionContainingClass;
    private List<Operation> syncOperations = null;
    private static final String UNKNOWN_DATABINDING = null;
    static QName ASYNC_INVOCATION = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "asyncInvocation");

    protected JavaInterfaceImpl() {
        this.setUnresolved(true);
    }

    @Override
    public String getName() {
        if (this.isUnresolved()) {
            return this.className;
        }
        if (this.javaClass != null) {
            return ((Class)this.javaClass.get()).getName();
        }
        return null;
    }

    @Override
    public void setName(String className) {
        if (!this.isUnresolved()) {
            throw new IllegalStateException();
        }
        this.className = className;
    }

    @Override
    public QName getQName() {
        return this.qname;
    }

    @Override
    public void setQName(QName interfacename) {
        this.qname = interfacename;
    }

    @Override
    public Class<?> getJavaClass() {
        if (this.javaClass != null) {
            return (Class)this.javaClass.get();
        }
        return null;
    }

    @Override
    public void setJavaClass(Class<?> javaClass) {
        this.javaClass = new WeakReference(javaClass);
        if (javaClass != null) {
            this.className = javaClass.getName();
        }
    }

    @Override
    public Class<?> getCallbackClass() {
        return this.callbackClass;
    }

    @Override
    public void setCallbackClass(Class<?> callbackClass) {
        this.callbackClass = callbackClass;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JavaInterfaceImpl other = (JavaInterfaceImpl)obj;
        if (this.isUnresolved() || other.isUnresolved()) {
            if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
                return false;
            }
        } else {
            if (this.javaClass == null ? other.javaClass != null : !((Class)this.javaClass.get()).equals(other.javaClass.get())) {
                return false;
            }
            if (this.callbackClass == null ? other.callbackClass != null : !this.callbackClass.equals(other.callbackClass)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<Operation> getOperations() {
        if (!this.isUnresolved() && this.isAsyncServer()) {
            return this.equivalentSyncOperations();
        }
        return super.getOperations();
    }

    private List<Operation> equivalentSyncOperations() {
        if (this.syncOperations != null) {
            return this.syncOperations;
        }
        List<Operation> allOperations = super.getOperations();
        this.syncOperations = new ArrayList<Operation>();
        for (Operation operation : allOperations) {
            this.syncOperations.add(this.getSyncFormOfOperation((JavaOperation)operation));
            this.getAttributes().put("ASYNC-SERVER-OPERATIONS", allOperations);
        }
        return this.syncOperations;
    }

    private Operation getSyncFormOfOperation(JavaOperation operation) {
        if (this.isAsyncServerOperation(operation)) {
            JavaOperationImpl syncOperation = new JavaOperationImpl();
            String opName = operation.getName();
            DataType<List<DataType>> requestParams = operation.getInputType();
            List<DataType> faultDataTypes = this.prepareSyncFaults(operation);
            syncOperation.setName(opName);
            syncOperation.setAsyncServer(true);
            syncOperation.setInputWrapper(operation.getInputWrapper());
            syncOperation.setOutputWrapper(operation.getOutputWrapper());
            syncOperation.setInputWrapperStyle(operation.isInputWrapperStyle());
            syncOperation.setOutputWrapperStyle(operation.isOutputWrapperStyle());
            syncOperation.setHasArrayWrappedOutput(operation.hasArrayWrappedOutput());
            syncOperation.setNotSubjectToWrapping(operation.isNotSubjectToWrapping());
            syncOperation.setInputType(operation.getInputType());
            syncOperation.setOutputType(operation.getOutputType());
            syncOperation.setFaultTypes(faultDataTypes);
            syncOperation.setNonBlocking(operation.isNonBlocking());
            syncOperation.setJavaMethod(operation.getJavaMethod());
            syncOperation.setInterface(this);
            return syncOperation;
        }
        return operation;
    }

    private DataType<List<DataType>> prepareSyncInputParams(DataType<List<DataType>> requestParams) {
        List<DataType> requestLogical = requestParams.getLogical();
        int paramCount = requestLogical.size();
        ArrayList<DataType> asyncParams = new ArrayList<DataType>(paramCount - 1);
        for (int i = 0; i < paramCount - 1; ++i) {
            asyncParams.add(requestLogical.get(i));
        }
        DataTypeImpl<List<DataType>> inputType = new DataTypeImpl<List<DataType>>(requestParams.getDataBinding(), requestParams.getPhysical(), asyncParams);
        return inputType;
    }

    private DataType<List<DataType>> prepareSyncReturnParam(DataType<List<DataType>> requestParams) {
        List<DataType> requestLogical = requestParams.getLogical();
        int paramCount = requestLogical.size();
        DataType finalParam = requestLogical.get(paramCount - 1);
        ParameterizedType t = (ParameterizedType)finalParam.getGenericType();
        XMLType returnXMLType = (XMLType)finalParam.getLogical();
        String namespace = null;
        namespace = returnXMLType.isElement() ? returnXMLType.getElementName().getNamespaceURI() : returnXMLType.getTypeName().getNamespaceURI();
        Type[] typeArgs = t.getActualTypeArguments();
        if (typeArgs.length != 1) {
            throw new IllegalArgumentException("ResponseDispatch parameter is not parameterized correctly");
        }
        Class returnType = (Class)typeArgs[0];
        XMLType xmlReturnType = new XMLType(new QName(namespace, "return"), null);
        DataTypeImpl<XMLType> returnDataType = returnType == Void.TYPE ? null : new DataTypeImpl<XMLType>(UNKNOWN_DATABINDING, returnType, xmlReturnType);
        ArrayList<DataTypeImpl<XMLType>> returnTypes = new ArrayList<DataTypeImpl<XMLType>>();
        returnTypes.add(returnDataType);
        DataTypeImpl<List<DataType>> outputType = new DataTypeImpl<List<DataType>>("idl:output", requestParams.getPhysical(), returnTypes);
        return outputType;
    }

    private List<DataType> prepareSyncFaults(JavaOperation operation) {
        return operation.getFaultTypes();
    }

    private boolean isAsyncServerOperation(Operation operation) {
        if (operation.isAsyncServer()) {
            return true;
        }
        int size = operation.getOutputType().getLogical().size();
        if (size != 0) {
            return false;
        }
        if (!operation.getName().endsWith("Async")) {
            return false;
        }
        DataType<List<DataType>> requestParams = operation.getInputType();
        int paramCount = requestParams.getLogical().size();
        if (paramCount < 1) {
            return false;
        }
        DataType finalParam = requestParams.getLogical().get(paramCount - 1);
        return finalParam.getPhysical() == ResponseDispatch.class;
    }

    private boolean isAsyncServer() {
        List<Intent> intents = this.getRequiredIntents();
        for (Intent intent : intents) {
            if (!intent.getName().equals(ASYNC_INVOCATION)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getJAXWSWSDLLocation() {
        return this.jaxwsWSDLLocation;
    }

    @Override
    public void setJAXWSWSDLLocation(String wsdlLocation) {
        this.jaxwsWSDLLocation = wsdlLocation;
    }

    @Override
    public String getJAXWSJavaInterfaceName() {
        return this.jaxwsJavaInterfaceName;
    }

    @Override
    public void setJAXWSJavaInterfaceName(String javaInterfaceName) {
        this.jaxwsJavaInterfaceName = javaInterfaceName;
    }

    @Override
    public Contribution getContributionContainingClass() {
        return this.contributionContainingClass;
    }

    @Override
    public void setContributionContainingClass(Contribution contributionContainingClass) {
        this.contributionContainingClass = contributionContainingClass;
    }
}

