/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.introspect.BaseJavaClassVisitor;
import org.oasisopen.sca.annotation.EagerInit;

public class EagerInitProcessor
extends BaseJavaClassVisitor {
    public EagerInitProcessor(AssemblyFactory factory) {
        super(factory);
    }

    public EagerInitProcessor(ExtensionPointRegistry registry) {
        super(registry);
    }

    @Override
    public <T> void visitClass(Class<T> clazz, JavaImplementation type) throws IntrospectionException {
        super.visitClass(clazz, type);
        EagerInit annotation = clazz.getAnnotation(EagerInit.class);
        if (annotation == null) {
            for (Class<T> superClass = clazz.getSuperclass(); superClass != null && !Object.class.equals(superClass) && (annotation = superClass.getAnnotation(EagerInit.class)) == null; superClass = superClass.getSuperclass()) {
            }
            if (annotation == null) {
                return;
            }
        }
        type.setEagerInit(true);
    }
}

