/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.context;

import org.apache.tuscany.sca.core.factory.InstanceWrapper;
import org.apache.tuscany.sca.core.scope.TargetDestructionException;
import org.apache.tuscany.sca.core.scope.TargetInitializationException;
import org.apache.tuscany.sca.implementation.java.injection.Injector;
import org.apache.tuscany.sca.implementation.java.invocation.EventInvoker;

public class ReflectiveInstanceWrapper<T>
implements InstanceWrapper<T> {
    private final EventInvoker<T> initInvoker;
    private final EventInvoker<T> destroyInvoker;
    private final T instance;
    private final Injector<T>[] callbackInjectors;

    public ReflectiveInstanceWrapper(T instance, EventInvoker<T> initInvoker, EventInvoker<T> destroyInvoker, Injector<T>[] callbackInjectors) {
        this.instance = instance;
        this.initInvoker = initInvoker;
        this.destroyInvoker = destroyInvoker;
        this.callbackInjectors = callbackInjectors;
    }

    @Override
    public T getInstance() {
        return this.instance;
    }

    @Override
    public void start() throws TargetInitializationException {
        if (this.initInvoker != null) {
            try {
                this.initInvoker.invokeEvent(this.instance);
            }
            catch (Exception e) {
                try {
                    this.stop();
                }
                catch (TargetDestructionException e1) {
                    throw new TargetInitializationException("TargetDestructionException while handling init exception", e);
                }
                throw new TargetInitializationException(e);
            }
        }
    }

    @Override
    public void stop() throws TargetDestructionException {
        if (this.destroyInvoker != null) {
            this.destroyInvoker.invokeEvent(this.instance);
        }
    }

    public Injector<T>[] getCallbackInjectors() {
        return this.callbackInjectors;
    }
}

