/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.util;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.WrapperInfo;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

public final class DataTypeHelper {
    private DataTypeHelper() {
    }

    public static Set<Class<?>> findClasses(DataType d) {
        HashSet classes = new HashSet();
        HashSet<Type> visited = new HashSet<Type>();
        DataTypeHelper.findClasses(d, classes, visited);
        return classes;
    }

    private static void findClasses(DataType d, Set<Class<?>> classes, Set<Type> visited) {
        if (d == null) {
            return;
        }
        classes.add(d.getPhysical());
        if (d.getPhysical() != d.getGenericType()) {
            DataTypeHelper.findClasses(d.getGenericType(), classes, visited);
        }
    }

    private static void findClasses(Type type, Set<Class<?>> classSet, Set<Type> visited) {
        block8: {
            block10: {
                block9: {
                    block7: {
                        if (visited.contains(type) || type == null) {
                            return;
                        }
                        visited.add(type);
                        if (type instanceof Class) {
                            Class cls = (Class)type;
                            if (!cls.isInterface()) {
                                classSet.add(cls);
                            }
                            return;
                        }
                        if (!(type instanceof ParameterizedType)) break block7;
                        ParameterizedType pType = (ParameterizedType)type;
                        DataTypeHelper.findClasses(pType.getRawType(), classSet, visited);
                        for (Type t : pType.getActualTypeArguments()) {
                            DataTypeHelper.findClasses(t, classSet, visited);
                        }
                        break block8;
                    }
                    if (!(type instanceof TypeVariable)) break block9;
                    TypeVariable tv = (TypeVariable)type;
                    for (Type t : tv.getBounds()) {
                        DataTypeHelper.findClasses(t, classSet, visited);
                    }
                    break block8;
                }
                if (!(type instanceof GenericArrayType)) break block10;
                GenericArrayType gType = (GenericArrayType)type;
                DataTypeHelper.findClasses(gType, classSet, visited);
                break block8;
            }
            if (!(type instanceof WildcardType)) break block8;
            WildcardType wType = (WildcardType)type;
            for (Type t : wType.getLowerBounds()) {
                DataTypeHelper.findClasses(t, classSet, visited);
            }
            for (Type t : wType.getUpperBounds()) {
                DataTypeHelper.findClasses(t, classSet, visited);
            }
        }
    }

    public static List<DataType> getDataTypes(Interface intf, boolean useWrapper) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        for (Operation op : intf.getOperations()) {
            DataTypeHelper.getDataTypes(dataTypes, op, useWrapper);
        }
        return dataTypes;
    }

    public static List<DataType> getDataTypes(Operation op, boolean useWrapper) {
        ArrayList<DataType> dataTypes = new ArrayList<DataType>();
        DataTypeHelper.getDataTypes(dataTypes, op, useWrapper);
        return dataTypes;
    }

    private static void getDataTypes(List<DataType> dataTypes, Operation op, boolean useWrapper) {
        WrapperInfo inputWrapper = op.getInputWrapper();
        WrapperInfo outputWrapper = op.getOutputWrapper();
        if (useWrapper && inputWrapper != null && outputWrapper != null) {
            DataType<XMLType> dt2;
            DataType<XMLType> dt1 = inputWrapper.getWrapperType();
            if (dt1 != null) {
                dataTypes.add(dt1);
            }
            if ((dt2 = outputWrapper.getWrapperType()) != null) {
                dataTypes.add(dt2);
            }
        }
        for (DataType dt1 : op.getInputType().getLogical()) {
            dataTypes.add(dt1);
        }
        DataType<List<DataType>> dt2 = op.getOutputType();
        if (dt2 != null) {
            dataTypes.add(dt2);
        }
        for (DataType dt3 : op.getFaultTypes()) {
            DataType dt4 = (DataType)dt3.getLogical();
            if (dt4 == null) continue;
            dataTypes.add(dt4);
        }
    }
}

