/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.jaxb;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.common.xml.dom.DOMHelper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseDataBinding;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.XMLTypeHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBContextHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBTypeHelper;
import org.apache.tuscany.sca.databinding.jaxb.JAXBWrapperHandler;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JAXBDataBinding
extends BaseDataBinding {
    public static final String NAME = JAXBElement.class.getName();
    public static final String ROOT_NAMESPACE = "http://tuscany.apache.org/xmlns/sca/databinding/jaxb/1.0";
    public static final QName ROOT_ELEMENT = new QName("http://tuscany.apache.org/xmlns/sca/databinding/jaxb/1.0", "root");
    private JAXBWrapperHandler wrapperHandler = new JAXBWrapperHandler();
    private JAXBTypeHelper xmlTypeHelper;
    private DOMHelper domHelper;
    private JAXBContextHelper contextHelper;

    public JAXBDataBinding(ExtensionPointRegistry registry) {
        super(NAME, JAXBElement.class);
        this.xmlTypeHelper = new JAXBTypeHelper(registry);
        this.domHelper = DOMHelper.getInstance(registry);
        this.contextHelper = JAXBContextHelper.getInstance(registry);
    }

    @Override
    public boolean introspect(DataType dataType, Operation operation) {
        Class<?> javaType = dataType.getPhysical();
        if (JAXBElement.class.isAssignableFrom(javaType)) {
            Type actualType;
            ParameterizedType parameterizedType;
            Type rawType;
            Type type = javaType.getGenericSuperclass();
            if (type instanceof ParameterizedType && (rawType = (parameterizedType = (ParameterizedType)type).getRawType()) == JAXBElement.class && (actualType = parameterizedType.getActualTypeArguments()[0]) instanceof Class) {
                XMLType xmlType = JAXBContextHelper.getXmlTypeName((Class)actualType);
                dataType.setLogical(xmlType);
                dataType.setDataBinding(NAME);
                return true;
            }
            if (dataType.getLogical() == null) {
                dataType.setLogical(XMLType.UNKNOWN);
            }
            dataType.setDataBinding(NAME);
            return true;
        }
        XMLType xmlType = JAXBContextHelper.getXmlTypeName(javaType);
        if (xmlType == null) {
            return false;
        }
        Object logical = dataType.getLogical();
        if (logical instanceof XMLType && logical != XMLType.UNKNOWN) {
            ((XMLType)logical).setTypeName(xmlType.getTypeName());
        } else {
            dataType.setLogical(xmlType);
        }
        dataType.setDataBinding(NAME);
        return true;
    }

    @Override
    public Object copy(Object arg, DataType sourceDataType, DataType targetDataType, Operation sourceOperation, Operation targetOperation) {
        try {
            JAXBElement value;
            boolean isElement = false;
            if (sourceDataType == null) {
                Class cls = arg.getClass();
                if (arg instanceof JAXBElement) {
                    isElement = true;
                    cls = ((JAXBElement)arg).getDeclaredType();
                }
                sourceDataType = new DataTypeImpl<XMLType>(NAME, cls, XMLType.UNKNOWN);
            }
            JAXBContext context = this.contextHelper.createJAXBContext(sourceDataType);
            arg = JAXBContextHelper.createJAXBElement(context, sourceDataType, arg);
            Document doc = this.domHelper.newDocument();
            context.createMarshaller().marshal(arg, (Node)doc);
            if (targetDataType != null && targetDataType.getPhysical() != sourceDataType.getPhysical()) {
                JAXBContext targetContext = this.contextHelper.createJAXBContext(targetDataType);
                value = targetContext.createUnmarshaller().unmarshal((Node)doc, JAXBContextHelper.getValueType(targetDataType.getPhysical()));
            } else {
                value = context.createUnmarshaller().unmarshal((Node)doc, JAXBContextHelper.getValueType(sourceDataType.getPhysical()));
            }
            if (isElement && value instanceof JAXBElement) {
                return value;
            }
            return JAXBContextHelper.createReturnValue(context, sourceDataType, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public WrapperHandler getWrapperHandler() {
        return this.wrapperHandler;
    }

    @Override
    public XMLTypeHelper getXMLTypeHelper() {
        return this.xmlTypeHelper;
    }
}

