/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.tuscany.sca.interfacedef.Operation;

public class DataBindingContext {
    private String contentType;
    private Class<?> type;
    private Type genericType;
    private Annotation[] annotations;
    private Operation operation;

    public DataBindingContext(Class<?> type, Type genericType, Annotation[] annotations, Operation operation, String contentType) {
        this.type = type;
        this.genericType = genericType;
        this.annotations = annotations;
        this.operation = operation;
        this.contentType = contentType;
    }

    public DataBindingContext(Class<?> type, Type genericType, Annotation[] annotations) {
        this.type = type;
        this.genericType = genericType;
        this.annotations = annotations;
    }

    public DataBindingContext(Class<?> type) {
        this.type = type;
        this.genericType = type;
    }

    public Class<?> getType() {
        return this.type;
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public <A extends Annotation> A getAnnotation(Class<A> type) {
        if (this.annotations == null) {
            return null;
        }
        for (Annotation a : this.annotations) {
            if (a.annotationType() != type) continue;
            return (A)((Annotation)type.cast(a));
        }
        return null;
    }

    public String getContentType() {
        return this.contentType;
    }
}

