/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PhaseSorter<V>
implements Cloneable {
    private final Map<V, Vertex> vertices = new HashMap<V, Vertex>();

    public void addEdge(V source, V target) {
        Vertex t;
        Vertex s = this.getVertex(source);
        if (s == null) {
            s = new Vertex(source);
            this.vertices.put((Vertex)source, s);
        }
        if ((t = this.getVertex(target)) == null) {
            t = new Vertex(target);
            this.vertices.put((Vertex)target, t);
        }
        Edge edge = new Edge(s, t);
        s.outEdges.put(t, edge);
        t.inEdges.put(s, edge);
    }

    public void addVertext(V source) {
        Vertex s = this.getVertex(source);
        if (s == null) {
            s = new Vertex(source);
            this.vertices.put((Vertex)source, s);
        }
    }

    public Vertex getVertex(V source) {
        Vertex s = this.vertices.get(source);
        return s;
    }

    public boolean removeEdge(V source, V target) {
        Vertex s = this.getVertex(source);
        if (s == null) {
            return false;
        }
        Vertex t = this.getVertex(target);
        if (t == null) {
            return false;
        }
        return s.outEdges.remove(t) != null && t.inEdges.remove(s) != null;
    }

    public void removeEdge(Edge edge) {
        edge.sourceVertex.outEdges.remove(edge.targetVertex);
        edge.targetVertex.inEdges.remove(edge.sourceVertex);
    }

    public void removeVertex(Vertex vertex) {
        this.vertices.remove(vertex.getValue());
        for (Edge e : new ArrayList(vertex.outEdges.values())) {
            this.removeEdge(e);
        }
        for (Edge e : new ArrayList(vertex.inEdges.values())) {
            this.removeEdge(e);
        }
    }

    public Edge getEdge(Vertex source, Vertex target) {
        return (Edge)source.outEdges.get(target);
    }

    public Edge getEdge(V source, V target) {
        Vertex sv = this.getVertex(source);
        if (sv == null) {
            return null;
        }
        Vertex tv = this.getVertex(target);
        if (tv == null) {
            return null;
        }
        return this.getEdge(this.getVertex(source), this.getVertex(target));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Vertex v : this.vertices.values()) {
            sb.append(v.outEdges.values()).append("\n");
        }
        return sb.toString();
    }

    public Map<V, Vertex> getVertices() {
        return this.vertices;
    }

    public void addGraph(PhaseSorter<V> otherGraph) {
        for (Vertex v : otherGraph.vertices.values()) {
            for (Edge e : v.outEdges.values()) {
                this.addEdge(e.sourceVertex.value, e.targetVertex.value);
            }
        }
    }

    private Vertex getFirst() {
        for (Vertex v : this.vertices.values()) {
            if (!v.inEdges.isEmpty()) continue;
            return v;
        }
        if (!this.vertices.isEmpty()) {
            throw new IllegalArgumentException("Circular ordering has been detected: " + this.toString());
        }
        return null;
    }

    public List<V> topologicalSort(boolean readOnly) {
        Vertex v;
        PhaseSorter graph = !readOnly ? this : (PhaseSorter)this.clone();
        ArrayList list = new ArrayList();
        while ((v = graph.getFirst()) != null) {
            list.add(v.getValue());
            graph.removeVertex(v);
        }
        return list;
    }

    public Object clone() {
        PhaseSorter<V> copy = new PhaseSorter<V>();
        copy.addGraph(this);
        return copy;
    }

    public final class Edge {
        private Vertex sourceVertex;
        private Vertex targetVertex;

        public Edge(Vertex source, Vertex target) {
            this.sourceVertex = source;
            this.targetVertex = target;
        }

        public String toString() {
            return this.sourceVertex + "->" + this.targetVertex;
        }

        public Vertex getTargetVertex() {
            return this.targetVertex;
        }

        public void setTargetVertex(Vertex vertex) {
            this.targetVertex = vertex;
        }

        public Vertex getSourceVertex() {
            return this.sourceVertex;
        }

        public void setSourceVertex(Vertex sourceVertex) {
            this.sourceVertex = sourceVertex;
        }
    }

    public final class Vertex {
        private V value;
        private Map<Vertex, Edge> outEdges = new HashMap<Vertex, Edge>();
        private Map<Vertex, Edge> inEdges = new HashMap<Vertex, Edge>();

        private Vertex(V value) {
            this.value = value;
        }

        public String toString() {
            return "(" + this.value + ")";
        }

        public V getValue() {
            return this.value;
        }

        public Map<Vertex, Edge> getOutEdges() {
            return this.outEdges;
        }

        public Map<Vertex, Edge> getInEdges() {
            return this.inEdges;
        }
    }
}

