/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation;

import java.lang.reflect.Constructor;

public class AsyncFaultWrapper {
    private String faultClassName = null;
    private String faultMessage = null;
    private AsyncFaultWrapper containedFault = null;

    public AsyncFaultWrapper() {
    }

    public AsyncFaultWrapper(Throwable e) {
        this.storeFault(e);
    }

    public void storeFault(Throwable e) {
        this.setFaultClassName(e.getClass().getCanonicalName());
        this.setFaultMessage(e.getMessage());
        Throwable cause = e.getCause();
        if (cause != null) {
            this.setContainedFault(new AsyncFaultWrapper(cause));
        }
    }

    public Throwable retrieveFault() {
        try {
            Class<?> faultClass;
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            Class<?> xclass = faultClass = tccl.loadClass(this.faultClassName);
            if (this.containedFault != null) {
                Constructor<?> cons = xclass.getConstructor(String.class, Throwable.class);
                return (Throwable)cons.newInstance(this.faultMessage, this.getContainedFault().retrieveFault());
            }
            try {
                Constructor<?> cons = xclass.getConstructor(String.class);
                return (Throwable)cons.newInstance(this.faultMessage);
            }
            catch (NoSuchMethodException e) {
                Constructor<?> cons = xclass.getConstructor(new Class[0]);
                return (Throwable)cons.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            return e;
        }
    }

    public void setFaultClassName(String name) {
        this.faultClassName = name;
    }

    public String getFaultClassName() {
        return this.faultClassName;
    }

    public String getFaultMessage() {
        return this.faultMessage;
    }

    public void setFaultMessage(String faultMessage) {
        this.faultMessage = faultMessage;
    }

    public AsyncFaultWrapper getContainedFault() {
        return this.containedFault;
    }

    public void setContainedFault(AsyncFaultWrapper containedFault) {
        this.containedFault = containedFault;
    }
}

