/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly.impl;

import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.policy.BindingType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.util.PolicyHelper;
import org.apache.tuscany.sca.runtime.EndpointSerializer;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.oasisopen.sca.ServiceRuntimeException;

public class EndpointSerializerImpl
implements EndpointSerializer {
    private ExtensionPointRegistry registry;
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private StAXArtifactProcessor<Endpoint> processor;
    private StAXArtifactProcessor<EndpointReference> refProcessor;

    public EndpointSerializerImpl(ExtensionPointRegistry registry) {
        this.registry = registry;
        FactoryExtensionPoint factories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.inputFactory = factories.getFactory(XMLInputFactory.class);
        this.outputFactory = factories.getFactory(XMLOutputFactory.class);
        StAXArtifactProcessorExtensionPoint processors = registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        this.processor = processors.getProcessor(Endpoint.class);
        this.refProcessor = processors.getProcessor(EndpointReference.class);
    }

    @Override
    public Endpoint readEndpoint(String xml) {
        try {
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(new StringReader(xml));
            Endpoint result = this.processor.read(reader, new ProcessorContext(this.registry));
            result.setRemote(true);
            reader.close();
            return result;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public void resolveEndpoint(Endpoint endpoint) {
        CompositeContext compositeContext = ((RuntimeEndpoint)endpoint).getCompositeContext();
        if (compositeContext == null) {
            return;
        }
        Definitions systemDefinitions = compositeContext.getSystemDefinitions();
        if (systemDefinitions != null) {
            ArrayList<Intent> intents = new ArrayList<Intent>();
            for (Intent intent : endpoint.getRequiredIntents()) {
                Intent resolvedIntent = PolicyHelper.getIntent(systemDefinitions, intent.getName());
                if (resolvedIntent != null) {
                    intents.add(resolvedIntent);
                    continue;
                }
                BindingType bindingType = systemDefinitions.getBindingType(endpoint.getBinding().getType());
                if (bindingType != null) {
                    for (Intent apIntent : bindingType.getAlwaysProvidedIntents()) {
                        if (!apIntent.getName().equals(intent.getName())) continue;
                        resolvedIntent = apIntent;
                        break;
                    }
                    if (resolvedIntent == null) {
                        for (Intent mpIntent : bindingType.getMayProvidedIntents()) {
                            if (!mpIntent.getName().equals(intent.getName())) continue;
                            resolvedIntent = mpIntent;
                            break;
                        }
                    }
                }
                if (resolvedIntent != null) {
                    intents.add(resolvedIntent);
                    continue;
                }
                throw new ServiceRuntimeException("Remote endpoint " + endpoint + " has intent " + intent + " that can't be found in the local system definitions in node " + compositeContext.getNodeURI());
            }
            endpoint.getRequiredIntents().clear();
            endpoint.getRequiredIntents().addAll(intents);
            ArrayList<PolicySet> policySets = new ArrayList<PolicySet>();
            for (PolicySet policySet : endpoint.getPolicySets()) {
                PolicySet resolvedPolicySet = PolicyHelper.getPolicySet(systemDefinitions, policySet.getName());
                if (resolvedPolicySet != null) {
                    policySets.add(resolvedPolicySet);
                    continue;
                }
                throw new ServiceRuntimeException("Remote endpoint " + endpoint + " has policy set " + policySet + " that can't be found in the local system definitions in node " + compositeContext.getNodeURI());
            }
            endpoint.getPolicySets().clear();
            endpoint.getPolicySets().addAll(policySets);
        }
    }

    @Override
    public String write(Endpoint endpoint) {
        StringWriter sw = new StringWriter();
        try {
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(sw);
            this.processor.write(endpoint, writer, new ProcessorContext(this.registry));
            writer.flush();
            writer.close();
            String endpointString = sw.toString();
            return endpointString;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public EndpointReference readEndpointReference(String xml) {
        try {
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(new StringReader(xml));
            EndpointReference result = this.refProcessor.read(reader, new ProcessorContext(this.registry));
            reader.close();
            return result;
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }

    @Override
    public String write(EndpointReference endpointReference) {
        StringWriter sw = new StringWriter();
        try {
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(sw);
            this.refProcessor.write(endpointReference, writer, new ProcessorContext(this.registry));
            writer.flush();
            writer.close();
            return sw.toString();
        }
        catch (Exception e) {
            throw new ServiceRuntimeException(e);
        }
    }
}

