/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ExtensibleStAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class AnyAttributeProcessor
extends BaseStAXArtifactProcessor
implements StAXAttributeProcessor<Extension> {
    private AssemblyFactory assemblyFactory;

    public AnyAttributeProcessor(FactoryExtensionPoint modelFactories) {
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
    }

    @Override
    public QName getArtifactType() {
        return ExtensibleStAXAttributeProcessor.ANY_ATTRIBUTE;
    }

    @Override
    public Class<Extension> getModelType() {
        return Extension.class;
    }

    @Override
    public Extension read(QName attributeName, XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        String attributeValue = reader.getAttributeValue(attributeName.getNamespaceURI(), attributeName.getLocalPart());
        Extension ext = this.assemblyFactory.createExtension();
        ext.setQName(attributeName);
        ext.setAttribute(true);
        ext.setValue(attributeValue);
        return ext;
    }

    @Override
    public void write(Extension attributeExtension, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeAttribute(attributeExtension.getQName().getPrefix(), attributeExtension.getQName().getNamespaceURI(), attributeExtension.getQName().getLocalPart(), attributeExtension.getValue().toString());
    }

    @Override
    public void resolve(Extension model, ModelResolver modelResolver, ProcessorContext context) throws ContributionResolveException {
    }
}

