/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.java.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;

public class ContributionHelper {
    public static List<URL> getNestedJarUrls(Contribution contribution) throws IOException {
        ArrayList<URL> urls = new ArrayList<URL>();
        final boolean isZipContribution = contribution.getLocation().endsWith(".zip");
        final URI uri = URI.create(contribution.getLocation());
        boolean isFolderContribution = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return !isZipContribution && uri.getScheme().equals("file") && new File(uri.getSchemeSpecificPart()).isDirectory();
            }
        });
        if (isZipContribution || isFolderContribution) {
            for (Artifact a : contribution.getArtifacts()) {
                if (!a.getLocation().endsWith(".jar")) continue;
                if (isZipContribution) {
                    urls.add(ContributionHelper.createTempJar(a, contribution));
                    continue;
                }
                urls.add(new URL(a.getLocation()));
            }
        }
        return urls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URL createTempJar(Artifact artifact, Contribution contribution) throws IOException {
        FileOutputStream fileOutputStream = null;
        ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(new File(URI.create(contribution.getLocation()))));
        try {
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                if (artifact.getLocation().endsWith(zipEntry.getName())) {
                    int n;
                    String tempName = ("tmp." + artifact.getURI().substring(0, artifact.getURI().length() - 3)).replace('/', '.');
                    File tempFile = File.createTempFile(tempName, ".jar");
                    tempFile.deleteOnExit();
                    fileOutputStream = new FileOutputStream(tempFile);
                    byte[] buf = new byte[2048];
                    while ((n = zipInputStream.read(buf, 0, buf.length)) > -1) {
                        fileOutputStream.write(buf, 0, n);
                    }
                    fileOutputStream.close();
                    zipInputStream.closeEntry();
                    URL uRL = tempFile.toURI().toURL();
                    return uRL;
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            zipInputStream.close();
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        throw new IllegalStateException();
    }
}

