/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.http;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.Random;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HTTPUtils {
    public static void prepareHTTPResponse(HttpServletResponse response) {
        response.setDateHeader("Date", System.currentTimeMillis());
    }

    public static String getRequestPath(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String requestURI = request.getRequestURI();
        int contextPathLength = contextPath.length();
        int servletPathLenght = servletPath.contains(contextPath) ? servletPath.length() - contextPath.length() : servletPath.length();
        String requestPath = requestURI.substring(contextPathLength + servletPathLenght);
        return requestPath;
    }

    public static String getContextRoot(HttpServletRequest request) {
        String contextPath = request.getContextPath();
        String requestURI = request.getRequestURI();
        int contextPathLength = contextPath.length();
        String contextRoot = requestURI.substring(0, contextPathLength);
        return contextRoot;
    }

    public static String calculateHashETag(byte[] content) {
        String eTag = "invalid";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] digest = messageDigest.digest(content);
            BigInteger number = new BigInteger(1, digest);
            StringBuffer sb = new StringBuffer(48);
            sb.append(number.toString(16));
            eTag = sb.toString();
        }
        catch (Exception e) {
            eTag = Integer.toString(new Random().nextInt(Integer.MAX_VALUE));
        }
        return eTag;
    }
}

