/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.jms.wireformat;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.binding.jms.wireformat.WireFormatJMSObject;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;

public class WireFormatJMSObjectProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<WireFormatJMSObject> {
    @Override
    public QName getArtifactType() {
        return WireFormatJMSObject.WIRE_FORMAT_JMS_BYTES_QNAME;
    }

    public WireFormatJMSObjectProcessor(FactoryExtensionPoint modelFactories) {
    }

    @Override
    public WireFormatJMSObject read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        WireFormatJMSObject wireFormat = new WireFormatJMSObject();
        String wrappedSingleInput = reader.getAttributeValue(null, "wrapSingle");
        if (wrappedSingleInput != null && wrappedSingleInput.length() > 0) {
            if ("true".equalsIgnoreCase(wrappedSingleInput)) {
                wireFormat.setWrappedSingleInput(true);
            } else if ("false".equalsIgnoreCase(wrappedSingleInput)) {
                wireFormat.setWrappedSingleInput(false);
            } else {
                throw new ContributionReadException(WireFormatJMSObject.WIRE_FORMAT_JMS_BYTES_QNAME.toString() + ": " + wrappedSingleInput + " is not a valid attribute value for " + "wrapSingle");
            }
        }
        return wireFormat;
    }

    @Override
    public void write(WireFormatJMSObject wireFormat, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        String prefix = "tuscany";
        writer.writeStartElement(prefix, this.getArtifactType().getLocalPart(), this.getArtifactType().getNamespaceURI());
        writer.writeNamespace("tuscany", "http://tuscany.apache.org/xmlns/sca/1.1");
        writer.writeAttribute("wrapSingle", String.valueOf(wireFormat.isWrappedSingleInput()));
        writer.writeEndElement();
    }

    @Override
    public Class<WireFormatJMSObject> getModelType() {
        return WireFormatJMSObject.class;
    }

    @Override
    public void resolve(WireFormatJMSObject arg0, ModelResolver arg1, ProcessorContext context) throws ContributionResolveException {
    }
}

