/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *   http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.    
 */

package org.apache.tuscany.sca.binding.jsonrpc;

import javax.xml.namespace.QName;

import org.apache.tuscany.sca.assembly.Binding;

/**
 * A model for the JSONRPC binding.
 * 
 * @version $Rev: 1180780 $ $Date: 2011-10-09 22:01:04 -0700 (Sun, 09 Oct 2011) $
 */
public interface JSONRPCBinding extends Binding {
    QName TYPE = new QName(SCA11_TUSCANY_NS, "binding.jsonrpc");
    String VERSION_10 = "1.0";
    String VERSION_20 = "2.0";

    String getVersion();

    void setVersion(String version);
}
