/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Base;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.PolicySubject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBeanModelProcessor
extends BaseAssemblyProcessor
implements StAXArtifactProcessor {
    private QName artifactType;
    private Class<Implementation> modelClass;
    private Object modelFactory;
    private Method factoryMethod;
    private Map<String, Method> setterMethods = new HashMap<String, Method>();
    private Map<String, Method> getterMethods = new HashMap<String, Method>();

    public DefaultBeanModelProcessor(FactoryExtensionPoint modeFactories, QName artifactType, Class<Implementation> modelClass, Object modelFactory, Monitor monitor) {
        super(modeFactories, null, monitor);
        Method method;
        int n;
        int n2;
        Method[] methodArray;
        this.artifactType = artifactType;
        this.modelClass = modelClass;
        this.modelFactory = modelFactory;
        if (modelFactory != null) {
            methodArray = modelFactory.getClass().getMethods();
            n2 = methodArray.length;
            n = 0;
            while (n < n2) {
                method = methodArray[n];
                if (method.getName().startsWith("create") && method.getReturnType() == modelClass) {
                    this.factoryMethod = method;
                    break;
                }
                ++n;
            }
        }
        methodArray = modelClass.getMethods();
        n2 = methodArray.length;
        n = 0;
        while (n < n2) {
            block10: {
                method = methodArray[n];
                String name = method.getName();
                if (name.startsWith("set") && name.length() > 3) {
                    Method getter;
                    try {
                        getter = modelClass.getMethod("get" + name.substring(3), new Class[0]);
                    }
                    catch (Exception exception) {
                        getter = null;
                        break block10;
                    }
                    name = name.substring(3);
                    if (name.length() > 1 && !name.toUpperCase().equals(name)) {
                        name = String.valueOf(name.substring(0, 1).toLowerCase()) + name.substring(1);
                    }
                    if (name.toUpperCase().equals(name)) {
                        name = name.toLowerCase();
                    }
                    if (name.endsWith("_")) {
                        name = name.substring(0, name.length() - 1);
                    }
                    this.setterMethods.put(name, method);
                    this.getterMethods.put(name, getter);
                }
            }
            ++n;
        }
    }

    public Object read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        try {
            Object model = this.modelFactory != null ? this.factoryMethod.invoke(this.modelFactory, new Object[0]) : this.modelClass.newInstance();
            int i = 0;
            int n = reader.getAttributeCount();
            while (i < n) {
                String attributeName = reader.getAttributeLocalName(i);
                Method setter = this.setterMethods.get(attributeName);
                if (setter != null) {
                    String value = reader.getAttributeValue(i);
                    setter.invoke(model, value);
                }
                ++i;
            }
            this.policyProcessor.readPolicies(model, reader);
            if (model instanceof Base) {
                ((Base)model).setUnresolved(true);
            }
            while (reader.hasNext()) {
                if (reader.next() == 2 && this.artifactType.equals(reader.getName())) break;
            }
            return model;
        }
        catch (Exception e) {
            ContributionReadException ce = new ContributionReadException((Throwable)e);
            this.error("ContributionReadException", (Object)reader, (Exception)ce);
            throw ce;
        }
    }

    public void write(Object bean, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        try {
            ArrayList<BaseStAXArtifactProcessor.XAttr> attrs = new ArrayList<BaseStAXArtifactProcessor.XAttr>();
            for (Map.Entry<String, Method> entry : this.getterMethods.entrySet()) {
                if (entry.getValue().getReturnType() != String.class) continue;
                String value = (String)entry.getValue().invoke(bean, new Object[0]);
                attrs.add(new BaseStAXArtifactProcessor.XAttr(entry.getKey(), value));
            }
            this.writeStart(writer, this.artifactType.getNamespaceURI(), this.artifactType.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[]{this.policyProcessor.writePolicies(bean), new BaseStAXArtifactProcessor.XAttr(null, attrs)});
            this.writeEnd(writer);
        }
        catch (Exception e) {
            ContributionWriteException ce = new ContributionWriteException((Throwable)e);
            this.error("ContributionWriteException", (Object)writer, (Exception)ce);
            throw ce;
        }
    }

    public void resolve(Object bean, ModelResolver resolver) throws ContributionResolveException {
        int d;
        Implementation implementation;
        String uri;
        if (bean instanceof Implementation && (uri = (implementation = (Implementation)bean).getURI()) != null && (d = uri.lastIndexOf(46)) != -1) {
            uri = String.valueOf(uri.substring(0, d)) + ".componentType";
            ComponentType componentType = this.assemblyFactory.createComponentType();
            componentType.setURI(uri);
            componentType.setUnresolved(true);
            componentType = (ComponentType)resolver.resolveModel(ComponentType.class, (Object)componentType);
            if (componentType != null && !componentType.isUnresolved()) {
                implementation.getServices().addAll(componentType.getServices());
                implementation.getReferences().addAll(componentType.getReferences());
                implementation.getProperties().addAll(componentType.getProperties());
                implementation.setConstrainingType(componentType.getConstrainingType());
                if (implementation instanceof PolicySubject && componentType instanceof PolicySubject) {
                    Implementation policiedImpl = implementation;
                    ComponentType policiedCompType = componentType;
                    if (policiedImpl.getPolicySets() != null) {
                        policiedImpl.getPolicySets().addAll(policiedCompType.getPolicySets());
                    }
                    if (policiedImpl.getRequiredIntents() != null) {
                        policiedImpl.getRequiredIntents().addAll(policiedCompType.getRequiredIntents());
                    }
                }
            }
        }
        if (bean instanceof Base) {
            ((Base)bean).setUnresolved(false);
        }
    }

    public QName getArtifactType() {
        return this.artifactType;
    }

    public Class<?> getModelType() {
        return this.modelClass;
    }
}

