/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.ConstrainingType;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstrainingTypeDocumentProcessor
extends BaseAssemblyProcessor
implements URLArtifactProcessor<ConstrainingType> {
    private XMLInputFactory inputFactory;

    public ConstrainingTypeDocumentProcessor(FactoryExtensionPoint modelFactories, StAXArtifactProcessor staxProcessor, Monitor monitor) {
        super(modelFactories, staxProcessor, monitor);
        this.inputFactory = (XMLInputFactory)modelFactories.getFactory(ValidatingXMLInputFactory.class);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConstrainingType read(URL contributionURL, URI uri, URL url) throws ContributionReadException {
        ConstrainingType constrainingType;
        InputStream urlStream = null;
        try {
            ConstrainingType constrainingType2;
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            urlStream = connection.getInputStream();
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(url.toString(), urlStream);
            reader.nextTag();
            constrainingType = constrainingType2 = (ConstrainingType)this.extensionProcessor.read(reader);
        }
        catch (XMLStreamException e) {
            try {
                ContributionReadException ce = new ContributionReadException((Throwable)e);
                this.error("ContributionReadException", (Object)this.inputFactory, (Exception)ce);
                throw ce;
                catch (IOException e2) {
                    ce = new ContributionReadException((Throwable)e2);
                    this.error("ContributionReadException", (Object)this.inputFactory, (Exception)ce);
                    throw ce;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (urlStream == null) throw throwable;
                    urlStream.close();
                    urlStream = null;
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            if (urlStream == null) return constrainingType;
            urlStream.close();
            return constrainingType;
        }
        catch (IOException iOException) {}
        return constrainingType;
    }

    public void resolve(ConstrainingType constrainingType, ModelResolver resolver) throws ContributionResolveException {
        this.extensionProcessor.resolve((Object)constrainingType, resolver);
    }

    public String getArtifactType() {
        return ".constrainingType";
    }

    public Class<ConstrainingType> getModelType() {
        return ConstrainingType.class;
    }
}

