/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.tuscany.sca.assembly.AbstractProperty;
import org.apache.tuscany.sca.assembly.AbstractReference;
import org.apache.tuscany.sca.assembly.Base;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Callback;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.ConstrainingType;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.Wire;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ResolverExtension;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.policy.BindingType;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.ImplementationType;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeProcessor
extends BaseAssemblyProcessor
implements StAXArtifactProcessor<Composite> {
    private XPathFactory xPathFactory;
    private PolicyFactory intentAttachPointTypeFactory;
    private StAXAttributeProcessor<Object> extensionAttributeProcessor;
    private ContributionFactory contributionFactory;

    public CompositeProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        this(CompositeProcessor.modelFactories(extensionPoints), extensionProcessor, extensionAttributeProcessor, CompositeProcessor.monitor(extensionPoints));
        this.extensionAttributeProcessor = extensionAttributeProcessor;
    }

    private CompositeProcessor(FactoryExtensionPoint modelFactories, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        super(modelFactories, extensionProcessor, monitor);
        this.intentAttachPointTypeFactory = (PolicyFactory)modelFactories.getFactory(PolicyFactory.class);
        this.xPathFactory = (XPathFactory)modelFactories.getFactory(XPathFactory.class);
        this.contributionFactory = (ContributionFactory)modelFactories.getFactory(ContributionFactory.class);
        this.extensionAttributeProcessor = extensionAttributeProcessor;
    }

    public Composite read(XMLStreamReader reader) throws ContributionReadException {
        Composite composite = null;
        Composite include = null;
        Component component = null;
        Property property = null;
        ComponentService componentService = null;
        ComponentReference componentReference = null;
        ComponentProperty componentProperty = null;
        CompositeService compositeService = null;
        CompositeReference compositeReference = null;
        ComponentService contract = null;
        Wire wire = null;
        Callback callback = null;
        QName name = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        String source;
                        name = reader.getName();
                        if (Constants.COMPOSITE_QNAME.equals(name)) {
                            composite = this.assemblyFactory.createComposite();
                            composite.setSpecVersion("http://docs.oasis-open.org/ns/opencsa/sca/200903");
                            composite.setName(new QName(this.getString(reader, "targetNamespace"), this.getString(reader, "name")));
                            if (!this.isSet(reader, "targetNamespace")) {
                                this.warning("NoCompositeNamespace", composite, composite.getName().toString());
                            }
                            if (this.isSet(reader, "autowire")) {
                                composite.setAutowire(Boolean.valueOf(this.getBoolean(reader, "autowire")));
                            }
                            this.readExtendedAttributes(reader, name, (Extensible)composite, this.extensionAttributeProcessor);
                            composite.setLocal(this.getBoolean(reader, "local"));
                            composite.setConstrainingType(this.readConstrainingType(reader));
                            this.policyProcessor.readPolicies(composite, reader);
                            break;
                        }
                        if (Constants.INCLUDE_QNAME.equals(name)) {
                            include = this.assemblyFactory.createComposite();
                            include.setName(this.getQName(reader, "name"));
                            include.setURI(this.getString(reader, "uri"));
                            include.setUnresolved(true);
                            composite.getIncludes().add(include);
                            break;
                        }
                        if (Constants.SERVICE_QNAME.equals(name)) {
                            if (component != null) {
                                contract = componentService = this.assemblyFactory.createComponentService();
                                componentService.setName(this.getString(reader, "name"));
                                this.readExtendedAttributes(reader, name, (Extensible)componentService, this.extensionAttributeProcessor);
                                component.getServices().add(componentService);
                                this.policyProcessor.readPolicies(contract, reader);
                                break;
                            }
                            compositeService = this.assemblyFactory.createCompositeService();
                            contract = compositeService;
                            compositeService.setName(this.getString(reader, "name"));
                            String promoted = this.getString(reader, "promote");
                            if (promoted != null) {
                                String promotedServiceName;
                                String promotedComponentName;
                                int s = promoted.indexOf(47);
                                if (s == -1) {
                                    promotedComponentName = promoted;
                                    promotedServiceName = null;
                                } else {
                                    promotedComponentName = promoted.substring(0, s);
                                    promotedServiceName = promoted.substring(s + 1);
                                }
                                Component promotedComponent = this.assemblyFactory.createComponent();
                                promotedComponent.setUnresolved(true);
                                promotedComponent.setName(promotedComponentName);
                                compositeService.setPromotedComponent(promotedComponent);
                                ComponentService promotedService = this.assemblyFactory.createComponentService();
                                promotedService.setUnresolved(true);
                                promotedService.setName(promotedServiceName);
                                compositeService.setPromotedService(promotedService);
                            }
                            this.readExtendedAttributes(reader, name, (Extensible)compositeService, this.extensionAttributeProcessor);
                            composite.getServices().add(compositeService);
                            this.policyProcessor.readPolicies(contract, reader);
                            break;
                        }
                        if (Constants.REFERENCE_QNAME.equals(name)) {
                            if (component != null) {
                                String nonOverridable;
                                componentReference = this.assemblyFactory.createComponentReference();
                                contract = componentReference;
                                componentReference.setName(this.getString(reader, "name"));
                                this.readMultiplicity((AbstractReference)componentReference, reader);
                                if (this.isSet(reader, "autowire")) {
                                    componentReference.setAutowire(Boolean.valueOf(this.getBoolean(reader, "autowire")));
                                }
                                if ((nonOverridable = reader.getAttributeValue(null, "nonOverridable")) != null) {
                                    componentReference.setNonOverridable(Boolean.parseBoolean(nonOverridable));
                                }
                                this.readTargets((Reference)componentReference, reader);
                                componentReference.setWiredByImpl(this.getBoolean(reader, "wiredByImpl"));
                                this.readExtendedAttributes(reader, name, (Extensible)componentReference, this.extensionAttributeProcessor);
                                component.getReferences().add(componentReference);
                                this.policyProcessor.readPolicies(contract, reader);
                                break;
                            }
                            compositeReference = this.assemblyFactory.createCompositeReference();
                            contract = compositeReference;
                            compositeReference.setName(this.getString(reader, "name"));
                            this.readMultiplicity((AbstractReference)compositeReference, reader);
                            this.readTargets((Reference)compositeReference, reader);
                            String promote = reader.getAttributeValue(null, "promote");
                            if (promote != null) {
                                StringTokenizer tokens = new StringTokenizer(promote);
                                while (tokens.hasMoreTokens()) {
                                    String refName = tokens.nextToken();
                                    Component promotedComponent = this.assemblyFactory.createComponent();
                                    int index = refName.indexOf(47);
                                    if (index == -1) {
                                        this.error("Invalid reference name", (Object)compositeReference, refName);
                                    }
                                    String promotedComponentName = refName.substring(0, index);
                                    promotedComponent.setName(promotedComponentName);
                                    promotedComponent.setUnresolved(true);
                                    compositeReference.getPromotedComponents().add(promotedComponent);
                                    ComponentReference promotedReference = this.assemblyFactory.createComponentReference();
                                    promotedReference.setUnresolved(true);
                                    promotedReference.setName(refName);
                                    compositeReference.getPromotedReferences().add(promotedReference);
                                }
                            }
                            compositeReference.setWiredByImpl(this.getBoolean(reader, "wiredByImpl"));
                            this.readExtendedAttributes(reader, name, (Extensible)compositeReference, this.extensionAttributeProcessor);
                            composite.getReferences().add(compositeReference);
                            this.policyProcessor.readPolicies(contract, reader);
                            break;
                        }
                        if (Constants.PROPERTY_QNAME.equals(name)) {
                            if (component != null) {
                                componentProperty = this.assemblyFactory.createComponentProperty();
                                property = componentProperty;
                                source = this.getString(reader, "source");
                                if (source != null) {
                                    source = source.trim();
                                }
                                componentProperty.setSource(source);
                                if (source != null) {
                                    if (source.charAt(0) == '$') {
                                        int index = source.indexOf(47);
                                        if (index == -1) {
                                            source = String.valueOf(source) + "/";
                                            index = source.length() - 1;
                                        }
                                        if ("".equals(source = source.substring(index + 1))) {
                                            source = ".";
                                        }
                                    }
                                    XPath xpath = this.xPathFactory.newXPath();
                                    xpath.setNamespaceContext(reader.getNamespaceContext());
                                    try {
                                        componentProperty.setSourceXPathExpression(xpath.compile(source));
                                    }
                                    catch (XPathExpressionException e) {
                                        ContributionReadException ce = new ContributionReadException((Throwable)e);
                                        this.error("ContributionReadException", (Object)xpath, (Exception)ce);
                                    }
                                }
                                componentProperty.setFile(this.getString(reader, "file"));
                                this.readExtendedAttributes(reader, name, (Extensible)componentProperty, this.extensionAttributeProcessor);
                                this.policyProcessor.readPolicies(property, reader);
                                this.readAbstractProperty((AbstractProperty)componentProperty, reader);
                                Document value = this.readPropertyValue(property.getXSDElement(), property.getXSDType(), reader);
                                property.setValue((Object)value);
                                component.getProperties().add(componentProperty);
                            } else {
                                property = this.assemblyFactory.createProperty();
                                this.policyProcessor.readPolicies(property, reader);
                                this.readAbstractProperty((AbstractProperty)property, reader);
                                Document value = this.readPropertyValue(property.getXSDElement(), property.getXSDType(), reader);
                                property.setValue((Object)value);
                                composite.getProperties().add(property);
                            }
                            if (reader.getEventType() != 2 || !Constants.PROPERTY_QNAME.equals(reader.getName())) break;
                            property = null;
                            componentProperty = null;
                            break;
                        }
                        if (Constants.COMPONENT_QNAME.equals(name)) {
                            component = this.assemblyFactory.createComponent();
                            component.setName(this.getString(reader, "name"));
                            if (this.isSet(reader, "autowire")) {
                                component.setAutowire(Boolean.valueOf(this.getBoolean(reader, "autowire")));
                            }
                            if (this.isSet(reader, "uri")) {
                                component.setURI(this.getString(reader, "uri"));
                            }
                            this.readExtendedAttributes(reader, name, (Extensible)component, this.extensionAttributeProcessor);
                            component.setConstrainingType(this.readConstrainingType(reader));
                            composite.getComponents().add(component);
                            this.policyProcessor.readPolicies(component, reader);
                            break;
                        }
                        if (Constants.WIRE_QNAME.equals(name)) {
                            wire = this.assemblyFactory.createWire();
                            source = this.assemblyFactory.createComponentReference();
                            source.setUnresolved(true);
                            source.setName(this.getString(reader, "source"));
                            wire.setSource((ComponentReference)source);
                            ComponentService target = this.assemblyFactory.createComponentService();
                            target.setUnresolved(true);
                            target.setName(this.getString(reader, "target"));
                            wire.setTarget(target);
                            String replace = reader.getAttributeValue(null, "replace");
                            if (replace != null) {
                                wire.setReplace(Boolean.parseBoolean(replace));
                            }
                            this.readExtendedAttributes(reader, name, (Extensible)wire, this.extensionAttributeProcessor);
                            composite.getWires().add(wire);
                            this.policyProcessor.readPolicies(wire, reader);
                            break;
                        }
                        if (Constants.CALLBACK_QNAME.equals(name)) {
                            callback = this.assemblyFactory.createCallback();
                            contract.setCallback(callback);
                            this.readExtendedAttributes(reader, name, (Extensible)callback, this.extensionAttributeProcessor);
                            this.policyProcessor.readPolicies(callback, reader);
                            break;
                        }
                        if (Constants.IMPLEMENTATION_COMPOSITE_QNAME.equals(name)) {
                            Composite implementation = this.assemblyFactory.createComposite();
                            implementation.setName(this.getQName(reader, "name"));
                            implementation.setUnresolved(true);
                            this.readExtendedAttributes(reader, name, (Extensible)implementation, this.extensionAttributeProcessor);
                            component.setImplementation((Implementation)implementation);
                            this.policyProcessor.readPolicies(implementation, reader);
                            break;
                        }
                        Object extension = this.extensionProcessor.read(reader);
                        if (extension == null) break;
                        if (extension instanceof InterfaceContract) {
                            if (contract != null) {
                                contract.setInterfaceContract((InterfaceContract)extension);
                                break;
                            }
                            if (name.getNamespaceURI().equals("http://docs.oasis-open.org/ns/opencsa/sca/200903")) {
                                this.error("UnexpectedInterfaceElement", extension, new Object[0]);
                                break;
                            }
                            composite.getExtensions().add(extension);
                            break;
                        }
                        if (extension instanceof Binding) {
                            if (extension instanceof PolicySubject) {
                                BindingType bindingType = this.intentAttachPointTypeFactory.createBindingType();
                                bindingType.setType(name);
                                bindingType.setUnresolved(true);
                                ((PolicySubject)extension).setType((ExtensionType)bindingType);
                            }
                            if (callback != null) {
                                callback.getBindings().add((Binding)extension);
                                break;
                            }
                            if (contract != null) {
                                contract.getBindings().add((Binding)extension);
                                break;
                            }
                            if (name.getNamespaceURI().equals("http://docs.oasis-open.org/ns/opencsa/sca/200903")) {
                                this.error("UnexpectedBindingElement", extension, new Object[0]);
                                break;
                            }
                            composite.getExtensions().add(extension);
                            break;
                        }
                        if (extension instanceof Implementation) {
                            if (extension instanceof PolicySubject) {
                                ImplementationType implType = this.intentAttachPointTypeFactory.createImplementationType();
                                implType.setType(name);
                                implType.setUnresolved(true);
                                ((PolicySubject)extension).setType((ExtensionType)implType);
                            }
                            if (component != null) {
                                component.setImplementation((Implementation)extension);
                                break;
                            }
                            if (name.getNamespaceURI().equals("http://docs.oasis-open.org/ns/opencsa/sca/200903")) {
                                this.error("UnexpectedImplementationElement", extension, new Object[0]);
                                break;
                            }
                            composite.getExtensions().add(extension);
                            break;
                        }
                        if (callback != null) {
                            callback.getExtensions().add(extension);
                            break;
                        }
                        if (contract != null) {
                            contract.getExtensions().add(extension);
                            break;
                        }
                        if (property != null) {
                            property.getExtensions().add(extension);
                            break;
                        }
                        if (component != null) {
                            component.getExtensions().add(extension);
                            break;
                        }
                        composite.getExtensions().add(extension);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 2: {
                        name = reader.getName();
                        if (Constants.SERVICE_QNAME.equals(name)) {
                            componentService = null;
                            compositeService = null;
                            contract = null;
                            break;
                        }
                        if (Constants.INCLUDE_QNAME.equals(name)) {
                            include = null;
                            break;
                        }
                        if (Constants.REFERENCE_QNAME.equals(name)) {
                            componentReference = null;
                            compositeReference = null;
                            contract = null;
                            break;
                        }
                        if (Constants.PROPERTY_QNAME.equals(name)) {
                            componentProperty = null;
                            property = null;
                            break;
                        }
                        if (Constants.COMPONENT_QNAME.equals(name)) {
                            component = null;
                            break;
                        }
                        if (Constants.WIRE_QNAME.equals(name)) {
                            wire = null;
                            break;
                        }
                        if (!Constants.CALLBACK_QNAME.equals(name)) break;
                        callback = null;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException((Throwable)e);
            this.error("XMLStreamException", (Object)reader, (Exception)ex);
        }
        return composite;
    }

    public void write(Composite composite, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStartDocument(writer, "composite", this.writeConstrainingType((ComponentType)composite), new BaseStAXArtifactProcessor.XAttr("targetNamespace", composite.getName().getNamespaceURI()), new BaseStAXArtifactProcessor.XAttr("name", composite.getName().getLocalPart()), new BaseStAXArtifactProcessor.XAttr("local", composite.isLocal() ? Boolean.TRUE : null), new BaseStAXArtifactProcessor.XAttr("autowire", composite.getAutowire()), this.policyProcessor.writePolicies(composite));
        this.writeExtendedAttributes(writer, (Extensible)composite, this.extensionAttributeProcessor);
        for (Composite include : composite.getIncludes()) {
            String uri = include.isUnresolved() ? include.getURI() : null;
            this.writeStart(writer, "include", new BaseStAXArtifactProcessor.XAttr("name", include.getName()), new BaseStAXArtifactProcessor.XAttr("uri", uri));
            this.writeExtendedAttributes(writer, (Extensible)include, this.extensionAttributeProcessor);
            this.writeEnd(writer);
        }
        for (Service service : composite.getServices()) {
            CompositeService compositeService = (CompositeService)service;
            Component promotedComponent = compositeService.getPromotedComponent();
            ComponentService promotedService = compositeService.getPromotedService();
            String promote = promotedService != null ? (promotedService.getName() != null ? String.valueOf(promotedComponent.getName()) + '/' + promotedService.getName() : promotedComponent.getName()) : null;
            this.writeStart(writer, "service", new BaseStAXArtifactProcessor.XAttr("name", service.getName()), new BaseStAXArtifactProcessor.XAttr("promote", promote), this.policyProcessor.writePolicies(service));
            this.writeExtendedAttributes(writer, (Extensible)service, this.extensionAttributeProcessor);
            this.extensionProcessor.write((Object)service.getInterfaceContract(), writer);
            for (Binding binding : service.getBindings()) {
                this.extensionProcessor.write((Object)binding, writer);
            }
            if (service.getCallback() != null) {
                Callback callback = service.getCallback();
                this.writeStart(writer, "callback", this.policyProcessor.writePolicies(callback));
                this.writeExtendedAttributes(writer, (Extensible)callback, this.extensionAttributeProcessor);
                for (Binding binding : callback.getBindings()) {
                    this.extensionProcessor.write((Object)binding, writer);
                }
                for (Object extension : callback.getExtensions()) {
                    this.extensionProcessor.write(extension, writer);
                }
                this.writeEnd(writer);
            }
            for (Object extension3 : service.getExtensions()) {
                this.extensionProcessor.write(extension3, writer);
            }
            this.writeEnd(writer);
        }
        for (Component component : composite.getComponents()) {
            Callback callback;
            Object extension3;
            this.writeStart(writer, "component", new BaseStAXArtifactProcessor.XAttr("name", component.getName()), new BaseStAXArtifactProcessor.XAttr("uri", component.getURI()), new BaseStAXArtifactProcessor.XAttr("autowire", component.getAutowire()), this.policyProcessor.writePolicies(component));
            this.writeExtendedAttributes(writer, (Extensible)component, this.extensionAttributeProcessor);
            Implementation implementation = component.getImplementation();
            if (implementation instanceof Composite) {
                this.writeStart(writer, "implementation.composite", new BaseStAXArtifactProcessor.XAttr("name", ((Composite)implementation).getName()));
                this.writeExtendedAttributes(writer, (Extensible)((Composite)implementation), this.extensionAttributeProcessor);
                this.writeEnd(writer);
            } else {
                this.extensionProcessor.write((Object)component.getImplementation(), writer);
            }
            for (Object extension2 : component.getExtensions()) {
                this.extensionProcessor.write(extension2, writer);
            }
            for (ComponentService service : component.getServices()) {
                this.writeStart(writer, "service", new BaseStAXArtifactProcessor.XAttr("name", service.getName()), this.policyProcessor.writePolicies(service));
                this.writeExtendedAttributes(writer, (Extensible)service, this.extensionAttributeProcessor);
                this.extensionProcessor.write((Object)service.getInterfaceContract(), writer);
                for (Binding binding : service.getBindings()) {
                    this.extensionProcessor.write((Object)binding, writer);
                }
                if (service.getCallback() != null) {
                    callback = service.getCallback();
                    this.writeStart(writer, "callback", this.policyProcessor.writePolicies(callback));
                    this.writeExtendedAttributes(writer, (Extensible)callback, this.extensionAttributeProcessor);
                    for (Binding binding : callback.getBindings()) {
                        this.extensionProcessor.write((Object)binding, writer);
                    }
                    for (Object extension3 : callback.getExtensions()) {
                        this.extensionProcessor.write(extension3, writer);
                    }
                    this.writeEnd(writer);
                }
                extension3 = service.getExtensions().iterator();
                while (extension3.hasNext()) {
                    Iterator extension4 = extension3.next();
                    this.extensionProcessor.write(extension4, writer);
                }
                this.writeEnd(writer);
            }
            for (ComponentReference reference : component.getReferences()) {
                this.writeStart(writer, "reference", new BaseStAXArtifactProcessor.XAttr("name", reference.getName()), new BaseStAXArtifactProcessor.XAttr("autowire", reference.getAutowire()), reference.isNonOverridable() ? new BaseStAXArtifactProcessor.XAttr("nonOverridable", Boolean.valueOf(true)) : null, this.writeMultiplicity((AbstractReference)reference), this.writeTargets((Reference)reference), this.policyProcessor.writePolicies(reference));
                this.writeExtendedAttributes(writer, (Extensible)reference, this.extensionAttributeProcessor);
                this.extensionProcessor.write((Object)reference.getInterfaceContract(), writer);
                extension3 = reference.getBindings().iterator();
                while (extension3.hasNext()) {
                    Binding binding;
                    binding = (Binding)extension3.next();
                    this.extensionProcessor.write((Object)binding, writer);
                }
                if (reference.getCallback() != null) {
                    callback = reference.getCallback();
                    this.writeStart(writer, "callback", this.policyProcessor.writePolicies(callback));
                    this.writeExtendedAttributes(writer, (Extensible)callback, this.extensionAttributeProcessor);
                    for (Binding binding : callback.getBindings()) {
                        this.extensionProcessor.write((Object)binding, writer);
                    }
                    for (Object extensions : callback.getExtensions()) {
                        this.extensionProcessor.write(extensions, writer);
                    }
                    this.writeEnd(writer);
                }
                for (Object extensions : reference.getExtensions()) {
                    this.extensionProcessor.write(extensions, writer);
                }
                this.writeEnd(writer);
            }
            for (ComponentProperty property : component.getProperties()) {
                this.writeStart(writer, "property", new BaseStAXArtifactProcessor.XAttr("name", property.getName()), new BaseStAXArtifactProcessor.XAttr("mustSupply", Boolean.valueOf(property.isMustSupply())), new BaseStAXArtifactProcessor.XAttr("many", Boolean.valueOf(property.isMany())), new BaseStAXArtifactProcessor.XAttr("type", property.getXSDType()), new BaseStAXArtifactProcessor.XAttr("element", property.getXSDElement()), new BaseStAXArtifactProcessor.XAttr("source", property.getSource()), new BaseStAXArtifactProcessor.XAttr("file", property.getFile()), this.policyProcessor.writePolicies(property));
                this.writeExtendedAttributes(writer, (Extensible)property, this.extensionAttributeProcessor);
                this.writePropertyValue(property.getValue(), property.getXSDElement(), property.getXSDType(), writer);
                for (Iterator extension4 : property.getExtensions()) {
                    this.extensionProcessor.write(extension4, writer);
                }
                this.writeEnd(writer);
            }
            this.writeEnd(writer);
        }
        for (Reference reference : composite.getReferences()) {
            CompositeReference compositeReference = (CompositeReference)reference;
            ArrayList<String> promote = new ArrayList<String>();
            for (ComponentReference promoted : compositeReference.getPromotedReferences()) {
                promote.add(promoted.getName());
            }
            this.writeStart(writer, "reference", new BaseStAXArtifactProcessor.XAttr("name", reference.getName()), new BaseStAXArtifactProcessor.XAttr("promote", promote), this.writeMultiplicity((AbstractReference)reference), this.policyProcessor.writePolicies(reference));
            this.writeExtendedAttributes(writer, (Extensible)reference, this.extensionAttributeProcessor);
            this.extensionProcessor.write((Object)reference.getInterfaceContract(), writer);
            for (Binding binding : reference.getBindings()) {
                this.extensionProcessor.write((Object)binding, writer);
            }
            if (reference.getCallback() != null) {
                Callback callback = reference.getCallback();
                this.writeStart(writer, "callback", new BaseStAXArtifactProcessor.XAttr[0]);
                this.writeExtendedAttributes(writer, (Extensible)callback, this.extensionAttributeProcessor);
                for (Binding binding : callback.getBindings()) {
                    this.extensionProcessor.write((Object)binding, writer);
                }
                for (Iterator extension4 : callback.getExtensions()) {
                    this.extensionProcessor.write(extension4, writer);
                }
                this.writeEnd(writer);
            }
            for (Object extension : reference.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (Property property : composite.getProperties()) {
            this.writeStart(writer, "property", new BaseStAXArtifactProcessor.XAttr("name", property.getName()), new BaseStAXArtifactProcessor.XAttr("mustSupply", Boolean.valueOf(property.isMustSupply())), new BaseStAXArtifactProcessor.XAttr("many", Boolean.valueOf(property.isMany())), new BaseStAXArtifactProcessor.XAttr("type", property.getXSDType()), new BaseStAXArtifactProcessor.XAttr("element", property.getXSDElement()), this.policyProcessor.writePolicies(property));
            this.writeExtendedAttributes(writer, (Extensible)property, this.extensionAttributeProcessor);
            this.writePropertyValue(property.getValue(), property.getXSDElement(), property.getXSDType(), writer);
            for (Object extension : property.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (Wire wire : composite.getWires()) {
            this.writeStart(writer, "wire", new BaseStAXArtifactProcessor.XAttr("source", wire.getSource().getName()), new BaseStAXArtifactProcessor.XAttr("target", wire.getTarget().getName()), wire.isReplace() ? new BaseStAXArtifactProcessor.XAttr("replace", Boolean.valueOf(true)) : null);
            this.writeExtendedAttributes(writer, (Extensible)wire, this.extensionAttributeProcessor);
            for (Object extension : wire.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (Object extension : composite.getExtensions()) {
            this.extensionProcessor.write(extension, writer);
        }
        this.writeEndDocument(writer);
    }

    public void resolve(Composite composite, ModelResolver resolver) throws ContributionResolveException {
        ConstrainingType constrainingType = composite.getConstrainingType();
        if (constrainingType != null) {
            constrainingType = (ConstrainingType)resolver.resolveModel(ConstrainingType.class, (Object)constrainingType);
            composite.setConstrainingType(constrainingType);
        }
        int i = 0;
        int n = composite.getIncludes().size();
        while (i < n) {
            Composite include = (Composite)composite.getIncludes().get(i);
            if (include != null) {
                include = (Composite)resolver.resolveModel(Composite.class, (Object)include);
                composite.getIncludes().set(i, include);
            }
            ++i;
        }
        for (Object extension : composite.getExtensions()) {
            if (extension == null) continue;
            this.extensionProcessor.resolve(extension, resolver);
        }
        this.resolveContracts((Base)composite, composite.getServices(), resolver);
        this.resolveContracts((Base)composite, composite.getReferences(), resolver);
        for (Component component : composite.getComponents()) {
            constrainingType = component.getConstrainingType();
            if (constrainingType != null) {
                constrainingType = (ConstrainingType)resolver.resolveModel(ConstrainingType.class, (Object)constrainingType);
                component.setConstrainingType(constrainingType);
            }
            this.resolveContracts((Base)component, component.getServices(), resolver);
            this.resolveContracts((Base)component, component.getReferences(), resolver);
            for (ComponentProperty componentProperty : component.getProperties()) {
                if (componentProperty.getFile() == null) continue;
                Artifact artifact = this.contributionFactory.createArtifact();
                artifact.setURI(componentProperty.getFile());
                artifact = (Artifact)resolver.resolveModel(Artifact.class, (Object)artifact);
                if (artifact.getLocation() == null) continue;
                componentProperty.setFile(artifact.getLocation());
            }
            Implementation implementation = component.getImplementation();
            if (implementation != null) {
                implementation = this.resolveImplementation(implementation, resolver);
                component.setImplementation(implementation);
            }
            if (!(component instanceof ResolverExtension)) continue;
            ((ResolverExtension)component).setModelResolver(resolver);
        }
        for (Service service : composite.getServices()) {
            CompositeService compositeService = (CompositeService)service;
            Component promotedComponent = compositeService.getPromotedComponent();
            if (!(promotedComponent instanceof ResolverExtension)) continue;
            ((ResolverExtension)promotedComponent).setModelResolver(resolver);
        }
    }

    public QName getArtifactType() {
        return Constants.COMPOSITE_QNAME;
    }

    public Class<Composite> getModelType() {
        return Composite.class;
    }

    private static FactoryExtensionPoint modelFactories(ExtensionPointRegistry extensionPoints) {
        return (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
    }

    private static Monitor monitor(ExtensionPointRegistry extensionPoints) {
        MonitorFactory monitorFactory;
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        if (utilities != null && (monitorFactory = (MonitorFactory)utilities.getUtility(MonitorFactory.class)) != null) {
            return monitorFactory.createMonitor();
        }
        return null;
    }
}

