/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.util.PolicyComputationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDocumentProcessor
extends BaseAssemblyProcessor
implements URLArtifactProcessor<Composite> {
    private XMLInputFactory inputFactory;
    private DocumentBuilderFactory documentBuilderFactory;
    private List scaDefnSink;
    private Collection<PolicySet> domainPolicySets = null;
    private int scaDefnsCount = 0;

    public CompositeDocumentProcessor(FactoryExtensionPoint modelFactories, StAXArtifactProcessor staxProcessor, Monitor monitor) {
        super(modelFactories, staxProcessor, monitor);
        this.inputFactory = (XMLInputFactory)modelFactories.getFactory(ValidatingXMLInputFactory.class);
        this.documentBuilderFactory = (DocumentBuilderFactory)modelFactories.getFactory(DocumentBuilderFactory.class);
    }

    public Composite read(URL contributionURL, URI uri, URL url) throws ContributionReadException {
        InputStream scdlStream = null;
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            scdlStream = connection.getInputStream();
        }
        catch (IOException e) {
            ContributionReadException ce = new ContributionReadException((Throwable)e);
            this.error("ContributionReadException", (Object)url, (Exception)ce);
            throw ce;
        }
        return this.read(uri, scdlStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Composite read(URI uri, InputStream scdlStream) throws ContributionReadException {
        Composite composite2;
        try {
            Composite composite = null;
            try {
                if (this.domainPolicySets != null) {
                    byte[] transformedArtifactContent = PolicyComputationUtils.addApplicablePolicySets((InputStream)scdlStream, this.domainPolicySets, (DocumentBuilderFactory)this.documentBuilderFactory);
                    scdlStream = new ByteArrayInputStream(transformedArtifactContent);
                }
            }
            catch (IOException e) {
                ContributionReadException ce = new ContributionReadException((Throwable)e);
                this.error("ContributionReadException", (Object)scdlStream, (Exception)ce);
                throw ce;
            }
            catch (Exception e) {
                ContributionReadException ce = new ContributionReadException((Throwable)e);
                this.error("ContributionReadException", (Object)scdlStream, (Exception)ce);
            }
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(scdlStream);
            reader.nextTag();
            composite = (Composite)this.extensionProcessor.read(reader);
            if (composite != null) {
                composite.setURI(uri.toString());
            }
            composite2 = composite;
        }
        catch (XMLStreamException e) {
            try {
                ContributionReadException ce = new ContributionReadException((Throwable)e);
                this.error("ContributionReadException", (Object)this.inputFactory, (Exception)ce);
                throw ce;
            }
            catch (Throwable throwable) {
                try {
                    if (scdlStream == null) throw throwable;
                    scdlStream.close();
                    scdlStream = null;
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            if (scdlStream == null) return composite2;
            scdlStream.close();
            return composite2;
        }
        catch (IOException iOException) {}
        return composite2;
    }

    public void resolve(Composite composite, ModelResolver resolver) throws ContributionResolveException {
        if (composite != null) {
            this.extensionProcessor.resolve((Object)composite, resolver);
        }
    }

    public String getArtifactType() {
        return ".composite";
    }

    public Class<Composite> getModelType() {
        return Composite.class;
    }
}

