/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Base;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBeanModelProcessor<T>
extends BaseAssemblyProcessor
implements StAXArtifactProcessor<T> {
    private QName artifactType;
    private Class<T> modelClass;
    private Object modelFactory;
    private Method factoryMethod;
    private Map<String, Method> setterMethods = new HashMap<String, Method>();
    private Map<String, Method> getterMethods = new HashMap<String, Method>();

    public DefaultBeanModelProcessor(AssemblyFactory assemblyFactory, ExtensionFactory extensionFactory, PolicyFactory policyFactory, QName artifactType, Class<T> modelClass, Object modelFactory, Monitor monitor) {
        super(assemblyFactory, extensionFactory, policyFactory, null, null, monitor);
        this.artifactType = artifactType;
        this.modelClass = modelClass;
        this.modelFactory = modelFactory;
        if (modelFactory != null) {
            for (Method method : modelFactory.getClass().getMethods()) {
                if (!method.getName().startsWith("create") || method.getReturnType() != modelClass) continue;
                this.factoryMethod = method;
                break;
            }
        }
        for (Method method : modelClass.getMethods()) {
            Method getter;
            String name = method.getName();
            if (!name.startsWith("set") || name.length() <= 3) continue;
            try {
                getter = modelClass.getMethod("get" + name.substring(3), new Class[0]);
            }
            catch (Exception e) {
                getter = null;
                continue;
            }
            name = name.substring(3);
            if (name.length() > 1 && !name.toUpperCase().equals(name)) {
                name = name.substring(0, 1).toLowerCase() + name.substring(1);
            }
            if (name.toUpperCase().equals(name)) {
                name = name.toLowerCase();
            }
            if (name.endsWith("_")) {
                name = name.substring(0, name.length() - 1);
            }
            this.setterMethods.put(name, method);
            this.getterMethods.put(name, getter);
        }
    }

    public T read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        try {
            Object model = this.modelFactory != null ? this.factoryMethod.invoke(this.modelFactory, new Object[0]) : this.modelClass.newInstance();
            int n = reader.getAttributeCount();
            for (int i = 0; i < n; ++i) {
                String attributeName = reader.getAttributeLocalName(i);
                Method setter = this.setterMethods.get(attributeName);
                if (setter == null) continue;
                String value = null;
                value = attributeName.equals("uri") ? DefaultBeanModelProcessor.getURIString((XMLStreamReader)reader, (String)"uri") : reader.getAttributeValue(i);
                setter.invoke(model, value);
            }
            this.policyProcessor.readPolicies(model, reader);
            if (model instanceof Base) {
                ((Base)model).setUnresolved(true);
            }
            while (reader.hasNext() && (reader.next() != 2 || !this.artifactType.equals(reader.getName()))) {
            }
            return model;
        }
        catch (Exception e) {
            ContributionReadException ce = new ContributionReadException((Throwable)e);
            this.error("ContributionReadException", (Object)reader, (Exception)ce);
            throw ce;
        }
    }

    public void write(T bean, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        try {
            ArrayList<BaseStAXArtifactProcessor.XAttr> attrs = new ArrayList<BaseStAXArtifactProcessor.XAttr>();
            for (Map.Entry<String, Method> entry : this.getterMethods.entrySet()) {
                if (entry.getValue().getReturnType() != String.class) continue;
                String value = (String)entry.getValue().invoke(bean, new Object[0]);
                attrs.add(new BaseStAXArtifactProcessor.XAttr(entry.getKey(), value));
            }
            this.writeStart(writer, this.artifactType.getNamespaceURI(), this.artifactType.getLocalPart(), new BaseStAXArtifactProcessor.XAttr[]{this.policyProcessor.writePolicies(bean), new BaseStAXArtifactProcessor.XAttr(null, attrs)});
            this.writeEnd(writer);
        }
        catch (Exception e) {
            ContributionWriteException ce = new ContributionWriteException((Throwable)e);
            this.error("ContributionWriteException", (Object)writer, (Exception)ce);
            throw ce;
        }
    }

    public void resolve(T bean, ModelResolver resolver) throws ContributionResolveException {
        int d;
        Implementation implementation;
        String uri;
        if (bean instanceof Implementation && (uri = (implementation = (Implementation)bean).getURI()) != null && (d = uri.lastIndexOf(46)) != -1) {
            uri = uri.substring(0, d) + ".componentType";
            ComponentType componentType = this.assemblyFactory.createComponentType();
            componentType.setURI(uri);
            componentType.setUnresolved(true);
            componentType = (ComponentType)resolver.resolveModel(ComponentType.class, (Object)componentType);
            if (componentType != null && !componentType.isUnresolved()) {
                implementation.getServices().addAll(componentType.getServices());
                implementation.getReferences().addAll(componentType.getReferences());
                implementation.getProperties().addAll(componentType.getProperties());
                implementation.setConstrainingType(componentType.getConstrainingType());
                if (implementation instanceof PolicySetAttachPoint && componentType instanceof PolicySetAttachPoint) {
                    PolicySetAttachPoint policiedImpl = (PolicySetAttachPoint)implementation;
                    PolicySetAttachPoint policiedCompType = (PolicySetAttachPoint)componentType;
                    if (policiedImpl.getPolicySets() != null) {
                        policiedImpl.getPolicySets().addAll(policiedCompType.getPolicySets());
                    }
                    if (policiedImpl.getRequiredIntents() != null) {
                        policiedImpl.getRequiredIntents().addAll(policiedCompType.getRequiredIntents());
                    }
                }
            }
        }
        if (bean instanceof Base) {
            ((Base)bean).setUnresolved(false);
        }
    }

    public QName getArtifactType() {
        return this.artifactType;
    }

    public Class<T> getModelType() {
        return this.modelClass;
    }
}

