/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.tuscany.sca.assembly.AbstractProperty;
import org.apache.tuscany.sca.assembly.AbstractReference;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Base;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Callback;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.ConstrainingType;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.OperationsConfigurator;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.Wire;
import org.apache.tuscany.sca.assembly.impl.CompositeImpl;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.resolver.ResolverExtension;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPoint;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.policy.util.PolicyComputationUtils;
import org.apache.tuscany.sca.policy.util.PolicyValidationException;
import org.apache.tuscany.sca.policy.util.PolicyValidationUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeProcessor
extends BaseAssemblyProcessor
implements StAXArtifactProcessor<Composite> {
    private XPathFactory xPathFactory = XPathFactory.newInstance();

    public CompositeProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        this(CompositeProcessor.modelFactories(extensionPoints), extensionProcessor, extensionAttributeProcessor, CompositeProcessor.monitor(extensionPoints));
        this.extensionAttributeProcessor = extensionAttributeProcessor;
    }

    private CompositeProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        super((ContributionFactory)modelFactories.getFactory(ContributionFactory.class), (AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class), (ExtensionFactory)modelFactories.getFactory(ExtensionFactory.class), (PolicyFactory)modelFactories.getFactory(PolicyFactory.class), extensionProcessor, extensionAttributeProcessor, monitor);
        this.extensionAttributeProcessor = extensionAttributeProcessor;
    }

    public CompositeProcessor(ContributionFactory contributionFactory, AssemblyFactory assemblyFactory, ExtensionFactory extensionFactory, PolicyFactory policyFactory, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        super(contributionFactory, assemblyFactory, extensionFactory, policyFactory, extensionProcessor, extensionAttributeProcessor, monitor);
    }

    public Composite read(XMLStreamReader reader) throws ContributionReadException {
        Composite composite = null;
        Composite include = null;
        Component component = null;
        Property property = null;
        ComponentService componentService = null;
        ComponentReference componentReference = null;
        ComponentProperty componentProperty = null;
        CompositeService compositeService = null;
        CompositeReference compositeReference = null;
        ComponentService contract = null;
        Wire wire = null;
        Callback callback = null;
        QName name = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        String source;
                        name = reader.getName();
                        if (COMPOSITE_QNAME.equals(name)) {
                            composite = this.assemblyFactory.createComposite();
                            composite.setName(new QName(CompositeProcessor.getURIString((XMLStreamReader)reader, (String)"targetNamespace"), this.getString(reader, "name")));
                            if (!this.isSet(reader, "targetNamespace")) {
                                this.warning("NoCompositeNamespace", composite, composite.getName().toString());
                            }
                            if (this.isSet(reader, "autowire")) {
                                composite.setAutowire(Boolean.valueOf(this.getBoolean(reader, "autowire")));
                            }
                            this.readExtendedAttributes(reader, (Extensible)composite);
                            composite.setLocal(this.getBoolean(reader, "local"));
                            composite.setConstrainingType(this.readConstrainingType(reader));
                            this.policyProcessor.readPolicies(composite, reader);
                            break;
                        }
                        if (INCLUDE_QNAME.equals(name)) {
                            include = this.assemblyFactory.createComposite();
                            include.setName(this.getQName(reader, "name"));
                            include.setURI(this.getString(reader, "uri"));
                            include.setUnresolved(true);
                            composite.getIncludes().add(include);
                            break;
                        }
                        if (SERVICE_QNAME.equals(name)) {
                            if (component != null) {
                                contract = componentService = this.assemblyFactory.createComponentService();
                                componentService.setName(this.getString(reader, "name"));
                                this.readExtendedAttributes(reader, (Extensible)componentService);
                                component.getServices().add(componentService);
                                this.policyProcessor.readPolicies(contract, reader);
                                break;
                            }
                            compositeService = this.assemblyFactory.createCompositeService();
                            contract = compositeService;
                            compositeService.setName(this.getString(reader, "name"));
                            String promoted = CompositeProcessor.getURIString((XMLStreamReader)reader, (String)"promote");
                            if (promoted != null) {
                                String promotedServiceName;
                                String promotedComponentName;
                                int s = promoted.indexOf(47);
                                if (s == -1) {
                                    promotedComponentName = promoted;
                                    promotedServiceName = null;
                                } else {
                                    promotedComponentName = promoted.substring(0, s);
                                    promotedServiceName = promoted.substring(s + 1);
                                }
                                Component promotedComponent = this.assemblyFactory.createComponent();
                                promotedComponent.setUnresolved(true);
                                promotedComponent.setName(promotedComponentName);
                                compositeService.setPromotedComponent(promotedComponent);
                                ComponentService promotedService = this.assemblyFactory.createComponentService();
                                promotedService.setUnresolved(true);
                                promotedService.setName(promotedServiceName);
                                compositeService.setPromotedService(promotedService);
                            }
                            this.readExtendedAttributes(reader, (Extensible)compositeService);
                            composite.getServices().add(compositeService);
                            this.policyProcessor.readPolicies(contract, reader);
                            break;
                        }
                        if (REFERENCE_QNAME.equals(name)) {
                            if (component != null) {
                                componentReference = this.assemblyFactory.createComponentReference();
                                contract = componentReference;
                                componentReference.setName(this.getString(reader, "name"));
                                this.readMultiplicity((AbstractReference)componentReference, reader);
                                if (this.isSet(reader, "autowire")) {
                                    componentReference.setAutowire(Boolean.valueOf(this.getBoolean(reader, "autowire")));
                                }
                                this.readTargets((Reference)componentReference, reader);
                                componentReference.setWiredByImpl(this.getBoolean(reader, "wiredByImpl"));
                                this.readExtendedAttributes(reader, (Extensible)componentReference);
                                component.getReferences().add(componentReference);
                                this.policyProcessor.readPolicies(contract, reader);
                                break;
                            }
                            compositeReference = this.assemblyFactory.createCompositeReference();
                            contract = compositeReference;
                            compositeReference.setName(this.getString(reader, "name"));
                            this.readMultiplicity((AbstractReference)compositeReference, reader);
                            this.readTargets((Reference)compositeReference, reader);
                            String promote = this.getString(reader, "promote");
                            if (promote != null) {
                                StringTokenizer tokens = new StringTokenizer(promote);
                                while (tokens.hasMoreTokens()) {
                                    ComponentReference promotedReference = this.assemblyFactory.createComponentReference();
                                    promotedReference.setUnresolved(true);
                                    promotedReference.setName(tokens.nextToken());
                                    compositeReference.getPromotedReferences().add(promotedReference);
                                }
                            }
                            compositeReference.setWiredByImpl(this.getBoolean(reader, "wiredByImpl"));
                            this.readExtendedAttributes(reader, (Extensible)compositeReference);
                            composite.getReferences().add(compositeReference);
                            this.policyProcessor.readPolicies(contract, reader);
                            break;
                        }
                        if (PROPERTY_QNAME.equals(name)) {
                            if (component != null) {
                                componentProperty = this.assemblyFactory.createComponentProperty();
                                property = componentProperty;
                                source = this.getString(reader, "source");
                                if (source != null) {
                                    source = source.trim();
                                }
                                componentProperty.setSource(source);
                                if (source != null) {
                                    if (source.charAt(0) == '$') {
                                        int index = source.indexOf(47);
                                        if (index == -1) {
                                            source = source + "/";
                                            index = source.length() - 1;
                                        }
                                        if ("".equals(source = source.substring(index + 1))) {
                                            source = ".";
                                        }
                                    }
                                    XPath xpath = this.xPathFactory.newXPath();
                                    xpath.setNamespaceContext(reader.getNamespaceContext());
                                    try {
                                        componentProperty.setSourceXPathExpression(xpath.compile(source));
                                    }
                                    catch (XPathExpressionException e) {
                                        ContributionReadException ce = new ContributionReadException((Throwable)e);
                                        this.error("ContributionReadException", (Object)xpath, (Exception)ce);
                                    }
                                }
                                componentProperty.setFile(CompositeProcessor.getURIString((XMLStreamReader)reader, (String)"file"));
                                this.readExtendedAttributes(reader, (Extensible)componentProperty);
                                this.policyProcessor.readPolicies(property, reader);
                                this.readAbstractProperty((AbstractProperty)componentProperty, reader);
                                Document value = this.readPropertyValue(property.getXSDElement(), property.getXSDType(), reader);
                                property.setValue((Object)value);
                                component.getProperties().add(componentProperty);
                            } else {
                                property = this.assemblyFactory.createProperty();
                                this.policyProcessor.readPolicies(property, reader);
                                this.readAbstractProperty((AbstractProperty)property, reader);
                                Document value = this.readPropertyValue(property.getXSDElement(), property.getXSDType(), reader);
                                property.setValue((Object)value);
                                composite.getProperties().add(property);
                            }
                            if (reader.getEventType() != 2 || !PROPERTY_QNAME.equals(reader.getName())) break;
                            property = null;
                            componentProperty = null;
                            break;
                        }
                        if (COMPONENT_QNAME.equals(name)) {
                            component = this.assemblyFactory.createComponent();
                            component.setName(this.getString(reader, "name"));
                            if (this.isSet(reader, "autowire")) {
                                component.setAutowire(Boolean.valueOf(this.getBoolean(reader, "autowire")));
                            }
                            if (this.isSet(reader, "uri")) {
                                component.setURI(CompositeProcessor.getURIString((XMLStreamReader)reader, (String)"uri"));
                            }
                            this.readExtendedAttributes(reader, (Extensible)component);
                            component.setConstrainingType(this.readConstrainingType(reader));
                            composite.getComponents().add(component);
                            this.policyProcessor.readPolicies(component, reader);
                            break;
                        }
                        if (WIRE_QNAME.equals(name)) {
                            wire = this.assemblyFactory.createWire();
                            source = this.assemblyFactory.createComponentReference();
                            source.setUnresolved(true);
                            source.setName(CompositeProcessor.getURIString((XMLStreamReader)reader, (String)"source"));
                            wire.setSource((ComponentReference)source);
                            ComponentService target = this.assemblyFactory.createComponentService();
                            target.setUnresolved(true);
                            target.setName(CompositeProcessor.getURIString((XMLStreamReader)reader, (String)"target"));
                            wire.setTarget(target);
                            this.readExtendedAttributes(reader, (Extensible)wire);
                            composite.getWires().add(wire);
                            this.policyProcessor.readPolicies(wire, reader);
                            break;
                        }
                        if (CALLBACK_QNAME.equals(name)) {
                            callback = this.assemblyFactory.createCallback();
                            contract.setCallback(callback);
                            this.readExtendedAttributes(reader, (Extensible)callback);
                            this.policyProcessor.readPolicies(callback, reader);
                            break;
                        }
                        if (OPERATION_QNAME.equals(name)) {
                            ConfiguredOperation operation = this.assemblyFactory.createConfiguredOperation();
                            operation.setName(this.getString(reader, "name"));
                            operation.setUnresolved(true);
                            if (callback != null) {
                                this.policyProcessor.readPolicies(operation, reader);
                            } else {
                                this.policyProcessor.readPolicies(operation, reader);
                            }
                            CompositeService opConfigurator = null;
                            if (compositeService != null) {
                                opConfigurator = compositeService;
                            } else if (componentService != null) {
                                opConfigurator = componentService;
                            } else if (compositeReference != null) {
                                opConfigurator = compositeReference;
                            } else if (componentReference != null) {
                                opConfigurator = componentReference;
                            }
                            opConfigurator.getConfiguredOperations().add(operation);
                            break;
                        }
                        if (IMPLEMENTATION_COMPOSITE_QNAME.equals(name)) {
                            Composite implementation = this.assemblyFactory.createComposite();
                            implementation.setName(this.getQName(reader, "name"));
                            implementation.setUnresolved(true);
                            this.readExtendedAttributes(reader, (Extensible)implementation);
                            component.setImplementation((Implementation)implementation);
                            this.policyProcessor.readPolicies(implementation, reader);
                            break;
                        }
                        Object extension = this.extensionProcessor.read(reader);
                        if (extension == null) break;
                        if (extension instanceof InterfaceContract) {
                            if (contract != null) {
                                contract.setInterfaceContract((InterfaceContract)extension);
                                break;
                            }
                            if (name.getNamespaceURI().equals("http://www.osoa.org/xmlns/sca/1.0")) {
                                this.error("UnexpectedInterfaceElement", extension, new Object[0]);
                                break;
                            }
                            composite.getExtensions().add(extension);
                            break;
                        }
                        if (extension instanceof Binding) {
                            if (extension instanceof PolicySetAttachPoint) {
                                IntentAttachPointType bindingType = this.intentAttachPointTypeFactory.createBindingType();
                                bindingType.setName(name);
                                bindingType.setUnresolved(true);
                                ((PolicySetAttachPoint)extension).setType(bindingType);
                            }
                            if (callback != null) {
                                callback.getBindings().add((Binding)extension);
                                break;
                            }
                            if (contract != null) {
                                contract.getBindings().add((Binding)extension);
                                break;
                            }
                            if (name.getNamespaceURI().equals("http://www.osoa.org/xmlns/sca/1.0")) {
                                this.error("UnexpectedBindingElement", extension, new Object[0]);
                                break;
                            }
                            composite.getExtensions().add(extension);
                            break;
                        }
                        if (extension instanceof Implementation) {
                            if (extension instanceof PolicySetAttachPoint) {
                                IntentAttachPointType implType = this.intentAttachPointTypeFactory.createImplementationType();
                                implType.setName(name);
                                implType.setUnresolved(true);
                                ((PolicySetAttachPoint)extension).setType(implType);
                            }
                            if (component != null) {
                                component.setImplementation((Implementation)extension);
                                break;
                            }
                            if (name.getNamespaceURI().equals("http://www.osoa.org/xmlns/sca/1.0")) {
                                this.error("UnexpectedImplementationElement", extension, new Object[0]);
                                break;
                            }
                            composite.getExtensions().add(extension);
                            break;
                        }
                        if (callback != null) {
                            callback.getExtensions().add(extension);
                            break;
                        }
                        if (contract != null) {
                            contract.getExtensions().add(extension);
                            break;
                        }
                        if (property != null) {
                            property.getExtensions().add(extension);
                            break;
                        }
                        if (component != null) {
                            component.getExtensions().add(extension);
                            break;
                        }
                        composite.getExtensions().add(extension);
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 2: {
                        name = reader.getName();
                        if (SERVICE_QNAME.equals(name)) {
                            componentService = null;
                            compositeService = null;
                            contract = null;
                            break;
                        }
                        if (INCLUDE_QNAME.equals(name)) {
                            include = null;
                            break;
                        }
                        if (REFERENCE_QNAME.equals(name)) {
                            componentReference = null;
                            compositeReference = null;
                            contract = null;
                            break;
                        }
                        if (PROPERTY_QNAME.equals(name)) {
                            componentProperty = null;
                            property = null;
                            break;
                        }
                        if (COMPONENT_QNAME.equals(name)) {
                            component = null;
                            break;
                        }
                        if (WIRE_QNAME.equals(name)) {
                            wire = null;
                            break;
                        }
                        if (!CALLBACK_QNAME.equals(name)) break;
                        callback = null;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException((Throwable)e);
            this.error("ContributionReadException", (Object)reader, (Exception)ex);
        }
        return composite;
    }

    public void write(Composite composite, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.writeStartDocument(writer, "composite", this.writeConstrainingType((ComponentType)composite), new BaseStAXArtifactProcessor.XAttr("targetNamespace", composite.getName().getNamespaceURI()), new BaseStAXArtifactProcessor.XAttr("name", composite.getName().getLocalPart()), new BaseStAXArtifactProcessor.XAttr("local", composite.isLocal() ? Boolean.TRUE : null), new BaseStAXArtifactProcessor.XAttr("autowire", composite.getAutowire()), this.policyProcessor.writePolicies(composite));
        this.writeExtendedAttributes(writer, (Extensible)composite, this.extensionAttributeProcessor);
        for (Composite include : composite.getIncludes()) {
            String uri = include.isUnresolved() ? include.getURI() : null;
            this.writeStart(writer, "include", new BaseStAXArtifactProcessor.XAttr("name", include.getName()), new BaseStAXArtifactProcessor.XAttr("uri", uri));
            this.writeExtendedAttributes(writer, (Extensible)include, this.extensionAttributeProcessor);
            this.writeEnd(writer);
        }
        for (Service service : composite.getServices()) {
            CompositeService compositeService = (CompositeService)service;
            Component promotedComponent = compositeService.getPromotedComponent();
            ComponentService promotedService = compositeService.getPromotedService();
            String promote = promotedService != null ? (promotedService.getName() != null ? promotedComponent.getName() + '/' + promotedService.getName() : promotedComponent.getName()) : null;
            this.writeStart(writer, "service", new BaseStAXArtifactProcessor.XAttr("name", service.getName()), new BaseStAXArtifactProcessor.XAttr("promote", promote), this.policyProcessor.writePolicies(service));
            this.writeExtendedAttributes(writer, (Extensible)service, this.extensionAttributeProcessor);
            this.extensionProcessor.write((Object)service.getInterfaceContract(), writer);
            for (Binding binding : service.getBindings()) {
                this.extensionProcessor.write((Object)binding, writer);
            }
            if (service.getCallback() != null) {
                Callback callback = service.getCallback();
                this.writeStart(writer, "callback", this.policyProcessor.writePolicies(callback));
                this.writeExtendedAttributes(writer, (Extensible)callback, this.extensionAttributeProcessor);
                for (Binding binding : callback.getBindings()) {
                    this.extensionProcessor.write((Object)binding, writer);
                }
                for (Object extension : callback.getExtensions()) {
                    this.extensionProcessor.write(extension, writer);
                }
                this.writeEnd(writer);
            }
            for (Object extension : service.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (Component component : composite.getComponents()) {
            Callback callback;
            this.writeStart(writer, "component", new BaseStAXArtifactProcessor.XAttr("name", component.getName()), new BaseStAXArtifactProcessor.XAttr("uri", component.getURI()), new BaseStAXArtifactProcessor.XAttr("autowire", component.getAutowire()), this.policyProcessor.writePolicies(component));
            this.writeExtendedAttributes(writer, (Extensible)component, this.extensionAttributeProcessor);
            Implementation implementation = component.getImplementation();
            if (implementation != null && implementation.getClass().equals(CompositeImpl.class)) {
                this.writeStart(writer, "implementation.composite", new BaseStAXArtifactProcessor.XAttr("name", ((Composite)implementation).getName()));
                this.writeExtendedAttributes(writer, (Extensible)((Composite)implementation), this.extensionAttributeProcessor);
                this.writeEnd(writer);
            } else {
                this.extensionProcessor.write((Object)component.getImplementation(), writer);
            }
            for (Object extension : component.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            for (ComponentService service : component.getServices()) {
                if (service.isCallback()) continue;
                this.writeStart(writer, "service", new BaseStAXArtifactProcessor.XAttr("name", service.getName()), this.policyProcessor.writePolicies(service));
                this.writeExtendedAttributes(writer, (Extensible)service, this.extensionAttributeProcessor);
                this.extensionProcessor.write((Object)service.getInterfaceContract(), writer);
                for (Binding binding : service.getBindings()) {
                    this.extensionProcessor.write((Object)binding, writer);
                }
                if (service.getCallback() != null) {
                    callback = service.getCallback();
                    this.writeStart(writer, "callback", this.policyProcessor.writePolicies(callback));
                    this.writeExtendedAttributes(writer, (Extensible)callback, this.extensionAttributeProcessor);
                    for (Binding binding : callback.getBindings()) {
                        this.extensionProcessor.write((Object)binding, writer);
                    }
                    for (Object extension : callback.getExtensions()) {
                        this.extensionProcessor.write(extension, writer);
                    }
                    this.writeEnd(writer);
                }
                for (Object extension : service.getExtensions()) {
                    this.extensionProcessor.write(extension, writer);
                }
                this.writeEnd(writer);
            }
            for (ComponentReference reference : component.getReferences()) {
                if (reference.isCallback()) continue;
                this.writeStart(writer, "reference", new BaseStAXArtifactProcessor.XAttr("name", reference.getName()), new BaseStAXArtifactProcessor.XAttr("autowire", reference.getAutowire()), this.writeMultiplicity((AbstractReference)reference), this.writeTargets((Reference)reference), this.policyProcessor.writePolicies(reference));
                this.writeExtendedAttributes(writer, (Extensible)reference, this.extensionAttributeProcessor);
                this.extensionProcessor.write((Object)reference.getInterfaceContract(), writer);
                for (Binding binding : reference.getBindings()) {
                    this.extensionProcessor.write((Object)binding, writer);
                }
                if (reference.getCallback() != null) {
                    callback = reference.getCallback();
                    this.writeStart(writer, "callback", this.policyProcessor.writePolicies(callback));
                    this.writeExtendedAttributes(writer, (Extensible)callback, this.extensionAttributeProcessor);
                    for (Binding binding : callback.getBindings()) {
                        this.extensionProcessor.write((Object)binding, writer);
                    }
                    for (Object extensions : callback.getExtensions()) {
                        this.extensionProcessor.write(extensions, writer);
                    }
                    this.writeEnd(writer);
                }
                for (Object extensions : reference.getExtensions()) {
                    this.extensionProcessor.write(extensions, writer);
                }
                this.writeEnd(writer);
            }
            for (ComponentProperty property : component.getProperties()) {
                this.writeStart(writer, "property", new BaseStAXArtifactProcessor.XAttr("name", property.getName()), new BaseStAXArtifactProcessor.XAttr("mustSupply", Boolean.valueOf(property.isMustSupply())), new BaseStAXArtifactProcessor.XAttr("many", Boolean.valueOf(property.isMany())), new BaseStAXArtifactProcessor.XAttr("type", property.getXSDType()), new BaseStAXArtifactProcessor.XAttr("element", property.getXSDElement()), new BaseStAXArtifactProcessor.XAttr("source", property.getSource()), new BaseStAXArtifactProcessor.XAttr("file", property.getFile()), this.policyProcessor.writePolicies(property));
                this.writeExtendedAttributes(writer, (Extensible)property, this.extensionAttributeProcessor);
                this.writePropertyValue(property.getValue(), property.getXSDElement(), property.getXSDType(), writer);
                for (Object extension : property.getExtensions()) {
                    this.extensionProcessor.write(extension, writer);
                }
                this.writeEnd(writer);
            }
            this.writeEnd(writer);
        }
        for (Reference reference : composite.getReferences()) {
            CompositeReference compositeReference = (CompositeReference)reference;
            ArrayList<String> promote = new ArrayList<String>();
            for (ComponentReference promoted : compositeReference.getPromotedReferences()) {
                promote.add(promoted.getName());
            }
            this.writeStart(writer, "reference", new BaseStAXArtifactProcessor.XAttr("name", reference.getName()), new BaseStAXArtifactProcessor.XAttr("promote", promote), this.writeMultiplicity((AbstractReference)reference), this.policyProcessor.writePolicies(reference));
            this.writeExtendedAttributes(writer, (Extensible)reference, this.extensionAttributeProcessor);
            this.extensionProcessor.write((Object)reference.getInterfaceContract(), writer);
            for (Binding binding : reference.getBindings()) {
                this.extensionProcessor.write((Object)binding, writer);
            }
            if (reference.getCallback() != null) {
                Callback callback = reference.getCallback();
                this.writeStart(writer, "callback", new BaseStAXArtifactProcessor.XAttr[0]);
                this.writeExtendedAttributes(writer, (Extensible)callback, this.extensionAttributeProcessor);
                for (Binding binding : callback.getBindings()) {
                    this.extensionProcessor.write((Object)binding, writer);
                }
                for (Object extension : callback.getExtensions()) {
                    this.extensionProcessor.write(extension, writer);
                }
                this.writeEnd(writer);
            }
            for (Object extension : reference.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (Property property : composite.getProperties()) {
            this.writeStart(writer, "property", new BaseStAXArtifactProcessor.XAttr("name", property.getName()), new BaseStAXArtifactProcessor.XAttr("mustSupply", Boolean.valueOf(property.isMustSupply())), new BaseStAXArtifactProcessor.XAttr("many", Boolean.valueOf(property.isMany())), new BaseStAXArtifactProcessor.XAttr("type", property.getXSDType()), new BaseStAXArtifactProcessor.XAttr("element", property.getXSDElement()), this.policyProcessor.writePolicies(property));
            this.writeExtendedAttributes(writer, (Extensible)property, this.extensionAttributeProcessor);
            this.writePropertyValue(property.getValue(), property.getXSDElement(), property.getXSDType(), writer);
            for (Object extension : property.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (Wire wire : composite.getWires()) {
            this.writeStart(writer, "wire", new BaseStAXArtifactProcessor.XAttr("source", wire.getSource().getName()), new BaseStAXArtifactProcessor.XAttr("target", wire.getTarget().getName()));
            this.writeExtendedAttributes(writer, (Extensible)wire, this.extensionAttributeProcessor);
            for (Object extension : wire.getExtensions()) {
                this.extensionProcessor.write(extension, writer);
            }
            this.writeEnd(writer);
        }
        for (Object extension : composite.getExtensions()) {
            this.extensionProcessor.write(extension, writer);
        }
        this.writeEndDocument(writer);
    }

    public void resolve(Composite composite, ModelResolver resolver) throws ContributionResolveException {
        ConstrainingType constrainingType = composite.getConstrainingType();
        if (constrainingType != null) {
            constrainingType = (ConstrainingType)resolver.resolveModel(ConstrainingType.class, (Object)constrainingType);
            composite.setConstrainingType(constrainingType);
        }
        int n = composite.getIncludes().size();
        for (int i = 0; i < n; ++i) {
            Composite include = (Composite)composite.getIncludes().get(i);
            if (include == null) continue;
            include = (Composite)resolver.resolveModel(Composite.class, (Object)include);
            composite.getIncludes().set(i, include);
        }
        for (Object extension : composite.getExtensions()) {
            if (extension == null) continue;
            this.extensionProcessor.resolve(extension, resolver);
        }
        List compositeIntents = null;
        List compositePolicySets = null;
        List compositeApplicablePolicySets = null;
        this.resolveIntents(composite.getRequiredIntents(), resolver);
        this.resolvePolicySets(composite.getPolicySets(), resolver);
        this.resolvePolicySets(composite.getApplicablePolicySets(), resolver);
        compositeIntents = composite.getRequiredIntents();
        compositePolicySets = composite.getPolicySets();
        compositeApplicablePolicySets = composite.getApplicablePolicySets();
        this.resolveContracts((Base)composite, composite.getServices(), resolver);
        this.resolveContracts((Base)composite, composite.getReferences(), resolver);
        for (Component component : composite.getComponents()) {
            constrainingType = component.getConstrainingType();
            if (constrainingType != null) {
                constrainingType = (ConstrainingType)resolver.resolveModel(ConstrainingType.class, (Object)constrainingType);
                component.setConstrainingType(constrainingType);
            }
            this.resolveIntents(component.getRequiredIntents(), resolver);
            this.resolvePolicySets(component.getPolicySets(), resolver);
            this.resolvePolicySets(component.getApplicablePolicySets(), resolver);
            PolicyComputationUtils.addDefaultPolicies((List)compositeIntents, (List)compositePolicySets, (List)component.getRequiredIntents(), (List)component.getPolicySets());
            this.addInheritedPolicySets(compositeApplicablePolicySets, component.getApplicablePolicySets());
            this.resolveContracts((Base)component, component.getServices(), resolver);
            this.resolveContracts((Base)component, component.getReferences(), resolver);
            for (ComponentProperty componentProperty : component.getProperties()) {
                if (componentProperty.getFile() == null) continue;
                Artifact artifact = this.contributionFactory.createArtifact();
                artifact.setURI(componentProperty.getFile());
                if ((artifact = (Artifact)resolver.resolveModel(Artifact.class, (Object)artifact)).getLocation() == null) continue;
                componentProperty.setFile(artifact.getLocation());
            }
            Implementation implementation = component.getImplementation();
            if (implementation != null) {
                try {
                    this.resolveImplIntentsAndPolicySets(implementation, component.getApplicablePolicySets(), resolver);
                    this.copyPoliciesToComponent(component, implementation, resolver, true);
                    implementation = this.resolveImplementation(implementation, resolver);
                    this.copyPoliciesToComponent(component, implementation, resolver, false);
                    component.setImplementation(implementation);
                }
                catch (PolicyValidationException e) {
                    this.error("PolicyImplValidationException", (Object)resolver, component.getName(), e.getMessage());
                }
            }
            if (!(component instanceof ResolverExtension)) continue;
            ((ResolverExtension)component).setModelResolver(resolver);
        }
        for (Service service : composite.getServices()) {
            CompositeService compositeService = (CompositeService)service;
            Component promotedComponent = compositeService.getPromotedComponent();
            if (!(promotedComponent instanceof ResolverExtension)) continue;
            ((ResolverExtension)promotedComponent).setModelResolver(resolver);
        }
    }

    private void resolveImplIntentsAndPolicySets(Implementation implementation, List<PolicySet> inheritedApplicablePolicySets, ModelResolver resolver) throws ContributionResolveException, PolicyValidationException {
        if (implementation instanceof PolicySetAttachPoint) {
            PolicySetAttachPoint policiedImpl = (PolicySetAttachPoint)implementation;
            policiedImpl.getApplicablePolicySets().addAll(inheritedApplicablePolicySets);
            this.resolveIntents(policiedImpl.getRequiredIntents(), resolver);
            PolicyValidationUtils.validateIntents((IntentAttachPoint)policiedImpl, (IntentAttachPointType)policiedImpl.getType());
            this.resolvePolicySets(policiedImpl.getPolicySets(), resolver);
            this.resolvePolicySets(policiedImpl.getApplicablePolicySets(), resolver);
            PolicyValidationUtils.validatePolicySets((PolicySetAttachPoint)policiedImpl);
            if (implementation instanceof OperationsConfigurator) {
                for (ConfiguredOperation implConfOp : ((OperationsConfigurator)implementation).getConfiguredOperations()) {
                    this.resolveIntents(implConfOp.getRequiredIntents(), resolver);
                    PolicyValidationUtils.validateIntents((IntentAttachPoint)implConfOp, (IntentAttachPointType)policiedImpl.getType());
                    this.resolvePolicySets(implConfOp.getPolicySets(), resolver);
                    this.resolvePolicySets(implConfOp.getApplicablePolicySets(), resolver);
                    this.addInheritedPolicySets(policiedImpl.getApplicablePolicySets(), implConfOp.getApplicablePolicySets());
                    PolicyValidationUtils.validatePolicySets((PolicySetAttachPoint)implConfOp, (IntentAttachPointType)policiedImpl.getType());
                    PolicyComputationUtils.addDefaultPolicies((List)((PolicySetAttachPoint)implementation).getRequiredIntents(), (List)((PolicySetAttachPoint)implementation).getPolicySets(), (List)implConfOp.getRequiredIntents(), (List)implConfOp.getPolicySets());
                }
            }
        }
    }

    private void copyPoliciesToComponent(Component component, Implementation implementation, ModelResolver resolver, boolean clearImplSettings) throws ContributionResolveException {
        if (implementation instanceof PolicySetAttachPoint) {
            if (clearImplSettings) {
                for (Intent intent : ((PolicySetAttachPoint)implementation).getRequiredIntents()) {
                    for (Intent excluded : intent.getExcludedIntents()) {
                        if (component.getRequiredIntents().contains(excluded)) {
                            component.getRequiredIntents().remove(excluded);
                        }
                        Iterator i = component.getPolicySets().iterator();
                        while (i.hasNext()) {
                            PolicySet cmpPolicySet = (PolicySet)i.next();
                            if (!cmpPolicySet.getProvidedIntents().contains(excluded)) continue;
                            i.remove();
                        }
                    }
                }
                for (PolicySet policySet : ((PolicySetAttachPoint)implementation).getPolicySets()) {
                    for (Intent intent : policySet.getProvidedIntents()) {
                        for (Intent excluded : intent.getExcludedIntents()) {
                            if (component.getRequiredIntents().contains(excluded)) {
                                component.getRequiredIntents().remove(excluded);
                            }
                            Iterator i = component.getPolicySets().iterator();
                            while (i.hasNext()) {
                                PolicySet cmpPolicySet = (PolicySet)i.next();
                                if (!cmpPolicySet.getProvidedIntents().contains(excluded)) continue;
                                i.remove();
                            }
                        }
                    }
                }
            }
            component.getRequiredIntents().addAll(((PolicySetAttachPoint)implementation).getRequiredIntents());
            component.getPolicySets().addAll(((PolicySetAttachPoint)implementation).getPolicySets());
            component.getApplicablePolicySets().addAll(((PolicySetAttachPoint)implementation).getApplicablePolicySets());
            if (implementation instanceof OperationsConfigurator) {
                ArrayList<ConfiguredOperation> opsFromImplementation = new ArrayList<ConfiguredOperation>();
                ArrayList implConfOperations = new ArrayList(((OperationsConfigurator)implementation).getConfiguredOperations());
                for (ConfiguredOperation implConfOp : implConfOperations) {
                    boolean notFound = true;
                    for (ConfiguredOperation compConfOp : ((OperationsConfigurator)component).getConfiguredOperations()) {
                        if (!implConfOp.getName().equals(compConfOp.getName())) continue;
                        notFound = false;
                        if (clearImplSettings) {
                            for (Intent intent : implConfOp.getRequiredIntents()) {
                                for (Intent excluded : intent.getExcludedIntents()) {
                                    if (!compConfOp.getRequiredIntents().contains(excluded)) continue;
                                    compConfOp.getRequiredIntents().remove(excluded);
                                }
                            }
                            for (PolicySet policySet : implConfOp.getPolicySets()) {
                                for (Intent intent : policySet.getProvidedIntents()) {
                                    for (Intent excluded : intent.getExcludedIntents()) {
                                        if (compConfOp.getRequiredIntents().contains(excluded)) {
                                            compConfOp.getRequiredIntents().remove(excluded);
                                        }
                                        Iterator i = compConfOp.getPolicySets().iterator();
                                        while (i.hasNext()) {
                                            PolicySet cmpPolicySet = (PolicySet)i.next();
                                            if (!cmpPolicySet.getProvidedIntents().contains(excluded)) continue;
                                            i.remove();
                                        }
                                    }
                                }
                            }
                        }
                        this.addInheritedIntents(implConfOp.getRequiredIntents(), compConfOp.getRequiredIntents());
                        this.addInheritedPolicySets(implConfOp.getPolicySets(), compConfOp.getPolicySets());
                        this.addInheritedPolicySets(implConfOp.getApplicablePolicySets(), compConfOp.getApplicablePolicySets());
                    }
                    if (notFound) {
                        opsFromImplementation.add(implConfOp);
                    }
                    if (!clearImplSettings) continue;
                    ((OperationsConfigurator)implementation).getConfiguredOperations().remove(implConfOp);
                }
                ((OperationsConfigurator)component).getConfiguredOperations().addAll(opsFromImplementation);
            }
            if (clearImplSettings) {
                ((PolicySetAttachPoint)implementation).getRequiredIntents().clear();
                ((PolicySetAttachPoint)implementation).getPolicySets().clear();
            }
        }
    }

    public QName getArtifactType() {
        return COMPOSITE_QNAME;
    }

    public Class<Composite> getModelType() {
        return Composite.class;
    }

    private static ModelFactoryExtensionPoint modelFactories(ExtensionPointRegistry extensionPoints) {
        return (ModelFactoryExtensionPoint)extensionPoints.getExtensionPoint(ModelFactoryExtensionPoint.class);
    }

    private static Monitor monitor(ExtensionPointRegistry extensionPoints) {
        MonitorFactory monitorFactory;
        UtilityExtensionPoint utilities = (UtilityExtensionPoint)extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        if (utilities != null && (monitorFactory = (MonitorFactory)utilities.getUtility(MonitorFactory.class)) != null) {
            return monitorFactory.createMonitor();
        }
        return null;
    }
}

