/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.definitions.util;

import java.util.HashSet;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.BindingType;
import org.apache.tuscany.sca.policy.ImplementationType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;

public class DefinitionsUtil {
    public static void aggregate(Definitions source, Definitions target, Monitor monitor) {
        HashSet<Intent> intents = new HashSet<Intent>(target.getIntents());
        for (Intent intent : source.getIntents()) {
            if (intents.contains(intent)) {
                Monitor.error((Monitor)monitor, (Object)target, (String)"org.apache.tuscany.sca.assembly.builder.definitions-validation-messages", (String)"DuplicateIntent", (Object[])new Object[]{intent.getName().toString()});
                continue;
            }
            target.getIntents().add(intent);
            intents.add(intent);
        }
        HashSet<PolicySet> policySets = new HashSet<PolicySet>(target.getPolicySets());
        for (PolicySet policySet : source.getPolicySets()) {
            if (policySets.contains(policySet)) {
                Monitor.error((Monitor)monitor, (Object)target, (String)"org.apache.tuscany.sca.assembly.builder.definitions-validation-messages", (String)"DuplicatePolicySet", (Object[])new Object[]{policySet.getName().toString()});
                continue;
            }
            target.getPolicySets().add(policySet);
            policySets.add(policySet);
        }
        HashSet<BindingType> bindingTypes = new HashSet<BindingType>(target.getBindingTypes());
        for (BindingType bindingType : source.getBindingTypes()) {
            if (bindingTypes.contains(bindingType)) {
                Monitor.error((Monitor)monitor, (Object)target, (String)"org.apache.tuscany.sca.assembly.builder.definitions-validation-messages", (String)"DuplicateBindingType", (Object[])new Object[]{bindingType.getType().toString()});
                continue;
            }
            target.getBindingTypes().add(bindingType);
            bindingTypes.add(bindingType);
        }
        HashSet<ImplementationType> implementationTypes = new HashSet<ImplementationType>(target.getImplementationTypes());
        for (ImplementationType implementationType : source.getImplementationTypes()) {
            if (implementationTypes.contains(implementationType)) {
                Monitor.error((Monitor)monitor, (Object)target, (String)"org.apache.tuscany.sca.assembly.builder.definitions-validation-messages", (String)"DuplicateImplementationType", (Object[])new Object[]{implementationType.getType().toString()});
                continue;
            }
            target.getImplementationTypes().add(implementationType);
            implementationTypes.add(implementationType);
        }
        target.getBindings().addAll(source.getBindings());
        target.getExternalAttachments().addAll(source.getExternalAttachments());
    }
}

