/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.BindingBuilder;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.ContractBuilder;
import org.apache.tuscany.sca.assembly.builder.ImplementationBuilder;
import org.apache.tuscany.sca.assembly.builder.PolicyBuilder;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.LifeCycleListener;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.extensibility.ServiceDeclarationParser;
import org.apache.tuscany.sca.extensibility.ServiceDiscovery;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;

public class DefaultBuilderExtensionPoint
implements BuilderExtensionPoint,
LifeCycleListener {
    private ExtensionPointRegistry registry;
    private final Map<String, CompositeBuilder> builders = new HashMap<String, CompositeBuilder>();
    private final Map<QName, BindingBuilder> bindingBuilders = new HashMap<QName, BindingBuilder>();
    private final Map<QName, ImplementationBuilder> implementationBuilders = new HashMap<QName, ImplementationBuilder>();
    private final Map<QName, PolicyBuilder> policyBuilders = new HashMap<QName, PolicyBuilder>();
    private ContractBuilder contractBuilder = null;
    private boolean loaded;

    public DefaultBuilderExtensionPoint(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    public void start() {
    }

    public void stop() {
        this.builders.clear();
        this.bindingBuilders.clear();
        this.implementationBuilders.clear();
        this.loaded = false;
    }

    @Override
    public void addCompositeBuilder(CompositeBuilder builder) {
        this.builders.put(builder.getID(), builder);
    }

    @Override
    public void removeCompositeBuilder(CompositeBuilder builder) {
        this.builders.remove(builder.getID());
    }

    @Override
    public CompositeBuilder getCompositeBuilder(String id) {
        this.loadBuilders();
        return this.builders.get(id);
    }

    @Override
    public void addContractBuilder(ContractBuilder contractBuilder) {
        this.contractBuilder = contractBuilder;
    }

    @Override
    public void removeContractBuilder(ContractBuilder contractBuilder) {
        this.contractBuilder = null;
    }

    @Override
    public ContractBuilder getContractBuilder() {
        this.loadBuilders();
        return this.contractBuilder;
    }

    private synchronized void loadBuilders() {
        Object builder;
        Collection builderDeclarations;
        if (this.loaded) {
            return;
        }
        FactoryExtensionPoint factories = (FactoryExtensionPoint)this.registry.getExtensionPoint(FactoryExtensionPoint.class);
        UtilityExtensionPoint utils = (UtilityExtensionPoint)this.registry.getExtensionPoint(UtilityExtensionPoint.class);
        InterfaceContractMapper mapper = (InterfaceContractMapper)utils.getUtility(InterfaceContractMapper.class);
        ServiceDiscovery serviceDiscovery = this.registry.getServiceDiscovery();
        try {
            builderDeclarations = serviceDiscovery.getServiceDeclarations(CompositeBuilder.class.getName());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration builderDeclaration : builderDeclarations) {
            Map attributes = builderDeclaration.getAttributes();
            String id = (String)attributes.get("id");
            LazyCompositeBuilder builder2 = new LazyCompositeBuilder(id, builderDeclaration, this, factories, mapper);
            this.builders.put(id, builder2);
        }
        try {
            builderDeclarations = serviceDiscovery.getServiceDeclarations(BindingBuilder.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration builderDeclaration : builderDeclarations) {
            builder = new LazyBindingBuilder(builderDeclaration);
            this.bindingBuilders.put(builder.getBindingType(), (BindingBuilder)builder);
        }
        try {
            builderDeclarations = serviceDiscovery.getServiceDeclarations(ImplementationBuilder.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration builderDeclaration : builderDeclarations) {
            builder = new LazyImplementationBuilder(builderDeclaration);
            this.implementationBuilders.put(builder.getImplementationType(), (ImplementationBuilder)builder);
        }
        try {
            builderDeclarations = serviceDiscovery.getServiceDeclarations(PolicyBuilder.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration builderDeclaration : builderDeclarations) {
            builder = new LazyPolicyBuilder(builderDeclaration);
            this.policyBuilders.put(builder.getPolicyType(), (PolicyBuilder)builder);
        }
        try {
            builderDeclarations = serviceDiscovery.getServiceDeclarations(ContractBuilder.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration builderDeclaration : builderDeclarations) {
            this.contractBuilder = new LazyContractBuilder(builderDeclaration);
        }
        this.loaded = true;
    }

    @Override
    public void addBindingBuilder(BindingBuilder<?> bindingBuilder) {
        this.bindingBuilders.put(bindingBuilder.getBindingType(), bindingBuilder);
    }

    @Override
    public <B extends Binding> BindingBuilder<B> getBindingBuilder(QName bindingType) {
        this.loadBuilders();
        return this.bindingBuilders.get(bindingType);
    }

    @Override
    public <B extends Binding> void removeBindingBuilder(BindingBuilder<B> builder) {
        this.bindingBuilders.remove(builder.getBindingType());
    }

    @Override
    public void addImplementationBuilder(ImplementationBuilder<?> implementationBuilder) {
        this.implementationBuilders.put(implementationBuilder.getImplementationType(), implementationBuilder);
    }

    @Override
    public <I extends Implementation> ImplementationBuilder<I> getImplementationBuilder(QName implementationType) {
        this.loadBuilders();
        return this.implementationBuilders.get(implementationType);
    }

    @Override
    public <I extends Implementation> void removeImplementationBuilder(ImplementationBuilder<I> builder) {
        this.implementationBuilders.remove(builder.getImplementationType());
    }

    @Override
    public void addPolicyBuilder(PolicyBuilder<?> policyBuilder) {
        this.policyBuilders.put(policyBuilder.getPolicyType(), policyBuilder);
    }

    public <B> PolicyBuilder<B> getPolicyBuilder(QName policyType) {
        this.loadBuilders();
        return this.policyBuilders.get(policyType);
    }

    @Override
    public Collection<PolicyBuilder> getPolicyBuilders() {
        this.loadBuilders();
        return this.policyBuilders.values();
    }

    public <B> void removePolicyBuilder(PolicyBuilder<B> builder) {
        this.policyBuilders.remove(builder.getPolicyType());
    }

    private class LazyContractBuilder
    implements ContractBuilder {
        private ServiceDeclaration sd;
        private ContractBuilder builder;

        public LazyContractBuilder(ServiceDeclaration sd) {
            this.sd = sd;
        }

        @Override
        public boolean build(InterfaceContract interfaceContract, BuilderContext context) {
            return this.getBuilder().build(interfaceContract, context);
        }

        private synchronized ContractBuilder getBuilder() {
            if (this.builder == null) {
                try {
                    Class builderClass = this.sd.loadClass();
                    try {
                        Constructor constructor = builderClass.getConstructor(ExtensionPointRegistry.class);
                        this.builder = (ContractBuilder)constructor.newInstance(DefaultBuilderExtensionPoint.this.registry);
                    }
                    catch (NoSuchMethodException e) {
                        Constructor constructor = builderClass.getConstructor(new Class[0]);
                        this.builder = (ContractBuilder)constructor.newInstance(new Object[0]);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.builder;
        }
    }

    private class LazyPolicyBuilder
    implements PolicyBuilder {
        private ServiceDeclaration sd;
        private PolicyBuilder<?> builder;
        private QName qname;

        public LazyPolicyBuilder(ServiceDeclaration sd) {
            this.sd = sd;
            this.qname = ServiceDeclarationParser.getQName((String)((String)sd.getAttributes().get("qname")));
        }

        @Override
        public boolean build(Component component, Implementation implementation, BuilderContext context) {
            return this.getBuilder().build(component, implementation, context);
        }

        @Override
        public QName getPolicyType() {
            return this.qname;
        }

        @Override
        public List<QName> getSupportedBindings() {
            return this.getBuilder().getSupportedBindings();
        }

        private synchronized PolicyBuilder getBuilder() {
            if (this.builder == null) {
                try {
                    Class builderClass = this.sd.loadClass();
                    try {
                        Constructor constructor = builderClass.getConstructor(ExtensionPointRegistry.class);
                        this.builder = (PolicyBuilder)constructor.newInstance(DefaultBuilderExtensionPoint.this.registry);
                    }
                    catch (NoSuchMethodException e) {
                        Constructor constructor = builderClass.getConstructor(new Class[0]);
                        this.builder = (PolicyBuilder)constructor.newInstance(new Object[0]);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.builder;
        }

        @Override
        public boolean build(Endpoint endpoint, BuilderContext context) {
            return this.getBuilder().build(endpoint, context);
        }

        @Override
        public boolean build(EndpointReference endpointReference, BuilderContext context) {
            return this.getBuilder().build(endpointReference, context);
        }

        @Override
        public boolean build(EndpointReference endpointReference, Endpoint endpoint, BuilderContext context) {
            return this.getBuilder().build(endpointReference, endpoint, context);
        }
    }

    private class LazyImplementationBuilder
    implements ImplementationBuilder {
        private ServiceDeclaration sd;
        private ImplementationBuilder<?> builder;
        private QName qname;

        public LazyImplementationBuilder(ServiceDeclaration sd) {
            this.sd = sd;
            this.qname = ServiceDeclarationParser.getQName((String)((String)sd.getAttributes().get("qname")));
        }

        public void build(Component component, Implementation implementation, BuilderContext context) {
            this.getBuilder().build(component, implementation, context);
        }

        @Override
        public QName getImplementationType() {
            return this.qname;
        }

        private synchronized ImplementationBuilder getBuilder() {
            if (this.builder == null) {
                try {
                    Class builderClass = this.sd.loadClass();
                    try {
                        Constructor constructor = builderClass.getConstructor(ExtensionPointRegistry.class);
                        this.builder = (ImplementationBuilder)constructor.newInstance(DefaultBuilderExtensionPoint.this.registry);
                    }
                    catch (NoSuchMethodException e) {
                        Constructor constructor = builderClass.getConstructor(new Class[0]);
                        this.builder = (ImplementationBuilder)constructor.newInstance(new Object[0]);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.builder;
        }
    }

    private class LazyBindingBuilder
    implements BindingBuilder {
        private ServiceDeclaration sd;
        private BindingBuilder<?> builder;
        private QName qname;

        public LazyBindingBuilder(ServiceDeclaration sd) {
            this.sd = sd;
            this.qname = ServiceDeclarationParser.getQName((String)((String)sd.getAttributes().get("qname")));
        }

        public void build(Component component, Contract contract, Binding binding, BuilderContext context, boolean rebuild) {
            this.getBuilder().build(component, contract, binding, context, rebuild);
        }

        @Override
        public QName getBindingType() {
            return this.qname;
        }

        private synchronized BindingBuilder getBuilder() {
            if (this.builder == null) {
                try {
                    Class builderClass = this.sd.loadClass();
                    try {
                        Constructor constructor = builderClass.getConstructor(ExtensionPointRegistry.class);
                        this.builder = (BindingBuilder)constructor.newInstance(DefaultBuilderExtensionPoint.this.registry);
                    }
                    catch (NoSuchMethodException e) {
                        Constructor constructor = builderClass.getConstructor(new Class[0]);
                        this.builder = (BindingBuilder)constructor.newInstance(new Object[0]);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.builder;
        }
    }

    private class LazyCompositeBuilder
    implements CompositeBuilder {
        private FactoryExtensionPoint factories;
        private InterfaceContractMapper mapper;
        private String id;
        private ServiceDeclaration builderDeclaration;
        private CompositeBuilder builder;
        private BuilderExtensionPoint builders;

        private LazyCompositeBuilder(String id, ServiceDeclaration factoryDeclaration, BuilderExtensionPoint builders, FactoryExtensionPoint factories, InterfaceContractMapper mapper) {
            this.id = id;
            this.builderDeclaration = factoryDeclaration;
            this.builders = builders;
            this.factories = factories;
            this.mapper = mapper;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
            return this.getBuilder().build(composite, context);
        }

        private CompositeBuilder getBuilder() {
            if (this.builder == null) {
                try {
                    Class builderClass = this.builderDeclaration.loadClass();
                    try {
                        Constructor constructor = builderClass.getConstructor(FactoryExtensionPoint.class, InterfaceContractMapper.class);
                        this.builder = (CompositeBuilder)constructor.newInstance(this.factories, this.mapper);
                    }
                    catch (NoSuchMethodException e) {
                        try {
                            Constructor constructor = builderClass.getConstructor(BuilderExtensionPoint.class, FactoryExtensionPoint.class, InterfaceContractMapper.class);
                            this.builder = (CompositeBuilder)constructor.newInstance(this.builders, this.factories, this.mapper);
                        }
                        catch (NoSuchMethodException ex) {
                            Constructor constructor = builderClass.getConstructor(ExtensionPointRegistry.class);
                            this.builder = (CompositeBuilder)constructor.newInstance(DefaultBuilderExtensionPoint.this.registry);
                        }
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            return this.builder;
        }
    }
}

