/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.impl;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.Wire;
import org.apache.tuscany.sca.assembly.impl.ImplementationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeImpl
extends ImplementationImpl
implements Composite,
Cloneable {
    private String specVersion = "undefined";
    private List<Component> components = new ArrayList<Component>();
    private List<Composite> includes = new ArrayList<Composite>();
    private QName name;
    private List<Wire> wires = new ArrayList<Wire>();
    private Boolean autowire;
    private boolean local = true;

    protected CompositeImpl() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        CompositeImpl clone = (CompositeImpl)super.clone();
        clone.components = new ArrayList<Component>();
        for (Component component : this.getComponents()) {
            Component clonedComponent = (Component)component.clone();
            for (Service service : clone.getServices()) {
                CompositeService compositeService = (CompositeService)service;
                if (compositeService.getPromotedComponent() != null) {
                    compositeService.getPromotedComponent().setUnresolved(true);
                }
                if (compositeService.getPromotedService() == null) continue;
                compositeService.getPromotedService().setUnresolved(true);
            }
            for (Reference reference : clone.getReferences()) {
                CompositeReference compositeReference = (CompositeReference)reference;
                for (ComponentReference ref : compositeReference.getPromotedReferences()) {
                    ref.setUnresolved(true);
                }
            }
            clone.components.add(clonedComponent);
        }
        clone.wires = new ArrayList<Wire>();
        for (Wire wire : this.getWires()) {
            clone.wires.add((Wire)wire.clone());
        }
        return clone;
    }

    @Override
    public String getSpecVersion() {
        return this.specVersion;
    }

    @Override
    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    @Override
    public List<Component> getComponents() {
        return this.components;
    }

    @Override
    public List<Composite> getIncludes() {
        return this.includes;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public List<Wire> getWires() {
        return this.wires;
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public void setLocal(boolean local) {
        this.local = local;
    }

    public boolean isAutowire() {
        return this.autowire == null ? false : this.autowire;
    }

    @Override
    public void setAutowire(Boolean autowire) {
        this.autowire = autowire;
    }

    @Override
    public Boolean getAutowire() {
        return this.autowire;
    }

    @Override
    public void setName(QName name) {
        this.name = name;
    }

    @Override
    public int hashCode() {
        return String.valueOf(this.getName()).hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Composite) {
            if (this.getName() != null) {
                return this.getName().equals(((Composite)obj).getName());
            }
            return ((Composite)obj).getName() == null;
        }
        return false;
    }

    public String toString() {
        return this.name != null ? this.getName().toString() : "null";
    }
}

