/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class PropertyConfigurationUtil {
    PropertyConfigurationUtil() {
    }

    private static Document evaluate(Document node, XPathExpression expression, DocumentBuilderFactory documentBuilderFactory) throws XPathExpressionException, ParserConfigurationException {
        Element value = node.getDocumentElement();
        Node result = (Node)expression.evaluate(value, XPathConstants.NODE);
        if (result == null) {
            return null;
        }
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        if (result instanceof Document) {
            return (Document)result;
        }
        document.appendChild(document.importNode(result, true));
        return document;
    }

    private static Document loadFromFile(String file, TransformerFactory transformerFactory) throws MalformedURLException, IOException, TransformerException, ParserConfigurationException {
        URI uri = URI.create(file);
        URL url = uri.toURL();
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream is = null;
        try {
            is = connection.getInputStream();
            SAXSource streamSource = new SAXSource(new InputSource(is));
            DOMResult result = new DOMResult();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.transform(streamSource, result);
            Document document = (Document)result.getNode();
            Element root = document.createElementNS(null, "value");
            root.appendChild(document.getDocumentElement());
            document.appendChild(root);
            Document document2 = document;
            return document2;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    static void sourceComponentProperties(Map<String, Property> compositeProperties, Component componentDefinition, DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory) throws CompositeBuilderException, ParserConfigurationException, XPathExpressionException, TransformerException, IOException {
        List<ComponentProperty> componentProperties = componentDefinition.getProperties();
        for (ComponentProperty aProperty : componentProperties) {
            String source = aProperty.getSource();
            String file = aProperty.getFile();
            if (source != null) {
                int index = source.indexOf(47);
                if (index == -1) {
                    source = String.valueOf(source) + "/";
                    index = source.length() - 1;
                }
                if (source.charAt(0) == '$') {
                    String name = source.substring(1, index);
                    Property compositeProp = compositeProperties.get(name);
                    if (compositeProp == null) {
                        throw new CompositeBuilderException("The 'source' cannot be resolved to a composite property: " + source);
                    }
                    Document compositePropDefValues = (Document)compositeProp.getValue();
                    Document node = PropertyConfigurationUtil.evaluate(compositePropDefValues, aProperty.getSourceXPathExpression(), documentBuilderFactory);
                    if (node == null) continue;
                    aProperty.setValue(node);
                    continue;
                }
                throw new CompositeBuilderException("The 'source' has an invalid value: " + source);
            }
            if (file == null) continue;
            aProperty.setValue(PropertyConfigurationUtil.loadFromFile(aProperty.getFile(), transformerFactory));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DOMNamespaceContext
    implements NamespaceContext {
        private Node node;

        public DOMNamespaceContext(Node node) {
            this.node = node;
        }

        @Override
        public String getNamespaceURI(String prefix) {
            if (prefix == null) {
                throw new IllegalArgumentException("Prefix is null");
            }
            if ("xml".equals(prefix)) {
                return "http://www.w3.org/XML/1998/namespace";
            }
            if ("xmlns".equals(prefix)) {
                return "http://www.w3.org/2000/xmlns/";
            }
            String ns = this.node.lookupNamespaceURI(prefix);
            return ns == null ? "" : ns;
        }

        @Override
        public String getPrefix(String namespaceURI) {
            if (namespaceURI == null) {
                throw new IllegalArgumentException("Namespace URI is null");
            }
            if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                return "xml";
            }
            if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                return "xmlns";
            }
            return this.node.lookupPrefix(namespaceURI);
        }

        public Iterator<?> getPrefixes(String namespaceURI) {
            if (namespaceURI == null) {
                throw new IllegalArgumentException("Namespace URI is null");
            }
            if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
                return Arrays.asList("xml").iterator();
            }
            if ("http://www.w3.org/2000/xmlns/".equals(namespaceURI)) {
                return Arrays.asList("xmlns").iterator();
            }
            String prefix = this.getPrefix(namespaceURI);
            if (prefix == null) {
                return Collections.emptyList().iterator();
            }
            return Arrays.asList(prefix).iterator();
        }
    }
}

