/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PrintUtil {
    private boolean useGetters = false;
    private PrintWriter out;
    private int indent;

    public PrintUtil(PrintWriter out, boolean useGetters) {
        this.out = out;
        this.useGetters = useGetters;
    }

    public PrintUtil(OutputStream out) {
        this.out = new PrintWriter((Writer)new OutputStreamWriter(out), true);
    }

    void indent() {
        int i = 0;
        while (i < this.indent) {
            this.out.print("  ");
            ++i;
        }
    }

    public void print(Object object) {
        HashSet<Integer> objects = new HashSet<Integer>();
        this.print(object, objects);
    }

    private void print(Object object, Set<Integer> printed) {
        if (object == null) {
            return;
        }
        int id = System.identityHashCode(object);
        if (printed.contains(id)) {
            this.indent();
            this.out.println(String.valueOf(object.getClass().getName()) + "@" + id);
        } else {
            printed.add(id);
            try {
                this.indent();
                this.out.println(String.valueOf(object.getClass().getSimpleName()) + " {");
                ValueAccessor accessor = this.useGetters ? new PropertyAccessor(object) : new FieldAccessor(object);
                int i = 0;
                while (i < accessor.size()) {
                    try {
                        List<Object> value = accessor.getValue(i);
                        if (value != null) {
                            if (value.getClass().isArray()) {
                                value = Arrays.asList((Object[])value);
                            }
                            if (value instanceof List) {
                                if (!value.isEmpty()) {
                                    ++this.indent;
                                    this.indent();
                                    this.out.println(String.valueOf(accessor.getName(i)) + "= [");
                                    for (Object element : value) {
                                        ++this.indent;
                                        this.print(element, printed);
                                        --this.indent;
                                    }
                                    this.indent();
                                    this.out.println(" ]");
                                    --this.indent;
                                }
                            } else {
                                Class<?> valueClass = value.getClass();
                                if (valueClass.isPrimitive() || valueClass.getName().startsWith("java.") || valueClass.getName().startsWith("javax.") || valueClass.isEnum()) {
                                    if (!accessor.getName(i).equals("class") && !Boolean.FALSE.equals(value)) {
                                        ++this.indent;
                                        this.indent();
                                        this.out.println(String.valueOf(accessor.getName(i)) + "=" + value.toString());
                                        --this.indent;
                                    }
                                } else if (value instanceof Node) {
                                    ++this.indent;
                                    this.indent();
                                    this.out.println(String.valueOf(accessor.getName(i)) + "=" + value.toString());
                                    --this.indent;
                                } else {
                                    ++this.indent;
                                    this.indent();
                                    this.out.println(String.valueOf(accessor.getName(i)) + "= {");
                                    ++this.indent;
                                    this.print(value, printed);
                                    --this.indent;
                                    this.indent();
                                    this.out.println("}");
                                    --this.indent;
                                }
                            }
                        }
                    }
                    catch (Exception exception) {}
                    ++i;
                }
                this.indent();
                this.out.println("}");
            }
            catch (Exception e) {
                this.indent();
                this.out.println(e);
            }
        }
    }

    private static List<Field> getAllFields(Class<?> clazz) {
        return PrintUtil.getAllFields(clazz, new ArrayList<Field>());
    }

    private static List<Field> getAllFields(Class<?> clazz, List<Field> fields) {
        Field[] declaredFields;
        if (clazz == null || clazz.isArray() || Object.class.equals(clazz)) {
            return fields;
        }
        fields = PrintUtil.getAllFields(clazz.getSuperclass(), fields);
        Field[] fieldArray = declaredFields = clazz.getDeclaredFields();
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            final Field field = fieldArray[n2];
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
            fields.add(field);
            ++n2;
        }
        return fields;
    }

    private static class FieldAccessor
    implements ValueAccessor {
        private Object object;
        private List<Field> fields;

        public FieldAccessor(Object object) {
            this.fields = PrintUtil.getAllFields(object.getClass());
            this.object = object;
        }

        public String getName(int i) {
            return this.fields.get(i).getName();
        }

        public Object getValue(int i) throws Exception {
            return this.fields.get(i).get(this.object);
        }

        public int size() {
            return this.fields.size();
        }
    }

    private static class PropertyAccessor
    implements ValueAccessor {
        private Object object;
        private PropertyDescriptor[] fields;

        public PropertyAccessor(Object object) throws IntrospectionException {
            BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
            this.fields = beanInfo.getPropertyDescriptors();
            this.object = object;
        }

        public String getName(int i) {
            return this.fields[i].getName();
        }

        public Object getValue(int i) throws Exception {
            Method getter = this.fields[i].getReadMethod();
            if (getter != null) {
                return getter.invoke(this.object, new Object[0]);
            }
            return null;
        }

        public int size() {
            return this.fields.length;
        }
    }

    public static interface ValueAccessor {
        public int size();

        public String getName(int var1);

        public Object getValue(int var1) throws Exception;
    }
}

