/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.ReferenceConfigurationUtil;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.monitor.Monitor;

public class CompositeReferenceWireBuilderImpl
implements CompositeBuilder {
    private AssemblyFactory assemblyFactory;

    public CompositeReferenceWireBuilderImpl(AssemblyFactory assemblyFactory) {
        this.assemblyFactory = assemblyFactory;
    }

    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.ComponentReferenceWireBuilder";
    }

    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        for (Reference reference : composite.getReferences()) {
            CompositeReference compositeReference = (CompositeReference)reference;
            if (!compositeReference.isPromotionOverride()) continue;
            List<ComponentReference> promotedReferences = ReferenceConfigurationUtil.getPromotedComponentReferences(compositeReference);
            for (ComponentReference promotedReference : promotedReferences) {
                ReferenceConfigurationUtil.reconcileReferenceBindings(compositeReference, promotedReference, this.assemblyFactory, monitor);
                if (compositeReference.getInterfaceContract() == null || compositeReference.getInterfaceContract().getCallbackInterface() == null) continue;
                SCABinding scaCallbackBinding = (SCABinding)promotedReference.getCallbackBinding(SCABinding.class);
                if (promotedReference.getCallback() != null) {
                    promotedReference.getCallback().getBindings().clear();
                } else {
                    promotedReference.setCallback(this.assemblyFactory.createCallback());
                }
                if (scaCallbackBinding != null) {
                    promotedReference.getCallback().getBindings().add(scaCallbackBinding);
                }
                if (compositeReference.getCallback() == null) continue;
                promotedReference.getCallback().getBindings().addAll(compositeReference.getCallback().getBindings());
            }
        }
    }
}

