/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.BaseBuilderImpl;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositePromotionBuilderImpl
extends BaseBuilderImpl
implements CompositeBuilder {
    public CompositePromotionBuilderImpl(AssemblyFactory assemblyFactory, InterfaceContractMapper interfaceContractMapper) {
        super(assemblyFactory, null, null, null, interfaceContractMapper);
    }

    @Override
    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.CompositePromotionBuilder";
    }

    @Override
    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.connectCompositeReferencesAndServices(composite, monitor);
    }

    protected void connectCompositeReferencesAndServices(Composite composite, Monitor monitor) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.connectCompositeReferencesAndServices((Composite)implementation, monitor);
        }
        HashMap<String, Component> components = new HashMap<String, Component>();
        HashMap<String, ComponentService> componentServices = new HashMap<String, ComponentService>();
        HashMap<String, ComponentReference> componentReferences = new HashMap<String, ComponentReference>();
        this.indexComponentsServicesAndReferences(composite, components, componentServices, componentReferences);
        this.connectCompositeServices(composite, components, componentServices, monitor);
        this.connectCompositeReferences(composite, components, componentReferences, monitor);
    }

    private void connectCompositeServices(Composite composite, Map<String, Component> components, Map<String, ComponentService> componentServices, Monitor monitor) {
        for (Component component : composite.getComponents()) {
            if (!(component.getImplementation() instanceof Composite)) continue;
            for (ComponentService componentService : component.getServices()) {
                Service service = componentService.getService();
                if (service == null || componentService.getInterfaceContract() != null) continue;
                componentService.setInterfaceContract(service.getInterfaceContract());
            }
        }
        for (Service service : composite.getServices()) {
            CompositeService compositeService = (CompositeService)service;
            ComponentService componentService = compositeService.getPromotedService();
            if (componentService == null || !componentService.isUnresolved()) continue;
            String promotedComponentName = compositeService.getPromotedComponent().getName();
            String promotedServiceName = componentService.getName() != null ? String.valueOf(promotedComponentName) + '/' + componentService.getName() : promotedComponentName;
            ComponentService promotedService = componentServices.get(promotedServiceName);
            if (promotedService != null) {
                boolean isCompatible;
                Component promotedComponent = components.get(promotedComponentName);
                compositeService.setPromotedComponent(promotedComponent);
                compositeService.setPromotedService(promotedService);
                InterfaceContract compositeServiceInterfaceContract = compositeService.getInterfaceContract();
                InterfaceContract promotedServiceInterfaceContract = promotedService.getInterfaceContract();
                if (compositeServiceInterfaceContract == null) {
                    compositeService.setInterfaceContract(promotedServiceInterfaceContract);
                    continue;
                }
                if (promotedServiceInterfaceContract == null || (isCompatible = this.interfaceContractMapper.isCompatible(compositeServiceInterfaceContract, promotedServiceInterfaceContract))) continue;
                this.warning(monitor, "ServiceInterfaceNotSubSet", compositeService, promotedServiceName);
                continue;
            }
            this.warning(monitor, "PromotedServiceNotFound", composite, composite.getName().toString(), promotedServiceName);
        }
    }

    private void connectCompositeReferences(Composite composite, Map<String, Component> components, Map<String, ComponentReference> componentReferences, Monitor monitor) {
        for (Component component : composite.getComponents()) {
            if (!(component.getImplementation() instanceof Composite)) continue;
            for (ComponentReference componentReference : component.getReferences()) {
                Reference reference = componentReference.getReference();
                if (reference == null || componentReference.getInterfaceContract() != null) continue;
                componentReference.setInterfaceContract(reference.getInterfaceContract());
            }
        }
        for (Reference reference : composite.getReferences()) {
            CompositeReference compositeReference = (CompositeReference)reference;
            List<ComponentReference> promotedReferences = compositeReference.getPromotedReferences();
            int i = 0;
            int n = promotedReferences.size();
            while (i < n) {
                ComponentReference componentReference = promotedReferences.get(i);
                if (componentReference.isUnresolved()) {
                    String componentReferenceName = componentReference.getName();
                    if ((componentReference = componentReferences.get(componentReferenceName)) != null) {
                        boolean isCompatible;
                        Component promotedComponent = compositeReference.getPromotedComponents().get(i);
                        promotedComponent = components.get(promotedComponent.getName());
                        compositeReference.getPromotedComponents().set(i, promotedComponent);
                        promotedReferences.set(i, componentReference);
                        InterfaceContract compositeReferenceInterfaceContract = compositeReference.getInterfaceContract();
                        InterfaceContract componentReferenceInterfaceContract = componentReference.getInterfaceContract();
                        if (compositeReferenceInterfaceContract == null) {
                            compositeReference.setInterfaceContract(componentReferenceInterfaceContract);
                        } else if (componentReferenceInterfaceContract != null && !(isCompatible = this.interfaceContractMapper.isCompatible(compositeReferenceInterfaceContract, componentReferenceInterfaceContract))) {
                            this.warning(monitor, "ReferenceInterfaceNotSubSet", compositeReference, componentReferenceName);
                        }
                    } else {
                        this.warning(monitor, "PromotedReferenceNotFound", composite, composite.getName().toString(), componentReferenceName);
                    }
                }
                ++i;
            }
        }
    }
}

