/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.HashSet;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Endpoint2;
import org.apache.tuscany.sca.assembly.EndpointReference2;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.BaseBuilderImpl;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;

public class CompositePolicyBuilderImpl
extends BaseBuilderImpl
implements CompositeBuilder {
    public CompositePolicyBuilderImpl(AssemblyFactory assemblyFactory, InterfaceContractMapper interfaceContractMapper) {
        super(assemblyFactory, null, null, null, interfaceContractMapper);
    }

    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.CompositePolicyBuilder";
    }

    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.computePolicies(composite, definitions, monitor);
    }

    private void inherit(PolicySubject policySubject, Object ... models) {
        Object[] objectArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            Object model = objectArray[n2];
            if (model instanceof PolicySubject) {
                PolicySubject subject = (PolicySubject)model;
                policySubject.getRequiredIntents().addAll(subject.getRequiredIntents());
                policySubject.getPolicySets().addAll(subject.getPolicySets());
            }
            ++n2;
        }
    }

    private boolean isMutualExclusive(PolicySubject subject1, PolicySubject subject2) {
        if (subject1 == subject2 || subject1 == null || subject2 == null) {
            return false;
        }
        for (Intent i1 : subject1.getRequiredIntents()) {
            for (Intent i2 : subject1.getRequiredIntents()) {
                if (!i1.getExcludedIntents().contains(i2) && !i2.getExcludedIntents().contains(i1)) continue;
                return true;
            }
        }
        return false;
    }

    private void inheritFromService(PolicySubject subject, Composite composite, Component component, Service service) {
        if (service == null) {
            return;
        }
        if (service instanceof ComponentService) {
            if (component.getImplementation() instanceof Composite) {
                composite = (Composite)component.getImplementation();
            }
            this.inheritFromService(subject, composite, component, ((ComponentService)service).getService());
            this.inherit(subject, composite, component);
        } else if (service instanceof CompositeService) {
            CompositeService compositeService = (CompositeService)service;
            this.inheritFromService(subject, composite, compositeService.getPromotedComponent(), compositeService.getPromotedService());
        }
        this.inherit(subject, component.getImplementation(), service);
    }

    private void inheritFromReference(PolicySubject subject, Composite composite, Component component, Reference reference) {
        if (reference == null) {
            return;
        }
        if (reference instanceof ComponentReference) {
            if (component.getImplementation() instanceof Composite) {
                composite = (Composite)component.getImplementation();
            }
            this.inheritFromReference(subject, composite, component, ((ComponentReference)reference).getReference());
        } else if (reference instanceof CompositeReference) {
            CompositeReference compositeReference = (CompositeReference)reference;
            int i = 0;
            int n = compositeReference.getPromotedReferences().size();
            while (i < n) {
                this.inheritFromReference(subject, composite, compositeReference.getPromotedComponents().get(i), compositeReference.getPromotedReferences().get(i));
                ++i;
            }
        }
        this.inherit(subject, component.getImplementation(), reference);
    }

    private boolean isEqual(String name1, String name2) {
        if (name1 == name2) {
            return true;
        }
        if (name1 != null) {
            return name1.equals(name2);
        }
        return name2.equals(name1);
    }

    private void resolveAndNormalize(PolicySubject subject, Definitions definitions, Monitor monitor) {
        HashSet copy;
        HashSet<Intent> intents = new HashSet<Intent>();
        if (definitions != null) {
            for (Intent i : subject.getRequiredIntents()) {
                int index = definitions.getIntents().indexOf(i);
                if (index != -1) {
                    intents.add((Intent)definitions.getIntents().get(index));
                    continue;
                }
                this.warning(monitor, "intent-not-found", subject, i.getName().toString());
            }
        }
        boolean profileIntentsFound = false;
        do {
            copy = new HashSet(intents);
            for (Intent i : copy) {
                if (i.getRequiredIntents().isEmpty()) continue;
                intents.remove(i);
                intents.addAll(i.getRequiredIntents());
                profileIntentsFound = true;
            }
        } while (profileIntentsFound);
        copy = new HashSet(intents);
        for (Intent i : copy) {
            if (i.getQualifiableIntent() == null) continue;
            intents.remove(i.getQualifiableIntent());
        }
        copy = new HashSet(intents);
        for (Intent i : copy) {
            if (i.getDefaultQualifiedIntent() == null) continue;
            intents.remove(i);
            intents.add(i.getDefaultQualifiedIntent());
        }
        subject.getRequiredIntents().clear();
        subject.getRequiredIntents().addAll(intents);
        HashSet<PolicySet> policySets = new HashSet<PolicySet>();
        if (definitions != null) {
            for (PolicySet policySet : subject.getPolicySets()) {
                int index = definitions.getPolicySets().indexOf(policySet);
                if (index == -1) continue;
                policySets.add((PolicySet)definitions.getPolicySets().get(index));
            }
        }
        for (PolicySet policySet : policySets) {
            policySet.getProvidedIntents();
        }
    }

    protected void computePolicies(Composite composite, Definitions definitions, Monitor monitor) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.computePolicies((Composite)implementation, definitions, monitor);
        }
        for (Component component : composite.getComponents()) {
            this.isMutualExclusive(component, component.getImplementation());
            for (ComponentService componentService : component.getServices()) {
                this.isMutualExclusive(componentService, componentService.getService());
                if (componentService.getInterfaceContract() != null) {
                    this.isMutualExclusive((PolicySubject)componentService.getInterfaceContract().getInterface(), (PolicySubject)componentService.getService().getInterfaceContract().getInterface());
                    this.isMutualExclusive((PolicySubject)componentService.getInterfaceContract().getCallbackInterface(), (PolicySubject)componentService.getService().getInterfaceContract().getCallbackInterface());
                }
                for (Endpoint2 ep : componentService.getEndpoints()) {
                    if (componentService.getService() != null && componentService.getService().getInterfaceContract() != null) {
                        this.inherit(ep, componentService.getService().getInterfaceContract().getInterface());
                    }
                    if (componentService.getInterfaceContract() != null) {
                        this.inherit(ep, componentService.getInterfaceContract().getInterface());
                    }
                    this.inheritFromService(ep, composite, component, componentService.getService());
                    if (componentService.getService() != null) {
                        for (Binding binding : componentService.getService().getBindings()) {
                            if (!this.isEqual(ep.getBinding().getName(), binding.getName()) || !(binding instanceof PolicySubject)) continue;
                            this.isMutualExclusive((PolicySubject)ep.getBinding(), (PolicySubject)binding);
                            this.inherit(ep, binding);
                            break;
                        }
                    }
                    this.inheritFromService(ep, composite, ep.getComponent(), ep.getService());
                    this.inherit(ep, ep.getBinding());
                    this.resolveAndNormalize(ep, definitions, monitor);
                }
            }
            for (ComponentReference componentReference : component.getReferences()) {
                this.isMutualExclusive(componentReference, componentReference.getReference());
                if (componentReference.getInterfaceContract() != null) {
                    this.isMutualExclusive((PolicySubject)componentReference.getInterfaceContract().getInterface(), (PolicySubject)componentReference.getReference().getInterfaceContract().getInterface());
                    this.isMutualExclusive((PolicySubject)componentReference.getInterfaceContract().getCallbackInterface(), (PolicySubject)componentReference.getReference().getInterfaceContract().getCallbackInterface());
                }
                for (EndpointReference2 epr : componentReference.getEndpointReferences()) {
                    if (componentReference.getReference() != null && componentReference.getReference().getInterfaceContract() != null) {
                        this.inherit(epr, componentReference.getReference().getInterfaceContract().getInterface());
                    }
                    if (componentReference.getInterfaceContract() != null) {
                        this.inherit(epr, componentReference.getInterfaceContract().getInterface());
                    }
                    this.inheritFromReference(epr, composite, component, componentReference.getReference());
                    if (componentReference.getReference() != null) {
                        for (Binding binding : componentReference.getReference().getBindings()) {
                            if (epr.getBinding() == null || !this.isEqual(epr.getBinding().getName(), binding.getName()) || !(binding instanceof PolicySubject)) continue;
                            this.isMutualExclusive((PolicySubject)epr.getBinding(), (PolicySubject)binding);
                            this.inherit(epr, binding);
                            break;
                        }
                    }
                    this.inheritFromReference(epr, composite, epr.getComponent(), epr.getReference());
                    this.inherit(epr, epr.getBinding());
                    this.resolveAndNormalize(epr, definitions, monitor);
                }
            }
            component.getImplementation();
        }
    }
}

