/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeIncludeBuilderImpl
implements CompositeBuilder {
    public CompositeIncludeBuilderImpl(FactoryExtensionPoint factories, InterfaceContractMapper mapper) {
    }

    public CompositeIncludeBuilderImpl() {
    }

    @Override
    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.CompositeIncludeBuilder";
    }

    @Override
    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.fuseIncludes(composite, monitor);
    }

    private void warning(Monitor monitor, String message, Object model, String ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "assembly-validation-messages", Problem.Severity.WARNING, model, message, (Object[])messageParameters);
            monitor.problem(problem);
        }
    }

    private void collectIncludes(Composite composite, List<Composite> includes, Set<Composite> visited, Monitor monitor) {
        for (Composite include : composite.getIncludes()) {
            if (visited.contains(include)) {
                this.warning(monitor, "CompositeAlreadyIncluded", composite, include.getName().toString());
                continue;
            }
            includes.add(include);
            visited.add(include);
            this.collectIncludes(include, includes, visited, monitor);
        }
    }

    private void fuseIncludes(Composite composite, Monitor monitor) {
        ArrayList<Composite> includes = new ArrayList<Composite>();
        HashSet<Composite> visited = new HashSet<Composite>();
        visited.add(composite);
        this.collectIncludes(composite, includes, visited, monitor);
        for (Composite include : includes) {
            Composite clone;
            try {
                clone = (Composite)include.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            composite.getComponents().addAll(clone.getComponents());
            composite.getServices().addAll(clone.getServices());
            composite.getReferences().addAll(clone.getReferences());
            composite.getProperties().addAll(clone.getProperties());
            composite.getWires().addAll(clone.getWires());
            composite.getPolicySets().addAll(clone.getPolicySets());
            composite.getRequiredIntents().addAll(clone.getRequiredIntents());
        }
        composite.getIncludes().clear();
    }
}

