/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.BaseBuilderImpl;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeBindingURIBuilderImpl
extends BaseBuilderImpl
implements CompositeBuilder {
    @Deprecated
    public CompositeBindingURIBuilderImpl(AssemblyFactory assemblyFactory, SCABindingFactory scaBindingFactory, InterfaceContractMapper interfaceContractMapper) {
        super(assemblyFactory, scaBindingFactory, null, null, interfaceContractMapper);
    }

    public CompositeBindingURIBuilderImpl(AssemblyFactory assemblyFactory, SCABindingFactory scaBindingFactory, DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory, InterfaceContractMapper interfaceContractMapper) {
        super(assemblyFactory, scaBindingFactory, documentBuilderFactory, transformerFactory, interfaceContractMapper);
    }

    @Override
    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.CompositeBindingURIBuilder";
    }

    @Override
    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.configureBindingURIsAndNames(composite, definitions, monitor);
    }

    protected void configureBindingURIsAndNames(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.configureBindingURIs(composite, null, definitions, null, monitor);
        this.configureBindingNames(composite, monitor);
    }

    protected void configureBindingURIs(Composite composite, Definitions definitions, List<Binding> defaultBindings, Monitor monitor) throws CompositeBuilderException {
        this.configureBindingURIs(composite, null, definitions, defaultBindings, monitor);
    }

    private void configureBindingURIs(Composite composite, String uri, Definitions definitions, List<Binding> defaultBindings, Monitor monitor) throws CompositeBuilderException {
        String parentComponentURI = uri;
        for (Component component : composite.getComponents()) {
            String componentURI = parentComponentURI == null ? component.getName() : URI.create(String.valueOf(parentComponentURI) + '/').resolve(component.getName()).toString();
            component.setURI(componentURI);
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.configureBindingURIs((Composite)implementation, componentURI, definitions, defaultBindings, monitor);
        }
        List<Service> compositeServices = composite.getServices();
        for (Service service : compositeServices) {
            if (service.getBindings().isEmpty()) {
                SCABinding scaBinding = this.createSCABinding(definitions);
                service.getBindings().add(scaBinding);
            }
            for (Binding binding : service.getBindings()) {
                this.constructBindingName(service, binding, monitor);
                this.constructBindingURI(parentComponentURI, composite, service, binding, defaultBindings, monitor);
            }
        }
        for (Component component : composite.getComponents()) {
            HashMap<String, Service> services = new HashMap<String, Service>();
            HashMap<String, Reference> references = new HashMap<String, Reference>();
            HashMap<String, Property> properties = new HashMap<String, Property>();
            this.indexImplementationPropertiesServicesAndReferences(component, services, references, properties, monitor);
            HashMap<String, ComponentService> componentServices = new HashMap<String, ComponentService>();
            HashMap<String, ComponentReference> componentReferences = new HashMap<String, ComponentReference>();
            HashMap<String, ComponentProperty> componentProperties = new HashMap<String, ComponentProperty>();
            this.indexComponentPropertiesServicesAndReferences(component, componentServices, componentReferences, componentProperties, monitor);
            this.reconcileServices(component, services, componentServices, monitor);
            this.reconcileReferences(component, references, componentReferences, monitor);
            this.reconcileProperties(component, properties, componentProperties, monitor);
            for (ComponentService service : component.getServices()) {
                if (service.getBindings().isEmpty()) {
                    SCABinding scaBinding = this.createSCABinding(definitions);
                    service.getBindings().add(scaBinding);
                }
                for (Binding binding : service.getBindings()) {
                    this.constructBindingName(service, binding, monitor);
                    this.constructBindingURI(component, service, binding, defaultBindings, monitor);
                }
            }
        }
    }

    private void configureBindingNames(Composite composite, Monitor monitor) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.configureBindingNames((Composite)implementation, monitor);
        }
        for (Service service : composite.getServices()) {
            if (service.getCallback() == null) continue;
            for (Binding binding : service.getCallback().getBindings()) {
                this.constructBindingName(service, binding, monitor);
            }
        }
        for (Reference reference : composite.getReferences()) {
            for (Binding binding : reference.getBindings()) {
                this.constructBindingName(reference, binding, monitor);
            }
            if (reference.getCallback() == null) continue;
            for (Binding binding : reference.getCallback().getBindings()) {
                this.constructBindingName(reference, binding, monitor);
            }
        }
        for (Component component : composite.getComponents()) {
            for (ComponentService service : component.getServices()) {
                if (service.getCallback() == null) continue;
                for (Binding binding : service.getCallback().getBindings()) {
                    this.constructBindingName(service, binding, monitor);
                }
            }
            for (ComponentReference reference : component.getReferences()) {
                for (Binding binding : reference.getBindings()) {
                    this.constructBindingName(reference, binding, monitor);
                }
                if (reference.getCallback() == null) continue;
                for (Binding binding : reference.getCallback().getBindings()) {
                    this.constructBindingName(reference, binding, monitor);
                }
            }
        }
    }

    private void constructBindingName(Contract contract, Binding binding, Monitor monitor) {
        if (binding.getName() == null) {
            binding.setName(contract.getName());
        }
        for (Binding otherBinding : contract.getBindings()) {
            if (otherBinding == binding || binding.getClass() != otherBinding.getClass() || !binding.getName().equals(otherBinding.getName())) continue;
            this.warning(monitor, contract instanceof Service ? "MultipleBindingsForService" : "MultipleBindingsForReference", binding, contract.getName(), binding.getName());
        }
    }

    private void constructBindingURI(String parentComponentURI, Composite composite, Service service, Binding binding, List<Binding> defaultBindings, Monitor monitor) throws CompositeBuilderException {
        boolean includeBindingName = composite.getServices().size() != 1;
        this.constructBindingURI(parentComponentURI, service, binding, includeBindingName, defaultBindings, monitor);
    }

    private void constructBindingURI(Component component, Service service, Binding binding, List<Binding> defaultBindings, Monitor monitor) throws CompositeBuilderException {
        boolean includeBindingName = component.getServices().size() != 1;
        this.constructBindingURI(component.getURI(), service, binding, includeBindingName, defaultBindings, monitor);
    }

    private void constructBindingURI(String componentURIString, Service service, Binding binding, boolean includeBindingName, List<Binding> defaultBindings, Monitor monitor) throws CompositeBuilderException {
        try {
            URI bindingURI;
            if (binding.getURI() != null) {
                bindingURI = new URI(binding.getURI());
                if (bindingURI.isAbsolute()) {
                    binding.setURI(bindingURI.toString());
                    return;
                }
            } else {
                bindingURI = null;
            }
            URI bindingName = binding.getName() != null ? new URI(binding.getName()) : new URI("");
            URI componentURI = componentURIString != null ? new URI(CompositeBindingURIBuilderImpl.addSlashToPath(componentURIString)) : null;
            if (componentURI != null && componentURI.isAbsolute()) {
                binding.setURI(CompositeBindingURIBuilderImpl.constructBindingURI(null, componentURI, bindingURI, includeBindingName, bindingName));
                return;
            }
            URI baseURI = null;
            if (defaultBindings != null) {
                for (Binding defaultBinding : defaultBindings) {
                    if (binding.getClass() != defaultBinding.getClass()) continue;
                    baseURI = new URI(CompositeBindingURIBuilderImpl.addSlashToPath(defaultBinding.getURI()));
                    break;
                }
            }
            binding.setURI(CompositeBindingURIBuilderImpl.constructBindingURI(baseURI, componentURI, bindingURI, includeBindingName, bindingName));
        }
        catch (URISyntaxException uRISyntaxException) {
            this.error(monitor, "URLSyntaxException", (Object)binding, componentURIString, service.getName(), binding.getName());
        }
    }

    private static String addSlashToPath(String path) {
        if (path.endsWith("/") || path.endsWith("#")) {
            return path;
        }
        return String.valueOf(path) + "/";
    }

    private static String constructBindingURI(URI baseURI, URI componentURI, URI bindingURI, boolean includeBindingName, URI bindingName) {
        URI uri;
        String uriString = baseURI == null ? (componentURI == null ? (bindingURI != null ? bindingURI.toString() : bindingName.toString()) : (bindingURI != null ? componentURI.resolve(bindingURI).toString() : (includeBindingName ? componentURI.resolve(bindingName).toString() : componentURI.toString()))) : (componentURI == null ? (bindingURI != null ? CompositeBindingURIBuilderImpl.basedURI(baseURI, bindingURI).toString() : (includeBindingName ? CompositeBindingURIBuilderImpl.basedURI(baseURI, bindingName).toString() : baseURI.toString())) : (bindingURI != null ? CompositeBindingURIBuilderImpl.basedURI(baseURI, componentURI.resolve(bindingURI)).toString() : (includeBindingName ? CompositeBindingURIBuilderImpl.basedURI(baseURI, componentURI.resolve(bindingName)).toString() : CompositeBindingURIBuilderImpl.basedURI(baseURI, componentURI).toString())));
        if (uriString.endsWith("/")) {
            uriString = uriString.substring(0, uriString.length() - 1);
        }
        if (!(uri = URI.create(uriString)).isAbsolute()) {
            uri = URI.create("/").resolve(uri);
        }
        return uri.toString();
    }

    private static URI basedURI(URI baseURI, URI uri) {
        if (uri.getScheme() != null) {
            return uri;
        }
        String str = uri.toString();
        if (str.startsWith("/")) {
            str = str.substring(1);
        }
        return URI.create(String.valueOf(baseURI.toString()) + str).normalize();
    }
}

