/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Endpoint2;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.ServiceConfigurationUtil;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.monitor.Monitor;

public class ComponentServiceEndpointBuilderImpl
implements CompositeBuilder {
    private AssemblyFactory assemblyFactory;

    public ComponentServiceEndpointBuilderImpl(AssemblyFactory assemblyFactory) {
        this.assemblyFactory = assemblyFactory;
    }

    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.ComponentReferenceEndpointReferenceBuilder";
    }

    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.processComponentServices(composite);
    }

    private void processCompositeServices(Composite composite) {
        for (Service service : composite.getServices()) {
            Component promotedComponent = ((CompositeService)service).getPromotedComponent();
            ComponentService promotedService = ((CompositeService)service).getPromotedService();
            if (promotedService == null) continue;
            for (Binding binding : service.getBindings()) {
                Endpoint2 endpoint = this.assemblyFactory.createEndpoint();
                endpoint.setComponent(promotedComponent);
                endpoint.setService(promotedService);
                endpoint.setBinding(binding);
                endpoint.setUnresolved(false);
                promotedService.getEndpoints().add(endpoint);
            }
        }
    }

    private void processComponentServices(Composite composite) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (implementation instanceof Composite) {
                this.processComponentServices((Composite)implementation);
            }
            for (ComponentService service : component.getServices()) {
                Component endpointComponent = component;
                ComponentService endpointService = service;
                if (service.getService() instanceof CompositeService) {
                    CompositeService compositeService = (CompositeService)service.getService();
                    endpointService = ServiceConfigurationUtil.getPromotedComponentService(compositeService);
                    endpointComponent = ServiceConfigurationUtil.getPromotedComponent(compositeService);
                }
                for (Binding binding : service.getBindings()) {
                    Endpoint2 endpoint = this.assemblyFactory.createEndpoint();
                    endpoint.setComponent(endpointComponent);
                    endpoint.setService(endpointService);
                    endpoint.setBinding(binding);
                    endpoint.setUnresolved(false);
                    service.getEndpoints().add(endpoint);
                }
            }
        }
    }
}

