/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Wire;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.BaseBuilderImpl;
import org.apache.tuscany.sca.assembly.builder.impl.ReferenceConfigurationUtil;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentReferenceWireBuilderImpl
extends BaseBuilderImpl
implements CompositeBuilder {
    public ComponentReferenceWireBuilderImpl(AssemblyFactory assemblyFactory, InterfaceContractMapper interfaceContractMapper) {
        super(assemblyFactory, null, null, null, interfaceContractMapper);
    }

    @Override
    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.ComponentReferenceWireBuilder";
    }

    @Override
    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.wireComponentReferences(composite, monitor);
    }

    protected void wireComponentReferences(Composite composite, Monitor monitor) {
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.wireComponentReferences((Composite)implementation, monitor);
        }
        HashMap<String, Component> components = new HashMap<String, Component>();
        HashMap<String, ComponentService> componentServices = new HashMap<String, ComponentService>();
        HashMap<String, ComponentReference> componentReferences = new HashMap<String, ComponentReference>();
        this.indexComponentsServicesAndReferences(composite, components, componentServices, componentReferences);
        this.connectWires(composite, componentServices, componentReferences, monitor);
        for (ComponentReference componentReference : componentReferences.values()) {
            if (ReferenceConfigurationUtil.validateMultiplicityAndTargets(componentReference.getMultiplicity(), componentReference.getTargets(), componentReference.getBindings())) continue;
            if (componentReference.getTargets().isEmpty()) {
                boolean promoted = false;
                for (Reference reference : composite.getReferences()) {
                    CompositeReference compositeReference = (CompositeReference)reference;
                    if (!compositeReference.getPromotedReferences().contains(componentReference)) continue;
                    promoted = true;
                    break;
                }
                if (promoted || componentReference.isCallback()) continue;
                this.warning(monitor, "ReferenceWithoutTargets", composite, composite.getName().toString(), componentReference.getName());
                continue;
            }
            this.warning(monitor, "TooManyReferenceTargets", composite, componentReference.getName());
        }
    }

    private void connectWires(Composite composite, Map<String, ComponentService> componentServices, Map<String, ComponentReference> componentReferences, Monitor monitor) {
        List<Wire> wires = composite.getWires();
        int i = 0;
        int n = wires.size();
        while (i < n) {
            ComponentService resolvedService;
            ComponentReference resolvedReference;
            Wire wire = wires.get(i);
            ComponentReference source = wire.getSource();
            if (source != null && source.isUnresolved()) {
                resolvedReference = componentReferences.get(source.getName());
                if (resolvedReference != null) {
                    wire.setSource(resolvedReference);
                } else {
                    this.warning(monitor, "WireSourceNotFound", composite, source.getName());
                }
            } else {
                resolvedReference = wire.getSource();
            }
            ComponentService target = wire.getTarget();
            if (target != null && target.isUnresolved()) {
                resolvedService = componentServices.get(target.getName());
                if (resolvedService != null) {
                    wire.setTarget(target);
                } else {
                    this.warning(monitor, "WireTargetNotFound", composite, source.getName());
                }
            } else {
                resolvedService = wire.getTarget();
            }
            if (resolvedReference != null && resolvedService != null) {
                if (resolvedReference.getInterfaceContract() == null || this.interfaceContractMapper.isCompatible(resolvedReference.getInterfaceContract(), resolvedService.getInterfaceContract())) {
                    resolvedReference.getTargets().add(wire.getTarget());
                } else {
                    this.warning(monitor, "WireIncompatibleInterface", composite, source.getName(), target.getName());
                }
            }
            ++i;
        }
        composite.getWires().clear();
    }
}

