/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.ReferenceConfigurationUtil;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.monitor.Monitor;

public class ComponentReferencePromotionBuilderImpl
implements CompositeBuilder {
    private AssemblyFactory assemblyFactory;

    public ComponentReferencePromotionBuilderImpl(AssemblyFactory assemblyFactory) {
        this.assemblyFactory = assemblyFactory;
    }

    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.configureNestedCompositeReferences(composite, monitor);
    }

    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.ComponentReferencePromotionBuilder";
    }

    private void configureNestedCompositeReferences(Composite composite, Monitor monitor) {
        Implementation implementation;
        for (Component component : composite.getComponents()) {
            implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.configureNestedCompositeReferences((Composite)implementation, monitor);
        }
        for (Component component : composite.getComponents()) {
            implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            for (ComponentReference componentReference : component.getReferences()) {
                Reference implReference = componentReference.getReference();
                if (implReference == null || !(implReference instanceof CompositeReference)) continue;
                if (!componentReference.getEndpointReferences().isEmpty()) {
                    componentReference.setPromotionOverride(true);
                }
                if (!componentReference.isPromotionOverride()) continue;
                CompositeReference compositeReference = (CompositeReference)implReference;
                List<ComponentReference> promotedReferences = ReferenceConfigurationUtil.getPromotedComponentReferences(compositeReference);
                for (ComponentReference promotedReference : promotedReferences) {
                    ReferenceConfigurationUtil.reconcileReferenceBindings(componentReference, promotedReference, this.assemblyFactory, monitor);
                    if (componentReference.getInterfaceContract() == null || componentReference.getInterfaceContract().getCallbackInterface() == null) continue;
                    SCABinding scaCallbackBinding = (SCABinding)promotedReference.getCallbackBinding(SCABinding.class);
                    if (promotedReference.getCallback() != null) {
                        promotedReference.getCallback().getBindings().clear();
                    } else {
                        promotedReference.setCallback(this.assemblyFactory.createCallback());
                    }
                    if (scaCallbackBinding != null) {
                        promotedReference.getCallback().getBindings().add(scaCallbackBinding);
                    }
                    if (componentReference.getCallback() == null) continue;
                    promotedReference.getCallback().getBindings().addAll(componentReference.getCallback().getBindings());
                }
            }
        }
    }
}

