/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint2;
import org.apache.tuscany.sca.assembly.EndpointReference2;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.BaseBuilderImpl;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentReferenceEndpointReferenceBuilderImpl
extends BaseBuilderImpl
implements CompositeBuilder {
    public ComponentReferenceEndpointReferenceBuilderImpl(AssemblyFactory assemblyFactory, InterfaceContractMapper interfaceContractMapper) {
        super(assemblyFactory, null, null, null, interfaceContractMapper);
    }

    @Override
    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.ComponentReferenceEndpointReferenceBuilder";
    }

    @Override
    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.processComponentReferences(composite, monitor);
    }

    private void processCompositeReferences(Composite composite) {
    }

    private void processComponentReferences(Composite composite, Monitor monitor) {
        HashMap<String, Component> components = new HashMap<String, Component>();
        this.indexComponents(composite, components);
        HashMap<String, ComponentService> componentServices = new HashMap<String, ComponentService>();
        this.indexServices(composite, componentServices);
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (implementation instanceof Composite) {
                this.processComponentReferences((Composite)implementation, monitor);
            }
            block1: for (ComponentReference reference : component.getReferences()) {
                this.createReferenceEndpointReferences(composite, component, reference, components, componentServices, monitor);
                for (ComponentService service : component.getServices()) {
                    if (service.getInterfaceContract() == null || service.getInterfaceContract().getCallbackInterface() == null || !reference.getName().equals(service.getName())) continue;
                    for (Endpoint2 endpoint : service.getEndpoints()) {
                        endpoint.getCallbackEndpointReferences().addAll(reference.getEndpointReferences());
                    }
                    continue block1;
                }
            }
        }
    }

    private void createReferenceEndpointReferences(Composite composite, Component component, ComponentReference reference, Map<String, Component> components, Map<String, ComponentService> componentServices, Monitor monitor) {
        Component targetComponent;
        String targetName;
        Endpoint2 endpoint;
        EndpointReference2 endpointRef;
        if (reference.getAutowire() == Boolean.TRUE && reference.getTargets().isEmpty()) {
            Multiplicity multiplicity = reference.getMultiplicity();
            block0: for (Component targetComponent2 : composite.getComponents()) {
                boolean skipSelf = false;
                for (ComponentReference targetComponentReference : targetComponent2.getReferences()) {
                    if (reference != targetComponentReference) continue;
                    skipSelf = true;
                }
                if (skipSelf) continue;
                for (ComponentService targetComponentService : targetComponent2.getServices()) {
                    if (reference.getInterfaceContract() != null && !this.interfaceContractMapper.isCompatible(reference.getInterfaceContract(), targetComponentService.getInterfaceContract())) continue;
                    endpointRef = this.assemblyFactory.createEndpointReference();
                    endpointRef.setComponent(component);
                    endpointRef.setReference(reference);
                    endpointRef.setUnresolved(false);
                    endpoint = this.assemblyFactory.createEndpoint();
                    endpoint.setComponent(targetComponent2);
                    endpoint.setService(targetComponentService);
                    endpoint.setUnresolved(true);
                    endpointRef.setTargetEndpoint(endpoint);
                    reference.getEndpointReferences().add(endpointRef);
                    if (multiplicity == Multiplicity.ZERO_ONE || multiplicity == Multiplicity.ONE_ONE) continue block0;
                }
            }
            if ((multiplicity == Multiplicity.ONE_N || multiplicity == Multiplicity.ONE_ONE) && reference.getEndpointReferences().size() == 0) {
                this.warning(monitor, "NoComponentReferenceTarget", reference, reference.getName());
            }
        } else if (!reference.getTargets().isEmpty()) {
            if (reference.getBindings().size() > 0) {
                this.warning(monitor, "ReferenceEndPointMixWithTarget", composite, reference.getName());
            }
            for (ComponentService target : reference.getTargets()) {
                targetName = target.getName();
                ComponentService targetComponentService = componentServices.get(targetName);
                int s = targetName.indexOf(47);
                targetComponent = s == -1 ? components.get(targetName) : components.get(targetName.substring(0, s));
                if (targetComponentService != null) {
                    if (reference.getInterfaceContract() == null || this.interfaceContractMapper.isCompatible(reference.getInterfaceContract(), targetComponentService.getInterfaceContract())) {
                        endpointRef = this.assemblyFactory.createEndpointReference();
                        endpointRef.setComponent(component);
                        endpointRef.setReference(reference);
                        endpointRef.setUnresolved(false);
                        endpoint = this.assemblyFactory.createEndpoint();
                        endpoint.setComponent(targetComponent);
                        endpoint.setService(targetComponentService);
                        endpoint.setUnresolved(true);
                        endpointRef.setTargetEndpoint(endpoint);
                        reference.getEndpointReferences().add(endpointRef);
                        continue;
                    }
                    this.warning(monitor, "ReferenceIncompatibleInterface", composite, composite.getName().toString(), reference.getName(), targetName);
                    continue;
                }
                endpointRef = this.assemblyFactory.createEndpointReference();
                endpointRef.setComponent(component);
                endpointRef.setReference(reference);
                endpointRef.setUnresolved(true);
                endpoint = this.assemblyFactory.createEndpoint();
                endpoint.setUnresolved(true);
                endpointRef.setTargetEndpoint(endpoint);
                this.warning(monitor, "ComponentReferenceTargetNotFound", composite, composite.getName().toString(), targetName);
            }
        } else if (reference.getReference() != null && !reference.getReference().getTargets().isEmpty()) {
            for (ComponentService target : reference.getReference().getTargets()) {
                targetName = target.getName();
                ComponentService targetComponentService = componentServices.get(targetName);
                int s = targetName.indexOf(47);
                targetComponent = s == -1 ? components.get(targetName) : components.get(targetName.substring(0, s));
                if (targetComponentService != null) {
                    if (reference.getInterfaceContract() == null || this.interfaceContractMapper.isCompatible(reference.getInterfaceContract(), targetComponentService.getInterfaceContract())) {
                        endpointRef = this.assemblyFactory.createEndpointReference();
                        endpointRef.setComponent(component);
                        endpointRef.setReference(reference);
                        endpointRef.setUnresolved(false);
                        endpoint = this.assemblyFactory.createEndpoint();
                        endpoint.setComponent(targetComponent);
                        endpoint.setService(targetComponentService);
                        endpoint.setUnresolved(true);
                        endpointRef.setTargetEndpoint(endpoint);
                        reference.getEndpointReferences().add(endpointRef);
                        continue;
                    }
                    this.warning(monitor, "ReferenceIncompatibleInterface", composite, composite.getName().toString(), reference.getName(), targetName);
                    continue;
                }
                endpointRef = this.assemblyFactory.createEndpointReference();
                endpointRef.setComponent(component);
                endpointRef.setReference(reference);
                endpointRef.setUnresolved(true);
                endpoint = this.assemblyFactory.createEndpoint();
                endpoint.setUnresolved(true);
                endpointRef.setTargetEndpoint(endpoint);
                this.warning(monitor, "ComponentReferenceTargetNotFound", composite, composite.getName().toString(), targetName);
            }
        }
        if (reference.getEndpointReferences().isEmpty()) {
            for (Binding binding : reference.getBindings()) {
                ComponentService targetComponentService;
                String uri = binding.getURI();
                if (uri == null) {
                    EndpointReference2 endpointRef2 = this.assemblyFactory.createEndpointReference();
                    endpointRef2.setComponent(component);
                    endpointRef2.setReference(reference);
                    endpointRef2.setBinding(binding);
                    endpointRef2.setTargetEndpoint(null);
                    endpointRef2.setUnresolved(false);
                    Endpoint2 endpoint2 = this.assemblyFactory.createEndpoint();
                    endpoint2.setUnresolved(false);
                    endpointRef2.setTargetEndpoint(endpoint2);
                    reference.getEndpointReferences().add(endpointRef2);
                    continue;
                }
                Component targetComponent3 = null;
                targetComponentService = null;
                if (uri.startsWith("/")) {
                    uri = uri.substring(1);
                }
                targetComponentService = componentServices.get(uri);
                int s = uri.indexOf(47);
                targetComponent3 = s == -1 ? components.get(uri) : components.get(uri.substring(0, s));
                if (targetComponentService != null) {
                    if (reference.getInterfaceContract() == null || this.interfaceContractMapper.isCompatible(reference.getInterfaceContract(), targetComponentService.getInterfaceContract())) {
                        endpointRef = this.assemblyFactory.createEndpointReference();
                        endpointRef.setComponent(component);
                        endpointRef.setReference(reference);
                        endpointRef.setBinding(binding);
                        endpointRef.setUnresolved(false);
                        endpoint = this.assemblyFactory.createEndpoint();
                        endpoint.setComponent(targetComponent3);
                        endpoint.setService(targetComponentService);
                        endpoint.setUnresolved(true);
                        endpointRef.setTargetEndpoint(endpoint);
                        reference.getEndpointReferences().add(endpointRef);
                        continue;
                    }
                    this.warning(monitor, "ReferenceIncompatibleInterface", composite, composite.getName().toString(), reference.getName(), uri);
                    continue;
                }
                endpointRef = this.assemblyFactory.createEndpointReference();
                endpointRef.setComponent(component);
                endpointRef.setReference(reference);
                endpointRef.setBinding(binding);
                endpointRef.setTargetEndpoint(null);
                endpointRef.setUnresolved(false);
                endpoint = this.assemblyFactory.createEndpoint();
                endpoint.setUnresolved(false);
                endpointRef.setTargetEndpoint(endpoint);
                reference.getEndpointReferences().add(endpointRef);
            }
        }
    }
}

