/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerFactory;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.ComponentPreProcessor;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.assembly.builder.impl.BaseBuilderImpl;
import org.apache.tuscany.sca.assembly.builder.impl.PropertyConfigurationUtil;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentConfigurationBuilderImpl
extends BaseBuilderImpl
implements CompositeBuilder {
    @Deprecated
    public ComponentConfigurationBuilderImpl(AssemblyFactory assemblyFactory, SCABindingFactory scaBindingFactory, InterfaceContractMapper interfaceContractMapper) {
        super(assemblyFactory, scaBindingFactory, null, null, interfaceContractMapper);
    }

    public ComponentConfigurationBuilderImpl(AssemblyFactory assemblyFactory, SCABindingFactory scaBindingFactory, DocumentBuilderFactory documentBuilderFactory, TransformerFactory transformerFactory, InterfaceContractMapper interfaceContractMapper) {
        super(assemblyFactory, scaBindingFactory, documentBuilderFactory, transformerFactory, interfaceContractMapper);
    }

    @Override
    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.ComponentConfigurationBuilder";
    }

    @Override
    public void build(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.configureComponents(composite, definitions, monitor);
    }

    protected void configureComponents(Composite composite, Definitions definitions, Monitor monitor) throws CompositeBuilderException {
        this.configureComponents(composite, null, definitions, monitor);
        this.configureSourcedProperties(composite, null);
    }

    private void configureComponents(Composite composite, String uri, Definitions definitions, Monitor monitor) {
        SCABinding scaBinding;
        String parentURI = uri;
        for (Component component : composite.getComponents()) {
            String componentURI = parentURI == null ? component.getName() : URI.create(String.valueOf(parentURI) + '/').resolve(component.getName()).toString();
            component.setURI(componentURI);
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.configureComponents((Composite)implementation, componentURI, definitions, monitor);
        }
        List<Service> compositeServices = composite.getServices();
        for (Service service : compositeServices) {
            if (!service.getBindings().isEmpty()) continue;
            scaBinding = this.createSCABinding(definitions);
            service.getBindings().add(scaBinding);
        }
        for (Reference reference : composite.getReferences()) {
            if (!reference.getBindings().isEmpty()) continue;
            scaBinding = this.createSCABinding(definitions);
            reference.getBindings().add(scaBinding);
        }
        HashMap<String, Component> components = new HashMap<String, Component>();
        for (Component component : composite.getComponents()) {
            SCABinding scaBinding2;
            if (components.containsKey(component.getName())) {
                this.error(monitor, "DuplicateComponentName", (Object)component, composite.getName().toString(), component.getName());
            } else {
                components.put(component.getName(), component);
            }
            if (component.getAutowire() == null) {
                component.setAutowire(composite.getAutowire());
            }
            if (component.getImplementation() instanceof ComponentPreProcessor) {
                ((ComponentPreProcessor)((Object)component.getImplementation())).preProcess(component);
            }
            HashMap<String, Service> services = new HashMap<String, Service>();
            HashMap<String, Reference> references = new HashMap<String, Reference>();
            HashMap<String, Property> properties = new HashMap<String, Property>();
            this.indexImplementationPropertiesServicesAndReferences(component, services, references, properties, monitor);
            HashMap<String, ComponentService> componentServices = new HashMap<String, ComponentService>();
            HashMap<String, ComponentReference> componentReferences = new HashMap<String, ComponentReference>();
            HashMap<String, ComponentProperty> componentProperties = new HashMap<String, ComponentProperty>();
            this.indexComponentPropertiesServicesAndReferences(component, componentServices, componentReferences, componentProperties, monitor);
            this.reconcileServices(component, services, componentServices, monitor);
            this.reconcileReferences(component, references, componentReferences, monitor);
            this.reconcileProperties(component, properties, componentProperties, monitor);
            this.configureCallbackServices(component, componentServices);
            this.configureCallbackReferences(component, componentReferences);
            for (ComponentService componentService : component.getServices()) {
                if (!componentService.getBindings().isEmpty()) continue;
                scaBinding2 = this.createSCABinding(definitions);
                componentService.getBindings().add(scaBinding2);
            }
            for (ComponentReference componentReference : component.getReferences()) {
                if (!componentReference.getBindings().isEmpty()) continue;
                scaBinding2 = this.createSCABinding(definitions);
                componentReference.getBindings().add(scaBinding2);
            }
        }
    }

    private void configureCallbackServices(Component component, Map<String, ComponentService> componentServices) {
        for (ComponentReference reference : component.getReferences()) {
            if (reference.getInterfaceContract() == null || reference.getInterfaceContract().getCallbackInterface() == null) continue;
            ComponentService service = componentServices.get(reference.getName());
            if (service == null) {
                service = this.createCallbackService(component, reference);
            }
            if (reference.getCallback() != null && service.getBindings().isEmpty()) {
                service.getBindings().addAll(reference.getCallback().getBindings());
            }
            reference.setCallbackService(service);
        }
    }

    private ComponentService createCallbackService(Component component, ComponentReference reference) {
        ComponentService componentService = this.assemblyFactory.createComponentService();
        componentService.setIsCallback(true);
        componentService.setName(reference.getName());
        try {
            InterfaceContract contract = (InterfaceContract)reference.getInterfaceContract().clone();
            contract.setInterface(contract.getCallbackInterface());
            contract.setCallbackInterface(null);
            componentService.setInterfaceContract(contract);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        Reference implReference = reference.getReference();
        if (implReference != null) {
            Service implService = this.assemblyFactory.createService();
            implService.setName(implReference.getName());
            try {
                InterfaceContract implContract = (InterfaceContract)implReference.getInterfaceContract().clone();
                implContract.setInterface(implContract.getCallbackInterface());
                implContract.setCallbackInterface(null);
                implService.setInterfaceContract(implContract);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            componentService.setService(implService);
        }
        component.getServices().add(componentService);
        return componentService;
    }

    private void configureCallbackReferences(Component component, Map<String, ComponentReference> componentReferences) {
        for (ComponentService service : component.getServices()) {
            if (service.getInterfaceContract() == null || service.getInterfaceContract().getCallbackInterface() == null) continue;
            ComponentReference reference = componentReferences.get(service.getName());
            if (reference == null) {
                reference = this.createCallbackReference(component, service);
            }
            if (service.getCallback() != null && reference.getBindings().isEmpty()) {
                reference.getBindings().addAll(service.getCallback().getBindings());
            }
            service.setCallbackReference(reference);
        }
    }

    private ComponentReference createCallbackReference(Component component, ComponentService service) {
        ComponentReference componentReference = this.assemblyFactory.createComponentReference();
        componentReference.setIsCallback(true);
        componentReference.setName(service.getName());
        try {
            InterfaceContract contract = (InterfaceContract)service.getInterfaceContract().clone();
            contract.setInterface(contract.getCallbackInterface());
            contract.setCallbackInterface(null);
            componentReference.setInterfaceContract(contract);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {}
        Service implService = service.getService();
        if (implService != null) {
            Reference implReference = this.assemblyFactory.createReference();
            implReference.setName(implService.getName());
            try {
                InterfaceContract implContract = (InterfaceContract)implService.getInterfaceContract().clone();
                implContract.setInterface(implContract.getCallbackInterface());
                implContract.setCallbackInterface(null);
                implReference.setInterfaceContract(implContract);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {}
            componentReference.setReference(implReference);
        }
        component.getReferences().add(componentReference);
        return componentReference;
    }

    private void configureSourcedProperties(Composite composite, List<ComponentProperty> propertySettings) {
        HashMap<String, Property> compositeProperties = new HashMap<String, Property>();
        ComponentProperty componentProperty = null;
        for (Property p : composite.getProperties()) {
            componentProperty = this.getComponentPropertyByName(p.getName(), propertySettings);
            if (componentProperty != null) {
                compositeProperties.put(p.getName(), componentProperty);
                continue;
            }
            compositeProperties.put(p.getName(), p);
        }
        for (Component component : composite.getComponents()) {
            try {
                PropertyConfigurationUtil.sourceComponentProperties(compositeProperties, component, this.documentBuilderFactory, this.transformerFactory);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Implementation impl = component.getImplementation();
            if (!(impl instanceof Composite)) continue;
            this.configureSourcedProperties((Composite)impl, component.getProperties());
        }
    }

    private ComponentProperty getComponentPropertyByName(String propertyName, List<ComponentProperty> properties) {
        if (properties != null) {
            for (ComponentProperty aProperty : properties) {
                if (!aProperty.getName().equals(propertyName)) continue;
                return aProperty;
            }
        }
        return null;
    }
}

