/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.AsynchronousServerSocketChannel;
import java.nio.channels.AsynchronousSocketChannel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.CompletionHandler;
import java.nio.channels.FileChannel;
import java.nio.channels.NetworkChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.buf.ByteBufferHolder;
import org.apache.tomcat.util.collections.SynchronizedStack;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AbstractJsseEndpoint;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SecureNio2Channel;
import org.apache.tomcat.util.net.SendfileDataBase;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketBufferHandler;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketProcessorBase;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.net.jsse.JSSESupport;

public class Nio2Endpoint
extends AbstractJsseEndpoint<Nio2Channel, AsynchronousSocketChannel> {
    private static final Log log = LogFactory.getLog(Nio2Endpoint.class);
    private AsynchronousServerSocketChannel serverSock = null;
    private static ThreadLocal<Boolean> inlineCompletion = new ThreadLocal();
    private AsynchronousChannelGroup threadGroup = null;
    private volatile boolean allClosed;
    private SynchronizedStack<Nio2Channel> nioChannels;

    public Nio2Endpoint() {
        this.setMaxConnections(-1);
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    public int getKeepAliveCount() {
        return -1;
    }

    @Override
    public void bind() throws Exception {
        if (this.getExecutor() == null) {
            this.createExecutor();
        }
        if (this.getExecutor() instanceof ExecutorService) {
            this.threadGroup = AsynchronousChannelGroup.withThreadPool((ExecutorService)this.getExecutor());
        }
        if (!this.internalExecutor) {
            log.warn(sm.getString("endpoint.nio2.exclusiveExecutor"));
        }
        this.serverSock = AsynchronousServerSocketChannel.open(this.threadGroup);
        this.socketProperties.setProperties(this.serverSock);
        InetSocketAddress addr = this.getAddress() != null ? new InetSocketAddress(this.getAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
        this.serverSock.bind(addr, this.getAcceptCount());
        if (this.acceptorThreadCount != 1) {
            this.acceptorThreadCount = 1;
        }
        this.initialiseSsl();
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.allClosed = false;
            this.running = true;
            this.paused = false;
            this.processorCache = new SynchronizedStack(128, this.socketProperties.getProcessorCache());
            this.nioChannels = new SynchronizedStack(128, this.socketProperties.getBufferPool());
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.startAcceptorThreads();
        }
    }

    @Override
    public void stopInternal() {
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (Nio2Channel channel : Nio2Endpoint.this.getHandler().getOpenSockets()) {
                            Nio2Endpoint.this.closeSocket(channel.getSocket());
                        }
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                    }
                    finally {
                        Nio2Endpoint.this.allClosed = true;
                    }
                }
            });
            this.nioChannels.clear();
            this.processorCache.clear();
        }
    }

    @Override
    public void unbind() throws Exception {
        if (this.running) {
            this.stop();
        }
        this.serverSock.close();
        this.serverSock = null;
        this.destroySsl();
        super.unbind();
        this.shutdownExecutor();
        if (this.getHandler() != null) {
            this.getHandler().recycle();
        }
    }

    @Override
    public void shutdownExecutor() {
        if (this.threadGroup != null && this.internalExecutor) {
            try {
                long timeout;
                for (timeout = this.getExecutorTerminationTimeoutMillis(); timeout > 0L && !this.allClosed; timeout -= 100L) {
                    Thread.sleep(100L);
                }
                this.threadGroup.shutdownNow();
                if (timeout > 0L) {
                    this.threadGroup.awaitTermination(timeout, TimeUnit.MILLISECONDS);
                }
            }
            catch (IOException e) {
                this.getLog().warn(sm.getString("endpoint.warn.executorShutdown", this.getName()), e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.threadGroup.isTerminated()) {
                this.getLog().warn(sm.getString("endpoint.warn.executorShutdown", this.getName()));
            }
            this.threadGroup = null;
        }
        super.shutdownExecutor();
    }

    @Override
    protected boolean setSocketOptions(AsynchronousSocketChannel socket) {
        try {
            this.socketProperties.setProperties(socket);
            Nio2Channel channel = this.nioChannels.pop();
            if (channel == null) {
                SocketBufferHandler bufhandler = new SocketBufferHandler(this.socketProperties.getAppReadBufSize(), this.socketProperties.getAppWriteBufSize(), this.socketProperties.getDirectBuffer());
                channel = this.isSSLEnabled() ? new SecureNio2Channel(bufhandler, this) : new Nio2Channel(bufhandler);
            }
            Nio2SocketWrapper socketWrapper = new Nio2SocketWrapper(channel, this);
            channel.reset(socket, socketWrapper);
            socketWrapper.setReadTimeout(this.getConnectionTimeout());
            socketWrapper.setWriteTimeout(this.getConnectionTimeout());
            socketWrapper.setKeepAliveLeft(this.getMaxKeepAliveRequests());
            socketWrapper.setSecure(this.isSSLEnabled());
            return this.processSocket(socketWrapper, SocketEvent.OPEN_READ, true);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            log.error("", t);
            return false;
        }
    }

    @Override
    protected void closeSocket(AsynchronousSocketChannel socket) {
        block2: {
            this.countDownConnection();
            try {
                socket.close();
            }
            catch (IOException ioe) {
                if (!log.isDebugEnabled()) break block2;
                log.debug(sm.getString("endpoint.err.close"), ioe);
            }
        }
    }

    @Override
    protected NetworkChannel getServerSocket() {
        return this.serverSock;
    }

    @Override
    protected AsynchronousSocketChannel serverSocketAccept() throws Exception {
        return this.serverSock.accept().get();
    }

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected SocketProcessorBase<Nio2Channel> createSocketProcessor(SocketWrapperBase<Nio2Channel> socketWrapper, SocketEvent event) {
        return new SocketProcessor(socketWrapper, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    private void closeSocket(SocketWrapperBase<Nio2Channel> socket) {
        block15: {
            block14: {
                block13: {
                    if (log.isDebugEnabled()) {
                        log.debug("Calling [" + this + "].closeSocket([" + socket + "],[" + socket.getSocket() + "])", new Exception());
                    }
                    if (socket == null) {
                        return;
                    }
                    try {
                        this.getHandler().release(socket);
                    }
                    catch (Throwable e) {
                        ExceptionUtils.handleThrowable(e);
                        if (!log.isDebugEnabled()) break block13;
                        log.error("", e);
                    }
                }
                try {
                    Nio2Channel e = socket.getSocket();
                    synchronized (e) {
                        if (socket.getSocket().isOpen()) {
                            this.countDownConnection();
                            socket.getSocket().close(true);
                        }
                    }
                }
                catch (Throwable e) {
                    ExceptionUtils.handleThrowable(e);
                    if (!log.isDebugEnabled()) break block14;
                    log.error("", e);
                }
            }
            try {
                Nio2SocketWrapper nio2Socket = (Nio2SocketWrapper)socket;
                if (nio2Socket.getSendfileData() != null && nio2Socket.getSendfileData().fchannel != null && nio2Socket.getSendfileData().fchannel.isOpen()) {
                    nio2Socket.getSendfileData().fchannel.close();
                }
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                if (!log.isDebugEnabled()) break block15;
                log.error("", e);
            }
        }
    }

    public static void startInline() {
        inlineCompletion.set(Boolean.TRUE);
    }

    public static void endInline() {
        inlineCompletion.set(Boolean.FALSE);
    }

    public static boolean isInline() {
        Boolean flag = inlineCompletion.get();
        if (flag == null) {
            return false;
        }
        return flag;
    }

    public static class SendfileData
    extends SendfileDataBase {
        private FileChannel fchannel;
        private boolean doneInline = false;
        private boolean error = false;

        public SendfileData(String filename, long pos, long length) {
            super(filename, pos, length);
        }
    }

    protected class SocketProcessor
    extends SocketProcessorBase<Nio2Channel> {
        public SocketProcessor(SocketWrapperBase<Nio2Channel> socketWrapper, SocketEvent event) {
            super(socketWrapper, event);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRun() {
            if (SocketEvent.OPEN_WRITE != this.event) {
                ((Nio2SocketWrapper)this.socketWrapper).releaseReadPending();
            }
            boolean launch = false;
            try {
                int handshake;
                block33: {
                    handshake = -1;
                    try {
                        if (((Nio2Channel)this.socketWrapper.getSocket()).isHandshakeComplete()) {
                            handshake = 0;
                        } else if (this.event == SocketEvent.STOP || this.event == SocketEvent.DISCONNECT || this.event == SocketEvent.ERROR) {
                            handshake = -1;
                        } else {
                            handshake = ((Nio2Channel)this.socketWrapper.getSocket()).handshake();
                            this.event = SocketEvent.OPEN_READ;
                        }
                    }
                    catch (IOException x) {
                        handshake = -1;
                        if (!log.isDebugEnabled()) break block33;
                        log.debug(AbstractEndpoint.sm.getString("endpoint.err.handshake"), x);
                    }
                }
                if (handshake == 0) {
                    AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.OPEN;
                    state = this.event == null ? Nio2Endpoint.this.getHandler().process(this.socketWrapper, SocketEvent.OPEN_READ) : Nio2Endpoint.this.getHandler().process(this.socketWrapper, this.event);
                    if (state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        Nio2Endpoint.this.closeSocket(this.socketWrapper);
                        if (Nio2Endpoint.this.running && !Nio2Endpoint.this.paused && !Nio2Endpoint.this.nioChannels.push(this.socketWrapper.getSocket())) {
                            ((Nio2Channel)this.socketWrapper.getSocket()).free();
                        }
                    } else if (state == AbstractEndpoint.Handler.SocketState.UPGRADING) {
                        launch = true;
                    }
                } else if (handshake == -1) {
                    Nio2Endpoint.this.closeSocket(this.socketWrapper);
                    if (Nio2Endpoint.this.running && !Nio2Endpoint.this.paused && !Nio2Endpoint.this.nioChannels.push(this.socketWrapper.getSocket())) {
                        ((Nio2Channel)this.socketWrapper.getSocket()).free();
                    }
                }
            }
            catch (VirtualMachineError vme) {
                ExceptionUtils.handleThrowable(vme);
            }
            catch (Throwable t) {
                log.error(AbstractEndpoint.sm.getString("endpoint.processing.fail"), t);
                if (this.socketWrapper != null) {
                    Nio2Endpoint.this.closeSocket(this.socketWrapper);
                }
            }
            finally {
                block35: {
                    if (launch) {
                        try {
                            Nio2Endpoint.this.getExecutor().execute(new SocketProcessor(this.socketWrapper, SocketEvent.OPEN_READ));
                        }
                        catch (NullPointerException npe) {
                            if (!Nio2Endpoint.this.running) break block35;
                            log.error(AbstractEndpoint.sm.getString("endpoint.launch.fail"), npe);
                        }
                    }
                }
                this.socketWrapper = null;
                this.event = null;
                if (Nio2Endpoint.this.running && !Nio2Endpoint.this.paused) {
                    Nio2Endpoint.this.processorCache.push(this);
                }
            }
        }
    }

    public static class Nio2SocketWrapper
    extends SocketWrapperBase<Nio2Channel> {
        private static final ThreadLocal<AtomicInteger> nestedWriteCompletionCount = new ThreadLocal<AtomicInteger>(){

            @Override
            protected AtomicInteger initialValue() {
                return new AtomicInteger(0);
            }
        };
        private SendfileData sendfileData = null;
        private final CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>> readCompletionHandler;
        private final Semaphore readPending = new Semaphore(1);
        private boolean readInterest = false;
        private final CompletionHandler<Integer, ByteBuffer> writeCompletionHandler;
        private final CompletionHandler<Long, ByteBuffer[]> gatheringWriteCompletionHandler;
        private final Semaphore writePending = new Semaphore(1);
        private boolean writeInterest = false;
        private boolean writeNotify = false;
        private CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>> awaitBytesHandler = new CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>>(){

            @Override
            public void completed(Integer nBytes, SocketWrapperBase<Nio2Channel> attachment) {
                if (nBytes < 0) {
                    this.failed((Throwable)new ClosedChannelException(), attachment);
                    return;
                }
                this.getEndpoint().processSocket(attachment, SocketEvent.OPEN_READ, Nio2Endpoint.isInline());
            }

            @Override
            public void failed(Throwable exc, SocketWrapperBase<Nio2Channel> attachment) {
                this.getEndpoint().processSocket(attachment, SocketEvent.DISCONNECT, true);
            }
        };
        private CompletionHandler<Integer, SendfileData> sendfileHandler = new CompletionHandler<Integer, SendfileData>(){

            @Override
            public void completed(Integer nWrite, SendfileData attachment) {
                if (nWrite < 0) {
                    this.failed((Throwable)new EOFException(), attachment);
                    return;
                }
                attachment.pos += (long)nWrite.intValue();
                ByteBuffer buffer = ((Nio2Channel)this.getSocket()).getBufHandler().getWriteBuffer();
                if (!buffer.hasRemaining()) {
                    if (attachment.length <= 0L) {
                        this.setSendfileData(null);
                        try {
                            attachment.fchannel.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (Nio2Endpoint.isInline()) {
                            attachment.doneInline = true;
                        } else {
                            switch (attachment.keepAliveState) {
                                case NONE: {
                                    this.getEndpoint().processSocket(this, SocketEvent.DISCONNECT, false);
                                    break;
                                }
                                case PIPELINED: {
                                    this.getEndpoint().processSocket(this, SocketEvent.OPEN_READ, true);
                                    break;
                                }
                                case OPEN: {
                                    this.awaitBytes();
                                }
                            }
                        }
                        return;
                    }
                    ((Nio2Channel)this.getSocket()).getBufHandler().configureWriteBufferForWrite();
                    int nRead = -1;
                    try {
                        nRead = attachment.fchannel.read(buffer);
                    }
                    catch (IOException e) {
                        this.failed((Throwable)e, attachment);
                        return;
                    }
                    if (nRead > 0) {
                        ((Nio2Channel)this.getSocket()).getBufHandler().configureWriteBufferForRead();
                        if (attachment.length < (long)buffer.remaining()) {
                            buffer.limit(buffer.limit() - buffer.remaining() + (int)attachment.length);
                        }
                        attachment.length -= (long)nRead;
                    } else {
                        this.failed((Throwable)new EOFException(), attachment);
                        return;
                    }
                }
                ((Nio2Channel)this.getSocket()).write(buffer, this.getNio2WriteTimeout(), TimeUnit.MILLISECONDS, attachment, this);
            }

            @Override
            public void failed(Throwable exc, SendfileData attachment) {
                try {
                    attachment.fchannel.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (!Nio2Endpoint.isInline()) {
                    this.getEndpoint().processSocket(this, SocketEvent.ERROR, false);
                } else {
                    attachment.doneInline = true;
                    attachment.error = true;
                }
            }
        };

        public Nio2SocketWrapper(Nio2Channel channel, final Nio2Endpoint endpoint) {
            super(channel, endpoint);
            this.socketBufferHandler = channel.getBufHandler();
            this.readCompletionHandler = new CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void completed(Integer nBytes, SocketWrapperBase<Nio2Channel> attachment) {
                    boolean notify = false;
                    if (log.isDebugEnabled()) {
                        log.debug("Socket: [" + attachment + "], Interest: [" + readInterest + "]");
                    }
                    CompletionHandler completionHandler = readCompletionHandler;
                    synchronized (completionHandler) {
                        if (nBytes < 0) {
                            this.failed((Throwable)new EOFException(), attachment);
                        } else if (readInterest && !Nio2Endpoint.isInline()) {
                            readInterest = false;
                            notify = true;
                        } else {
                            readPending.release();
                        }
                    }
                    if (notify) {
                        this.getEndpoint().processSocket(attachment, SocketEvent.OPEN_READ, false);
                    }
                }

                @Override
                public void failed(Throwable exc, SocketWrapperBase<Nio2Channel> attachment) {
                    IOException ioe = exc instanceof IOException ? (IOException)exc : new IOException(exc);
                    this.setError(ioe);
                    if (exc instanceof AsynchronousCloseException) {
                        readPending.release();
                        return;
                    }
                    this.getEndpoint().processSocket(attachment, SocketEvent.ERROR, true);
                }
            };
            this.writeCompletionHandler = new CompletionHandler<Integer, ByteBuffer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void completed(Integer nBytes, ByteBuffer attachment) {
                    writeNotify = false;
                    CompletionHandler completionHandler = writeCompletionHandler;
                    synchronized (completionHandler) {
                        if (nBytes < 0) {
                            this.failed((Throwable)new EOFException(SocketWrapperBase.sm.getString("iob.failedwrite")), attachment);
                        } else if (bufferedWrites.size() > 0) {
                            ((AtomicInteger)nestedWriteCompletionCount.get()).incrementAndGet();
                            ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
                            if (attachment.hasRemaining()) {
                                arrayList.add(attachment);
                            }
                            for (ByteBufferHolder buffer : bufferedWrites) {
                                buffer.flip();
                                arrayList.add(buffer.getBuf());
                            }
                            bufferedWrites.clear();
                            ByteBuffer[] array = arrayList.toArray(new ByteBuffer[arrayList.size()]);
                            ((Nio2Channel)this.getSocket()).write(array, 0, array.length, this.getNio2WriteTimeout(), TimeUnit.MILLISECONDS, array, gatheringWriteCompletionHandler);
                            ((AtomicInteger)nestedWriteCompletionCount.get()).decrementAndGet();
                        } else if (attachment.hasRemaining()) {
                            ((AtomicInteger)nestedWriteCompletionCount.get()).incrementAndGet();
                            ((Nio2Channel)this.getSocket()).write(attachment, this.getNio2WriteTimeout(), TimeUnit.MILLISECONDS, attachment, writeCompletionHandler);
                            ((AtomicInteger)nestedWriteCompletionCount.get()).decrementAndGet();
                        } else {
                            if (writeInterest) {
                                writeInterest = false;
                                writeNotify = true;
                            }
                            writePending.release();
                        }
                    }
                    if (writeNotify && ((AtomicInteger)nestedWriteCompletionCount.get()).get() == 0) {
                        endpoint.processSocket(this, SocketEvent.OPEN_WRITE, Nio2Endpoint.isInline());
                    }
                }

                @Override
                public void failed(Throwable exc, ByteBuffer attachment) {
                    IOException ioe = exc instanceof IOException ? (IOException)exc : new IOException(exc);
                    this.setError(ioe);
                    writePending.release();
                    endpoint.processSocket(this, SocketEvent.ERROR, true);
                }
            };
            this.gatheringWriteCompletionHandler = new CompletionHandler<Long, ByteBuffer[]>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void completed(Long nBytes, ByteBuffer[] attachment) {
                    writeNotify = false;
                    CompletionHandler completionHandler = writeCompletionHandler;
                    synchronized (completionHandler) {
                        if (nBytes < 0L) {
                            this.failed((Throwable)new EOFException(SocketWrapperBase.sm.getString("iob.failedwrite")), attachment);
                        } else if (bufferedWrites.size() > 0 || Nio2SocketWrapper.arrayHasData(attachment)) {
                            ((AtomicInteger)nestedWriteCompletionCount.get()).incrementAndGet();
                            ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
                            for (ByteBuffer buffer : attachment) {
                                if (!buffer.hasRemaining()) continue;
                                arrayList.add(buffer);
                            }
                            for (ByteBufferHolder buffer : bufferedWrites) {
                                buffer.flip();
                                arrayList.add(buffer.getBuf());
                            }
                            bufferedWrites.clear();
                            ByteBuffer[] array = arrayList.toArray(new ByteBuffer[arrayList.size()]);
                            ((Nio2Channel)this.getSocket()).write(array, 0, array.length, this.getNio2WriteTimeout(), TimeUnit.MILLISECONDS, array, gatheringWriteCompletionHandler);
                            ((AtomicInteger)nestedWriteCompletionCount.get()).decrementAndGet();
                        } else {
                            if (writeInterest) {
                                writeInterest = false;
                                writeNotify = true;
                            }
                            writePending.release();
                        }
                    }
                    if (writeNotify && ((AtomicInteger)nestedWriteCompletionCount.get()).get() == 0) {
                        endpoint.processSocket(this, SocketEvent.OPEN_WRITE, Nio2Endpoint.isInline());
                    }
                }

                @Override
                public void failed(Throwable exc, ByteBuffer[] attachment) {
                    IOException ioe = exc instanceof IOException ? (IOException)exc : new IOException(exc);
                    this.setError(ioe);
                    writePending.release();
                    endpoint.processSocket(this, SocketEvent.ERROR, true);
                }
            };
        }

        private static boolean arrayHasData(ByteBuffer[] byteBuffers) {
            for (ByteBuffer byteBuffer : byteBuffers) {
                if (!byteBuffer.hasRemaining()) continue;
                return true;
            }
            return false;
        }

        public void setSendfileData(SendfileData sf) {
            this.sendfileData = sf;
        }

        public SendfileData getSendfileData() {
            return this.sendfileData;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadyForRead() throws IOException {
            CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>> completionHandler = this.readCompletionHandler;
            synchronized (completionHandler) {
                boolean isReady;
                if (!this.readPending.tryAcquire()) {
                    this.readInterest = true;
                    return false;
                }
                if (!this.socketBufferHandler.isReadBufferEmpty()) {
                    this.readPending.release();
                    return true;
                }
                int nRead = this.fillReadBuffer(false);
                boolean bl = isReady = nRead > 0;
                if (!isReady) {
                    this.readInterest = true;
                }
                return isReady;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(boolean block, byte[] b, int off, int len) throws IOException {
            this.checkError();
            if (log.isDebugEnabled()) {
                log.debug("Socket: [" + this + "], block: [" + block + "], length: [" + len + "]");
            }
            if (this.socketBufferHandler == null) {
                throw new IOException(sm.getString("socket.closed"));
            }
            if (block) {
                try {
                    this.readPending.acquire();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            } else if (!this.readPending.tryAcquire()) {
                if (log.isDebugEnabled()) {
                    log.debug("Socket: [" + this + "], Read in progress. Returning [0]");
                }
                return 0;
            }
            int nRead = this.populateReadBuffer(b, off, len);
            if (nRead > 0) {
                this.readPending.release();
                return nRead;
            }
            CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>> completionHandler = this.readCompletionHandler;
            synchronized (completionHandler) {
                nRead = this.fillReadBuffer(block);
                if (nRead > 0) {
                    this.socketBufferHandler.configureReadBufferForRead();
                    nRead = Math.min(nRead, len);
                    this.socketBufferHandler.getReadBuffer().get(b, off, nRead);
                } else if (nRead == 0 && !block) {
                    this.readInterest = true;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Socket: [" + this + "], Read: [" + nRead + "]");
                }
                return nRead;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(boolean block, ByteBuffer to) throws IOException {
            this.checkError();
            if (this.socketBufferHandler == null) {
                throw new IOException(sm.getString("socket.closed"));
            }
            if (block) {
                try {
                    this.readPending.acquire();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
            } else if (!this.readPending.tryAcquire()) {
                if (log.isDebugEnabled()) {
                    log.debug("Socket: [" + this + "], Read in progress. Returning [0]");
                }
                return 0;
            }
            int nRead = this.populateReadBuffer(to);
            if (nRead > 0) {
                this.readPending.release();
                return nRead;
            }
            CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>> completionHandler = this.readCompletionHandler;
            synchronized (completionHandler) {
                int limit = this.socketBufferHandler.getReadBuffer().capacity();
                if (block && to.remaining() >= limit) {
                    to.limit(to.position() + limit);
                    nRead = this.fillReadBuffer(block, to);
                } else {
                    nRead = this.fillReadBuffer(block);
                    if (nRead > 0) {
                        nRead = this.populateReadBuffer(to);
                    } else if (nRead == 0 && !block) {
                        this.readInterest = true;
                    }
                }
                return nRead;
            }
        }

        @Override
        public void close() throws IOException {
            ((Nio2Channel)this.getSocket()).close();
        }

        @Override
        public boolean isClosed() {
            return !((Nio2Channel)this.getSocket()).isOpen();
        }

        @Override
        public boolean hasAsyncIO() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> SocketWrapperBase.CompletionState read(ByteBuffer[] dsts, int offset, int length, SocketWrapperBase.BlockingMode block, long timeout, TimeUnit unit, A attachment, SocketWrapperBase.CompletionCheck check, CompletionHandler<Long, ? super A> handler) {
            block14: {
                IOException ioe = this.getError();
                if (ioe != null) {
                    handler.failed(ioe, attachment);
                    return SocketWrapperBase.CompletionState.ERROR;
                }
                if (block != SocketWrapperBase.BlockingMode.NON_BLOCK) {
                    try {
                        if (!this.readPending.tryAcquire(timeout, unit)) {
                            handler.failed(new SocketTimeoutException(), attachment);
                            return SocketWrapperBase.CompletionState.ERROR;
                        }
                        break block14;
                    }
                    catch (InterruptedException e) {
                        handler.failed(e, attachment);
                        return SocketWrapperBase.CompletionState.ERROR;
                    }
                }
                if (!this.readPending.tryAcquire()) {
                    return SocketWrapperBase.CompletionState.NOT_DONE;
                }
            }
            OperationState state = new OperationState(dsts, offset, length, block, timeout, unit, attachment, check, handler);
            ScatterReadCompletionHandler completion = new ScatterReadCompletionHandler();
            Nio2Endpoint.startInline();
            ((Nio2Channel)this.getSocket()).read(dsts, offset, length, timeout, unit, state, completion);
            Nio2Endpoint.endInline();
            if (block == SocketWrapperBase.BlockingMode.BLOCK) {
                OperationState operationState = state;
                synchronized (operationState) {
                    if (state.state == SocketWrapperBase.CompletionState.PENDING) {
                        try {
                            state.wait(unit.toMillis(timeout));
                            if (state.state == SocketWrapperBase.CompletionState.PENDING) {
                                handler.failed(new SocketTimeoutException(), attachment);
                                return SocketWrapperBase.CompletionState.ERROR;
                            }
                        }
                        catch (InterruptedException e) {
                            handler.failed(new SocketTimeoutException(), attachment);
                            return SocketWrapperBase.CompletionState.ERROR;
                        }
                    }
                }
            }
            return state.state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isWritePending() {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                return this.writePending.availablePermits() == 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <A> SocketWrapperBase.CompletionState write(ByteBuffer[] srcs, int offset, int length, SocketWrapperBase.BlockingMode block, long timeout, TimeUnit unit, A attachment, SocketWrapperBase.CompletionCheck check, CompletionHandler<Long, ? super A> handler) {
            block14: {
                IOException ioe = this.getError();
                if (ioe != null) {
                    handler.failed(ioe, attachment);
                    return SocketWrapperBase.CompletionState.ERROR;
                }
                if (block != SocketWrapperBase.BlockingMode.NON_BLOCK) {
                    try {
                        if (!this.writePending.tryAcquire(timeout, unit)) {
                            handler.failed(new SocketTimeoutException(), attachment);
                            return SocketWrapperBase.CompletionState.ERROR;
                        }
                        break block14;
                    }
                    catch (InterruptedException e) {
                        handler.failed(e, attachment);
                        return SocketWrapperBase.CompletionState.ERROR;
                    }
                }
                if (!this.writePending.tryAcquire()) {
                    return SocketWrapperBase.CompletionState.NOT_DONE;
                }
            }
            OperationState state = new OperationState(srcs, offset, length, block, timeout, unit, attachment, check, handler);
            GatherWriteCompletionHandler completion = new GatherWriteCompletionHandler();
            Nio2Endpoint.startInline();
            ((Nio2Channel)this.getSocket()).write(srcs, offset, length, timeout, unit, state, completion);
            Nio2Endpoint.endInline();
            if (block == SocketWrapperBase.BlockingMode.BLOCK) {
                OperationState operationState = state;
                synchronized (operationState) {
                    if (state.state == SocketWrapperBase.CompletionState.PENDING) {
                        try {
                            state.wait(unit.toMillis(timeout));
                            if (state.state == SocketWrapperBase.CompletionState.PENDING) {
                                handler.failed(new SocketTimeoutException(), attachment);
                                return SocketWrapperBase.CompletionState.ERROR;
                            }
                        }
                        catch (InterruptedException e) {
                            handler.failed(new SocketTimeoutException(), attachment);
                            return SocketWrapperBase.CompletionState.ERROR;
                        }
                    }
                }
            }
            return state.state;
        }

        private int fillReadBuffer(boolean block) throws IOException {
            this.socketBufferHandler.configureReadBufferForWrite();
            return this.fillReadBuffer(block, this.socketBufferHandler.getReadBuffer());
        }

        private int fillReadBuffer(boolean block, ByteBuffer to) throws IOException {
            int nRead = 0;
            Future<Integer> integer = null;
            if (block) {
                try {
                    integer = ((Nio2Channel)this.getSocket()).read(to);
                    nRead = integer.get(this.getNio2ReadTimeout(), TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof IOException) {
                        throw (IOException)e.getCause();
                    }
                    throw new IOException(e);
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                catch (TimeoutException e) {
                    integer.cancel(true);
                    throw new SocketTimeoutException();
                }
                finally {
                    this.readPending.release();
                }
            } else {
                Nio2Endpoint.startInline();
                ((Nio2Channel)this.getSocket()).read(to, this.getNio2ReadTimeout(), TimeUnit.MILLISECONDS, this, this.readCompletionHandler);
                Nio2Endpoint.endInline();
                if (this.readPending.availablePermits() == 1) {
                    nRead = to.position();
                }
            }
            return nRead;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void writeNonBlocking(byte[] buf, int off, int len) throws IOException {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                if (this.writePending.tryAcquire()) {
                    this.socketBufferHandler.configureWriteBufferForWrite();
                    int thisTime = Nio2SocketWrapper.transfer(buf, off, len, this.socketBufferHandler.getWriteBuffer());
                    off += thisTime;
                    if ((len -= thisTime) > 0) {
                        this.addToBuffers(buf, off, len);
                    }
                    this.flushNonBlocking(true);
                } else {
                    this.addToBuffers(buf, off, len);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void writeNonBlocking(ByteBuffer from) throws IOException {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                if (this.writePending.tryAcquire()) {
                    this.socketBufferHandler.configureWriteBufferForWrite();
                    Nio2SocketWrapper.transfer(from, this.socketBufferHandler.getWriteBuffer());
                    if (from.remaining() > 0) {
                        this.addToBuffers(from);
                    }
                    this.flushNonBlocking(true);
                } else {
                    this.addToBuffers(from);
                }
            }
        }

        @Override
        protected void doWrite(boolean block, ByteBuffer from) throws IOException {
            Future<Integer> integer = null;
            try {
                do {
                    if ((integer = ((Nio2Channel)this.getSocket()).write(from)).get(this.getNio2WriteTimeout(), TimeUnit.MILLISECONDS) >= 0) continue;
                    throw new EOFException(sm.getString("iob.failedwrite"));
                } while (from.hasRemaining());
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            catch (TimeoutException e) {
                integer.cancel(true);
                throw new SocketTimeoutException();
            }
        }

        @Override
        protected void flushBlocking() throws IOException {
            this.checkError();
            try {
                if (!this.writePending.tryAcquire(this.getNio2WriteTimeout(), TimeUnit.MILLISECONDS)) {
                    throw new SocketTimeoutException();
                }
                this.writePending.release();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            super.flushBlocking();
        }

        @Override
        protected boolean flushNonBlocking() throws IOException {
            return this.flushNonBlocking(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean flushNonBlocking(boolean hasPermit) throws IOException {
            this.checkError();
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                if (hasPermit || this.writePending.tryAcquire()) {
                    this.socketBufferHandler.configureWriteBufferForRead();
                    if (this.bufferedWrites.size() > 0) {
                        ArrayList<ByteBuffer> arrayList = new ArrayList<ByteBuffer>();
                        if (this.socketBufferHandler.getWriteBuffer().hasRemaining()) {
                            arrayList.add(this.socketBufferHandler.getWriteBuffer());
                        }
                        for (ByteBufferHolder buffer : this.bufferedWrites) {
                            buffer.flip();
                            arrayList.add(buffer.getBuf());
                        }
                        this.bufferedWrites.clear();
                        ByteBuffer[] array = arrayList.toArray(new ByteBuffer[arrayList.size()]);
                        Nio2Endpoint.startInline();
                        ((Nio2Channel)this.getSocket()).write(array, 0, array.length, this.getNio2WriteTimeout(), TimeUnit.MILLISECONDS, array, this.gatheringWriteCompletionHandler);
                        Nio2Endpoint.endInline();
                    } else if (this.socketBufferHandler.getWriteBuffer().hasRemaining()) {
                        Nio2Endpoint.startInline();
                        ((Nio2Channel)this.getSocket()).write(this.socketBufferHandler.getWriteBuffer(), this.getNio2WriteTimeout(), TimeUnit.MILLISECONDS, this.socketBufferHandler.getWriteBuffer(), this.writeCompletionHandler);
                        Nio2Endpoint.endInline();
                    } else if (!hasPermit) {
                        this.writePending.release();
                    }
                }
                return this.hasDataToWrite();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasDataToWrite() {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                return !this.socketBufferHandler.isWriteBufferEmpty() || this.bufferedWrites.size() > 0 || this.getError() != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isReadPending() {
            CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>> completionHandler = this.readCompletionHandler;
            synchronized (completionHandler) {
                return this.readPending.availablePermits() == 0;
            }
        }

        @Override
        public boolean awaitReadComplete(long timeout, TimeUnit unit) {
            try {
                if (this.readPending.tryAcquire(timeout, unit)) {
                    this.readPending.release();
                    return true;
                }
                return false;
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        @Override
        public boolean awaitWriteComplete(long timeout, TimeUnit unit) {
            try {
                if (this.writePending.tryAcquire(timeout, unit)) {
                    this.writePending.release();
                    return true;
                }
                return false;
            }
            catch (InterruptedException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releaseReadPending() {
            CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>> completionHandler = this.readCompletionHandler;
            synchronized (completionHandler) {
                if (this.readPending.availablePermits() == 0) {
                    this.readPending.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerReadInterest() {
            CompletionHandler<Integer, SocketWrapperBase<Nio2Channel>> completionHandler = this.readCompletionHandler;
            synchronized (completionHandler) {
                if (this.readPending.availablePermits() == 0) {
                    this.readInterest = true;
                } else {
                    this.awaitBytes();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerWriteInterest() {
            CompletionHandler<Integer, ByteBuffer> completionHandler = this.writeCompletionHandler;
            synchronized (completionHandler) {
                if (this.writePending.availablePermits() == 0) {
                    this.writeInterest = true;
                } else {
                    this.getEndpoint().processSocket(this, SocketEvent.OPEN_WRITE, true);
                }
            }
        }

        public void awaitBytes() {
            if (this.readPending.tryAcquire()) {
                ((Nio2Channel)this.getSocket()).getBufHandler().configureReadBufferForWrite();
                Nio2Endpoint.startInline();
                ((Nio2Channel)this.getSocket()).read(((Nio2Channel)this.getSocket()).getBufHandler().getReadBuffer(), this.getNio2ReadTimeout(), TimeUnit.MILLISECONDS, this, this.awaitBytesHandler);
                Nio2Endpoint.endInline();
            }
        }

        @Override
        public SendfileDataBase createSendfileData(String filename, long pos, long length) {
            return new SendfileData(filename, pos, length);
        }

        @Override
        public SendfileState processSendfile(SendfileDataBase sendfileData) {
            SendfileData data = (SendfileData)sendfileData;
            this.setSendfileData(data);
            if (data.fchannel == null || !data.fchannel.isOpen()) {
                Path path = new File(sendfileData.fileName).toPath();
                try {
                    data.fchannel = FileChannel.open(path, StandardOpenOption.READ).position(sendfileData.pos);
                }
                catch (IOException e) {
                    return SendfileState.ERROR;
                }
            }
            ((Nio2Channel)this.getSocket()).getBufHandler().configureWriteBufferForWrite();
            ByteBuffer buffer = ((Nio2Channel)this.getSocket()).getBufHandler().getWriteBuffer();
            int nRead = -1;
            try {
                nRead = data.fchannel.read(buffer);
            }
            catch (IOException e1) {
                return SendfileState.ERROR;
            }
            if (nRead >= 0) {
                data.length -= (long)nRead;
                ((Nio2Channel)this.getSocket()).getBufHandler().configureWriteBufferForRead();
                Nio2Endpoint.startInline();
                ((Nio2Channel)this.getSocket()).write(buffer, this.getNio2WriteTimeout(), TimeUnit.MILLISECONDS, data, this.sendfileHandler);
                Nio2Endpoint.endInline();
                if (data.doneInline) {
                    if (data.error) {
                        return SendfileState.ERROR;
                    }
                    return SendfileState.DONE;
                }
                return SendfileState.PENDING;
            }
            return SendfileState.ERROR;
        }

        private long getNio2ReadTimeout() {
            long readTimeout = this.getReadTimeout();
            if (readTimeout > 0L) {
                return readTimeout;
            }
            return Long.MAX_VALUE;
        }

        private long getNio2WriteTimeout() {
            long writeTimeout = this.getWriteTimeout();
            if (writeTimeout > 0L) {
                return writeTimeout;
            }
            return Long.MAX_VALUE;
        }

        @Override
        protected void populateRemoteAddr() {
            SocketAddress socketAddress = null;
            try {
                socketAddress = ((Nio2Channel)this.getSocket()).getIOChannel().getRemoteAddress();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (socketAddress instanceof InetSocketAddress) {
                this.remoteAddr = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
            }
        }

        @Override
        protected void populateRemoteHost() {
            SocketAddress socketAddress = null;
            try {
                socketAddress = ((Nio2Channel)this.getSocket()).getIOChannel().getRemoteAddress();
            }
            catch (IOException e) {
                log.warn(sm.getString("endpoint.warn.noRemoteHost", this.getSocket()), e);
            }
            if (socketAddress instanceof InetSocketAddress) {
                this.remoteHost = ((InetSocketAddress)socketAddress).getAddress().getHostName();
                if (this.remoteAddr == null) {
                    this.remoteAddr = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
                }
            }
        }

        @Override
        protected void populateRemotePort() {
            SocketAddress socketAddress = null;
            try {
                socketAddress = ((Nio2Channel)this.getSocket()).getIOChannel().getRemoteAddress();
            }
            catch (IOException e) {
                log.warn(sm.getString("endpoint.warn.noRemotePort", this.getSocket()), e);
            }
            if (socketAddress instanceof InetSocketAddress) {
                this.remotePort = ((InetSocketAddress)socketAddress).getPort();
            }
        }

        @Override
        protected void populateLocalName() {
            SocketAddress socketAddress = null;
            try {
                socketAddress = ((Nio2Channel)this.getSocket()).getIOChannel().getLocalAddress();
            }
            catch (IOException e) {
                log.warn(sm.getString("endpoint.warn.noLocalName", this.getSocket()), e);
            }
            if (socketAddress instanceof InetSocketAddress) {
                this.localName = ((InetSocketAddress)socketAddress).getHostName();
            }
        }

        @Override
        protected void populateLocalAddr() {
            SocketAddress socketAddress = null;
            try {
                socketAddress = ((Nio2Channel)this.getSocket()).getIOChannel().getLocalAddress();
            }
            catch (IOException e) {
                log.warn(sm.getString("endpoint.warn.noLocalAddr", this.getSocket()), e);
            }
            if (socketAddress instanceof InetSocketAddress) {
                this.localAddr = ((InetSocketAddress)socketAddress).getAddress().getHostAddress();
            }
        }

        @Override
        protected void populateLocalPort() {
            SocketAddress socketAddress = null;
            try {
                socketAddress = ((Nio2Channel)this.getSocket()).getIOChannel().getLocalAddress();
            }
            catch (IOException e) {
                log.warn(sm.getString("endpoint.warn.noLocalPort", this.getSocket()), e);
            }
            if (socketAddress instanceof InetSocketAddress) {
                this.localPort = ((InetSocketAddress)socketAddress).getPort();
            }
        }

        @Override
        public SSLSupport getSslSupport(String clientCertProvider) {
            if (this.getSocket() instanceof SecureNio2Channel) {
                SecureNio2Channel ch = (SecureNio2Channel)this.getSocket();
                SSLSession session = ch.getSslEngine().getSession();
                return ((Nio2Endpoint)this.getEndpoint()).getSslImplementation().getSSLSupport(session);
            }
            return null;
        }

        @Override
        public void doClientAuth(SSLSupport sslSupport) throws IOException {
            SecureNio2Channel sslChannel = (SecureNio2Channel)this.getSocket();
            SSLEngine engine = sslChannel.getSslEngine();
            if (!engine.getNeedClientAuth()) {
                engine.setNeedClientAuth(true);
                sslChannel.rehandshake();
                ((JSSESupport)sslSupport).setSession(engine.getSession());
            }
        }

        @Override
        public void setAppReadBufHandler(ApplicationBufferHandler handler) {
            ((Nio2Channel)this.getSocket()).setAppReadBufHandler(handler);
        }

        private class GatherWriteCompletionHandler<A>
        implements CompletionHandler<Long, OperationState<A>> {
            private GatherWriteCompletionHandler() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(Long nBytes, OperationState<A> state) {
                if (nBytes < 0L) {
                    this.failed((Throwable)new EOFException(), state);
                } else {
                    OperationState<A> operationState = state;
                    ((OperationState)operationState).nBytes = ((OperationState)operationState).nBytes + nBytes;
                    SocketWrapperBase.CompletionState currentState = Nio2Endpoint.isInline() ? SocketWrapperBase.CompletionState.INLINE : SocketWrapperBase.CompletionState.DONE;
                    boolean complete = true;
                    boolean completion = true;
                    if (((OperationState)state).check != null) {
                        switch (((OperationState)state).check.callHandler(currentState, ((OperationState)state).buffers, ((OperationState)state).offset, ((OperationState)state).length)) {
                            case CONTINUE: {
                                complete = false;
                                break;
                            }
                            case DONE: {
                                break;
                            }
                            case NONE: {
                                completion = false;
                            }
                        }
                    }
                    if (complete) {
                        OperationState<A> operationState2 = state;
                        synchronized (operationState2) {
                            Nio2SocketWrapper.this.writePending.release();
                            if (((OperationState)state).block == SocketWrapperBase.BlockingMode.BLOCK && currentState != SocketWrapperBase.CompletionState.INLINE) {
                                ((OperationState)state).state = currentState;
                                state.notify();
                            } else {
                                ((OperationState)state).state = currentState;
                            }
                        }
                        if (completion && ((OperationState)state).handler != null) {
                            ((OperationState)state).handler.completed(((OperationState)state).nBytes, ((OperationState)state).attachment);
                        }
                    } else {
                        ((Nio2Channel)Nio2SocketWrapper.this.getSocket()).write(((OperationState)state).buffers, ((OperationState)state).offset, ((OperationState)state).length, ((OperationState)state).timeout, ((OperationState)state).unit, state, this);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Throwable exc, OperationState<A> state) {
                IOException ioe = exc instanceof IOException ? (IOException)exc : new IOException(exc);
                Nio2SocketWrapper.this.setError(ioe);
                OperationState<A> operationState = state;
                synchronized (operationState) {
                    Nio2SocketWrapper.this.writePending.release();
                    if (((OperationState)state).block == SocketWrapperBase.BlockingMode.BLOCK) {
                        ((OperationState)state).state = Nio2Endpoint.isInline() ? SocketWrapperBase.CompletionState.ERROR : SocketWrapperBase.CompletionState.DONE;
                        state.notify();
                    } else {
                        ((OperationState)state).state = Nio2Endpoint.isInline() ? SocketWrapperBase.CompletionState.ERROR : SocketWrapperBase.CompletionState.DONE;
                    }
                }
                if (((OperationState)state).handler != null) {
                    ((OperationState)state).handler.failed(ioe, ((OperationState)state).attachment);
                }
            }
        }

        private class ScatterReadCompletionHandler<A>
        implements CompletionHandler<Long, OperationState<A>> {
            private ScatterReadCompletionHandler() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(Long nBytes, OperationState<A> state) {
                if (nBytes.intValue() < 0) {
                    this.failed((Throwable)new EOFException(), state);
                } else {
                    OperationState<A> operationState = state;
                    ((OperationState)operationState).nBytes = ((OperationState)operationState).nBytes + nBytes;
                    SocketWrapperBase.CompletionState currentState = Nio2Endpoint.isInline() ? SocketWrapperBase.CompletionState.INLINE : SocketWrapperBase.CompletionState.DONE;
                    boolean complete = true;
                    boolean completion = true;
                    if (((OperationState)state).check != null) {
                        switch (((OperationState)state).check.callHandler(currentState, ((OperationState)state).buffers, ((OperationState)state).offset, ((OperationState)state).length)) {
                            case CONTINUE: {
                                complete = false;
                                break;
                            }
                            case DONE: {
                                break;
                            }
                            case NONE: {
                                completion = false;
                            }
                        }
                    }
                    if (complete) {
                        OperationState<A> operationState2 = state;
                        synchronized (operationState2) {
                            Nio2SocketWrapper.this.readPending.release();
                            if (((OperationState)state).block == SocketWrapperBase.BlockingMode.BLOCK && currentState != SocketWrapperBase.CompletionState.INLINE) {
                                ((OperationState)state).state = currentState;
                                state.notify();
                            } else {
                                ((OperationState)state).state = currentState;
                            }
                        }
                        if (completion && ((OperationState)state).handler != null) {
                            ((OperationState)state).handler.completed(((OperationState)state).nBytes, ((OperationState)state).attachment);
                        }
                    } else {
                        ((Nio2Channel)Nio2SocketWrapper.this.getSocket()).read(((OperationState)state).buffers, ((OperationState)state).offset, ((OperationState)state).length, ((OperationState)state).timeout, ((OperationState)state).unit, state, this);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(Throwable exc, OperationState<A> state) {
                IOException ioe = exc instanceof IOException ? (IOException)exc : new IOException(exc);
                Nio2SocketWrapper.this.setError(ioe);
                OperationState<A> operationState = state;
                synchronized (operationState) {
                    Nio2SocketWrapper.this.readPending.release();
                    if (((OperationState)state).block == SocketWrapperBase.BlockingMode.BLOCK) {
                        ((OperationState)state).state = Nio2Endpoint.isInline() ? SocketWrapperBase.CompletionState.ERROR : SocketWrapperBase.CompletionState.DONE;
                        state.notify();
                    } else {
                        ((OperationState)state).state = Nio2Endpoint.isInline() ? SocketWrapperBase.CompletionState.ERROR : SocketWrapperBase.CompletionState.DONE;
                    }
                }
                if (exc instanceof AsynchronousCloseException) {
                    return;
                }
                if (((OperationState)state).handler != null) {
                    ((OperationState)state).handler.failed(ioe, ((OperationState)state).attachment);
                }
            }
        }

        private static class OperationState<A> {
            private final ByteBuffer[] buffers;
            private final int offset;
            private final int length;
            private final A attachment;
            private final long timeout;
            private final TimeUnit unit;
            private final SocketWrapperBase.BlockingMode block;
            private final SocketWrapperBase.CompletionCheck check;
            private final CompletionHandler<Long, ? super A> handler;
            private volatile long nBytes = 0L;
            private volatile SocketWrapperBase.CompletionState state = SocketWrapperBase.CompletionState.PENDING;

            private OperationState(ByteBuffer[] buffers, int offset, int length, SocketWrapperBase.BlockingMode block, long timeout, TimeUnit unit, A attachment, SocketWrapperBase.CompletionCheck check, CompletionHandler<Long, ? super A> handler) {
                this.buffers = buffers;
                this.offset = offset;
                this.length = length;
                this.block = block;
                this.timeout = timeout;
                this.unit = unit;
                this.attachment = attachment;
                this.check = check;
                this.handler = handler;
            }
        }
    }
}

