/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.DomainLoadStoreParameter;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.res.StringManager;

public abstract class SSLUtilBase
implements SSLUtil {
    private static final Log log = LogFactory.getLog(SSLUtilBase.class);
    private static final StringManager sm = StringManager.getManager(SSLUtilBase.class);
    protected final SSLHostConfigCertificate certificate;
    private final String[] enabledProtocols;
    private final String[] enabledCiphers;

    protected SSLUtilBase(SSLHostConfigCertificate certificate) {
        this(certificate, true);
    }

    protected SSLUtilBase(SSLHostConfigCertificate certificate, boolean warnTls13) {
        this.certificate = certificate;
        SSLHostConfig sslHostConfig = certificate.getSSLHostConfig();
        Set<String> configuredProtocols = sslHostConfig.getProtocols();
        if (!this.isTls13Available() && !sslHostConfig.isExplicitlyRequestedProtocol("TLSv1.3")) {
            configuredProtocols.remove("TLSv1.3");
        }
        Set<String> implementedProtocols = this.getImplementedProtocols();
        List<String> enabledProtocols = SSLUtilBase.getEnabled("protocols", this.getLog(), warnTls13, configuredProtocols, implementedProtocols);
        if (enabledProtocols.contains("SSLv3")) {
            log.warn(sm.getString("jsse.ssl3"));
        }
        this.enabledProtocols = enabledProtocols.toArray(new String[enabledProtocols.size()]);
        if (enabledProtocols.contains("TLSv1.3") && sslHostConfig.getCertificateVerification() == SSLHostConfig.CertificateVerification.OPTIONAL && !this.isTls13RenegAuthAvailable() && warnTls13) {
            log.warn(sm.getString("jsse.tls13.auth"));
        }
        List<String> configuredCiphers = sslHostConfig.getJsseCipherNames();
        Set<String> implementedCiphers = this.getImplementedCiphers();
        List<String> enabledCiphers = SSLUtilBase.getEnabled("ciphers", this.getLog(), false, configuredCiphers, implementedCiphers);
        this.enabledCiphers = enabledCiphers.toArray(new String[enabledCiphers.size()]);
    }

    static <T> List<T> getEnabled(String name, Log log, boolean warnOnSkip, Collection<T> configured, Collection<T> implemented) {
        ArrayList<T> enabled = new ArrayList<T>();
        if (implemented.size() == 0) {
            enabled.addAll(configured);
        } else {
            enabled.addAll(configured);
            enabled.retainAll(implemented);
            if (enabled.isEmpty()) {
                throw new IllegalArgumentException(sm.getString("sslUtilBase.noneSupported", name, configured));
            }
            if (log.isDebugEnabled()) {
                log.debug(sm.getString("sslUtilBase.active", name, enabled));
            }
            if ((log.isDebugEnabled() || warnOnSkip) && enabled.size() != configured.size()) {
                ArrayList<T> skipped = new ArrayList<T>();
                skipped.addAll(configured);
                skipped.removeAll(enabled);
                String msg = sm.getString("sslUtilBase.skipped", name, skipped);
                if (warnOnSkip) {
                    log.warn(msg);
                } else {
                    log.debug(msg);
                }
            }
        }
        return enabled;
    }

    static KeyStore getStore(String type, String provider, String path, String pass) throws IOException {
        KeyStore ks = null;
        InputStream istream = null;
        try {
            ks = provider == null ? KeyStore.getInstance(type) : KeyStore.getInstance(type, provider);
            if ("DKS".equalsIgnoreCase(type)) {
                URI uri = ConfigFileLoader.getSource().getURI(path);
                ks.load(new DomainLoadStoreParameter(uri, Collections.emptyMap()));
            } else {
                if (!"PKCS11".equalsIgnoreCase(type) && !"".equalsIgnoreCase(path) || "NONE".equalsIgnoreCase(path)) {
                    istream = ConfigFileLoader.getSource().getResource(path).getInputStream();
                }
                char[] storePass = null;
                if (pass != null && (!"".equals(pass) || "JKS".equalsIgnoreCase(type) || "PKCS12".equalsIgnoreCase(type))) {
                    storePass = pass.toCharArray();
                }
                ks.load(istream, storePass);
            }
        }
        catch (FileNotFoundException fnfe) {
            throw fnfe;
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception ex) {
            String msg = sm.getString("jsse.keystore_load_failed", type, path, ex.getMessage());
            log.error(msg, ex);
            throw new IOException(msg);
        }
        finally {
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.enabledProtocols;
    }

    @Override
    public String[] getEnabledCiphers() {
        return this.enabledCiphers;
    }

    protected abstract Set<String> getImplementedProtocols();

    protected abstract Set<String> getImplementedCiphers();

    protected abstract Log getLog();

    protected abstract boolean isTls13Available();

    protected abstract boolean isTls13RenegAuthAvailable();
}

