/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.coyote.ActionCode;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.jni.Socket;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.http.HttpMessages;

public class InternalAprOutputBuffer
extends AbstractOutputBuffer {
    protected long socket;
    protected ByteBuffer bbuf = null;

    public InternalAprOutputBuffer(Response response, int headerBufferSize) {
        this.response = response;
        this.buf = new byte[headerBufferSize];
        this.bbuf = headerBufferSize < 8192 ? ByteBuffer.allocateDirect(9000) : ByteBuffer.allocateDirect((headerBufferSize / 1500 + 1) * 1500);
        this.outputStreamOutputBuffer = new SocketOutputBuffer();
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        HttpMessages.getMessage(200);
    }

    public void setSocket(long socket) {
        this.socket = socket;
        Socket.setsbb(this.socket, this.bbuf);
    }

    public long getSocket() {
        return this.socket;
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.flushBuffer();
    }

    @Override
    public void recycle() {
        super.recycle();
        this.bbuf.clear();
    }

    @Override
    public void endRequest() throws IOException {
        if (!this.committed) {
            this.response.action(ActionCode.COMMIT, null);
        }
        if (this.finished) {
            return;
        }
        if (this.lastActiveFilter != -1) {
            this.activeFilters[this.lastActiveFilter].end();
        }
        this.flushBuffer();
        this.finished = true;
    }

    @Override
    public void sendAck() throws IOException {
        if (!this.committed && Socket.send(this.socket, Constants.ACK_BYTES, 0, Constants.ACK_BYTES.length) < 0) {
            throw new IOException(sm.getString("iib.failedwrite"));
        }
    }

    @Override
    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.bbuf.put(this.buf, 0, this.pos);
        }
    }

    protected void flushBuffer() throws IOException {
        if (this.bbuf.position() > 0) {
            if (Socket.sendbb(this.socket, 0, this.bbuf.position()) < 0) {
                throw new IOException();
            }
            this.bbuf.clear();
        }
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            int len = chunk.getLength();
            int start = chunk.getStart();
            byte[] b = chunk.getBuffer();
            while (len > 0) {
                int thisTime = len;
                if (InternalAprOutputBuffer.this.bbuf.position() == InternalAprOutputBuffer.this.bbuf.capacity()) {
                    InternalAprOutputBuffer.this.flushBuffer();
                }
                if (thisTime > InternalAprOutputBuffer.this.bbuf.capacity() - InternalAprOutputBuffer.this.bbuf.position()) {
                    thisTime = InternalAprOutputBuffer.this.bbuf.capacity() - InternalAprOutputBuffer.this.bbuf.position();
                }
                InternalAprOutputBuffer.this.bbuf.put(b, start, thisTime);
                len -= thisTime;
                start += thisTime;
            }
            InternalAprOutputBuffer.this.byteCount += (long)chunk.getLength();
            return chunk.getLength();
        }

        @Override
        public long getBytesWritten() {
            return InternalAprOutputBuffer.this.byteCount;
        }
    }
}

