/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.annotation.HandlesTypes;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ContainerBase;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardEngine;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.deploy.ServletDef;
import org.apache.catalina.deploy.WebXml;
import org.apache.catalina.startup.ContextRuleSet;
import org.apache.catalina.startup.DigesterFactory;
import org.apache.catalina.startup.ExpandWar;
import org.apache.catalina.startup.NamingRuleSet;
import org.apache.catalina.startup.WebAnnotationSet;
import org.apache.catalina.startup.WebRuleSet;
import org.apache.catalina.startup.XmlErrorHandler;
import org.apache.catalina.util.ContextName;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.resources.DirContextURLConnection;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.bcel.classfile.AnnotationElementValue;
import org.apache.tomcat.util.bcel.classfile.AnnotationEntry;
import org.apache.tomcat.util.bcel.classfile.ArrayElementValue;
import org.apache.tomcat.util.bcel.classfile.ClassFormatException;
import org.apache.tomcat.util.bcel.classfile.ClassParser;
import org.apache.tomcat.util.bcel.classfile.ElementValue;
import org.apache.tomcat.util.bcel.classfile.ElementValuePair;
import org.apache.tomcat.util.bcel.classfile.JavaClass;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.res.StringManager;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ContextConfig
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(ContextConfig.class);
    private static final String SCI_LOCATION = "META-INF/services/javax.servlet.ServletContainerInitializer";
    protected Map<String, Authenticator> customAuthenticators;
    protected static Properties authenticators = null;
    protected Context context = null;
    protected String defaultContextXml = null;
    protected String defaultWebXml = null;
    protected boolean ok = false;
    protected String originalDocBase = null;
    protected Map<ServletContainerInitializer, Set<Class<?>>> initializerClassMap = new LinkedHashMap();
    protected Map<Class<?>, Set<ServletContainerInitializer>> typeInitializerMap = new HashMap();
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");
    protected static Digester contextDigester = null;
    protected Digester webDigester = null;
    protected Digester webFragmentDigester = null;
    protected static Digester[] webDigesters = new Digester[4];
    protected static Digester[] webFragmentDigesters = new Digester[4];
    protected static WebRuleSet webRuleSet = new WebRuleSet(false);
    protected static WebRuleSet webFragmentRuleSet = new WebRuleSet(true);
    protected static long deploymentCount = 0L;
    protected static final LoginConfig DUMMY_LOGIN_CONFIG = new LoginConfig("NONE", null, null, null);

    public String getDefaultWebXml() {
        if (this.defaultWebXml == null) {
            this.defaultWebXml = "conf/web.xml";
        }
        return this.defaultWebXml;
    }

    public void setDefaultWebXml(String path) {
        this.defaultWebXml = path;
    }

    public String getDefaultContextXml() {
        if (this.defaultContextXml == null) {
            this.defaultContextXml = "conf/context.xml";
        }
        return this.defaultContextXml;
    }

    public void setDefaultContextXml(String path) {
        this.defaultContextXml = path;
    }

    public void setCustomAuthenticators(Map<String, Authenticator> customAuthenticators) {
        this.customAuthenticators = customAuthenticators;
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        try {
            this.context = (Context)event.getLifecycle();
        }
        catch (ClassCastException e) {
            log.error((Object)sm.getString("contextConfig.cce", event.getLifecycle()), (Throwable)e);
            return;
        }
        if (event.getType().equals("configure_start")) {
            this.configureStart();
        } else if (event.getType().equals("before_start")) {
            this.beforeStart();
        } else if (event.getType().equals("after_start")) {
            if (this.originalDocBase != null) {
                String docBase = this.context.getDocBase();
                this.context.setDocBase(this.originalDocBase);
                this.originalDocBase = docBase;
            }
        } else if (event.getType().equals("configure_stop")) {
            if (this.originalDocBase != null) {
                String docBase = this.context.getDocBase();
                this.context.setDocBase(this.originalDocBase);
                this.originalDocBase = docBase;
            }
            this.configureStop();
        } else if (event.getType().equals("after_init")) {
            this.init();
        } else if (event.getType().equals("after_destroy")) {
            this.destroy();
        }
    }

    protected void applicationAnnotationsConfig() {
        long t1 = System.currentTimeMillis();
        WebAnnotationSet.loadApplicationAnnotations(this.context);
        long t2 = System.currentTimeMillis();
        if (this.context instanceof StandardContext) {
            ((StandardContext)this.context).setStartupTime(t2 - t1 + ((StandardContext)this.context).getStartupTime());
        }
    }

    protected synchronized void authenticatorConfig() {
        Pipeline pipeline;
        SecurityConstraint[] constraints = this.context.findConstraints();
        if (constraints == null || constraints.length == 0) {
            return;
        }
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig == null) {
            loginConfig = DUMMY_LOGIN_CONFIG;
            this.context.setLoginConfig(loginConfig);
        }
        if (this.context.getAuthenticator() != null) {
            return;
        }
        if (!(this.context instanceof ContainerBase)) {
            return;
        }
        if (this.context.getRealm() == null) {
            log.error((Object)sm.getString("contextConfig.missingRealm"));
            this.ok = false;
            return;
        }
        Valve authenticator = null;
        if (this.customAuthenticators != null) {
            authenticator = (Valve)((Object)this.customAuthenticators.get(loginConfig.getAuthMethod()));
        }
        if (authenticator == null) {
            if (authenticators == null) {
                try {
                    InputStream is = this.getClass().getClassLoader().getResourceAsStream("org/apache/catalina/startup/Authenticators.properties");
                    if (is == null) {
                        log.error((Object)sm.getString("contextConfig.authenticatorResources"));
                        this.ok = false;
                        return;
                    }
                    authenticators = new Properties();
                    authenticators.load(is);
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("contextConfig.authenticatorResources"), (Throwable)e);
                    this.ok = false;
                    return;
                }
            }
            String authenticatorName = null;
            authenticatorName = authenticators.getProperty(loginConfig.getAuthMethod());
            if (authenticatorName == null) {
                log.error((Object)sm.getString("contextConfig.authenticatorMissing", loginConfig.getAuthMethod()));
                this.ok = false;
                return;
            }
            try {
                Class<?> authenticatorClass = Class.forName(authenticatorName);
                authenticator = (Valve)authenticatorClass.newInstance();
            }
            catch (Throwable t) {
                ExceptionUtils.handleThrowable(t);
                log.error((Object)sm.getString("contextConfig.authenticatorInstantiate", authenticatorName), t);
                this.ok = false;
            }
        }
        if (authenticator != null && this.context instanceof ContainerBase && (pipeline = ((ContainerBase)((Object)this.context)).getPipeline()) != null) {
            ((ContainerBase)((Object)this.context)).getPipeline().addValve(authenticator);
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextConfig.authenticatorConfigured", loginConfig.getAuthMethod()));
            }
        }
    }

    public void createWebXmlDigester(boolean namespaceAware, boolean validation) {
        if (!namespaceAware && !validation) {
            if (webDigesters[0] == null) {
                ContextConfig.webDigesters[0] = DigesterFactory.newDigester(validation, namespaceAware, webRuleSet);
                ContextConfig.webFragmentDigesters[0] = DigesterFactory.newDigester(validation, namespaceAware, webFragmentRuleSet);
            }
            this.webDigester = webDigesters[0];
            this.webFragmentDigester = webFragmentDigesters[0];
        } else if (!namespaceAware && validation) {
            if (webDigesters[1] == null) {
                ContextConfig.webDigesters[1] = DigesterFactory.newDigester(validation, namespaceAware, webRuleSet);
                ContextConfig.webFragmentDigesters[1] = DigesterFactory.newDigester(validation, namespaceAware, webFragmentRuleSet);
            }
            this.webDigester = webDigesters[1];
            this.webFragmentDigester = webFragmentDigesters[1];
        } else if (namespaceAware && !validation) {
            if (webDigesters[2] == null) {
                ContextConfig.webDigesters[2] = DigesterFactory.newDigester(validation, namespaceAware, webRuleSet);
                ContextConfig.webFragmentDigesters[2] = DigesterFactory.newDigester(validation, namespaceAware, webFragmentRuleSet);
            }
            this.webDigester = webDigesters[2];
            this.webFragmentDigester = webFragmentDigesters[2];
        } else {
            if (webDigesters[3] == null) {
                ContextConfig.webDigesters[3] = DigesterFactory.newDigester(validation, namespaceAware, webRuleSet);
                ContextConfig.webFragmentDigesters[3] = DigesterFactory.newDigester(validation, namespaceAware, webFragmentRuleSet);
            }
            this.webDigester = webDigesters[3];
            this.webFragmentDigester = webFragmentDigesters[3];
        }
    }

    protected Digester createContextDigester() {
        Digester digester = new Digester();
        digester.setValidating(false);
        digester.setRulesValidation(true);
        HashMap fakeAttributes = new HashMap();
        ArrayList<String> attrs = new ArrayList<String>();
        attrs.add("className");
        fakeAttributes.put(Object.class, attrs);
        digester.setFakeAttributes(fakeAttributes);
        ContextRuleSet contextRuleSet = new ContextRuleSet("", false);
        digester.addRuleSet(contextRuleSet);
        NamingRuleSet namingRuleSet = new NamingRuleSet("Context/");
        digester.addRuleSet(namingRuleSet);
        return digester;
    }

    protected String getBaseDir() {
        Container engineC = this.context.getParent().getParent();
        if (engineC instanceof StandardEngine) {
            return ((StandardEngine)engineC).getBaseDir();
        }
        return System.getProperty("catalina.base");
    }

    protected void contextConfig() {
        if (this.defaultContextXml == null && this.context instanceof StandardContext) {
            this.defaultContextXml = ((StandardContext)this.context).getDefaultContextXml();
        }
        if (this.defaultContextXml == null) {
            this.getDefaultContextXml();
        }
        if (!this.context.getOverride()) {
            File hostContextFile;
            File defaultContextFile = new File(this.defaultContextXml);
            if (!defaultContextFile.isAbsolute()) {
                defaultContextFile = new File(this.getBaseDir(), this.defaultContextXml);
            }
            if (defaultContextFile.exists()) {
                try {
                    URL defaultContextUrl = defaultContextFile.toURI().toURL();
                    this.processContextConfig(defaultContextUrl);
                }
                catch (MalformedURLException e) {
                    log.error((Object)sm.getString("contextConfig.badUrl", defaultContextFile), (Throwable)e);
                }
            }
            if ((hostContextFile = new File(this.getConfigBase(), this.getHostConfigPath("context.xml.default"))).exists()) {
                try {
                    URL hostContextUrl = hostContextFile.toURI().toURL();
                    this.processContextConfig(hostContextUrl);
                }
                catch (MalformedURLException e) {
                    log.error((Object)sm.getString("contextConfig.badUrl", hostContextFile), (Throwable)e);
                }
            }
        }
        if (this.context.getConfigFile() != null) {
            this.processContextConfig(this.context.getConfigFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContextConfig(URL contextXml) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing context [" + this.context.getName() + "] configuration file [" + contextXml + "]"));
        }
        InputSource source = null;
        InputStream stream = null;
        try {
            source = new InputSource(contextXml.toString());
            stream = contextXml.openStream();
            if (contextXml.getProtocol() == "file") {
                this.context.addWatchedResource(new File(contextXml.toURI()).getAbsolutePath());
            }
        }
        catch (Exception e) {
            log.error((Object)sm.getString("contextConfig.contextMissing", contextXml), (Throwable)e);
        }
        if (source == null) {
            return;
        }
        Digester digester = contextDigester;
        synchronized (digester) {
            try {
                source.setByteStream(stream);
                contextDigester.setClassLoader(this.getClass().getClassLoader());
                contextDigester.setUseContextClassLoader(false);
                contextDigester.push(this.context.getParent());
                contextDigester.push(this.context);
                XmlErrorHandler errorHandler = new XmlErrorHandler();
                contextDigester.setErrorHandler(errorHandler);
                contextDigester.parse(source);
                if (errorHandler.getWarnings().size() > 0 || errorHandler.getErrors().size() > 0) {
                    errorHandler.logFindings(log, contextXml.toString());
                    this.ok = false;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Successfully processed context [" + this.context.getName() + "] configuration file [" + contextXml + "]"));
                }
            }
            catch (SAXParseException e) {
                log.error((Object)sm.getString("contextConfig.contextParse", this.context.getName()), (Throwable)e);
                log.error((Object)sm.getString("contextConfig.defaultPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                this.ok = false;
            }
            catch (Exception e) {
                log.error((Object)sm.getString("contextConfig.contextParse", this.context.getName()), (Throwable)e);
                this.ok = false;
            }
            finally {
                contextDigester.reset();
                try {
                    if (stream != null) {
                        stream.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("contextConfig.contextClose"), (Throwable)e);
                }
            }
        }
    }

    protected void fixDocBase() throws IOException {
        File file;
        File canonicalAppBase;
        Host host = (Host)this.context.getParent();
        String appBase = host.getAppBase();
        boolean unpackWARs = true;
        if (host instanceof StandardHost) {
            unpackWARs = ((StandardHost)host).isUnpackWARs() && ((StandardContext)this.context).getUnpackWAR();
        }
        canonicalAppBase = (canonicalAppBase = new File(appBase)).isAbsolute() ? canonicalAppBase.getCanonicalFile() : new File(System.getProperty("catalina.base"), appBase).getCanonicalFile();
        String docBase = this.context.getDocBase();
        if (docBase == null) {
            String path = this.context.getPath();
            if (path == null) {
                return;
            }
            ContextName cn = new ContextName(path, this.context.getWebappVersion());
            docBase = cn.getBaseName();
        }
        docBase = !(file = new File(docBase)).isAbsolute() ? new File(canonicalAppBase, docBase).getPath() : file.getCanonicalPath();
        file = new File(docBase);
        String origDocBase = docBase;
        ContextName cn = new ContextName(this.context.getPath(), this.context.getWebappVersion());
        String pathName = cn.getBaseName();
        if (docBase.toLowerCase(Locale.ENGLISH).endsWith(".war") && !file.isDirectory() && unpackWARs) {
            URL war = new URL("jar:" + new File(docBase).toURI().toURL() + "!/");
            docBase = ExpandWar.expand(host, war, pathName);
            file = new File(docBase);
            docBase = file.getCanonicalPath();
            if (this.context instanceof StandardContext) {
                ((StandardContext)this.context).setOriginalDocBase(origDocBase);
            }
        } else if (docBase.toLowerCase(Locale.ENGLISH).endsWith(".war") && !file.isDirectory() && !unpackWARs) {
            URL war = new URL("jar:" + new File(docBase).toURI().toURL() + "!/");
            ExpandWar.validate(host, war, pathName);
        } else {
            File docDir = new File(docBase);
            if (!docDir.exists()) {
                File warFile = new File(docBase + ".war");
                if (warFile.exists()) {
                    URL war = new URL("jar:" + warFile.toURI().toURL() + "!/");
                    if (unpackWARs) {
                        docBase = ExpandWar.expand(host, war, pathName);
                        file = new File(docBase);
                        docBase = file.getCanonicalPath();
                    } else {
                        docBase = warFile.getCanonicalPath();
                        ExpandWar.validate(host, war, pathName);
                    }
                }
                if (this.context instanceof StandardContext) {
                    ((StandardContext)this.context).setOriginalDocBase(origDocBase);
                }
            }
        }
        if (docBase.startsWith(canonicalAppBase.getPath() + File.separatorChar)) {
            docBase = docBase.substring(canonicalAppBase.getPath().length());
            if ((docBase = docBase.replace(File.separatorChar, '/')).startsWith("/")) {
                docBase = docBase.substring(1);
            }
        } else {
            docBase = docBase.replace(File.separatorChar, '/');
        }
        this.context.setDocBase(docBase);
    }

    protected void antiLocking() {
        if (this.context instanceof StandardContext && ((StandardContext)this.context).getAntiResourceLocking()) {
            String path;
            Host host = (Host)this.context.getParent();
            String appBase = host.getAppBase();
            String docBase = this.context.getDocBase();
            if (docBase == null) {
                return;
            }
            if (this.originalDocBase == null) {
                this.originalDocBase = docBase;
            } else {
                docBase = this.originalDocBase;
            }
            File docBaseFile = new File(docBase);
            if (!docBaseFile.isAbsolute()) {
                File file = new File(appBase);
                if (!file.isAbsolute()) {
                    file = new File(System.getProperty("catalina.base"), appBase);
                }
                docBaseFile = new File(file, docBase);
            }
            if ((path = this.context.getPath()) == null) {
                return;
            }
            ContextName cn = new ContextName(path, this.context.getWebappVersion());
            docBase = cn.getBaseName();
            File file = null;
            file = docBase.toLowerCase(Locale.ENGLISH).endsWith(".war") ? new File(System.getProperty("java.io.tmpdir"), deploymentCount++ + "-" + docBase + ".war") : new File(System.getProperty("java.io.tmpdir"), deploymentCount++ + "-" + docBase);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Anti locking context[" + this.context.getName() + "] setting docBase to " + file));
            }
            ExpandWar.delete(file);
            if (ExpandWar.copy(docBaseFile, file)) {
                this.context.setDocBase(file.getAbsolutePath());
            }
        }
    }

    protected void init() {
        if (contextDigester == null) {
            contextDigester = this.createContextDigester();
            contextDigester.getParser();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.init"));
        }
        this.context.setConfigured(false);
        this.ok = true;
        this.contextConfig();
        try {
            this.fixDocBase();
        }
        catch (IOException e) {
            log.error((Object)sm.getString("contextConfig.fixDocBase", this.context.getName()), (Throwable)e);
        }
    }

    protected synchronized void beforeStart() {
        this.antiLocking();
    }

    protected synchronized void configureStart() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.start"));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.xmlSettings", this.context.getName(), this.context.getXmlValidation(), this.context.getXmlNamespaceAware()));
        }
        this.createWebXmlDigester(this.context.getXmlNamespaceAware(), this.context.getXmlValidation());
        this.webConfig();
        if (!this.context.getIgnoreAnnotations()) {
            this.applicationAnnotationsConfig();
        }
        if (this.ok) {
            this.validateSecurityRoles();
        }
        if (this.ok) {
            this.authenticatorConfig();
        }
        if (log.isDebugEnabled() && this.context instanceof ContainerBase) {
            log.debug((Object)"Pipeline Configuration:");
            Pipeline pipeline = ((ContainerBase)((Object)this.context)).getPipeline();
            Valve[] valves = null;
            if (pipeline != null) {
                valves = pipeline.getValves();
            }
            if (valves != null) {
                for (int i = 0; i < valves.length; ++i) {
                    log.debug((Object)("  " + valves[i].getInfo()));
                }
            }
            log.debug((Object)"======================");
        }
        if (this.ok) {
            this.context.setConfigured(true);
        } else {
            log.error((Object)sm.getString("contextConfig.unavailable"));
            this.context.setConfigured(false);
        }
    }

    protected synchronized void configureStop() {
        int i;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.stop"));
        }
        Container[] children = this.context.findChildren();
        for (i = 0; i < children.length; ++i) {
            this.context.removeChild(children[i]);
        }
        SecurityConstraint[] securityConstraints = this.context.findConstraints();
        for (i = 0; i < securityConstraints.length; ++i) {
            this.context.removeConstraint(securityConstraints[i]);
        }
        ErrorPage[] errorPages = this.context.findErrorPages();
        for (i = 0; i < errorPages.length; ++i) {
            this.context.removeErrorPage(errorPages[i]);
        }
        FilterDef[] filterDefs = this.context.findFilterDefs();
        for (i = 0; i < filterDefs.length; ++i) {
            this.context.removeFilterDef(filterDefs[i]);
        }
        FilterMap[] filterMaps = this.context.findFilterMaps();
        for (i = 0; i < filterMaps.length; ++i) {
            this.context.removeFilterMap(filterMaps[i]);
        }
        String[] mimeMappings = this.context.findMimeMappings();
        for (i = 0; i < mimeMappings.length; ++i) {
            this.context.removeMimeMapping(mimeMappings[i]);
        }
        String[] parameters = this.context.findParameters();
        for (i = 0; i < parameters.length; ++i) {
            this.context.removeParameter(parameters[i]);
        }
        String[] securityRoles = this.context.findSecurityRoles();
        for (i = 0; i < securityRoles.length; ++i) {
            this.context.removeSecurityRole(securityRoles[i]);
        }
        String[] servletMappings = this.context.findServletMappings();
        for (i = 0; i < servletMappings.length; ++i) {
            this.context.removeServletMapping(servletMappings[i]);
        }
        String[] welcomeFiles = this.context.findWelcomeFiles();
        for (i = 0; i < welcomeFiles.length; ++i) {
            this.context.removeWelcomeFile(welcomeFiles[i]);
        }
        String[] wrapperLifecycles = this.context.findWrapperLifecycles();
        for (i = 0; i < wrapperLifecycles.length; ++i) {
            this.context.removeWrapperLifecycle(wrapperLifecycles[i]);
        }
        String[] wrapperListeners = this.context.findWrapperListeners();
        for (i = 0; i < wrapperListeners.length; ++i) {
            this.context.removeWrapperListener(wrapperListeners[i]);
        }
        Host host = (Host)this.context.getParent();
        String appBase = host.getAppBase();
        String docBase = this.context.getDocBase();
        if (docBase != null && this.originalDocBase != null) {
            File docBaseFile = new File(docBase);
            if (!docBaseFile.isAbsolute()) {
                docBaseFile = new File(appBase, docBase);
            }
            ExpandWar.delete(docBaseFile, false);
        }
        this.initializerClassMap.clear();
        this.typeInitializerMap.clear();
        this.ok = true;
    }

    protected synchronized void destroy() {
        String workDir;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("contextConfig.destroy"));
        }
        if ((workDir = ((StandardContext)this.context).getWorkPath()) != null) {
            ExpandWar.delete(new File(workDir));
        }
    }

    protected void validateSecurityRoles() {
        SecurityConstraint[] constraints = this.context.findConstraints();
        for (int i = 0; i < constraints.length; ++i) {
            String[] roles = constraints[i].findAuthRoles();
            for (int j = 0; j < roles.length; ++j) {
                if ("*".equals(roles[j]) || this.context.findSecurityRole(roles[j])) continue;
                log.info((Object)sm.getString("contextConfig.role.auth", roles[j]));
                this.context.addSecurityRole(roles[j]);
            }
        }
        Container[] wrappers = this.context.findChildren();
        for (int i = 0; i < wrappers.length; ++i) {
            Wrapper wrapper = (Wrapper)wrappers[i];
            String runAs = wrapper.getRunAs();
            if (runAs != null && !this.context.findSecurityRole(runAs)) {
                log.info((Object)sm.getString("contextConfig.role.runas", runAs));
                this.context.addSecurityRole(runAs);
            }
            String[] names = wrapper.findSecurityReferences();
            for (int j = 0; j < names.length; ++j) {
                String link = wrapper.findSecurityReference(names[j]);
                if (link == null || this.context.findSecurityRole(link)) continue;
                log.info((Object)sm.getString("contextConfig.role.link", link));
                this.context.addSecurityRole(link);
            }
        }
    }

    protected File getConfigBase() {
        File configBase = new File(System.getProperty("catalina.base"), "conf");
        if (!configBase.exists()) {
            return null;
        }
        return configBase;
    }

    protected String getHostConfigPath(String resourceName) {
        StringBuilder result = new StringBuilder();
        Context host = null;
        Container engine = null;
        for (Container container = this.context; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            result.append(engine.getName()).append('/');
        }
        if (host != null) {
            result.append(host.getName()).append('/');
        }
        result.append(resourceName);
        return result.toString();
    }

    protected void webConfig() {
        WebXml webXml = this.createWebXml();
        InputSource globalWebXml = this.getGlobalWebXmlSource();
        if (globalWebXml == null) {
            log.info((Object)sm.getString("contextConfig.defaultMissing"));
        } else {
            this.parseWebXml(globalWebXml, webXml, false);
        }
        webXml.setReplaceWelcomeFiles(true);
        InputSource hostWebXml = this.getHostWebXmlSource();
        this.parseWebXml(hostWebXml, webXml, false);
        webXml.setReplaceWelcomeFiles(true);
        InputSource contextWebXml = this.getContextWebXmlSource();
        this.parseWebXml(contextWebXml, webXml, false);
        double webXmlVersion = 0.0;
        if (webXml.getVersion() != null) {
            webXmlVersion = Double.parseDouble(webXml.getVersion());
        }
        if (webXmlVersion >= 3.0) {
            Map<String, WebXml> fragments = this.processJarsForWebFragments();
            Set<WebXml> orderedFragments = null;
            if (!webXml.isMetadataComplete()) {
                orderedFragments = WebXml.orderWebFragments(webXml, fragments);
                this.ok = this.processServletContainerInitializers(orderedFragments);
                if (this.ok) {
                    try {
                        URL webinfClasses = this.context.getServletContext().getResource("/WEB-INF/classes");
                        this.processAnnotationsUrl(webinfClasses, webXml);
                    }
                    catch (MalformedURLException e) {
                        log.error((Object)sm.getString("contextConfig.webinfClassesUrl"), (Throwable)e);
                    }
                }
                if (this.ok) {
                    this.processAnnotations(orderedFragments);
                }
                if (this.ok) {
                    this.ok = webXml.merge(orderedFragments);
                }
                this.convertJsps(webXml);
                if (this.ok) {
                    webXml.configureContext(this.context);
                    String mergedWebXml = webXml.toXml();
                    this.context.getServletContext().setAttribute("org.apache.tomcat.util.scan.MergedWebXml", mergedWebXml);
                    if (this.context.getLogEffectiveWebXml()) {
                        log.info((Object)("web.xml:\n" + mergedWebXml));
                    }
                }
            } else {
                webXml.configureContext(this.context);
                this.ok = true;
            }
            if (this.ok) {
                LinkedHashSet<WebXml> resourceJars = new LinkedHashSet<WebXml>();
                if (orderedFragments != null) {
                    for (WebXml fragment : orderedFragments) {
                        resourceJars.add(fragment);
                    }
                }
                for (WebXml fragment : fragments.values()) {
                    if (resourceJars.contains(fragment)) continue;
                    resourceJars.add(fragment);
                }
                this.processResourceJARs(resourceJars);
            }
            if (!webXml.isMetadataComplete() && this.ok) {
                for (Map.Entry<ServletContainerInitializer, Set<Class<?>>> entry : this.initializerClassMap.entrySet()) {
                    if (entry.getValue().isEmpty()) {
                        this.context.addServletContainerInitializer(entry.getKey(), null);
                        continue;
                    }
                    this.context.addServletContainerInitializer(entry.getKey(), entry.getValue());
                }
            }
        } else {
            this.convertJsps(webXml);
            webXml.configureContext(this.context);
        }
    }

    private void convertJsps(WebXml webXml) {
        ServletDef jspServlet = webXml.getServlets().get("jsp");
        for (ServletDef servletDef : webXml.getServlets().values()) {
            if (servletDef.getJspFile() == null) continue;
            this.convertJsp(servletDef, jspServlet);
        }
    }

    private void convertJsp(ServletDef servletDef, ServletDef jspServletDef) {
        servletDef.setServletClass("org.apache.jasper.servlet.JspServlet");
        String jspFile = servletDef.getJspFile();
        servletDef.getParameterMap().put("jspFile", jspFile);
        if (jspFile != null && !jspFile.startsWith("/")) {
            if (this.context.isServlet22()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("standardContext.wrapper.warning", jspFile));
                }
                jspFile = "/" + jspFile;
            } else {
                throw new IllegalArgumentException(sm.getString("standardContext.wrapper.error", jspFile));
            }
        }
        servletDef.setJspFile(null);
        for (Map.Entry<String, String> initParam : jspServletDef.getParameterMap().entrySet()) {
            servletDef.addInitParameter(initParam.getKey(), initParam.getValue());
        }
    }

    protected WebXml createWebXml() {
        return new WebXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processServletContainerInitializers(Set<WebXml> fragments) {
        for (WebXml fragment : fragments) {
            Class[] types;
            URL url = fragment.getURL();
            ZipFile jarFile = null;
            InputStream is = null;
            ServletContainerInitializer sci = null;
            try {
                String path;
                File file;
                if ("jar".equals(url.getProtocol())) {
                    JarURLConnection conn = (JarURLConnection)url.openConnection();
                    jarFile = conn.getJarFile();
                    ZipEntry entry = ((JarFile)jarFile).getEntry(SCI_LOCATION);
                    if (entry != null) {
                        is = ((JarFile)jarFile).getInputStream(entry);
                    }
                } else if ("file".equals(url.getProtocol()) && (file = new File(path = url.getPath(), SCI_LOCATION)).exists()) {
                    is = new FileInputStream(file);
                }
                if (is != null) {
                    sci = this.getServletContainerInitializer(is);
                }
            }
            catch (IOException ioe) {
                log.error((Object)sm.getString("contextConfig.servletContainerInitializerFail", url, this.context.getName()));
                boolean file = false;
                return file;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (sci == null) continue;
            this.initializerClassMap.put(sci, new HashSet());
            HandlesTypes ht = sci.getClass().getAnnotation(HandlesTypes.class);
            if (ht == null || (types = ht.value()) == null) continue;
            for (Class type : types) {
                Set<ServletContainerInitializer> scis = this.typeInitializerMap.get(type);
                if (scis == null) {
                    scis = new HashSet<ServletContainerInitializer>();
                    this.typeInitializerMap.put(type, scis);
                }
                scis.add(sci);
            }
        }
        return true;
    }

    protected ServletContainerInitializer getServletContainerInitializer(InputStream is) throws IOException {
        String className = null;
        if (is != null) {
            String line = null;
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                line = br.readLine();
                if (line != null && line.trim().length() > 0) {
                    className = line.trim();
                }
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        ServletContainerInitializer sci = null;
        try {
            Class<?> clazz = Class.forName(className, true, this.context.getLoader().getClassLoader());
            sci = (ServletContainerInitializer)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)sm.getString("contextConfig.invalidSci", className), (Throwable)e);
            throw new IOException(e);
        }
        catch (InstantiationException e) {
            log.error((Object)sm.getString("contextConfig.invalidSci", className), (Throwable)e);
            throw new IOException(e);
        }
        catch (IllegalAccessException e) {
            log.error((Object)sm.getString("contextConfig.invalidSci", className), (Throwable)e);
            throw new IOException(e);
        }
        return sci;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processResourceJARs(Set<WebXml> fragments) {
        for (WebXml fragment : fragments) {
            URL url = fragment.getURL();
            ZipFile jarFile = null;
            try {
                JarURLConnection conn;
                ZipEntry entry;
                if (!"jar".equals(url.getProtocol()) || (entry = ((JarFile)(jarFile = (conn = (JarURLConnection)url.openConnection()).getJarFile())).getEntry("META-INF/resources/")) == null) continue;
                this.context.addResourceJarUrl(url);
            }
            catch (IOException ioe) {
                log.error((Object)sm.getString("contextConfig.resourceJarFail", url, this.context.getName()));
            }
            finally {
                if (jarFile == null) continue;
                try {
                    jarFile.close();
                }
                catch (IOException e) {}
            }
        }
    }

    protected InputSource getGlobalWebXmlSource() {
        if (this.defaultWebXml == null && this.context instanceof StandardContext) {
            this.defaultWebXml = ((StandardContext)this.context).getDefaultWebXml();
        }
        if (this.defaultWebXml == null) {
            this.getDefaultWebXml();
        }
        return this.getWebXmlSource(this.defaultWebXml, this.getBaseDir());
    }

    protected InputSource getHostWebXmlSource() {
        String resourceName = this.getHostConfigPath("web.xml.default");
        File configBase = this.getConfigBase();
        if (configBase == null) {
            return null;
        }
        String basePath = null;
        try {
            basePath = configBase.getCanonicalPath();
        }
        catch (IOException e) {
            log.error((Object)sm.getString("contectConfig.baseError"), (Throwable)e);
            return null;
        }
        return this.getWebXmlSource(resourceName, basePath);
    }

    protected InputSource getContextWebXmlSource() {
        InputStream stream = null;
        InputSource source = null;
        URL url = null;
        String altDDName = null;
        ServletContext servletContext = this.context.getServletContext();
        if (servletContext != null) {
            altDDName = (String)servletContext.getAttribute("org.apache.catalina.deploy.alt_dd");
            if (altDDName != null) {
                try {
                    stream = new FileInputStream(altDDName);
                    url = new File(altDDName).toURI().toURL();
                }
                catch (FileNotFoundException e) {
                    log.error((Object)sm.getString("contextConfig.altDDNotFound", altDDName));
                }
                catch (MalformedURLException e) {
                    log.error((Object)sm.getString("contextConfig.applicationUrl"));
                }
            } else {
                stream = servletContext.getResourceAsStream("/WEB-INF/web.xml");
                try {
                    url = servletContext.getResource("/WEB-INF/web.xml");
                }
                catch (MalformedURLException e) {
                    log.error((Object)sm.getString("contextConfig.applicationUrl"));
                }
            }
        }
        if (stream == null || url == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(sm.getString("contextConfig.applicationMissing") + " " + this.context));
            }
        } else {
            source = new InputSource(url.toExternalForm());
            source.setByteStream(stream);
        }
        return source;
    }

    protected InputSource getWebXmlSource(String filename, String path) {
        File file = new File(filename);
        if (!file.isAbsolute()) {
            file = new File(path, filename);
        }
        InputStream stream = null;
        InputSource source = null;
        try {
            if (!file.exists()) {
                stream = this.getClass().getClassLoader().getResourceAsStream(filename);
                if (stream != null) {
                    source = new InputSource(this.getClass().getClassLoader().getResource(filename).toString());
                }
            } else {
                source = new InputSource("file://" + file.getAbsolutePath());
                stream = new FileInputStream(file);
                this.context.addWatchedResource(file.getAbsolutePath());
            }
            if (stream != null && source != null) {
                source.setByteStream(stream);
            }
        }
        catch (Exception e) {
            log.error((Object)sm.getString("contextConfig.defaultError", filename, file), (Throwable)e);
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseWebXml(InputSource source, WebXml dest, boolean fragment) {
        if (source == null) {
            return;
        }
        XmlErrorHandler handler = new XmlErrorHandler();
        Digester digester = fragment ? this.webFragmentDigester : this.webDigester;
        Digester digester2 = digester;
        synchronized (digester2) {
            digester.push(dest);
            digester.setErrorHandler(handler);
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("contextConfig.applicationStart", source.getSystemId()));
            }
            try {
                digester.parse(source);
                if (handler.getWarnings().size() > 0 || handler.getErrors().size() > 0) {
                    this.ok = false;
                    handler.logFindings(log, source.getSystemId());
                }
            }
            catch (SAXParseException e) {
                log.error((Object)sm.getString("contextConfig.applicationParse", source.getSystemId()), (Throwable)e);
                log.error((Object)sm.getString("contextConfig.applicationPosition", "" + e.getLineNumber(), "" + e.getColumnNumber()));
                this.ok = false;
            }
            catch (Exception e) {
                log.error((Object)sm.getString("contextConfig.applicationParse", source.getSystemId()), (Throwable)e);
                this.ok = false;
            }
            finally {
                digester.reset();
                if (fragment) {
                    webFragmentRuleSet.recycle();
                } else {
                    webRuleSet.recycle();
                }
            }
        }
    }

    protected Map<String, WebXml> processJarsForWebFragments() {
        JarScanner jarScanner = this.context.getJarScanner();
        FragmentJarScannerCallback callback = new FragmentJarScannerCallback();
        jarScanner.scan(this.context.getServletContext(), this.context.getLoader().getClassLoader(), callback, null);
        return callback.getFragments();
    }

    protected void processAnnotations(Set<WebXml> fragments) {
        for (WebXml fragment : fragments) {
            if (fragment.isMetadataComplete()) continue;
            WebXml annotations = new WebXml();
            annotations.setDistributable(true);
            URL url = fragment.getURL();
            this.processAnnotationsUrl(url, annotations);
            HashSet<WebXml> set = new HashSet<WebXml>();
            set.add(annotations);
            fragment.merge(set);
        }
    }

    protected void processAnnotationsUrl(URL url, WebXml fragment) {
        if (url == null) {
            return;
        }
        if ("jar".equals(url.getProtocol())) {
            this.processAnnotationsJar(url, fragment);
        } else if ("jndi".equals(url.getProtocol())) {
            this.processAnnotationsJndi(url, fragment);
        } else if ("file".equals(url.getProtocol())) {
            try {
                this.processAnnotationsFile(new File(url.toURI()), fragment);
            }
            catch (URISyntaxException e) {
                log.error((Object)sm.getString("contextConfig.fileUrl", url), (Throwable)e);
            }
        } else {
            log.error((Object)sm.getString("contextConfig.unknownUrlProtocol", url.getProtocol(), url));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAnnotationsJar(URL url, WebXml fragment) {
        ZipFile jarFile = null;
        try {
            URLConnection urlConn = url.openConnection();
            if (!(urlConn instanceof JarURLConnection)) {
                sm.getString("contextConfig.jarUrl", url);
                return;
            }
            JarURLConnection jarUrlConn = (JarURLConnection)urlConn;
            jarUrlConn.setUseCaches(false);
            jarFile = jarUrlConn.getJarFile();
            Enumeration<JarEntry> jarEntries = ((JarFile)jarFile).entries();
            while (jarEntries.hasMoreElements()) {
                JarEntry jarEntry = jarEntries.nextElement();
                String entryName = jarEntry.getName();
                if (!entryName.endsWith(".class")) continue;
                InputStream is = null;
                try {
                    is = ((JarFile)jarFile).getInputStream(jarEntry);
                    this.processAnnotationsStream(is, fragment);
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("contextConfig.inputStreamJar", entryName, url), (Throwable)e);
                }
                finally {
                    if (is == null) continue;
                    try {
                        is.close();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                    }
                }
            }
        }
        catch (IOException e) {
            log.error((Object)sm.getString("contextConfig.jarFile", url), (Throwable)e);
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAnnotationsJndi(URL url, WebXml fragment) {
        block17: {
            try {
                URLConnection urlConn = url.openConnection();
                if (!(urlConn instanceof DirContextURLConnection)) {
                    sm.getString("contextConfig.jndiUrlNotDirContextConn", url);
                    return;
                }
                DirContextURLConnection dcUrlConn = (DirContextURLConnection)urlConn;
                dcUrlConn.setUseCaches(false);
                String type = dcUrlConn.getHeaderField("resourcetype");
                if ("<collection/>".equals(type)) {
                    Enumeration<String> dirs = dcUrlConn.list();
                    while (dirs.hasMoreElements()) {
                        String dir = dirs.nextElement();
                        URL dirUrl = new URL(url.toString() + '/' + dir);
                        this.processAnnotationsJndi(dirUrl, fragment);
                    }
                    break block17;
                }
                if (!url.getPath().endsWith(".class")) break block17;
                InputStream is = null;
                try {
                    is = dcUrlConn.getInputStream();
                    this.processAnnotationsStream(is, fragment);
                }
                catch (IOException e) {
                    log.error((Object)sm.getString("contextConfig.inputStreamJndi", url), (Throwable)e);
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable t) {
                            ExceptionUtils.handleThrowable(t);
                        }
                    }
                }
            }
            catch (IOException e) {
                log.error((Object)sm.getString("contextConfig.jndiUrl", url), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAnnotationsFile(File file, WebXml fragment) {
        block14: {
            block13: {
                String[] dirs;
                if (!file.isDirectory()) break block13;
                for (String dir : dirs = file.list()) {
                    this.processAnnotationsFile(new File(file, dir), fragment);
                }
                break block14;
            }
            if (!file.canRead() || !file.getName().endsWith(".class")) break block14;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                this.processAnnotationsStream(fis, fragment);
            }
            catch (IOException e) {
                log.error((Object)sm.getString("contextConfig.inputStreamFile", file.getAbsolutePath()), (Throwable)e);
            }
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                    }
                }
            }
        }
    }

    protected void processAnnotationsStream(InputStream is, WebXml fragment) throws ClassFormatException, IOException {
        AnnotationEntry[] annotationsEntries;
        ClassParser parser = new ClassParser(is, null);
        JavaClass clazz = parser.parse();
        this.checkHandlesTypes(clazz);
        String className = clazz.getClassName();
        for (AnnotationEntry ae : annotationsEntries = clazz.getAnnotationEntries()) {
            String type = ae.getAnnotationType();
            if ("Ljavax/servlet/annotation/WebServlet;".equals(type)) {
                this.processAnnotationWebServlet(className, ae, fragment);
                continue;
            }
            if ("Ljavax/servlet/annotation/WebFilter;".equals(type)) {
                this.processAnnotationWebFilter(className, ae, fragment);
                continue;
            }
            if (!"Ljavax/servlet/annotation/WebListener;".equals(type)) continue;
            fragment.addListener(className);
        }
    }

    protected void checkHandlesTypes(JavaClass javaClass) {
        if (this.typeInitializerMap.size() == 0) {
            return;
        }
        String className = javaClass.getClassName();
        Class<?> clazz = null;
        try {
            clazz = this.context.getLoader().getClassLoader().loadClass(className);
        }
        catch (NoClassDefFoundError e) {
            log.debug((Object)sm.getString("contextConfig.invalidSciHandlesTypes", className), (Throwable)e);
            return;
        }
        catch (ClassNotFoundException e) {
            log.warn((Object)sm.getString("contextConfig.invalidSciHandlesTypes", className), (Throwable)e);
            return;
        }
        catch (ClassFormatError e) {
            log.warn((Object)sm.getString("contextConfig.invalidSciHandlesTypes", className), (Throwable)e);
            return;
        }
        if (clazz.isAnnotation()) {
            return;
        }
        boolean match = false;
        for (Map.Entry<Class<?>, Set<ServletContainerInitializer>> entry : this.typeInitializerMap.entrySet()) {
            if (entry.getKey().isAnnotation()) {
                AnnotationEntry[] annotationEntries;
                for (AnnotationEntry annotationEntry : annotationEntries = javaClass.getAnnotationEntries()) {
                    if (!entry.getKey().getName().equals(ContextConfig.getClassName(annotationEntry.getAnnotationType()))) continue;
                    match = true;
                    break;
                }
            } else if (entry.getKey().isAssignableFrom(clazz)) {
                match = true;
            }
            if (!match) continue;
            for (ServletContainerInitializer sci : entry.getValue()) {
                this.initializerClassMap.get(sci).add(clazz);
            }
        }
    }

    private static final String getClassName(String internalForm) {
        if (!internalForm.startsWith("L")) {
            return internalForm;
        }
        return internalForm.substring(1, internalForm.length() - 1).replace('/', '.');
    }

    protected void processAnnotationWebServlet(String className, AnnotationEntry ae, WebXml fragment) {
        boolean isWebXMLservletDef;
        ServletDef servletDef;
        ElementValuePair[] evps;
        String servletName = null;
        for (ElementValuePair evp : evps = ae.getElementValuePairs()) {
            String name = evp.getNameString();
            if (!"name".equals(name)) continue;
            servletName = evp.getValue().stringifyValue();
            break;
        }
        if (servletName == null) {
            servletName = className;
        }
        if ((servletDef = fragment.getServlets().get(servletName)) == null) {
            servletDef = new ServletDef();
            servletDef.setServletName(servletName);
            servletDef.setServletClass(className);
            isWebXMLservletDef = false;
        } else {
            isWebXMLservletDef = true;
        }
        boolean urlPatternsSet = false;
        String[] urlPatterns = null;
        for (ElementValuePair elementValuePair : evps) {
            String name = elementValuePair.getNameString();
            if ("value".equals(name) || "urlPatterns".equals(name)) {
                if (urlPatternsSet) {
                    throw new IllegalArgumentException(sm.getString("contextConfig.urlPatternValue", className));
                }
                urlPatternsSet = true;
                urlPatterns = this.processAnnotationsStringArray(elementValuePair.getValue());
                continue;
            }
            if ("description".equals(name)) {
                if (servletDef.getDescription() != null) continue;
                servletDef.setDescription(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("displayName".equals(name)) {
                if (servletDef.getDisplayName() != null) continue;
                servletDef.setDisplayName(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("largeIcon".equals(name)) {
                if (servletDef.getLargeIcon() != null) continue;
                servletDef.setLargeIcon(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("smallIcon".equals(name)) {
                if (servletDef.getSmallIcon() != null) continue;
                servletDef.setSmallIcon(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("asyncSupported".equals(name)) {
                if (servletDef.getAsyncSupported() != null) continue;
                servletDef.setAsyncSupported(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if ("loadOnStartup".equals(name)) {
                if (servletDef.getLoadOnStartup() != null) continue;
                servletDef.setLoadOnStartup(elementValuePair.getValue().stringifyValue());
                continue;
            }
            if (!"initParams".equals(name)) continue;
            Map<String, String> initParams = this.processAnnotationWebInitParams(elementValuePair.getValue());
            if (isWebXMLservletDef) {
                Map<String, String> webXMLInitParams = servletDef.getParameterMap();
                for (Map.Entry<String, String> entry : initParams.entrySet()) {
                    if (webXMLInitParams.get(entry.getKey()) != null) continue;
                    servletDef.addInitParameter(entry.getKey(), entry.getValue());
                }
                continue;
            }
            for (Map.Entry<String, String> entry : initParams.entrySet()) {
                servletDef.addInitParameter(entry.getKey(), entry.getValue());
            }
        }
        if (!isWebXMLservletDef && urlPatterns != null) {
            fragment.addServlet(servletDef);
        }
        if (urlPatterns != null && !fragment.getServletMappings().containsValue(servletName)) {
            for (ElementValuePair elementValuePair : urlPatterns) {
                fragment.addServletMapping((String)((Object)elementValuePair), servletName);
            }
        }
    }

    protected void processAnnotationWebFilter(String className, AnnotationEntry ae, WebXml fragment) {
        boolean isWebXMLfilterDef;
        ElementValuePair[] evps;
        String filterName = null;
        for (ElementValuePair evp : evps = ae.getElementValuePairs()) {
            String name = evp.getNameString();
            if (!"filterName".equals(name)) continue;
            filterName = evp.getValue().stringifyValue();
            break;
        }
        if (filterName == null) {
            filterName = className;
        }
        FilterDef filterDef = fragment.getFilters().get(filterName);
        FilterMap filterMap = new FilterMap();
        if (filterDef == null) {
            filterDef = new FilterDef();
            filterDef.setFilterName(filterName);
            filterDef.setFilterClass(className);
            isWebXMLfilterDef = false;
        } else {
            isWebXMLfilterDef = true;
        }
        boolean urlPatternsSet = false;
        boolean dispatchTypesSet = false;
        String[] urlPatterns = null;
        for (ElementValuePair evp : evps) {
            int i$;
            String name = evp.getNameString();
            if ("value".equals(name) || "urlPatterns".equals(name)) {
                if (urlPatternsSet) {
                    throw new IllegalArgumentException(sm.getString("contextConfig.urlPatternValue", className));
                }
                urlPatterns = this.processAnnotationsStringArray(evp.getValue());
                urlPatternsSet = urlPatterns.length > 0;
                for (String urlPattern : urlPatterns) {
                    filterMap.addURLPattern(urlPattern);
                }
                continue;
            }
            if ("servletNames".equals(name)) {
                String[] servletNames;
                String[] arr$ = servletNames = this.processAnnotationsStringArray(evp.getValue());
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String servletName = arr$[i$];
                    filterMap.addServletName(servletName);
                }
                continue;
            }
            if ("dispatcherTypes".equals(name)) {
                String[] dispatcherTypes = this.processAnnotationsStringArray(evp.getValue());
                dispatchTypesSet = dispatcherTypes.length > 0;
                String[] arr$ = dispatcherTypes;
                int len$ = arr$.length;
                for (i$ = 0; i$ < len$; ++i$) {
                    String dispatcherType = arr$[i$];
                    filterMap.setDispatcher(dispatcherType);
                }
                continue;
            }
            if ("description".equals(name)) {
                if (filterDef.getDescription() != null) continue;
                filterDef.setDescription(evp.getValue().stringifyValue());
                continue;
            }
            if ("displayName".equals(name)) {
                if (filterDef.getDisplayName() != null) continue;
                filterDef.setDisplayName(evp.getValue().stringifyValue());
                continue;
            }
            if ("largeIcon".equals(name)) {
                if (filterDef.getLargeIcon() != null) continue;
                filterDef.setLargeIcon(evp.getValue().stringifyValue());
                continue;
            }
            if ("smallIcon".equals(name)) {
                if (filterDef.getSmallIcon() != null) continue;
                filterDef.setSmallIcon(evp.getValue().stringifyValue());
                continue;
            }
            if ("asyncSupported".equals(name)) {
                if (filterDef.getAsyncSupported() != null) continue;
                filterDef.setAsyncSupported(evp.getValue().stringifyValue());
                continue;
            }
            if (!"initParams".equals(name)) continue;
            Map<String, String> initParams = this.processAnnotationWebInitParams(evp.getValue());
            if (isWebXMLfilterDef) {
                Map<String, String> webXMLInitParams = filterDef.getParameterMap();
                for (Map.Entry<String, String> entry : initParams.entrySet()) {
                    if (webXMLInitParams.get(entry.getKey()) != null) continue;
                    filterDef.addInitParameter(entry.getKey(), entry.getValue());
                }
                continue;
            }
            for (Map.Entry<String, String> entry : initParams.entrySet()) {
                filterDef.addInitParameter(entry.getKey(), entry.getValue());
            }
        }
        if (!isWebXMLfilterDef) {
            fragment.addFilter(filterDef);
            filterMap.setFilterName(filterName);
            fragment.addFilterMapping(filterMap);
        }
        if (urlPatternsSet || dispatchTypesSet) {
            Set<FilterMap> fmap = fragment.getFilterMappings();
            FilterMap descMap = null;
            for (FilterMap map : fmap) {
                if (!filterName.equals(map.getFilterName())) continue;
                descMap = map;
                break;
            }
            if (descMap != null) {
                String[] urlsPatterns = descMap.getURLPatterns();
                if (urlPatternsSet && (urlsPatterns == null || urlsPatterns.length == 0)) {
                    for (String urlPattern : filterMap.getURLPatterns()) {
                        descMap.addURLPattern(urlPattern);
                    }
                }
                String[] dispatcherNames = descMap.getDispatcherNames();
                if (dispatchTypesSet && (dispatcherNames == null || dispatcherNames.length == 0)) {
                    for (String dis : filterMap.getDispatcherNames()) {
                        descMap.setDispatcher(dis);
                    }
                }
            }
        }
    }

    protected String[] processAnnotationsStringArray(ElementValue ev) {
        ArrayList<String> values = new ArrayList<String>();
        if (ev instanceof ArrayElementValue) {
            ElementValue[] arrayValues;
            for (ElementValue value : arrayValues = ((ArrayElementValue)ev).getElementValuesArray()) {
                values.add(value.stringifyValue());
            }
        } else {
            values.add(ev.stringifyValue());
        }
        String[] result = new String[values.size()];
        return values.toArray(result);
    }

    protected Map<String, String> processAnnotationWebInitParams(ElementValue ev) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (ev instanceof ArrayElementValue) {
            ElementValue[] arrayValues;
            for (ElementValue value : arrayValues = ((ArrayElementValue)ev).getElementValuesArray()) {
                if (!(value instanceof AnnotationElementValue)) continue;
                ElementValuePair[] evps = ((AnnotationElementValue)value).getAnnotationEntry().getElementValuePairs();
                String initParamName = null;
                String initParamValue = null;
                for (ElementValuePair evp : evps) {
                    if ("name".equals(evp.getNameString())) {
                        initParamName = evp.getValue().stringifyValue();
                        continue;
                    }
                    if (!"value".equals(evp.getNameString())) continue;
                    initParamValue = evp.getValue().stringifyValue();
                }
                result.put(initParamName, initParamValue);
            }
        }
        return result;
    }

    private class FragmentJarScannerCallback
    implements JarScannerCallback {
        private static final String FRAGMENT_LOCATION = "META-INF/web-fragment.xml";
        private Map<String, WebXml> fragments = new HashMap<String, WebXml>();

        private FragmentJarScannerCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scan(JarURLConnection urlConn) throws IOException {
            JarFile jarFile = null;
            InputStream stream = null;
            WebXml fragment = new WebXml();
            try {
                urlConn.setUseCaches(false);
                jarFile = urlConn.getJarFile();
                JarEntry fragmentEntry = jarFile.getJarEntry(FRAGMENT_LOCATION);
                if (fragmentEntry == null) {
                    fragment.setDistributable(true);
                } else {
                    stream = jarFile.getInputStream(fragmentEntry);
                    InputSource source = new InputSource(urlConn.getJarFileURL().toString() + "!/" + FRAGMENT_LOCATION);
                    source.setByteStream(stream);
                    ContextConfig.this.parseWebXml(source, fragment, true);
                }
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                    }
                }
                fragment.setURL(urlConn.getURL());
                if (fragment.getName() == null) {
                    fragment.setName(fragment.getURL().toString());
                }
                this.fragments.put(fragment.getName(), fragment);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void scan(File file) throws IOException {
            InputStream stream = null;
            WebXml fragment = null;
            try {
                File fragmentFile = new File(file, FRAGMENT_LOCATION);
                if (fragmentFile.isFile()) {
                    stream = new FileInputStream(fragmentFile);
                    InputSource source = new InputSource(fragmentFile.toURI().toURL().toString());
                    source.setByteStream(stream);
                    fragment = new WebXml();
                    ContextConfig.this.parseWebXml(source, fragment, true);
                }
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable t) {
                        ExceptionUtils.handleThrowable(t);
                    }
                }
                if (fragment == null) {
                    this.fragments.put(file.toURI().toURL().toString(), fragment);
                } else {
                    fragment.setURL(file.toURI().toURL());
                    if (fragment.getName() == null) {
                        fragment.setName(fragment.getURL().toString());
                    }
                    this.fragments.put(fragment.getName(), fragment);
                }
            }
        }

        public Map<String, WebXml> getFragments() {
            return this.fragments;
        }
    }
}

