/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.security;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Globals;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public final class SecurityUtil {
    private static final int INIT = 0;
    private static final int SERVICE = 1;
    private static final int DOFILTER = 1;
    private static final int EVENT = 2;
    private static final int DOFILTEREVENT = 2;
    private static final int DESTROY = 3;
    private static final String INIT_METHOD = "init";
    private static final String DOFILTER_METHOD = "doFilter";
    private static final String SERVICE_METHOD = "service";
    private static final String EVENT_METHOD = "event";
    private static final String DOFILTEREVENT_METHOD = "doFilterEvent";
    private static final String DESTROY_METHOD = "destroy";
    private static final Map<Object, Method[]> objectCache = new ConcurrentHashMap<Object, Method[]>();
    private static final Log log = LogFactory.getLog(SecurityUtil.class);
    private static String PACKAGE = "org.apache.catalina.security";
    private static boolean packageDefinitionEnabled = System.getProperty("package.definition") != null || System.getProperty("package.access") != null;
    private static final StringManager sm = StringManager.getManager(PACKAGE);

    public static void doAsPrivilege(String methodName, Servlet targetObject) throws Exception {
        SecurityUtil.doAsPrivilege(methodName, targetObject, null, null, null);
    }

    public static void doAsPrivilege(String methodName, Servlet targetObject, Class<?>[] targetType, Object[] targetArguments) throws Exception {
        SecurityUtil.doAsPrivilege(methodName, targetObject, targetType, targetArguments, null);
    }

    public static void doAsPrivilege(String methodName, Servlet targetObject, Class<?>[] targetType, Object[] targetArguments, Principal principal) throws Exception {
        Method method = null;
        Method[] methodsCache = objectCache.get(targetObject);
        if (methodsCache == null) {
            method = SecurityUtil.createMethodAndCacheIt(methodsCache, methodName, targetObject, targetType);
        } else {
            method = SecurityUtil.findMethod(methodsCache, methodName);
            if (method == null) {
                method = SecurityUtil.createMethodAndCacheIt(methodsCache, methodName, targetObject, targetType);
            }
        }
        SecurityUtil.execute(method, targetObject, targetArguments, principal);
    }

    public static void doAsPrivilege(String methodName, Filter targetObject) throws Exception {
        SecurityUtil.doAsPrivilege(methodName, targetObject, null, null);
    }

    public static void doAsPrivilege(String methodName, Filter targetObject, Class<?>[] targetType, Object[] targetArguments) throws Exception {
        SecurityUtil.doAsPrivilege(methodName, targetObject, targetType, targetArguments, null);
    }

    public static void doAsPrivilege(String methodName, Filter targetObject, Class<?>[] targetType, Object[] targetArguments, Principal principal) throws Exception {
        Method method = null;
        Method[] methodsCache = objectCache.get(targetObject);
        if (methodsCache == null) {
            method = SecurityUtil.createMethodAndCacheIt(methodsCache, methodName, targetObject, targetType);
        } else {
            method = SecurityUtil.findMethod(methodsCache, methodName);
            if (method == null) {
                method = SecurityUtil.createMethodAndCacheIt(methodsCache, methodName, targetObject, targetType);
            }
        }
        SecurityUtil.execute(method, targetObject, targetArguments, principal);
    }

    private static void execute(final Method method, final Object targetObject, final Object[] targetArguments, Principal principal) throws Exception {
        try {
            Subject subject = null;
            PrivilegedExceptionAction<Void> pea = new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    method.invoke(targetObject, targetArguments);
                    return null;
                }
            };
            if (targetArguments != null && targetArguments[0] instanceof HttpServletRequest) {
                HttpServletRequest request = (HttpServletRequest)targetArguments[0];
                boolean hasSubject = false;
                HttpSession session = request.getSession(false);
                if (session != null) {
                    subject = (Subject)session.getAttribute("javax.security.auth.subject");
                    boolean bl = hasSubject = subject != null;
                }
                if (subject == null) {
                    subject = new Subject();
                    if (principal != null) {
                        subject.getPrincipals().add(principal);
                    }
                }
                if (session != null && !hasSubject) {
                    session.setAttribute("javax.security.auth.subject", subject);
                }
            }
            Subject.doAsPrivileged(subject, pea, null);
        }
        catch (PrivilegedActionException pe) {
            Throwable e = pe.getException() instanceof InvocationTargetException ? ((InvocationTargetException)pe.getException()).getTargetException() : pe;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("SecurityUtil.doAsPrivilege"), e);
            }
            if (e instanceof UnavailableException) {
                throw (UnavailableException)e;
            }
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ServletException(e.getMessage(), e);
        }
    }

    private static Method findMethod(Method[] methodsCache, String methodName) {
        if (methodName.equalsIgnoreCase(INIT_METHOD) && methodsCache[0] != null) {
            return methodsCache[0];
        }
        if (methodName.equalsIgnoreCase(DESTROY_METHOD) && methodsCache[3] != null) {
            return methodsCache[3];
        }
        if (methodName.equalsIgnoreCase(SERVICE_METHOD) && methodsCache[1] != null) {
            return methodsCache[1];
        }
        if (methodName.equalsIgnoreCase(DOFILTER_METHOD) && methodsCache[1] != null) {
            return methodsCache[1];
        }
        if (methodName.equalsIgnoreCase(EVENT_METHOD) && methodsCache[2] != null) {
            return methodsCache[2];
        }
        if (methodName.equalsIgnoreCase(DOFILTEREVENT_METHOD) && methodsCache[2] != null) {
            return methodsCache[2];
        }
        return null;
    }

    private static Method createMethodAndCacheIt(Method[] methodsCache, String methodName, Object targetObject, Class<?>[] targetType) throws Exception {
        if (methodsCache == null) {
            methodsCache = new Method[4];
        }
        Method method = targetObject.getClass().getMethod(methodName, targetType);
        if (methodName.equalsIgnoreCase(INIT_METHOD)) {
            methodsCache[0] = method;
        } else if (methodName.equalsIgnoreCase(DESTROY_METHOD)) {
            methodsCache[3] = method;
        } else if (methodName.equalsIgnoreCase(SERVICE_METHOD)) {
            methodsCache[1] = method;
        } else if (methodName.equalsIgnoreCase(DOFILTER_METHOD)) {
            methodsCache[1] = method;
        } else if (methodName.equalsIgnoreCase(EVENT_METHOD)) {
            methodsCache[2] = method;
        } else if (methodName.equalsIgnoreCase(DOFILTEREVENT_METHOD)) {
            methodsCache[2] = method;
        }
        objectCache.put(targetObject, methodsCache);
        return method;
    }

    public static void remove(Object cachedObject) {
        objectCache.remove(cachedObject);
    }

    public static boolean isPackageProtectionEnabled() {
        return packageDefinitionEnabled && Globals.IS_SECURITY_ENABLED;
    }
}

