/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.manager;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Locale;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.InitialContext;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.Manager;
import org.apache.catalina.Role;
import org.apache.catalina.Server;
import org.apache.catalina.Session;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.ServerInfo;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.res.StringManager;

public class ManagerServlet
extends HttpServlet
implements ContainerServlet {
    private static final long serialVersionUID = 1L;
    protected File configBase = null;
    protected Context context = null;
    protected int debug = 1;
    protected File deployed = null;
    protected File versioned = null;
    protected File contextDescriptors = null;
    protected Host host = null;
    protected File appBase = null;
    protected MBeanServer mBeanServer = null;
    protected ObjectName oname = null;
    protected javax.naming.Context global = null;
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.manager");
    protected Wrapper wrapper = null;

    @Override
    public Wrapper getWrapper() {
        return this.wrapper;
    }

    @Override
    public void setWrapper(Wrapper wrapper) {
        this.wrapper = wrapper;
        if (wrapper == null) {
            this.context = null;
            this.host = null;
            this.oname = null;
        } else {
            this.context = (Context)wrapper.getParent();
            this.host = (Host)this.context.getParent();
            Engine engine = (Engine)this.host.getParent();
            try {
                this.oname = new ObjectName(engine.getName() + ":type=Deployer,host=" + this.host.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
    }

    @Override
    public void destroy() {
    }

    @Override
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StringManager smClient = this.getStringManager(request);
        String command = request.getPathInfo();
        if (command == null) {
            command = request.getServletPath();
        }
        String config = request.getParameter("config");
        String path = request.getParameter("path");
        ContextName cn = null;
        if (path != null) {
            cn = new ContextName(path, request.getParameter("version"));
        }
        String type = request.getParameter("type");
        String war = request.getParameter("war");
        String tag = request.getParameter("tag");
        boolean update = false;
        if (request.getParameter("update") != null && request.getParameter("update").equals("true")) {
            update = true;
        }
        response.setContentType("text/plain; charset=utf-8");
        PrintWriter writer = response.getWriter();
        if (command == null) {
            writer.println(smClient.getString("managerServlet.noCommand"));
        } else if (command.equals("/deploy")) {
            if (war != null || config != null) {
                this.deploy(writer, config, cn, war, update, smClient);
            } else {
                this.deploy(writer, cn, tag, smClient);
            }
        } else if (command.equals("/list")) {
            this.list(writer, smClient);
        } else if (command.equals("/reload")) {
            this.reload(writer, cn, smClient);
        } else if (command.equals("/resources")) {
            this.resources(writer, type, smClient);
        } else if (command.equals("/roles")) {
            this.roles(writer, smClient);
        } else if (command.equals("/save")) {
            this.save(writer, path, smClient);
        } else if (command.equals("/serverinfo")) {
            this.serverinfo(writer, smClient);
        } else if (command.equals("/sessions")) {
            this.expireSessions(writer, cn, request, smClient);
        } else if (command.equals("/expire")) {
            this.expireSessions(writer, cn, request, smClient);
        } else if (command.equals("/start")) {
            this.start(writer, cn, smClient);
        } else if (command.equals("/stop")) {
            this.stop(writer, cn, smClient);
        } else if (command.equals("/undeploy")) {
            this.undeploy(writer, cn, smClient);
        } else if (command.equals("/findleaks")) {
            this.findleaks(writer, smClient);
        } else {
            writer.println(smClient.getString("managerServlet.unknownCommand", command));
        }
        writer.flush();
        writer.close();
    }

    @Override
    public void doPut(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        StringManager smClient = this.getStringManager(request);
        String command = request.getPathInfo();
        if (command == null) {
            command = request.getServletPath();
        }
        String path = request.getParameter("path");
        ContextName cn = null;
        if (path != null) {
            cn = new ContextName(path, request.getParameter("version"));
        }
        String tag = request.getParameter("tag");
        boolean update = false;
        if (request.getParameter("update") != null && request.getParameter("update").equals("true")) {
            update = true;
        }
        response.setContentType("text/plain;charset=utf-8");
        PrintWriter writer = response.getWriter();
        if (command == null) {
            writer.println(smClient.getString("managerServlet.noCommand"));
        } else if (command.equals("/deploy")) {
            this.deploy(writer, cn, tag, update, request, smClient);
        } else {
            writer.println(smClient.getString("managerServlet.unknownCommand", command));
        }
        writer.flush();
        writer.close();
    }

    @Override
    public void init() throws ServletException {
        if (this.wrapper == null || this.context == null) {
            throw new UnavailableException(sm.getString("managerServlet.noWrapper"));
        }
        String value = null;
        try {
            value = this.getServletConfig().getInitParameter("debug");
            this.debug = Integer.parseInt(value);
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
        }
        Server server = ((Engine)this.host.getParent()).getService().getServer();
        if (server != null && server instanceof StandardServer) {
            this.global = ((StandardServer)server).getGlobalNamingContext();
        }
        this.versioned = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
        String appBase = ((Host)this.context.getParent()).getAppBase();
        this.deployed = new File(appBase);
        if (!this.deployed.isAbsolute()) {
            this.deployed = new File(System.getProperty("catalina.base"), appBase);
        }
        this.configBase = new File(System.getProperty("catalina.base"), "conf");
        Context host = null;
        Context engine = null;
        for (Container container = this.context; container != null; container = container.getParent()) {
            if (container instanceof Host) {
                host = container;
            }
            if (!(container instanceof Engine)) continue;
            engine = container;
        }
        if (engine != null) {
            this.configBase = new File(this.configBase, engine.getName());
        }
        if (host != null) {
            this.configBase = new File(this.configBase, host.getName());
        }
        if (this.debug >= 1) {
            this.log("init: Associated with Deployer '" + this.oname + "'");
            if (this.global != null) {
                this.log("init: Global resources are available");
            }
        }
    }

    protected void findleaks(PrintWriter writer, StringManager smClient) {
        String[] results;
        if (!(this.host instanceof StandardHost)) {
            writer.println(smClient.getString("managerServlet.findleaksFail"));
            return;
        }
        for (String result : results = ((StandardHost)this.host).findReloadedContextMemoryLeaks()) {
            if ("".equals(result)) {
                result = "/";
            }
            writer.println(result);
        }
    }

    protected synchronized void save(PrintWriter writer, String path, StringManager smClient) {
        Context context;
        Server server = ((Engine)this.host.getParent()).getService().getServer();
        if (!(server instanceof StandardServer)) {
            writer.println(smClient.getString("managerServlet.saveFail", server));
            return;
        }
        if (path == null || path.length() == 0 || !path.startsWith("/")) {
            try {
                ((StandardServer)server).storeConfig();
                writer.println(smClient.getString("managerServlet.saved"));
            }
            catch (Exception e) {
                this.log("managerServlet.storeConfig", e);
                writer.println(smClient.getString("managerServlet.exception", e.toString()));
                return;
            }
        }
        String contextPath = path;
        if (path.equals("/")) {
            contextPath = "";
        }
        if ((context = (Context)this.host.findChild(contextPath)) == null) {
            writer.println(smClient.getString("managerServlet.noContext", path));
            return;
        }
        try {
            ((StandardServer)server).storeContext(context);
            writer.println(smClient.getString("managerServlet.savedContext", path));
        }
        catch (Exception e) {
            this.log("managerServlet.save[" + path + "]", e);
            writer.println(smClient.getString("managerServlet.exception", e.toString()));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void deploy(PrintWriter writer, ContextName cn, String tag, boolean update, HttpServletRequest request, StringManager smClient) {
        Context context;
        String displayPath;
        String name;
        block15: {
            if (this.debug >= 1) {
                this.log("deploy: Deploying web application '" + cn + "'");
            }
            if (!ManagerServlet.validateContextName(cn, writer, smClient)) {
                return;
            }
            name = cn.getName();
            String baseName = cn.getBaseName();
            displayPath = cn.getDisplayName();
            context = (Context)this.host.findChild(name);
            if (update) {
                if (context != null) {
                    this.undeploy(writer, cn, smClient);
                }
                context = (Context)this.host.findChild(name);
            }
            if (context != null) {
                writer.println(smClient.getString("managerServlet.alreadyContext", displayPath));
                return;
            }
            File deployedPath = this.deployed;
            if (tag != null) {
                deployedPath = new File(this.versioned, tag);
                deployedPath.mkdirs();
            }
            File localWar = new File(deployedPath, baseName + ".war");
            if (this.debug >= 2) {
                this.log("Uploading WAR file to " + localWar);
            }
            try {
                if (this.isServiced(name)) break block15;
                this.addServiced(name);
                try {
                    this.uploadWar(request, localWar);
                    if (tag != null) {
                        deployedPath = this.deployed;
                        File localWarCopy = new File(deployedPath, baseName + ".war");
                        ManagerServlet.copy(localWar, localWarCopy);
                        localWar = localWarCopy;
                        ManagerServlet.copy(localWar, new File(this.getAppBase(), baseName + ".war"));
                    }
                    this.check(name);
                }
                finally {
                    this.removeServiced(name);
                }
            }
            catch (Exception e) {
                this.log("managerServlet.check[" + displayPath + "]", e);
                writer.println(smClient.getString("managerServlet.exception", e.toString()));
                return;
            }
        }
        context = (Context)this.host.findChild(name);
        if (context != null && context.getConfigured()) {
            writer.println(smClient.getString("managerServlet.deployed", displayPath));
        } else {
            writer.println(smClient.getString("managerServlet.deployFailed", displayPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deploy(PrintWriter writer, ContextName cn, String tag, StringManager smClient) {
        Context context;
        String displayPath;
        String name;
        block10: {
            if (!ManagerServlet.validateContextName(cn, writer, smClient)) {
                return;
            }
            String baseName = cn.getBaseName();
            name = cn.getName();
            displayPath = cn.getDisplayName();
            File deployedPath = this.versioned;
            if (tag != null) {
                deployedPath = new File(deployedPath, tag);
            }
            File localWar = new File(deployedPath, baseName + ".war");
            context = (Context)this.host.findChild(name);
            if (context != null) {
                this.undeploy(writer, cn, smClient);
            }
            try {
                if (this.isServiced(name)) break block10;
                this.addServiced(name);
                try {
                    ManagerServlet.copy(localWar, new File(this.getAppBase(), baseName + ".war"));
                    this.check(name);
                }
                finally {
                    this.removeServiced(name);
                }
            }
            catch (Exception e) {
                this.log("managerServlet.check[" + displayPath + "]", e);
                writer.println(smClient.getString("managerServlet.exception", e.toString()));
                return;
            }
        }
        context = (Context)this.host.findChild(name);
        if (context != null && context.getConfigured()) {
            writer.println(smClient.getString("managerServlet.deployed", displayPath));
        } else {
            writer.println(smClient.getString("managerServlet.deployFailed", displayPath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deploy(PrintWriter writer, String config, ContextName cn, String war, boolean update, StringManager smClient) {
        if (config != null && config.length() == 0) {
            config = null;
        }
        if (war != null && war.length() == 0) {
            war = null;
        }
        if (this.debug >= 1) {
            if (config != null && config.length() > 0) {
                if (war != null) {
                    this.log("install: Installing context configuration at '" + config + "' from '" + war + "'");
                } else {
                    this.log("install: Installing context configuration at '" + config + "'");
                }
            } else if (cn != null) {
                this.log("install: Installing web application '" + cn + "' from '" + war + "'");
            } else {
                this.log("install: Installing web application from '" + war + "'");
            }
        }
        if (!ManagerServlet.validateContextName(cn, writer, smClient)) {
            return;
        }
        String name = cn.getName();
        String baseName = cn.getBaseName();
        String displayPath = cn.getDisplayName();
        Context context = (Context)this.host.findChild(name);
        if (update) {
            if (context != null) {
                this.undeploy(writer, cn, smClient);
            }
            context = (Context)this.host.findChild(name);
        }
        if (context != null) {
            writer.println(smClient.getString("managerServlet.alreadyContext", displayPath));
            return;
        }
        if (config != null && config.startsWith("file:")) {
            config = config.substring("file:".length());
        }
        if (war != null && war.startsWith("file:")) {
            war = war.substring("file:".length());
        }
        try {
            if (!this.isServiced(name)) {
                this.addServiced(name);
                try {
                    if (config != null) {
                        this.configBase.mkdirs();
                        ManagerServlet.copy(new File(config), new File(this.configBase, baseName + ".xml"));
                    }
                    if (war != null) {
                        if (war.endsWith(".war")) {
                            ManagerServlet.copy(new File(war), new File(this.getAppBase(), baseName + ".war"));
                        } else {
                            ManagerServlet.copy(new File(war), new File(this.getAppBase(), baseName));
                        }
                    }
                    this.check(name);
                }
                finally {
                    this.removeServiced(name);
                }
            }
            if ((context = (Context)this.host.findChild(name)) != null && context.getConfigured() && context.getAvailable()) {
                writer.println(smClient.getString("managerServlet.deployed", displayPath));
            } else if (context != null && !context.getAvailable()) {
                writer.println(smClient.getString("managerServlet.deployedButNotStarted", displayPath));
            } else {
                writer.println(smClient.getString("managerServlet.deployFailed", displayPath));
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log("ManagerServlet.install[" + displayPath + "]", t);
            writer.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    protected void list(PrintWriter writer, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("list: Listing contexts for virtual host '" + this.host.getName() + "'");
        }
        writer.println(smClient.getString("managerServlet.listed", this.host.getName()));
        Container[] contexts = this.host.findChildren();
        for (int i = 0; i < contexts.length; ++i) {
            Context context = (Context)contexts[i];
            if (context == null) continue;
            String displayPath = context.getPath();
            if (displayPath.equals("")) {
                displayPath = "/";
            }
            if (context.getAvailable()) {
                writer.println(smClient.getString("managerServlet.listitem", displayPath, "running", "" + context.getManager().findSessions().length, context.getDocBase()));
                continue;
            }
            writer.println(smClient.getString("managerServlet.listitem", displayPath, "stopped", "0", context.getDocBase()));
        }
    }

    protected void reload(PrintWriter writer, ContextName cn, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("restart: Reloading web application '" + cn + "'");
        }
        if (!ManagerServlet.validateContextName(cn, writer, smClient)) {
            return;
        }
        try {
            Context context = (Context)this.host.findChild(cn.getName());
            if (context == null) {
                writer.println(smClient.getString("managerServlet.noContext", RequestUtil.filter(cn.getDisplayName())));
                return;
            }
            if (context.getName().equals(this.context.getName())) {
                writer.println(smClient.getString("managerServlet.noSelf"));
                return;
            }
            context.reload();
            writer.println(smClient.getString("managerServlet.reloaded", cn.getDisplayName()));
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log("ManagerServlet.reload[" + cn.getDisplayName() + "]", t);
            writer.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    protected void resources(PrintWriter writer, String type, StringManager smClient) {
        if (this.debug >= 1) {
            if (type != null) {
                this.log("resources:  Listing resources of type " + type);
            } else {
                this.log("resources:  Listing resources of all types");
            }
        }
        if (this.global == null) {
            writer.println(smClient.getString("managerServlet.noGlobal"));
            return;
        }
        if (type != null) {
            writer.println(smClient.getString("managerServlet.resourcesType", type));
        } else {
            writer.println(smClient.getString("managerServlet.resourcesAll"));
        }
        Class<?> clazz = null;
        try {
            if (type != null) {
                clazz = Class.forName(type);
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log("ManagerServlet.resources[" + type + "]", t);
            writer.println(smClient.getString("managerServlet.exception", t.toString()));
            return;
        }
        this.printResources(writer, "", this.global, type, clazz, smClient);
    }

    protected void printResources(PrintWriter writer, String prefix, javax.naming.Context namingContext, String type, Class<?> clazz, StringManager smClient) {
        try {
            NamingEnumeration<Binding> items = namingContext.listBindings("");
            while (items.hasMore()) {
                Binding item = items.next();
                if (item.getObject() instanceof javax.naming.Context) {
                    this.printResources(writer, prefix + item.getName() + "/", (javax.naming.Context)item.getObject(), type, clazz, smClient);
                    continue;
                }
                if (clazz != null && !clazz.isInstance(item.getObject())) continue;
                writer.print(prefix + item.getName());
                writer.print(':');
                writer.print(item.getClassName());
                writer.println();
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log("ManagerServlet.resources[" + type + "]", t);
            writer.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    protected void roles(PrintWriter writer, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("roles:  List security roles from user database");
        }
        UserDatabase database = null;
        try {
            InitialContext ic = new InitialContext();
            database = (UserDatabase)ic.lookup("java:comp/env/users");
        }
        catch (NamingException e) {
            writer.println(smClient.getString("managerServlet.userDatabaseError"));
            this.log("java:comp/env/users", e);
            return;
        }
        if (database == null) {
            writer.println(smClient.getString("managerServlet.userDatabaseMissing"));
            return;
        }
        writer.println(smClient.getString("managerServlet.rolesList"));
        Iterator<Role> roles = database.getRoles();
        if (roles != null) {
            while (roles.hasNext()) {
                Role role = roles.next();
                writer.print(role.getRolename());
                writer.print(':');
                if (role.getDescription() != null) {
                    writer.print(role.getDescription());
                }
                writer.println();
            }
        }
    }

    protected void serverinfo(PrintWriter writer, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("serverinfo");
        }
        try {
            StringBuilder props = new StringBuilder();
            props.append("OK - Server info");
            props.append("\nTomcat Version: ");
            props.append(ServerInfo.getServerInfo());
            props.append("\nOS Name: ");
            props.append(System.getProperty("os.name"));
            props.append("\nOS Version: ");
            props.append(System.getProperty("os.version"));
            props.append("\nOS Architecture: ");
            props.append(System.getProperty("os.arch"));
            props.append("\nJVM Version: ");
            props.append(System.getProperty("java.runtime.version"));
            props.append("\nJVM Vendor: ");
            props.append(System.getProperty("java.vm.vendor"));
            writer.println(props.toString());
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.getServletContext().log("ManagerServlet.serverinfo", t);
            writer.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    protected void sessions(PrintWriter writer, ContextName cn, int idle, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("sessions: Session information for web application '" + cn + "'");
            if (idle >= 0) {
                this.log("sessions: Session expiration for " + idle + " minutes '" + cn + "'");
            }
        }
        if (!ManagerServlet.validateContextName(cn, writer, smClient)) {
            return;
        }
        String displayPath = cn.getDisplayName();
        try {
            int i;
            Context context = (Context)this.host.findChild(cn.getName());
            if (context == null) {
                writer.println(smClient.getString("managerServlet.noContext", RequestUtil.filter(displayPath)));
                return;
            }
            Manager manager = context.getManager();
            if (manager == null) {
                writer.println(smClient.getString("managerServlet.noManager", RequestUtil.filter(displayPath)));
                return;
            }
            int maxCount = 60;
            int maxInactiveInterval = manager.getMaxInactiveInterval() / 60;
            int histoInterval = maxInactiveInterval / maxCount;
            if (histoInterval * maxCount < maxInactiveInterval) {
                ++histoInterval;
            }
            if (0 == histoInterval) {
                histoInterval = 1;
            }
            if (histoInterval * (maxCount = maxInactiveInterval / histoInterval) < maxInactiveInterval) {
                ++maxCount;
            }
            writer.println(smClient.getString("managerServlet.sessions", displayPath));
            writer.println(smClient.getString("managerServlet.sessiondefaultmax", "" + maxInactiveInterval));
            Session[] sessions = manager.findSessions();
            int[] timeout = new int[maxCount];
            int notimeout = 0;
            int expired = 0;
            long now = System.currentTimeMillis();
            for (i = 0; i < sessions.length; ++i) {
                int time = (int)((now - sessions[i].getThisAccessedTimeInternal()) / 1000L);
                if (idle >= 0 && time >= idle * 60) {
                    sessions[i].expire();
                    ++expired;
                }
                if ((time = time / 60 / histoInterval) < 0) {
                    ++notimeout;
                    continue;
                }
                if (time >= maxCount) {
                    int n = maxCount - 1;
                    timeout[n] = timeout[n] + 1;
                    continue;
                }
                int n = time;
                timeout[n] = timeout[n] + 1;
            }
            if (timeout[0] > 0) {
                writer.println(smClient.getString("managerServlet.sessiontimeout", "<" + histoInterval, "" + timeout[0]));
            }
            for (i = 1; i < maxCount - 1; ++i) {
                if (timeout[i] <= 0) continue;
                writer.println(smClient.getString("managerServlet.sessiontimeout", "" + i * histoInterval + " - <" + (i + 1) * histoInterval, "" + timeout[i]));
            }
            if (timeout[maxCount - 1] > 0) {
                writer.println(smClient.getString("managerServlet.sessiontimeout", ">=" + maxCount * histoInterval, "" + timeout[maxCount - 1]));
            }
            if (notimeout > 0) {
                writer.println(smClient.getString("managerServlet.sessiontimeout.unlimited", "" + notimeout));
            }
            if (idle >= 0) {
                writer.println(smClient.getString("managerServlet.sessiontimeout.expired", "" + idle, "" + expired));
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log("ManagerServlet.sessions[" + displayPath + "]", t);
            writer.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    protected void sessions(PrintWriter writer, ContextName cn, StringManager smClient) {
        this.sessions(writer, cn, -1, smClient);
    }

    protected void expireSessions(PrintWriter writer, ContextName cn, HttpServletRequest req, StringManager smClient) {
        int idle = -1;
        String idleParam = req.getParameter("idle");
        if (idleParam != null) {
            try {
                idle = Integer.parseInt(idleParam);
            }
            catch (NumberFormatException e) {
                this.log("Could not parse idle parameter to an int: " + idleParam);
            }
        }
        this.sessions(writer, cn, idle, smClient);
    }

    protected void start(PrintWriter writer, ContextName cn, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("start: Starting web application '" + cn + "'");
        }
        if (!ManagerServlet.validateContextName(cn, writer, smClient)) {
            return;
        }
        String displayPath = cn.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(cn.getName());
            if (context == null) {
                writer.println(smClient.getString("managerServlet.noContext", RequestUtil.filter(displayPath)));
                return;
            }
            context.start();
            if (context.getAvailable()) {
                writer.println(smClient.getString("managerServlet.started", displayPath));
            } else {
                writer.println(smClient.getString("managerServlet.startFailed", displayPath));
            }
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.getServletContext().log(sm.getString("managerServlet.startFailed", displayPath), t);
            writer.println(smClient.getString("managerServlet.startFailed", displayPath));
            writer.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    protected void stop(PrintWriter writer, ContextName cn, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("stop: Stopping web application '" + cn + "'");
        }
        if (!ManagerServlet.validateContextName(cn, writer, smClient)) {
            return;
        }
        String displayPath = cn.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(cn.getName());
            if (context == null) {
                writer.println(smClient.getString("managerServlet.noContext", RequestUtil.filter(displayPath)));
                return;
            }
            if (context.getName().equals(this.context.getName())) {
                writer.println(smClient.getString("managerServlet.noSelf"));
                return;
            }
            context.stop();
            writer.println(smClient.getString("managerServlet.stopped", displayPath));
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log("ManagerServlet.stop[" + displayPath + "]", t);
            writer.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void undeploy(PrintWriter writer, ContextName cn, StringManager smClient) {
        if (this.debug >= 1) {
            this.log("undeploy: Undeploying web application at '" + cn + "'");
        }
        if (!ManagerServlet.validateContextName(cn, writer, smClient)) {
            return;
        }
        String name = cn.getName();
        String baseName = cn.getBaseName();
        String displayPath = cn.getDisplayName();
        try {
            Context context = (Context)this.host.findChild(name);
            if (context == null) {
                writer.println(smClient.getString("managerServlet.noContext", RequestUtil.filter(displayPath)));
                return;
            }
            if (!this.isDeployed(name)) {
                writer.println(smClient.getString("managerServlet.notDeployed", RequestUtil.filter(displayPath)));
                return;
            }
            if (!this.isServiced(name)) {
                this.addServiced(name);
                try {
                    context.stop();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
                try {
                    File war = new File(this.getAppBase(), baseName + ".war");
                    File dir = new File(this.getAppBase(), baseName);
                    File xml = new File(this.configBase, baseName + ".xml");
                    if (war.exists()) {
                        war.delete();
                    } else if (dir.exists()) {
                        this.undeployDir(dir);
                    } else {
                        xml.delete();
                    }
                    this.check(name);
                }
                finally {
                    this.removeServiced(name);
                }
            }
            writer.println(smClient.getString("managerServlet.undeployed", displayPath));
        }
        catch (Throwable t) {
            ExceptionUtils.handleThrowable(t);
            this.log("ManagerServlet.undeploy[" + displayPath + "]", t);
            writer.println(smClient.getString("managerServlet.exception", t.toString()));
        }
    }

    protected File getAppBase() {
        if (this.appBase != null) {
            return this.appBase;
        }
        File file = new File(this.host.getAppBase());
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.host.getAppBase());
        }
        try {
            this.appBase = file.getCanonicalFile();
        }
        catch (IOException e) {
            this.appBase = file;
        }
        return this.appBase;
    }

    protected boolean isDeployed(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        Boolean result = (Boolean)this.mBeanServer.invoke(this.oname, "isDeployed", params, signature);
        return result;
    }

    protected void check(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "check", params, signature);
    }

    protected boolean isServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        Boolean result = (Boolean)this.mBeanServer.invoke(this.oname, "isServiced", params, signature);
        return result;
    }

    protected void addServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "addServiced", params, signature);
    }

    protected void removeServiced(String name) throws Exception {
        Object[] params = new String[]{name};
        String[] signature = new String[]{"java.lang.String"};
        this.mBeanServer.invoke(this.oname, "removeServiced", params, signature);
    }

    protected void undeployDir(File dir) {
        String[] files = dir.list();
        if (files == null) {
            files = new String[]{};
        }
        for (int i = 0; i < files.length; ++i) {
            File file = new File(dir, files[i]);
            if (file.isDirectory()) {
                this.undeployDir(file);
                continue;
            }
            file.delete();
        }
        dir.delete();
    }

    protected void uploadWar(HttpServletRequest request, File war) throws IOException {
        war.delete();
        ServletInputStream istream = null;
        FilterOutputStream ostream = null;
        try {
            int n;
            istream = request.getInputStream();
            ostream = new BufferedOutputStream(new FileOutputStream(war), 1024);
            byte[] buffer = new byte[1024];
            while ((n = istream.read(buffer)) >= 0) {
                ((BufferedOutputStream)ostream).write(buffer, 0, n);
            }
            ((BufferedOutputStream)ostream).flush();
            ostream.close();
            ostream = null;
            istream.close();
            istream = null;
        }
        catch (IOException e) {
            war.delete();
            throw e;
        }
        finally {
            if (ostream != null) {
                try {
                    ostream.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
                ostream = null;
            }
            if (istream != null) {
                try {
                    istream.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.handleThrowable(t);
                }
                istream = null;
            }
        }
    }

    protected StringManager getStringManager(HttpServletRequest req) {
        Enumeration<Locale> requestedLocales = req.getLocales();
        while (requestedLocales.hasMoreElements()) {
            Locale locale = requestedLocales.nextElement();
            StringManager result = StringManager.getManager("org.apache.catalina.manager", locale);
            if (!result.getLocale().equals(locale)) continue;
            return result;
        }
        return sm;
    }

    protected static boolean validateContextName(ContextName cn, PrintWriter writer, StringManager sm) {
        if (cn != null && (cn.getPath().startsWith("/") || cn.getPath().equals(""))) {
            return true;
        }
        String path = null;
        if (cn != null) {
            path = RequestUtil.filter(cn.getPath());
        }
        writer.println(sm.getString("managerServlet.invalidPath", path));
        return false;
    }

    public static boolean copy(File src, File dest) {
        boolean result = false;
        try {
            if (src != null && !src.getCanonicalPath().equals(dest.getCanonicalPath())) {
                result = ManagerServlet.copyInternal(src, dest, new byte[4096]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyInternal(File src, File dest, byte[] buf) {
        boolean result = true;
        String[] files = null;
        if (src.isDirectory()) {
            files = src.list();
            result = dest.mkdir();
        } else {
            files = new String[]{""};
        }
        if (files == null) {
            files = new String[]{};
        }
        block17: for (int i = 0; i < files.length && result; ++i) {
            File fileSrc = new File(src, files[i]);
            File fileDest = new File(dest, files[i]);
            if (fileSrc.isDirectory()) {
                result = ManagerServlet.copyInternal(fileSrc, fileDest, buf);
                continue;
            }
            FileInputStream is = null;
            FileOutputStream os = null;
            try {
                is = new FileInputStream(fileSrc);
                os = new FileOutputStream(fileDest);
                int len = 0;
                while (true) {
                    if ((len = is.read(buf)) == -1) {
                        continue block17;
                    }
                    os.write(buf, 0, len);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                result = false;
                continue;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        return result;
    }
}

