/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import javax.naming.directory.DirContext;
import org.apache.catalina.Container;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.util.LifecycleMBeanBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.http.mapper.Mapper;
import org.apache.tomcat.util.res.StringManager;

public class MapperListener
extends LifecycleMBeanBase
implements ContainerListener,
LifecycleListener {
    private static final Log log = LogFactory.getLog(MapperListener.class);
    private Mapper mapper = null;
    private Connector connector = null;
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.connector");
    private String domain = null;

    public MapperListener(Mapper mapper, Connector connector) {
        this.mapper = mapper;
        this.connector = connector;
    }

    public String getConnectorName() {
        return this.connector.toString();
    }

    @Override
    public void startInternal() {
        Container[] conHosts;
        this.setState(LifecycleState.STARTING);
        this.findDefaultHost();
        Engine engine = (Engine)this.connector.getService().getContainer();
        this.addListeners(engine);
        for (Container conHost : conHosts = engine.findChildren()) {
            Host host = (Host)conHost;
            if (LifecycleState.NEW.equals((Object)host.getState())) continue;
            this.registerHost(host);
        }
    }

    @Override
    public void stopInternal() {
        this.setState(LifecycleState.STOPPING);
    }

    @Override
    protected String getDomainInternal() {
        return this.connector.getDomainInternal();
    }

    @Override
    protected String getObjectNameKeyProperties() {
        return this.connector.createObjectNameKeyProperties("Mapper");
    }

    @Override
    public void containerEvent(ContainerEvent event) {
        if (event.getType() == "addChild") {
            Container child = (Container)event.getData();
            this.addListeners(child);
            if (child.getState().isAvailable()) {
                if (child instanceof Host) {
                    this.registerHost((Host)child);
                } else if (child instanceof Context) {
                    this.registerContext((Context)child);
                } else if (child instanceof Wrapper) {
                    this.registerWrapper((Wrapper)child);
                }
            }
        } else if (event.getType() == "removeChild") {
            Container child = (Container)event.getData();
            this.removeListeners(child);
        } else if (event.getType() == "addAlias") {
            this.mapper.addHostAlias(((Host)event.getSource()).getName(), event.getData().toString());
        } else if (event.getType() == "removeAlias") {
            this.mapper.removeHostAlias(event.getData().toString());
        } else if (event.getType() == "addMapping") {
            Wrapper wrapper = (Wrapper)event.getSource();
            Context context = (Context)wrapper.getParent();
            String contextPath = context.getPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            String version = ((Context)wrapper.getParent()).getWebappVersion();
            String hostName = context.getParent().getName();
            String wrapperName = wrapper.getName();
            String mapping = (String)event.getData();
            boolean jspWildCard = "jsp".equals(wrapperName) && mapping.endsWith("/*");
            this.mapper.addWrapper(hostName, contextPath, version, mapping, wrapper, jspWildCard, context.isResourceOnlyServlet(wrapperName));
        } else if (event.getType() == "removeMapping") {
            Wrapper wrapper = (Wrapper)event.getSource();
            String contextPath = ((Context)wrapper.getParent()).getPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            String version = ((Context)wrapper.getParent()).getWebappVersion();
            String hostName = wrapper.getParent().getParent().getName();
            String mapping = (String)event.getData();
            this.mapper.removeWrapper(hostName, contextPath, version, mapping);
        } else if (event.getType() == "addWelcomeFile") {
            Context context = (Context)event.getSource();
            String hostName = context.getParent().getName();
            String contextPath = context.getPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            String welcomeFile = (String)event.getData();
            this.mapper.addWelcomeFile(hostName, contextPath, context.getWebappVersion(), welcomeFile);
        } else if (event.getType() == "removeWelcomeFile") {
            Context context = (Context)event.getSource();
            String hostName = context.getParent().getName();
            String contextPath = context.getPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            String welcomeFile = (String)event.getData();
            this.mapper.removeWelcomeFile(hostName, contextPath, context.getWebappVersion(), welcomeFile);
        } else if (event.getType() == "clearWelcomeFiles") {
            Context context = (Context)event.getSource();
            String hostName = context.getParent().getName();
            String contextPath = context.getPath();
            if ("/".equals(contextPath)) {
                contextPath = "";
            }
            this.mapper.clearWelcomeFiles(hostName, contextPath, context.getWebappVersion());
        }
    }

    private void findDefaultHost() {
        Engine engine = (Engine)this.connector.getService().getContainer();
        String defaultHost = engine.getDefaultHost();
        boolean found = false;
        if (defaultHost != null && defaultHost.length() > 0) {
            Container[] containers;
            block0: for (Container container : containers = engine.findChildren()) {
                String[] aliases;
                Host host = (Host)container;
                if (defaultHost.equalsIgnoreCase(host.getName())) {
                    found = true;
                    break;
                }
                for (String alias : aliases = host.findAliases()) {
                    if (!defaultHost.equalsIgnoreCase(alias)) continue;
                    found = true;
                    continue block0;
                }
            }
        }
        if (found) {
            this.mapper.setDefaultHostName(defaultHost);
        } else {
            log.warn((Object)sm.getString("mapperListener.unknownDefaultHost", defaultHost, this.connector));
        }
    }

    private void registerHost(Host host) {
        String[] aliases = host.findAliases();
        this.mapper.addHost(host.getName(), aliases, host);
        for (Container container : host.findChildren()) {
            this.registerContext((Context)container);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.registerHost", host.getName(), this.domain, this.connector));
        }
    }

    private void unregisterHost(Host host) {
        String hostname = host.getName();
        this.mapper.removeHost(hostname);
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.unregisterHost", hostname, this.domain, this.connector));
        }
    }

    private void unregisterWrapper(Wrapper wrapper) {
        String[] mappings;
        String contextPath = ((Context)wrapper.getParent()).getPath();
        String wrapperName = wrapper.getName();
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        String version = ((Context)wrapper.getParent()).getWebappVersion();
        String hostName = wrapper.getParent().getParent().getName();
        for (String mapping : mappings = wrapper.findMappings()) {
            this.mapper.removeWrapper(hostName, contextPath, version, mapping);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.unregisterWrapper", wrapperName, contextPath, this.connector));
        }
    }

    private void registerContext(Context context) {
        String contextPath = context.getPath();
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        Container host = context.getParent();
        DirContext resources = context.getResources();
        String[] welcomeFiles = context.findWelcomeFiles();
        this.mapper.addContextVersion(host.getName(), host, contextPath, context.getWebappVersion(), context, welcomeFiles, resources);
        for (Container container : context.findChildren()) {
            this.registerWrapper((Wrapper)container);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.registerContext", contextPath, this.connector));
        }
    }

    private void unregisterContext(Context context) {
        if (context.getPaused()) {
            return;
        }
        String contextPath = context.getPath();
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        String hostName = context.getParent().getName();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.unregisterContext", contextPath, this.connector));
        }
        this.mapper.removeContextVersion(hostName, contextPath, context.getWebappVersion());
    }

    private void registerWrapper(Wrapper wrapper) {
        String[] mappings;
        String wrapperName = wrapper.getName();
        Context context = (Context)wrapper.getParent();
        String contextPath = context.getPath();
        if ("/".equals(contextPath)) {
            contextPath = "";
        }
        String version = ((Context)wrapper.getParent()).getWebappVersion();
        String hostName = context.getParent().getName();
        for (String mapping : mappings = wrapper.findMappings()) {
            boolean jspWildCard = wrapperName.equals("jsp") && mapping.endsWith("/*");
            this.mapper.addWrapper(hostName, contextPath, version, mapping, wrapper, jspWildCard, context.isResourceOnlyServlet(wrapperName));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("mapperListener.registerWrapper", wrapperName, contextPath, this.connector));
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if (event.getType() == "after_start") {
            Object obj = event.getSource();
            if (obj instanceof Wrapper) {
                this.registerWrapper((Wrapper)obj);
            } else if (obj instanceof Context) {
                this.registerContext((Context)obj);
            } else if (obj instanceof Host) {
                this.registerHost((Host)obj);
            }
        } else if (event.getType() == "before_stop") {
            Object obj = event.getSource();
            if (obj instanceof Wrapper) {
                this.unregisterWrapper((Wrapper)obj);
            } else if (obj instanceof Context) {
                this.unregisterContext((Context)obj);
            } else if (obj instanceof Host) {
                this.unregisterHost((Host)obj);
            }
        }
    }

    private void addListeners(Container container) {
        container.addContainerListener(this);
        container.addLifecycleListener(this);
        for (Container child : container.findChildren()) {
            this.addListeners(child);
        }
    }

    private void removeListeners(Container container) {
        container.removeContainerListener(this);
        container.removeLifecycleListener(this);
        for (Container child : container.findChildren()) {
            this.removeListeners(child);
        }
    }
}

